/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix.pretrade.inner;

import com.fxcm.fix.FXCMTimingIntervalFactory;
import com.fxcm.fix.IFXCMTimingInterval;
import com.fxcm.fix.Instrument;
import com.fxcm.fix.UTCDate;
import com.fxcm.fix.UTCTimeOnly;
import com.fxcm.fix.UTCTimestamp;
import com.fxcm.fix.pretrade.inner.MarketDataEntry;
import com.fxcm.messaging.IFieldGroup;
import com.fxcm.messaging.IFieldGroupList;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.IMessageFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class MarketDataSnapshot
extends com.fxcm.fix.pretrade.MarketDataSnapshot {
    private Map mDefaultEntryPks;
    private Map mEntries;

    public MarketDataSnapshot() {
        this.reset();
    }

    public MarketDataSnapshot(MarketDataSnapshot aMarketDataSnapshot) {
        super(aMarketDataSnapshot);
    }

    @Override
    public void setAskLow(double aAskLow) {
        MarketDataEntry mde = this.getDefaultMarketDataEntry("G", true);
        if (mde != null) {
            mde.setMDEntryPx(aAskLow);
        }
    }

    @Override
    public void setAskHigh(double aAskHigh) {
        MarketDataEntry mde = this.getDefaultMarketDataEntry("F", true);
        if (mde != null) {
            mde.setMDEntryPx(aAskHigh);
        }
    }

    @Override
    public void setAskOpen(double aAskOpen) {
        MarketDataEntry mde = this.getDefaultMarketDataEntry("B", true);
        if (mde != null) {
            mde.setMDEntryPx(aAskOpen);
        }
    }

    @Override
    public void setAskClose(double aAskClose) {
        String type = FXCMTimingIntervalFactory.TICK == this.getFXCMTimingInterval() ? "1" : "C";
        MarketDataEntry mde = this.getDefaultMarketDataEntry(type, true);
        if (mde != null) {
            mde.setMDEntryPx(aAskClose);
        }
    }

    @Override
    public void setLow(double aLow) {
        MarketDataEntry mde = this.getDefaultMarketDataEntry("8", true);
        if (mde != null) {
            mde.setMDEntryPx(aLow);
        }
    }

    @Override
    public void setHigh(double aHigh) {
        MarketDataEntry mde = this.getDefaultMarketDataEntry("7", true);
        if (mde != null) {
            mde.setMDEntryPx(aHigh);
        }
    }

    @Override
    public void setBidLow(double aBidLow) {
        MarketDataEntry mde = this.getDefaultMarketDataEntry("E", true);
        if (mde != null) {
            mde.setMDEntryPx(aBidLow);
        }
    }

    @Override
    public void setBidHigh(double aBidHigh) {
        MarketDataEntry mde = this.getDefaultMarketDataEntry("D", true);
        if (mde != null) {
            mde.setMDEntryPx(aBidHigh);
        }
    }

    @Override
    public void setBidOpen(double aBidOpen) {
        MarketDataEntry mde = this.getDefaultMarketDataEntry("4", true);
        if (mde != null) {
            mde.setMDEntryPx(aBidOpen);
        }
    }

    @Override
    public void setBidClose(double aBidClose) {
        String type = FXCMTimingIntervalFactory.TICK == this.getFXCMTimingInterval() ? "0" : "5";
        MarketDataEntry mde = this.getDefaultMarketDataEntry(type, true);
        if (mde != null) {
            mde.setMDEntryPx(aBidClose);
        }
    }

    @Override
    public void setTickVolume(int aTickVolume) {
        MarketDataEntry mde = this.getDefaultMarketDataEntry("H", true);
        if (mde != null) {
            mde.setMDEntryPx(aTickVolume);
        }
    }

    @Override
    protected double _getAskLow() {
        double ret = 0.0;
        MarketDataEntry mde = this.getDefaultMarketDataEntry("G", false);
        if (mde != null) {
            ret = mde.getMDEntryPx();
        }
        return ret;
    }

    @Override
    protected double _getAskHigh() {
        double ret = 0.0;
        MarketDataEntry mde = this.getDefaultMarketDataEntry("F", false);
        if (mde != null) {
            ret = mde.getMDEntryPx();
        }
        return ret;
    }

    @Override
    protected double _getAskOpen() {
        double ret = 0.0;
        MarketDataEntry mde = this.getDefaultMarketDataEntry("B", false);
        if (mde != null) {
            ret = mde.getMDEntryPx();
        }
        return ret;
    }

    @Override
    protected double _getAskClose() {
        double ret = 0.0;
        String type = FXCMTimingIntervalFactory.TICK == this.getFXCMTimingInterval() ? "1" : "C";
        MarketDataEntry mde = this.getDefaultMarketDataEntry(type, false);
        if (mde != null) {
            ret = mde.getMDEntryPx();
        }
        return ret;
    }

    @Override
    protected double _getLow() {
        double ret = 0.0;
        MarketDataEntry mde = this.getDefaultMarketDataEntry("8", false);
        if (mde != null) {
            ret = mde.getMDEntryPx();
        }
        return ret;
    }

    @Override
    protected double _getHigh() {
        double ret = 0.0;
        MarketDataEntry mde = this.getDefaultMarketDataEntry("7", false);
        if (mde != null) {
            ret = mde.getMDEntryPx();
        }
        return ret;
    }

    @Override
    protected double _getBidLow() {
        double ret = 0.0;
        MarketDataEntry mde = this.getDefaultMarketDataEntry("E", false);
        if (mde != null) {
            ret = mde.getMDEntryPx();
        }
        return ret;
    }

    @Override
    protected double _getBidHigh() {
        double ret = 0.0;
        MarketDataEntry mde = this.getDefaultMarketDataEntry("D", false);
        if (mde != null) {
            ret = mde.getMDEntryPx();
        }
        return ret;
    }

    @Override
    protected double _getBidOpen() {
        double ret = 0.0;
        MarketDataEntry mde = this.getDefaultMarketDataEntry("4", false);
        if (mde != null) {
            ret = mde.getMDEntryPx();
        }
        return ret;
    }

    @Override
    protected double _getBidClose() {
        double ret = 0.0;
        String type = FXCMTimingIntervalFactory.TICK == this.getFXCMTimingInterval() ? "0" : "5";
        MarketDataEntry mde = this.getDefaultMarketDataEntry(type, false);
        if (mde != null) {
            ret = mde.getMDEntryPx();
        }
        return ret;
    }

    @Override
    protected int _getTickVolume() {
        int ret = 0;
        MarketDataEntry mde = this.getDefaultMarketDataEntry("H", false);
        if (mde != null) {
            ret = (int)mde.getMDEntryPx();
        }
        return ret;
    }

    @Override
    public String getBidId() {
        String ret = null;
        MarketDataEntry mde = this.getDefaultMarketDataEntry("0", false);
        if (mde != null) {
            ret = mde.getQuoteEntryID();
        }
        return ret;
    }

    @Override
    public void setBidId(String aBidId) {
        MarketDataEntry mde = this.getDefaultMarketDataEntry("0", true);
        if (mde != null) {
            mde.setQuoteEntryID(aBidId);
        }
    }

    @Override
    public String getAskId() {
        String ret = null;
        MarketDataEntry mde = this.getDefaultMarketDataEntry("1", false);
        if (mde != null) {
            ret = mde.getQuoteEntryID();
        }
        return ret;
    }

    @Override
    public void setAskId(String aAskId) {
        MarketDataEntry mde = this.getDefaultMarketDataEntry("1", true);
        if (mde != null) {
            mde.setQuoteEntryID(aAskId);
        }
    }

    @Override
    public String getBidQuoteCondition() {
        String ret = null;
        MarketDataEntry mde = this.getDefaultMarketDataEntry("0", false);
        if (mde != null) {
            ret = mde.getQuoteCondition();
        }
        return ret;
    }

    @Override
    public void setBidQuoteCondition(String aBidQuoteCondition) {
        MarketDataEntry mde = this.getDefaultMarketDataEntry("0", true);
        if (mde != null) {
            mde.setQuoteCondition(aBidQuoteCondition);
        }
    }

    @Override
    public int getBidQuoteType() {
        int ret = 0;
        MarketDataEntry mde = this.getDefaultMarketDataEntry("0", false);
        if (mde != null) {
            ret = mde.getMDQuoteType();
        }
        return ret;
    }

    @Override
    public void setBidQuoteType(int aBidQuoteType) {
        MarketDataEntry mde = this.getDefaultMarketDataEntry("0", true);
        if (mde != null) {
            mde.setMDQuoteType(aBidQuoteType);
        }
    }

    @Override
    public UTCDate getBidExpireDate() {
        UTCDate ret = null;
        MarketDataEntry mde = this.getDefaultMarketDataEntry("0", false);
        if (mde != null) {
            ret = mde.getExpireDate();
        }
        return ret;
    }

    @Override
    public void setBidExpireDate(UTCDate aBidExpireDate) {
        MarketDataEntry mde = this.getDefaultMarketDataEntry("0", true);
        if (mde != null) {
            mde.setExpireDate(aBidExpireDate);
        }
    }

    @Override
    public void setBidExpireDate(String aBidExpireDate) {
        MarketDataEntry mde = this.getDefaultMarketDataEntry("0", true);
        if (mde != null) {
            mde.setExpireDate(aBidExpireDate);
        }
    }

    @Override
    public UTCTimeOnly getBidExpireTime() {
        UTCTimeOnly ret = null;
        MarketDataEntry mde = this.getDefaultMarketDataEntry("0", false);
        if (mde != null) {
            ret = mde.getExpireTime();
        }
        return ret;
    }

    @Override
    public void setBidExpireTime(UTCTimeOnly aBidExpireTime) {
        MarketDataEntry mde = this.getDefaultMarketDataEntry("0", true);
        if (mde != null) {
            mde.setExpireTime(aBidExpireTime);
        }
    }

    @Override
    public void setBidExpireTime(String aBidExpireTime) {
        MarketDataEntry mde = this.getDefaultMarketDataEntry("0", true);
        if (mde != null) {
            mde.setExpireTime(aBidExpireTime);
        }
    }

    @Override
    public void setBidExpireTimestamp(UTCTimestamp aBidExpireTimestamp) {
        MarketDataEntry mde = this.getDefaultMarketDataEntry("0", true);
        if (mde != null) {
            mde.setExpireTimestamp(aBidExpireTimestamp);
        }
    }

    @Override
    public UTCTimestamp getBidExpireTimestamp() {
        UTCTimestamp ret = null;
        MarketDataEntry mde = this.getDefaultMarketDataEntry("0", true);
        if (mde != null) {
            ret = mde.getExpireTimestamp();
        }
        return ret;
    }

    @Override
    public String getBidOriginator() {
        String ret = null;
        MarketDataEntry mde = this.getDefaultMarketDataEntry("0", false);
        if (mde != null) {
            ret = mde.getMDEntryOriginator();
        }
        return ret;
    }

    @Override
    public void setBidOriginator(String aBidOriginator) {
        MarketDataEntry mde = this.getDefaultMarketDataEntry("0", true);
        if (mde != null) {
            mde.setMDEntryOriginator(aBidOriginator);
        }
    }

    @Override
    public String getBidCurrency() {
        String ret = null;
        MarketDataEntry mde = this.getDefaultMarketDataEntry("0", false);
        if (mde != null) {
            ret = mde.getCurrency();
        }
        return ret;
    }

    @Override
    public void setBidCurrency(String aBidCurrency) {
        MarketDataEntry mde = this.getDefaultMarketDataEntry("0", true);
        if (mde != null) {
            mde.setCurrency(aBidCurrency);
        }
    }

    @Override
    public double getBidEntrySize() {
        double ret = 0.0;
        MarketDataEntry mde = this.getDefaultMarketDataEntry("0", false);
        if (mde != null) {
            ret = mde.getMDEntrySize();
        }
        return ret;
    }

    @Override
    public void setBidEntrySize(double aBidEntrySize) {
        MarketDataEntry mde = this.getDefaultMarketDataEntry("0", true);
        if (mde != null) {
            mde.setMDEntrySize(aBidEntrySize);
        }
    }

    @Override
    public String getAskQuoteCondition() {
        String ret = null;
        MarketDataEntry mde = this.getDefaultMarketDataEntry("1", false);
        if (mde != null) {
            ret = mde.getQuoteCondition();
        }
        return ret;
    }

    @Override
    public void setAskQuoteCondition(String aAskQuoteCondition) {
        MarketDataEntry mde = this.getDefaultMarketDataEntry("1", true);
        if (mde != null) {
            mde.setQuoteCondition(aAskQuoteCondition);
        }
    }

    @Override
    public int getAskQuoteType() {
        int ret = 0;
        MarketDataEntry mde = this.getDefaultMarketDataEntry("1", false);
        if (mde != null) {
            ret = mde.getMDQuoteType();
        }
        return ret;
    }

    @Override
    public void setAskQuoteType(int aAskQuoteType) {
        MarketDataEntry mde = this.getDefaultMarketDataEntry("1", true);
        if (mde != null) {
            mde.setMDQuoteType(aAskQuoteType);
        }
    }

    @Override
    public UTCDate getAskExpireDate() {
        UTCDate ret = null;
        MarketDataEntry mde = this.getDefaultMarketDataEntry("1", false);
        if (mde != null) {
            ret = mde.getExpireDate();
        }
        return ret;
    }

    @Override
    public void setAskExpireDate(UTCDate aAskExpireDate) {
        MarketDataEntry mde = this.getDefaultMarketDataEntry("1", true);
        if (mde != null) {
            mde.setExpireDate(aAskExpireDate);
        }
    }

    @Override
    public void setAskExpireDate(String aAskExpireDate) {
        MarketDataEntry mde = this.getDefaultMarketDataEntry("1", true);
        if (mde != null) {
            mde.setExpireDate(aAskExpireDate);
        }
    }

    @Override
    public UTCTimeOnly getAskExpireTime() {
        UTCTimeOnly ret = null;
        MarketDataEntry mde = this.getDefaultMarketDataEntry("1", false);
        if (mde != null) {
            ret = mde.getExpireTime();
        }
        return ret;
    }

    @Override
    public void setAskExpireTime(UTCTimeOnly aAskExpireTime) {
        MarketDataEntry mde = this.getDefaultMarketDataEntry("1", true);
        if (mde != null) {
            mde.setExpireTime(aAskExpireTime);
        }
    }

    @Override
    public void setAskExpireTime(String aAskExpireTime) {
        MarketDataEntry mde = this.getDefaultMarketDataEntry("1", true);
        if (mde != null) {
            mde.setExpireTime(aAskExpireTime);
        }
    }

    @Override
    public UTCTimestamp getAskExpireTimestamp() {
        UTCTimestamp ret = null;
        MarketDataEntry mde = this.getDefaultMarketDataEntry("1", true);
        if (mde != null) {
            ret = mde.getExpireTimestamp();
        }
        return ret;
    }

    @Override
    public void setAskExpireTimestamp(UTCTimestamp aAskExpireTimeStamp) {
        MarketDataEntry mde = this.getDefaultMarketDataEntry("1", true);
        if (mde != null) {
            mde.setExpireTimestamp(aAskExpireTimeStamp);
        }
    }

    @Override
    public String getAskOriginator() {
        String ret = null;
        MarketDataEntry mde = this.getDefaultMarketDataEntry("1", false);
        if (mde != null) {
            ret = mde.getMDEntryOriginator();
        }
        return ret;
    }

    @Override
    public void setAskOriginator(String aAskOriginator) {
        MarketDataEntry mde = this.getDefaultMarketDataEntry("1", true);
        if (mde != null) {
            mde.setMDEntryOriginator(aAskOriginator);
        }
    }

    @Override
    public String getAskCurrency() {
        String ret = null;
        MarketDataEntry mde = this.getDefaultMarketDataEntry("1", false);
        if (mde != null) {
            ret = mde.getCurrency();
        }
        return ret;
    }

    @Override
    public void setAskCurrency(String aAskCurrency) {
        MarketDataEntry mde = this.getDefaultMarketDataEntry("1", true);
        if (mde != null) {
            mde.setCurrency(aAskCurrency);
        }
    }

    @Override
    public double getAskEntrySize() {
        double ret = 0.0;
        MarketDataEntry mde = this.getDefaultMarketDataEntry("1", false);
        if (mde != null) {
            ret = mde.getMDEntrySize();
        }
        return ret;
    }

    @Override
    public void setAskEntrySize(double aAskEntrySize) {
        MarketDataEntry mde = this.getDefaultMarketDataEntry("1", true);
        if (mde != null) {
            mde.setMDEntrySize(aAskEntrySize);
        }
    }

    public int typeToFlagSet(IFXCMTimingInterval aInterval, String aMDEntryType) {
        int ret = 0;
        if (FXCMTimingIntervalFactory.TICK == aInterval) {
            if (aMDEntryType.equals("0")) {
                ret = 1;
            } else if (aMDEntryType.equals("1")) {
                ret = 2;
            } else if (aMDEntryType.equals("4")) {
                ret = 0;
            } else if (aMDEntryType.equals("B")) {
                ret = 0;
            } else if (aMDEntryType.equals("D")) {
                ret = 0;
            } else if (aMDEntryType.equals("E")) {
                ret = 0;
            } else if (aMDEntryType.equals("F")) {
                ret = 0;
            } else if (aMDEntryType.equals("G")) {
                ret = 0;
            } else if (aMDEntryType.equals("7")) {
                ret = 0;
            } else if (aMDEntryType.equals("8")) {
                ret = 0;
            }
        } else if (aMDEntryType.equals("4")) {
            ret = 1;
        } else if (aMDEntryType.equals("B")) {
            ret = 2;
        } else if (aMDEntryType.equals("5")) {
            ret = 1;
        } else if (aMDEntryType.equals("C")) {
            ret = 2;
        } else if (aMDEntryType.equals("D")) {
            ret = 1;
        } else if (aMDEntryType.equals("E")) {
            ret = 1;
        } else if (aMDEntryType.equals("F")) {
            ret = 2;
        } else if (aMDEntryType.equals("G")) {
            ret = 2;
        }
        return ret;
    }

    protected void fillEntryTime(IFieldGroup aGroup, MarketDataEntry aMarketDataEntry, String aTradingSessionID, String aTradingSessionSubID) {
        if (this.getTimestamp() != null && ("1".equals(aMarketDataEntry.getMDEntryType()) || "0".equals(aMarketDataEntry.getMDEntryType()) || "5".equals(aMarketDataEntry.getMDEntryType()) || "C".equals(aMarketDataEntry.getMDEntryType())) && aMarketDataEntry.getMDEntryTimestamp() == null) {
            aGroup.setValue("272", this.getTimestamp().toStringDateOnly());
            aGroup.setValue("273", this.getTimestamp().toStringTimeOnly());
        }
        if (aTradingSessionID != null && ("1".equals(aMarketDataEntry.getMDEntryType()) || "0".equals(aMarketDataEntry.getMDEntryType()) || "5".equals(aMarketDataEntry.getMDEntryType()) || "C".equals(aMarketDataEntry.getMDEntryType())) && aMarketDataEntry.getTradingSessionID() == null) {
            aGroup.setValue("336", aTradingSessionID);
        }
        if (aTradingSessionSubID != null && ("1".equals(aMarketDataEntry.getMDEntryType()) || "0".equals(aMarketDataEntry.getMDEntryType()) || "5".equals(aMarketDataEntry.getMDEntryType()) || "C".equals(aMarketDataEntry.getMDEntryType())) && aMarketDataEntry.getTradingSessionSubID() == null) {
            aGroup.setValue("625", aTradingSessionSubID);
        }
        if (this.getQuoteID() != null && ("1".equals(aMarketDataEntry.getMDEntryType()) || "0".equals(aMarketDataEntry.getMDEntryType())) && aMarketDataEntry.getQuoteEntryID() == null) {
            aGroup.setValue("299", this.getQuoteID());
        }
        if (this.getOriginator() != null && ("1".equals(aMarketDataEntry.getMDEntryType()) || "0".equals(aMarketDataEntry.getMDEntryType())) && aMarketDataEntry.getMDEntryOriginator() == null) {
            aGroup.setValue("282", this.getOriginator());
        }
        if (("1".equals(aMarketDataEntry.getMDEntryType()) || "0".equals(aMarketDataEntry.getMDEntryType())) && aMarketDataEntry.getQuoteCondition() == null) {
            aGroup.setValue("276", this.isTradeable() ? "A" : "B");
            aGroup.setValue("537", this.isTradeable() ? 1 : 0);
        }
    }

    @Override
    public IMessage toMessage(String aSID, String aTradingSessionID, String aTradingSessionSubID, String aRequestID, int aMDEntryTypeSet, IMessageFactory aFactory) {
        String tssubid;
        String tsid;
        String req = aRequestID;
        if (req == null) {
            req = this.getMDReqID();
        }
        if ((tsid = aTradingSessionID) == null) {
            tsid = this.getTradingSessionID();
        }
        if ((tssubid = aTradingSessionSubID) == null) {
            tssubid = this.getTradingSessionSubID();
        }
        IMessage ret = null;
        try {
            ret = aFactory.createMessage(aSID, "W");
            if (this.getFXCMMsgID() != null) {
                ret.setValue("9039", this.getFXCMMsgID());
            }
            ret.setValue("55", this.getInstrument().getSymbol());
            ret.setValue("9000", this.getInstrument().getFXCMSymID());
            ret.setValue("9001", this.getInstrument().getFXCMSymPrecision());
            ret.setValue("9002", this.getInstrument().getFXCMSymPointSize());
            ret.setValue("9005", this.getInstrument().getFXCMSymSortOrder());
            int product = this.getInstrument().getProduct();
            if (product >= 1 && product <= 13) {
                ret.setValue("460", product);
            }
            ret.setValue("231", this.getInstrument().getContractMultiplier());
            ret.setValue("228", this.getInstrument().getFactor());
            ret.setValue("461", this.getInstrument().getCFICode());
            ret.setValue("167", this.getInstrument().getSecurityType());
            ret.setValue("9080", this.getInstrument().getFXCMProductID());
            ret.setValue("9090", this.getInstrument().getFXCMCondDistStop());
            ret.setValue("9091", this.getInstrument().getFXCMCondDistLimit());
            ret.setValue("9092", this.getInstrument().getFXCMCondDistEntryStop());
            ret.setValue("9093", this.getInstrument().getFXCMCondDistEntryLimit());
            ret.setValue("9094", this.getInstrument().getFXCMMaxQuantity());
            ret.setValue("9095", this.getInstrument().getFXCMMinQuantity());
            ret.setValue("9096", this.getInstrument().getFXCMTradingStatus());
            ret.setValue("262", req);
            ret.setValue("9072", this.getPriceStream());
            IFieldGroupList grl = aFactory.createFieldGroupList();
            Iterator it = this.getMarketDataEntries().iterator();
            while (it.hasNext()) {
                IFieldGroup gr = null;
                MarketDataEntry mde = (MarketDataEntry)it.next();
                int set = this.typeToFlagSet(this.getFXCMTimingInterval(), mde.getMDEntryType());
                if ((aMDEntryTypeSet & set) == set) {
                    if (mde.getMDEntryTimestamp() != null) {
                        mde.getMDEntryTimestamp().setTime(this.getTimestamp().getTime());
                    }
                    gr = mde.toGroup(aFactory, this.getInstrument());
                    this.fillEntryTime(gr, mde, tsid, tssubid);
                }
                if (gr == null) continue;
                grl.put(gr);
            }
            ret.setValue("268", grl);
            if (this.getFXCMTimingInterval() != null) {
                String[] messageCodes = FXCMTimingIntervalFactory.storageToMessageIntervalCodes(this.getFXCMTimingInterval().getCode());
                ret.setValue("9011", messageCodes[0]);
                ret.setValue("9075", messageCodes[1]);
            }
            ret.setValue("9020", this.getFXCMContinuousFlag());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    @Override
    public boolean fill(IMessage aMsg) {
        boolean ret = false;
        this.reset();
        long id = aMsg.getValueLong("9039");
        if (id != 0L) {
            this.setFXCMMsgID(id);
        }
        this.setMDReqID(aMsg.getValueString("262"));
        int mainTICode = aMsg.getValueInt("9011");
        String auxTICode = aMsg.getValueString("9075");
        if (auxTICode == null) {
            auxTICode = "";
        }
        int interval = FXCMTimingIntervalFactory.messageToStorageIntervalCode(mainTICode, auxTICode);
        this.setFXCMTimingInterval(FXCMTimingIntervalFactory.toCode(interval));
        this.setInstrument(new Instrument(aMsg.getValueString("55"), aMsg.getValueInt("9000"), aMsg.getValueInt("9001")));
        this.getInstrument().setFXCMSymPointSize(aMsg.getValueDouble("9002"));
        this.getInstrument().setFXCMSymSortOrder(aMsg.getValueInt("9005"));
        int product = aMsg.getValueInt("460");
        if (product >= 1 && product <= 13) {
            this.getInstrument().setProduct(product);
        }
        this.getInstrument().setContractMultiplier(aMsg.getValueDouble("231"));
        this.getInstrument().setFactor(aMsg.getValueInt("228"));
        this.getInstrument().setCFICode(aMsg.getValueString("461"));
        this.getInstrument().setSecurityType(aMsg.getValueString("167"));
        this.getInstrument().setFXCMProductID(aMsg.getValueInt("9080"));
        this.getInstrument().setFXCMCondDistStop(aMsg.getValueDouble("9090"));
        this.getInstrument().setFXCMCondDistLimit(aMsg.getValueDouble("9091"));
        this.getInstrument().setFXCMCondDistEntryStop(aMsg.getValueDouble("9092"));
        this.getInstrument().setFXCMCondDistEntryLimit(aMsg.getValueDouble("9093"));
        this.getInstrument().setFXCMMaxQuantity(aMsg.getValueDouble("9094"));
        this.getInstrument().setFXCMMinQuantity(aMsg.getValueDouble("9095"));
        this.getInstrument().setFXCMTradingStatus(aMsg.getValueString("9096"));
        this.setFXCMContinuousFlag(aMsg.getValueInt("9020"));
        this.setPriceStream(aMsg.getValueString("9072"));
        IFieldGroupList grl = aMsg.getValueList("268");
        if (grl != null) {
            for (IFieldGroup gr : grl.values()) {
                String aTime;
                MarketDataEntry mde = new MarketDataEntry();
                String mdeType = gr.getValueString("269");
                if (!mde.fill(gr) && !"H".equals(mdeType)) continue;
                this.addMarketDataEntry(mde);
                String aDate = gr.getValueString("272");
                if (aDate != null) {
                    this.setDate(aDate);
                }
                if ((aTime = gr.getValueString("273")) != null) {
                    boolean isTick = FXCMTimingIntervalFactory.TICK.equals(this.getFXCMTimingInterval());
                    mde.setMDEntryTime(aTime);
                    this.setTime(aTime, isTick);
                }
                ret = true;
            }
        }
        return ret;
    }

    @Override
    public void reset() {
        this.mDefaultEntryPks = new HashMap();
        this.mEntries = new LinkedHashMap();
        super.reset();
    }

    @Override
    protected void copy(com.fxcm.fix.pretrade.MarketDataSnapshot aMarketDataSnapshot) {
        if (aMarketDataSnapshot instanceof MarketDataSnapshot) {
            this.setInstrument(aMarketDataSnapshot.getInstrument());
            this.setTimestamp(aMarketDataSnapshot.getTimestamp());
            this.setFXCMTimingInterval(aMarketDataSnapshot.getFXCMTimingInterval());
            this.setComplete(aMarketDataSnapshot.isComplete());
            this.setMDReqID(aMarketDataSnapshot.getMDReqID());
            this.setTradingSessionID(aMarketDataSnapshot.getTradingSessionID());
            this.setTradingSessionSubID(aMarketDataSnapshot.getTradingSessionSubID());
            this.setFXCMContinuousFlag(aMarketDataSnapshot.getFXCMContinuousFlag());
            this.setPriceStream(aMarketDataSnapshot.getPriceStream());
            this.setFXCMMsgID(null);
            MarketDataSnapshot mds = (MarketDataSnapshot)aMarketDataSnapshot;
            Iterator it = mds.getMarketDataEntries().iterator();
            while (it.hasNext()) {
                this.addMarketDataEntry(new MarketDataEntry((MarketDataEntry)it.next()));
            }
        } else {
            super.copy(aMarketDataSnapshot);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MarketDataSnapshot");
        sb.append("{QuoteID='").append(this.getQuoteID()).append('\'');
        sb.append(", FXCMMsgID ='").append(this.getFXCMMsgID()).append('\'');
        if (this.getInstrument() != null) {
            sb.append(",Instrument={").append(this.getInstrument().getFXCMSymID());
            try {
                sb.append(",").append(this.getInstrument().getSymbol());
            }
            catch (Exception e) {
                sb.append(",null");
            }
            sb.append("}");
        } else {
            sb.append(",Instrument=null");
        }
        sb.append(", Time=").append(this.getTime());
        sb.append(", Date=").append(this.getDate());
        sb.append(", Interval=").append(this.getFXCMTimingInterval());
        sb.append(", Complete=").append(this.isComplete());
        sb.append(", MDReqID='").append(this.getMDReqID()).append('\'');
        sb.append(", TradingSessionID='").append(this.getTradingSessionID()).append('\'');
        sb.append(", TradingSessionSubID='").append(this.getTradingSessionSubID()).append('\'');
        sb.append(", Originator='").append(this.getOriginator()).append('\'');
        sb.append(", IsTradeable=").append(this.isTradeable());
        sb.append(", ContinuousFlag=").append(this.getFXCMContinuousFlag());
        sb.append(", PriceStream=").append(this.getPriceStream());
        sb.append(", Entries=").append(this.mEntries);
        sb.append('}');
        return sb.toString();
    }

    public MarketDataEntry getDefaultMarketDataEntry(String aMDEntryType, boolean aCreateNew) {
        MarketDataEntry ret = null;
        String pk = (String)this.mDefaultEntryPks.get(aMDEntryType);
        if (pk == null) {
            double sz = -1.0;
            for (MarketDataEntry mde : this.mEntries.values()) {
                if (!aMDEntryType.equals(mde.getMDEntryType()) || !(sz < 0.0) && !(sz > mde.getMDEntrySize())) continue;
                sz = mde.getMDEntrySize();
                pk = mde.getMDEntryID();
            }
            if (pk != null) {
                this.mDefaultEntryPks.put(aMDEntryType, pk);
            }
        }
        if (pk != null) {
            ret = (MarketDataEntry)this.mEntries.get(pk);
        } else if (pk == null && aCreateNew && this.getInstrument() != null) {
            pk = MarketDataEntry.createEntryID(this.mEntries.size(), this.getInstrument().getFXCMSymID(), aMDEntryType, 0.0, this.getOriginator());
            ret = new MarketDataEntry();
            ret.setMDEntryID(pk);
            ret.setMDEntryType(aMDEntryType);
            this.mEntries.put(pk, ret);
            this.mDefaultEntryPks.put(aMDEntryType, pk);
        }
        return ret;
    }

    public Collection getMarketDataEntries() {
        return this.mEntries.values();
    }

    public void addMarketDataEntry(MarketDataEntry aMarketDataEntry) {
        if (aMarketDataEntry.getMDEntryID() == null) {
            aMarketDataEntry.setMDEntryID(MarketDataEntry.createEntryID(this.mEntries.size(), this.getInstrument().getFXCMSymID(), aMarketDataEntry.getMDEntryType(), aMarketDataEntry.getMDEntrySize(), aMarketDataEntry.getMDEntryOriginator()));
        }
        if ("PriceServer".equalsIgnoreCase(aMarketDataEntry.getTradingSessionSubID())) {
            this.setTradingSessionSubID(aMarketDataEntry.getTradingSessionSubID());
        }
        this.mEntries.put(aMarketDataEntry.getMDEntryID(), aMarketDataEntry);
        if ("1".equals(aMarketDataEntry.getMDEntryType()) || "0".equals(aMarketDataEntry.getMDEntryType())) {
            if (aMarketDataEntry.getQuoteEntryID() != null) {
                this.setQuoteID(aMarketDataEntry.getQuoteEntryID());
            }
            if (aMarketDataEntry.getTradingSessionID() != null) {
                this.setTradingSessionID(aMarketDataEntry.getTradingSessionID());
            }
            if (aMarketDataEntry.getTradingSessionSubID() != null) {
                this.setTradingSessionSubID(aMarketDataEntry.getTradingSessionSubID());
            }
            if (aMarketDataEntry.getMDEntryOriginator() != null) {
                this.setOriginator(aMarketDataEntry.getMDEntryOriginator());
            }
            if (aMarketDataEntry.getMDEntryOriginator() != null) {
                this.setOriginator(aMarketDataEntry.getMDEntryOriginator());
            }
            if (!this.isTradeable() && FXCMTimingIntervalFactory.TICK == this.getFXCMTimingInterval() && "A".equals(aMarketDataEntry.getQuoteCondition())) {
                this.setTradeable(true);
            }
            if (aMarketDataEntry.getMDEntryTimestamp() != null) {
                this.setTimestamp(aMarketDataEntry.getMDEntryTimestamp());
            }
        }
    }

    public MarketDataEntry getMarketDataEntry(String aMDEntryID) {
        return (MarketDataEntry)this.mEntries.get(aMDEntryID);
    }

    protected Collection getDefaultKeys() {
        return this.mDefaultEntryPks.values();
    }
}

