/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix.pretrade.inner;

import com.fxcm.fix.Instrument;
import com.fxcm.fix.UTCDate;
import com.fxcm.fix.UTCTimeOnly;
import com.fxcm.fix.UTCTimestamp;
import com.fxcm.messaging.IFieldGroup;
import com.fxcm.messaging.IMessageFactory;
import java.text.ParseException;

public class MarketDataEntry {
    private String mMDEntryType;
    private String mMDEntryID;
    private double mMDEntryPx;
    private String mCurrency;
    private double mMDEntrySize;
    private UTCTimestamp mMDEntryTimestamp;
    private String mTradingSessionID;
    private String mTradingSessionSubID;
    private String mQuoteCondition;
    private String mMDEntryOriginator;
    private UTCTimestamp mExpireTimestamp;
    private int mMDQuoteType;
    private String mQuoteEntryID;

    public MarketDataEntry() {
        this.reset();
    }

    public MarketDataEntry(MarketDataEntry aMarketDataEntry) {
        this.setMDEntryType(aMarketDataEntry.getMDEntryType());
        this.setMDEntryID(aMarketDataEntry.getMDEntryID());
        this.setMDEntryPx(aMarketDataEntry.getMDEntryPx());
        this.setCurrency(aMarketDataEntry.getCurrency());
        this.setMDEntrySize(aMarketDataEntry.getMDEntrySize());
        this.setMDEntryTimestamp(aMarketDataEntry.getMDEntryTimestamp());
        this.setTradingSessionID(aMarketDataEntry.getTradingSessionID());
        this.setTradingSessionSubID(aMarketDataEntry.getTradingSessionSubID());
        this.setQuoteCondition(aMarketDataEntry.getQuoteCondition());
        this.setMDEntryOriginator(aMarketDataEntry.getMDEntryOriginator());
        this.setExpireTimestamp(aMarketDataEntry.getExpireTimestamp());
        this.setMDQuoteType(aMarketDataEntry.getMDQuoteType());
        this.setQuoteEntryID(aMarketDataEntry.getQuoteEntryID());
    }

    public void setMDEntryType(String aMDEntryType) {
        this.mMDEntryType = aMDEntryType;
    }

    public void setMDEntryID(String aMDEntryID) {
        this.mMDEntryID = aMDEntryID != null && aMDEntryID.length() == 0 ? null : aMDEntryID;
    }

    public void setMDEntryPx(double aMDEntryPx) {
        this.mMDEntryPx = aMDEntryPx;
    }

    public void setCurrency(String aCurrency) {
        this.mCurrency = aCurrency;
    }

    public void setMDEntrySize(double aMDEntrySize) {
        this.mMDEntrySize = aMDEntrySize;
    }

    public void setMDEntryDate(UTCDate aMDEntryDate) {
        if (aMDEntryDate == null) {
            this.mMDEntryTimestamp = null;
            return;
        }
        if (this.mMDEntryTimestamp == null) {
            this.mMDEntryTimestamp = new UTCTimestamp();
        }
        this.mMDEntryTimestamp.setDateOnly(aMDEntryDate);
    }

    public void setMDEntryDate(String aMDEntryDate) {
        if (aMDEntryDate == null) {
            this.mMDEntryTimestamp = null;
            return;
        }
        if (this.mMDEntryTimestamp == null) {
            this.mMDEntryTimestamp = new UTCTimestamp();
        }
        try {
            this.mMDEntryTimestamp.setDateOnly(aMDEntryDate);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void setMDEntryTime(UTCTimeOnly aMDEntryTime) {
        if (aMDEntryTime == null) {
            this.mMDEntryTimestamp = null;
            return;
        }
        if (this.mMDEntryTimestamp == null) {
            this.mMDEntryTimestamp = new UTCTimestamp();
        }
        this.mMDEntryTimestamp.setTimeOnly(aMDEntryTime);
    }

    public void setMDEntryTime(String aMDEntryTime) {
        if (aMDEntryTime == null) {
            this.mMDEntryTimestamp = null;
            return;
        }
        if (this.mMDEntryTimestamp == null) {
            this.mMDEntryTimestamp = new UTCTimestamp();
        }
        try {
            this.mMDEntryTimestamp.setTimeOnly(aMDEntryTime);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public UTCTimestamp getMDEntryTimestamp() {
        return this.mMDEntryTimestamp;
    }

    public void setMDEntryTimestamp(UTCTimestamp aMDEntryTimestamp) {
        this.mMDEntryTimestamp = aMDEntryTimestamp;
    }

    public void setTradingSessionID(String aTradingSessionID) {
        this.mTradingSessionID = aTradingSessionID;
    }

    public void setTradingSessionSubID(String aTradingSessionSubID) {
        this.mTradingSessionSubID = aTradingSessionSubID;
    }

    public void setQuoteCondition(String aQuoteCondition) {
        this.mQuoteCondition = aQuoteCondition;
    }

    public void setMDEntryOriginator(String aMDEntryOriginator) {
        this.mMDEntryOriginator = aMDEntryOriginator;
    }

    public UTCTimestamp getExpireTimestamp() {
        return this.mExpireTimestamp;
    }

    public void setExpireTimestamp(UTCTimestamp aExpireTimestamp) {
        this.mExpireTimestamp = aExpireTimestamp;
    }

    public void setExpireDate(UTCDate aExpireDate) {
        if (aExpireDate == null) {
            this.mExpireTimestamp = null;
            return;
        }
        if (this.mExpireTimestamp == null) {
            this.mExpireTimestamp = new UTCTimestamp();
        }
        this.mExpireTimestamp.setDateOnly(aExpireDate);
    }

    public void setExpireDate(String aExpireDate) {
        if (aExpireDate == null) {
            this.mExpireTimestamp = null;
            return;
        }
        if (this.mExpireTimestamp == null) {
            this.mExpireTimestamp = new UTCTimestamp();
        }
        try {
            this.mExpireTimestamp.setDateOnly(aExpireDate);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void setExpireTime(UTCTimeOnly aExpireTime) {
        if (aExpireTime == null) {
            this.mExpireTimestamp = null;
            return;
        }
        if (this.mExpireTimestamp == null) {
            this.mExpireTimestamp = new UTCTimestamp();
        }
        this.mExpireTimestamp.setTimeOnly(aExpireTime);
    }

    public void setExpireTime(String aExpireTime) {
        if (aExpireTime == null) {
            this.mExpireTimestamp = null;
            return;
        }
        if (this.mExpireTimestamp == null) {
            this.mExpireTimestamp = new UTCTimestamp();
        }
        try {
            this.mExpireTimestamp.setTimeOnly(aExpireTime);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void setMDQuoteType(int aMDQuoteType) {
        this.mMDQuoteType = aMDQuoteType;
    }

    public void setQuoteEntryID(String aQuoteEntryID) {
        this.mQuoteEntryID = aQuoteEntryID;
    }

    public String getMDEntryType() {
        return this.mMDEntryType;
    }

    public String getMDEntryID() {
        return this.mMDEntryID;
    }

    public double getMDEntryPx() {
        return this.mMDEntryPx;
    }

    public String getCurrency() {
        return this.mCurrency;
    }

    public double getMDEntrySize() {
        return this.mMDEntrySize;
    }

    public UTCDate getMDEntryDate() {
        if (this.mMDEntryTimestamp == null) {
            return null;
        }
        return new UTCDate(this.mMDEntryTimestamp);
    }

    public UTCTimeOnly getMDEntryTime() {
        if (this.mMDEntryTimestamp == null) {
            return null;
        }
        return new UTCTimeOnly(this.mMDEntryTimestamp);
    }

    public String getTradingSessionID() {
        return this.mTradingSessionID;
    }

    public String getTradingSessionSubID() {
        return this.mTradingSessionSubID;
    }

    public String getQuoteCondition() {
        return this.mQuoteCondition;
    }

    public String getMDEntryOriginator() {
        return this.mMDEntryOriginator;
    }

    public UTCDate getExpireDate() {
        if (this.mExpireTimestamp == null) {
            return null;
        }
        return new UTCDate(this.mExpireTimestamp);
    }

    public UTCTimeOnly getExpireTime() {
        if (this.mExpireTimestamp == null) {
            return null;
        }
        return new UTCTimeOnly(this.mExpireTimestamp);
    }

    public int getMDQuoteType() {
        return this.mMDQuoteType;
    }

    public String getQuoteEntryID() {
        return this.mQuoteEntryID;
    }

    public IFieldGroup toGroup(IMessageFactory aFactory, Instrument aInstrument) {
        IFieldGroup ret = aFactory.createFieldGroup();
        if (this.getMDEntryType() != null) {
            ret.setValue("269", this.getMDEntryType());
        }
        if (this.getMDEntryID() != null) {
            ret.setValue("278", this.getMDEntryID());
        }
        if ("H".equals(this.getMDEntryType())) {
            ret.setValue("270", Integer.toString((int)this.getMDEntryPx()));
        } else if (this.getMDEntryPx() != 0.0) {
            ret.setValue("270", aInstrument.priceToString(this.getMDEntryPx()));
        }
        if (this.getCurrency() != null) {
            ret.setValue("15", this.getCurrency());
        }
        if ("4".equals(this.getMDEntryType()) || "5".equals(this.getMDEntryType())) {
            ret.setValue("286", 0);
        }
        if ("0".equals(this.getMDEntryType()) || "1".equals(this.getMDEntryType())) {
            ret.setValue("271", this.getMDEntrySize());
        }
        if (this.getMDEntryTimestamp() != null) {
            ret.setValue("272", this.getMDEntryTimestamp().toStringDateOnly());
            ret.setValue("273", this.getMDEntryTimestamp().toStringTimeOnly());
        }
        if (this.getTradingSessionID() != null && this.getTradingSessionID().length() > 0) {
            ret.setValue("336", this.getTradingSessionID());
        }
        if (this.getTradingSessionSubID() != null && this.getTradingSessionSubID().length() > 0) {
            ret.setValue("625", this.getTradingSessionSubID());
        }
        if (this.getQuoteCondition() != null) {
            ret.setValue("276", this.getQuoteCondition());
        }
        if (this.getMDEntryOriginator() != null) {
            ret.setValue("282", this.getMDEntryOriginator());
        }
        if (this.getExpireTimestamp() != null) {
            ret.setValue("432", this.getExpireTimestamp().toStringDateOnly());
            ret.setValue("126", this.getExpireTimestamp().toString());
        }
        if (this.getMDQuoteType() != 0) {
            ret.setValue("537", this.getMDQuoteType());
        }
        if (this.getQuoteEntryID() != null) {
            ret.setValue("299", this.getQuoteEntryID());
        }
        return ret;
    }

    public void reset() {
        this.mMDEntryType = "0";
        this.mMDEntryID = null;
        this.mMDEntryPx = 0.0;
        this.mCurrency = null;
        this.mMDEntrySize = 0.0;
        this.mMDEntryTimestamp = null;
        this.mTradingSessionID = null;
        this.mTradingSessionSubID = null;
        this.mQuoteCondition = null;
        this.mMDEntryOriginator = null;
        this.mExpireTimestamp = null;
        this.mMDQuoteType = 0;
        this.mQuoteEntryID = null;
    }

    public boolean fill(IFieldGroup aFieldGroup) {
        this.reset();
        try {
            this.setMDEntryType(aFieldGroup.getValueString("269"));
            this.setMDEntryID(aFieldGroup.getValueString("278"));
            this.setMDEntryPx(aFieldGroup.getValueDouble("270"));
            this.setCurrency(aFieldGroup.getValueString("15"));
            this.setMDEntrySize(aFieldGroup.getValueDouble("271"));
            if (aFieldGroup.getValueString("272") != null) {
                this.setMDEntryDate(aFieldGroup.getValueString("272"));
            }
            if (aFieldGroup.getValueString("273") != null) {
                this.setMDEntryTime(aFieldGroup.getValueString("273"));
            }
            this.setTradingSessionID(aFieldGroup.getValueString("336"));
            this.setTradingSessionSubID(aFieldGroup.getValueString("625"));
            this.setQuoteCondition(aFieldGroup.getValueString("276"));
            this.setMDEntryOriginator(aFieldGroup.getValueString("282"));
            if (aFieldGroup.getValueString("432") != null) {
                this.setExpireDate(aFieldGroup.getValueString("432"));
            }
            if (aFieldGroup.getValueString("126") != null) {
                this.setExpireTime(aFieldGroup.getValueString("126"));
            }
            this.setMDQuoteType(aFieldGroup.getValueInt("537"));
            this.setQuoteEntryID(aFieldGroup.getValueString("299"));
        }
        catch (Exception e) {
            this.setMDEntryType(null);
        }
        return this.getMDEntryType() != null && this.getMDEntryPx() != 0.0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MarketDataEntry");
        sb.append("{mCurrency='").append(this.mCurrency).append('\'');
        sb.append(", mMDEntryType='").append(this.mMDEntryType).append('\'');
        sb.append(", mMDEntryID='").append(this.mMDEntryID).append('\'');
        sb.append(", mMDEntryPx=").append(this.mMDEntryPx);
        sb.append(", mMDEntrySize=").append(this.mMDEntrySize);
        sb.append(", mMDEntryTimeStamp=").append(this.mMDEntryTimestamp);
        sb.append(", mTradingSessionID='").append(this.mTradingSessionID).append('\'');
        sb.append(", mTradingSessionSubID='").append(this.mTradingSessionSubID).append('\'');
        sb.append(", mQuoteCondition='").append(this.mQuoteCondition).append('\'');
        sb.append(", mMDEntryOriginator='").append(this.mMDEntryOriginator).append('\'');
        sb.append(", mExpireTimestamp=").append(this.mExpireTimestamp);
        sb.append(", mMDQuoteType=").append(this.mMDQuoteType);
        sb.append(", mQuoteEntryID='").append(this.mQuoteEntryID).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public int hashCode() {
        return this.getMDEntryID() == null ? 0 : this.getMDEntryID().hashCode();
    }

    public static String createEntryID(int aFXCMSymID, String aMDEntryType, double aMDEntrySize, String aOriginator) {
        return MarketDataEntry.createEntryID(0, aFXCMSymID, aMDEntryType, aMDEntrySize, aOriginator);
    }

    public static String createEntryID(int aIndex, int aFXCMSymID, String aMDEntryType, double aMDEntrySize, String aOriginator) {
        StringBuilder sb = new StringBuilder();
        sb.append(aIndex).append("-");
        sb.append(aFXCMSymID).append("-");
        sb.append(aMDEntryType).append("-");
        long l = 0L;
        if (aMDEntrySize > 0.0) {
            l = Math.round(aMDEntrySize / 100000.0);
        }
        sb.append(l);
        if (aOriginator != null && aOriginator.trim().length() != 0) {
            sb.append("-").append(aOriginator);
        }
        return sb.toString();
    }
}

