/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix.pretrade;

import com.fxcm.entity.ACode;
import com.fxcm.entity.ICode;
import com.fxcm.fix.IFixDefs;
import com.fxcm.fix.ISubscriptionRequestType;
import com.fxcm.fix.SubscriptionRequestTypeFactory;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.IMessageFactory;
import com.fxcm.messaging.ITransportable;

public class TradingSessionStatusRequest
implements ITransportable,
IFixDefs {
    public static final ICode OBJ_TYPE = new TradingSessionStatusRequestType();
    protected String mTradSesReqID;
    protected String mTradingSessionID;
    protected String mTradingSessionSubID = "";
    protected ISubscriptionRequestType mSubscriptionRequestType;
    private long mMakingTime = System.currentTimeMillis();

    public TradingSessionStatusRequest() {
        this.reset();
    }

    @Override
    public ICode getType() {
        return OBJ_TYPE;
    }

    public void setTradSesReqID(String aTradSesReqID) {
        this.mTradSesReqID = aTradSesReqID;
    }

    public void setTradingSessionID(String aTradingSessionID) {
        this.mTradingSessionID = aTradingSessionID;
    }

    public void setTradingSessionSubID(String aTradingSessionSubID) {
        this.mTradingSessionSubID = aTradingSessionSubID;
    }

    public void setSubscriptionRequestType(String aSubscriptionRequestType) {
        this.setSubscriptionRequestType(SubscriptionRequestTypeFactory.toCode(aSubscriptionRequestType));
    }

    public void setSubscriptionRequestType(ISubscriptionRequestType aSubscriptionRequestType) {
        this.mSubscriptionRequestType = aSubscriptionRequestType == null ? SubscriptionRequestTypeFactory.SUBSCRIBE : aSubscriptionRequestType;
    }

    public String getTradSesReqID() {
        return this.mTradSesReqID;
    }

    @Override
    public String getTradingSessionID() {
        return this.mTradingSessionID;
    }

    @Override
    public String getTradingSessionSubID() {
        return this.mTradingSessionSubID;
    }

    public ISubscriptionRequestType getSubscriptionRequestType() {
        return this.mSubscriptionRequestType;
    }

    @Override
    public IMessage toMessage(String aSID, IMessageFactory aFactory) {
        return this.toMessage(aSID, null, null, null, 0, aFactory);
    }

    @Override
    public IMessage toMessage(String aSID, String aTradingSessionID, String aTradingSessionSubID, String aRequestID, int aOptions, IMessageFactory aFactory) {
        String tssubid;
        String tsid;
        String req = aRequestID;
        if (req == null) {
            req = this.getTradSesReqID();
        }
        if ((tsid = aTradingSessionID) == null) {
            tsid = this.getTradingSessionID();
        }
        if ((tssubid = aTradingSessionSubID) == null) {
            tssubid = this.getTradingSessionSubID();
        }
        IMessage ret = aFactory.createMessage(aSID, "g");
        ret.setValue("335", req);
        ret.setValue("336", tsid);
        ret.setValue("625", tssubid);
        ret.setValue("263", this.getSubscriptionRequestType().getCode());
        return ret;
    }

    public void reset() {
        this.setTradingSessionID("FXCM");
        this.setTradingSessionSubID("");
        this.setSubscriptionRequestType(SubscriptionRequestTypeFactory.SUBSCRIBE);
        this.setTradSesReqID(null);
    }

    @Override
    public boolean fill(IMessage aMsg) {
        this.reset();
        if (aMsg != null) {
            this.setTradSesReqID(aMsg.getValueString("335"));
            this.setTradingSessionID(aMsg.getValueString("336"));
            this.setTradingSessionSubID(aMsg.getValueString("625"));
            this.setSubscriptionRequestType(aMsg.getValueString("263"));
        }
        return aMsg != null;
    }

    @Override
    public boolean update(IMessage aMsg) {
        return this.fill(aMsg);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public String getRequestID() {
        return this.getTradSesReqID();
    }

    @Override
    public long getMakingTime() {
        return this.mMakingTime;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("TradingSessionStatusRequest");
        sb.append("{mMakingTime=").append(this.mMakingTime);
        sb.append(", mSubscriptionRequestType=").append(this.mSubscriptionRequestType);
        sb.append(", mTradingSessionID='").append(this.mTradingSessionID).append('\'');
        sb.append(", mTradingSessionSubID='").append(this.mTradingSessionSubID).append('\'');
        sb.append(", mTradSesReqID='").append(this.mTradSesReqID).append('\'');
        sb.append('}');
        return sb.toString();
    }

    private static class TradingSessionStatusRequestType
    extends ACode {
        TradingSessionStatusRequestType() {
            super("g", "TradingSessionStatusRequestType", "");
        }
    }
}

