/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix.pretrade;

import com.fxcm.GenericException;
import com.fxcm.entity.ACode;
import com.fxcm.entity.ICode;
import com.fxcm.entity.IStatus;
import com.fxcm.fix.IFixDefs;
import com.fxcm.fix.ITradSesMode;
import com.fxcm.fix.ITradSesStatus;
import com.fxcm.fix.ITradSesStatusRejReason;
import com.fxcm.fix.NotDefinedException;
import com.fxcm.fix.Parameter;
import com.fxcm.fix.PriceStream;
import com.fxcm.fix.TradSesModeFactory;
import com.fxcm.fix.TradSesStatusFactory;
import com.fxcm.fix.TradSesStatusRejReasonFactory;
import com.fxcm.fix.TradingSecurity;
import com.fxcm.fix.UTCTimestamp;
import com.fxcm.messaging.IFieldGroup;
import com.fxcm.messaging.IFieldGroupList;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.IMessageFactory;
import com.fxcm.messaging.ITransportable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TradingSessionStatus
implements Serializable,
ITransportable,
IFixDefs {
    private static final long serialVersionUID = 3582512225909119628L;
    public static final ICode OBJ_TYPE = new TradingSessionStatusType();
    protected int mFXCMServerTimeZone;
    protected String mFXCMServerTimeZoneName;
    protected final Map mParameters;
    protected final Map mSecurities;
    protected final Map<Integer, PriceStream> mPriceStreams;
    protected String mText;
    protected UTCTimestamp mTradSesCloseTime;
    protected ITradSesMode mTradSesMode;
    protected UTCTimestamp mTradSesOpenTime;
    protected String mTradSesReqID;
    protected UTCTimestamp mTradSesStartTime;
    protected ITradSesStatus mTradSesStatus;
    protected ITradSesStatusRejReason mTradSesStatusRejReason;
    protected String mTradingSessionID;
    protected String mTradingSessionSubID = "";
    protected UTCTimestamp mTransactTime;
    protected String mUnsolicitedIndicator;
    private long mMakingTime = System.currentTimeMillis();

    public TradingSessionStatus() {
        this.mSecurities = Collections.synchronizedMap(new HashMap());
        this.mParameters = Collections.synchronizedMap(new HashMap());
        this.mPriceStreams = Collections.synchronizedMap(new HashMap());
        this.reset();
    }

    @Override
    public boolean fill(IMessage aMsg) {
        this.reset();
        this.setTradSesReqID(aMsg.getValueString("335"));
        this.setTradingSessionID(aMsg.getValueString("336"));
        this.setTradingSessionSubID(aMsg.getValueString("625"));
        this.setTradSesStatus(aMsg.getValueInt("340"));
        this.setText(aMsg.getValueString("58"));
        if (aMsg.getValueString("60") != null) {
            this.setTransactTime(new UTCTimestamp(aMsg.getValueString("60")));
        }
        if (this.getTradSesStatus() == null || TradSesStatusFactory.REQUESTREJECTED == this.getTradSesStatus()) {
            this.setTradSesStatusRejReason(aMsg.getValueInt("567"));
        } else {
            IFieldGroup gr;
            IFieldGroup field;
            Iterator<IFieldGroup> iterator;
            IFieldGroupList grl;
            this.setTradSesMode(aMsg.getValueInt("339"));
            this.setUnsolicitedIndicator(aMsg.getValueString("325"));
            String s = aMsg.getValueString("341");
            if (s != null) {
                this.setTradSesStartTime(new UTCTimestamp(s));
            }
            if ((s = aMsg.getValueString("342")) != null) {
                this.setTradSesOpenTime(new UTCTimestamp(s));
            }
            if ((s = aMsg.getValueString("344")) != null) {
                this.setTradSesCloseTime(new UTCTimestamp(s));
            }
            if ((grl = aMsg.getValueList("146")) != null) {
                iterator = grl.values().iterator();
                while (iterator.hasNext()) {
                    gr = field = iterator.next();
                    TradingSecurity ts = new TradingSecurity();
                    ts.setSymbol(gr.getValueString("55"));
                    ts.setFXCMSymID(gr.getValueInt("9000"));
                    ts.setFXCMSymPrecision(gr.getValueInt("9001"));
                    ts.setFXCMSymPointSize(gr.getValueDouble("9002"));
                    ts.setFXCMSymSortOrder(gr.getValueInt("9005"));
                    ts.setCurrency(gr.getValueString("15"));
                    ts.setRoundLot(gr.getValueDouble("561"));
                    ts.setFXCMSymInterestBuy(gr.getValueDouble("9003"));
                    ts.setFXCMSymInterestSell(gr.getValueDouble("9004"));
                    ts.setFXCMSubscriptionStatus(gr.getValueString("9076"));
                    int product = gr.getValueInt("460");
                    if (product >= 1 && product <= 13) {
                        ts.setProduct(product);
                    }
                    ts.setContractMultiplier(gr.getValueDouble("231"));
                    ts.setFactor(gr.getValueInt("228"));
                    ts.setCFICode(gr.getValueString("461"));
                    ts.setSecurityType(gr.getValueString("167"));
                    ts.setFXCMProductID(gr.getValueInt("9080"));
                    ts.setFXCMCondDistStop(gr.getValueDouble("9090"));
                    ts.setFXCMCondDistLimit(gr.getValueDouble("9091"));
                    ts.setFXCMCondDistEntryStop(gr.getValueDouble("9092"));
                    ts.setFXCMCondDistEntryLimit(gr.getValueDouble("9093"));
                    ts.setFXCMMaxQuantity(gr.getValueDouble("9094"));
                    ts.setFXCMMinQuantity(gr.getValueDouble("9095"));
                    ts.setFXCMTradingStatus(gr.getValueString("9096"));
                    this.setSecurity(ts);
                }
            }
            if ((grl = aMsg.getValueList("9016")) != null) {
                iterator = grl.values().iterator();
                while (iterator.hasNext()) {
                    gr = field = iterator.next();
                    Parameter par = new Parameter(gr.getValueString("9017"), gr.getValueString("9018"));
                    this.setParameter(par);
                }
            }
            if ((grl = aMsg.getValueList("9078")) != null) {
                iterator = grl.values().iterator();
                while (iterator.hasNext()) {
                    gr = field = iterator.next();
                    PriceStream ps = new PriceStream(gr.getValueInt("9077"), gr.getValueString("9072"));
                    this.setPriceStream(ps);
                }
            }
            this.setFXCMServerTimeZoneName(aMsg.getValueString("9030"));
            this.setFXCMServerTimeZone(aMsg.getValueInt("9019"));
        }
        return this.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFXCMNoParam() {
        Map map = this.mParameters;
        synchronized (map) {
            return this.mParameters.size();
        }
    }

    public int getFXCMServerTimeZone() {
        return this.mFXCMServerTimeZone;
    }

    public void setFXCMServerTimeZone(int aFXCMServerTimeZone) {
        this.mFXCMServerTimeZone = aFXCMServerTimeZone;
    }

    public String getFXCMServerTimeZoneName() {
        return this.mFXCMServerTimeZoneName;
    }

    public void setFXCMServerTimeZoneName(String aFXCMServerTimeZoneName) {
        this.mFXCMServerTimeZoneName = aFXCMServerTimeZoneName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNoRelatedSym() {
        Map map = this.mSecurities;
        synchronized (map) {
            return this.mSecurities.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Parameter getParameter(String aName) {
        Map map = this.mParameters;
        synchronized (map) {
            return (Parameter)this.mParameters.get(aName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getParameterValue(String aName) {
        Map map = this.mParameters;
        synchronized (map) {
            Parameter par = (Parameter)this.mParameters.get(aName);
            return par == null ? null : par.getValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getParameters() {
        Map map = this.mParameters;
        synchronized (map) {
            return Collections.enumeration(new ArrayList(this.mParameters.values()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PriceStream getPriceStream(int aID) {
        Map<Integer, PriceStream> map = this.mPriceStreams;
        synchronized (map) {
            return this.mPriceStreams.get(aID);
        }
    }

    public PriceStream getPriceStream(String aName) {
        PriceStream ret = null;
        Enumeration en = this.getPriceStreams();
        while (en.hasMoreElements()) {
            PriceStream ps = (PriceStream)en.nextElement();
            if (ps.getName() == null || !ps.getName().equalsIgnoreCase(aName)) continue;
            ret = ps;
            break;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getPriceStreams() {
        Map<Integer, PriceStream> map = this.mPriceStreams;
        synchronized (map) {
            return Collections.enumeration(new ArrayList<PriceStream>(this.mPriceStreams.values()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPriceStream(PriceStream aPriceStream) {
        Map<Integer, PriceStream> map = this.mPriceStreams;
        synchronized (map) {
            this.mPriceStreams.put(aPriceStream.getID(), aPriceStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFXCMNoPriceStream() {
        Map<Integer, PriceStream> map = this.mPriceStreams;
        synchronized (map) {
            return this.mPriceStreams.size();
        }
    }

    @Override
    public String getRequestID() {
        return this.getTradSesReqID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getSecurities() {
        Map map = this.mSecurities;
        synchronized (map) {
            return Collections.enumeration(new ArrayList(this.mSecurities.values()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TradingSecurity getSecurity(String aSymbol) {
        Map map = this.mSecurities;
        synchronized (map) {
            return (TradingSecurity)this.mSecurities.get(aSymbol);
        }
    }

    public IStatus getStatus() {
        return this.mTradSesStatus;
    }

    public String getText() {
        return this.mText;
    }

    public void setText(String aText) {
        this.mText = aText;
    }

    public UTCTimestamp getTradSesCloseTime() {
        return this.mTradSesCloseTime;
    }

    public void setTradSesCloseTime(UTCTimestamp aTradSesCloseTime) {
        this.mTradSesCloseTime = aTradSesCloseTime;
    }

    public ITradSesMode getTradSesMode() {
        return this.mTradSesMode;
    }

    public void setTradSesMode(ITradSesMode aTradSesMode) {
        this.mTradSesMode = aTradSesMode;
    }

    public UTCTimestamp getTradSesOpenTime() {
        return this.mTradSesOpenTime;
    }

    public void setTradSesOpenTime(UTCTimestamp aTradSesOpenTime) {
        this.mTradSesOpenTime = aTradSesOpenTime;
    }

    public String getTradSesReqID() {
        return this.mTradSesReqID;
    }

    public void setTradSesReqID(String aTradSesReqID) {
        this.mTradSesReqID = aTradSesReqID;
    }

    public UTCTimestamp getTradSesStartTime() {
        return this.mTradSesStartTime;
    }

    public void setTradSesStartTime(UTCTimestamp aTradSesStartTime) {
        this.mTradSesStartTime = aTradSesStartTime;
    }

    public ITradSesStatus getTradSesStatus() {
        return this.mTradSesStatus;
    }

    public ITradSesStatusRejReason getTradSesStatusRejReason() {
        return this.mTradSesStatusRejReason;
    }

    public void setTradSesStatusRejReason(ITradSesStatusRejReason aTradSesStatusRejReason) {
        this.mTradSesStatusRejReason = aTradSesStatusRejReason;
    }

    @Override
    public String getTradingSessionID() {
        return this.mTradingSessionID;
    }

    @Override
    public String getTradingSessionSubID() {
        return this.mTradingSessionSubID;
    }

    public UTCTimestamp getTransactTime() {
        return this.mTransactTime;
    }

    public void setTransactTime(UTCTimestamp aTransactTime) {
        this.mTransactTime = aTransactTime;
    }

    @Override
    public ICode getType() {
        return OBJ_TYPE;
    }

    public String getUnsolicitedIndicator() {
        return this.mUnsolicitedIndicator;
    }

    public void setUnsolicitedIndicator(String aUnsolicitedIndicator) {
        this.mUnsolicitedIndicator = aUnsolicitedIndicator;
        if (this.mUnsolicitedIndicator == null) {
            this.mUnsolicitedIndicator = "N";
        }
    }

    @Override
    public boolean isValid() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Map map = this.mSecurities;
        synchronized (map) {
            this.mSecurities.clear();
        }
        map = this.mParameters;
        synchronized (map) {
            this.mParameters.clear();
        }
        this.setTradingSessionID("FXCM");
        this.setTradingSessionSubID("");
        this.setTradSesMode(TradSesModeFactory.PRODUCTION);
        this.setTradSesStatus(TradSesStatusFactory.OPEN);
        this.setTradSesStatusRejReason(null);
        this.setTradSesStartTime(null);
        this.setTradSesOpenTime(null);
        this.setTradSesCloseTime(null);
        this.setText(null);
        Calendar calendar = Calendar.getInstance();
        int offset = calendar.get(15) + calendar.get(16);
        this.setFXCMServerTimeZone(offset / 3600000);
        this.setUnsolicitedIndicator("N");
        this.setTransactTime(null);
    }

    public void setCreationTime(Date aTime) {
    }

    public void setDeleted() {
    }

    public void setDesc(String aDesc) {
    }

    public void setModificationTime(Date aTime) {
    }

    public void setName(String aName) {
    }

    public void setNew() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameter(Parameter aParameter) {
        Map map = this.mParameters;
        synchronized (map) {
            this.mParameters.put(aParameter.getName(), aParameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSecurity(TradingSecurity aSecurity) {
        if (aSecurity != null) {
            try {
                Map map = this.mSecurities;
                synchronized (map) {
                    this.mSecurities.put(aSecurity.getSymbol(), aSecurity);
                }
            }
            catch (NotDefinedException notDefinedException) {
                // empty catch block
            }
        }
    }

    public void setStatus(IStatus aStatus) throws GenericException {
        this.setTradSesStatus((ITradSesStatus)aStatus);
    }

    public void setTradSesMode(int aTradSesMode) {
        this.setTradSesMode(TradSesModeFactory.toCode(aTradSesMode));
    }

    public void setTradSesStatus(int aTradSesStatus) {
        this.setTradSesStatus(TradSesStatusFactory.toStatus(aTradSesStatus));
    }

    public void setTradSesStatus(ITradSesStatus aTradSesStatus) {
        this.mTradSesStatus = aTradSesStatus != null ? aTradSesStatus : TradSesStatusFactory.OPEN;
    }

    public void setTradSesStatusRejReason(int aTradSesStatusRejReason) {
        this.setTradSesStatusRejReason(TradSesStatusRejReasonFactory.toCode(aTradSesStatusRejReason));
    }

    public void setTradingSessionID(String aTradingSessionID) {
        this.mTradingSessionID = aTradingSessionID;
    }

    public void setTradingSessionSubID(String aTradingSessionSubID) {
        this.mTradingSessionSubID = aTradingSessionSubID;
    }

    @Override
    public IMessage toMessage(String aSID, IMessageFactory aFactory) {
        return this.toMessage(aSID, null, null, null, 0, aFactory);
    }

    @Override
    public IMessage toMessage(String aSID, String aTradingSessionID, String aTradingSessionSubID, String aRequestID, int aOptions, IMessageFactory aFactory) {
        String tssubid;
        String tsid;
        String req = aRequestID;
        if (req == null) {
            req = this.getTradSesReqID();
        }
        if ((tsid = aTradingSessionID) == null) {
            tsid = this.getTradingSessionID();
        }
        if ((tssubid = aTradingSessionSubID) == null) {
            tssubid = this.getTradingSessionSubID();
        }
        IMessage ret = aFactory.createMessage(aSID, "h");
        if (this.getTransactTime() != null) {
            ret.setValue("60", this.getTransactTime().toString());
        }
        ret.setValue("335", req);
        if (this.getTradSesReqID() != null) {
            ret.setValue("325", "N");
        } else {
            ret.setValue("325", this.getUnsolicitedIndicator());
        }
        if (this.getTradSesStatus() != null) {
            ret.setValue("340", this.getTradSesStatus().getCode());
        }
        ret.setValue("336", tsid);
        ret.setValue("625", tssubid);
        ret.setValue("58", this.getText());
        if (this.getTradSesStatus() == null || TradSesStatusFactory.REQUESTREJECTED == this.getTradSesStatus()) {
            if (this.getTradSesStatusRejReason() != null) {
                ret.setValue("567", this.getTradSesStatusRejReason().getCode());
            }
        } else {
            IFieldGroup gr;
            if (this.getTradSesStartTime() != null) {
                ret.setValue("341", this.getTradSesStartTime().toString());
            }
            if (this.getTradSesOpenTime() != null) {
                ret.setValue("342", this.getTradSesOpenTime().toString());
            }
            if (this.getTradSesCloseTime() != null) {
                ret.setValue("344", this.getTradSesCloseTime().toString());
            }
            if (this.getTradSesMode() != null) {
                ret.setValue("339", this.getTradSesMode().getCode());
            }
            ret.setValue("9019", this.getFXCMServerTimeZone());
            ret.setValue("9030", this.getFXCMServerTimeZoneName());
            Enumeration enumeration = this.getSecurities();
            IFieldGroupList grl = aFactory.createFieldGroupList();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    try {
                        TradingSecurity ts = (TradingSecurity)enumeration.nextElement();
                        gr = aFactory.createFieldGroup();
                        gr.setValue("55", ts.getSymbol());
                        gr.setValue("9000", ts.getFXCMSymID());
                        gr.setValue("9001", ts.getFXCMSymPrecision());
                        gr.setValue("9002", ts.getFXCMSymPointSize());
                        gr.setValue("9005", ts.getFXCMSymSortOrder());
                        gr.setValue("15", ts.getCurrency());
                        gr.setValue("561", ts.getRoundLot());
                        gr.setValue("9003", ts.getFXCMSymInterestBuy());
                        gr.setValue("9004", ts.getFXCMSymInterestSell());
                        gr.setValue("9076", ts.getFXCMSubscriptionStatus());
                        int product = ts.getProduct();
                        if (product >= 1 && product <= 13) {
                            gr.setValue("460", product);
                        }
                        gr.setValue("231", ts.getContractMultiplier());
                        gr.setValue("228", ts.getFactor());
                        gr.setValue("461", ts.getCFICode());
                        gr.setValue("167", ts.getSecurityType());
                        gr.setValue("9080", ts.getFXCMProductID());
                        gr.setValue("9090", ts.getFXCMCondDistStop());
                        gr.setValue("9091", ts.getFXCMCondDistLimit());
                        gr.setValue("9092", ts.getFXCMCondDistEntryStop());
                        gr.setValue("9093", ts.getFXCMCondDistEntryLimit());
                        gr.setValue("9094", ts.getFXCMMaxQuantity());
                        gr.setValue("9095", ts.getFXCMMinQuantity());
                        gr.setValue("9096", ts.getFXCMTradingStatus());
                        grl.put(gr);
                    }
                    catch (Exception ts) {}
                }
            }
            ret.setValue("146", grl);
            enumeration = this.getParameters();
            grl = aFactory.createFieldGroupList();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    Parameter par = (Parameter)enumeration.nextElement();
                    if (par.getName() == null || par.getName().trim().length() <= 0 || par.getValue() == null || par.getValue().trim().length() <= 0) continue;
                    gr = aFactory.createFieldGroup();
                    gr.setValue("9017", par.getName());
                    gr.setValue("9018", par.getValue());
                    grl.put(gr);
                }
            }
            ret.setValue("9016", grl);
            enumeration = this.getPriceStreams();
            grl = aFactory.createFieldGroupList();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    PriceStream ps = (PriceStream)enumeration.nextElement();
                    gr = aFactory.createFieldGroup();
                    gr.setValue("9077", ps.getID());
                    gr.setValue("9072", ps.getName());
                    grl.put(gr);
                }
            }
            ret.setValue("9078", grl);
        }
        return ret;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("TradingSessionStatus");
        buf.append("{mFXCMServerTimeZone=").append(this.mFXCMServerTimeZone);
        buf.append(",mFXCMServerTimeZoneName=").append(this.mFXCMServerTimeZoneName);
        buf.append(",mParameters=").append(this.mParameters);
        buf.append(",mSecurities=").append(this.mSecurities);
        buf.append(",mPriceStreams=").append(this.mPriceStreams);
        buf.append(",mText=").append(this.mText);
        buf.append(",mTradSesCloseTime=").append(this.mTradSesCloseTime);
        buf.append(",mTradSesMode=").append(this.mTradSesMode);
        buf.append(",mTradSesOpenTime=").append(this.mTradSesOpenTime);
        buf.append(",mTradSesReqID=").append(this.mTradSesReqID);
        buf.append(",mTradSesStartTime=").append(this.mTradSesStartTime);
        buf.append(",mTradSesStatus=").append(this.mTradSesStatus);
        buf.append(",mTradSesStatusRejReason=").append(this.mTradSesStatusRejReason);
        buf.append(",mTradingSessionID=").append(this.mTradingSessionID);
        buf.append(",mTradingSessionSubID=").append(this.mTradingSessionSubID);
        buf.append(",mTransactTime=").append(this.mTransactTime);
        buf.append(",mUnsolicitedIndicator=").append(this.mUnsolicitedIndicator);
        buf.append('}');
        return buf.toString();
    }

    @Override
    public boolean update(IMessage aMsg) {
        return this.fill(aMsg);
    }

    @Override
    public long getMakingTime() {
        return this.mMakingTime;
    }

    private static class TradingSessionStatusType
    extends ACode {
        private static final long serialVersionUID = -5905548299550061722L;

        TradingSessionStatusType() {
            super("h", "TradingSessionStatus", "");
        }
    }
}

