/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix.pretrade;

import com.fxcm.entity.ACode;
import com.fxcm.entity.ICode;
import com.fxcm.fix.ATradeTransportable;
import com.fxcm.fix.ISubscriptionRequestType;
import com.fxcm.fix.Instrument;
import com.fxcm.fix.SubscriptionRequestTypeFactory;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.IMessageFactory;

public class SecurityStatusRequest
extends ATradeTransportable {
    public static final ICode OBJ_TYPE = new SecurityStatusRequestType();
    private String mSecurityStatusReqID;
    private ISubscriptionRequestType mSubscriptionRequestType;

    public SecurityStatusRequest() {
        this.reset();
    }

    public SecurityStatusRequest(String aSymbol) {
        this.reset();
        this.mInstrument = new Instrument(aSymbol);
    }

    @Override
    public boolean fill(IMessage aMsg) {
        this.reset();
        this.setSecurityStatusReqID(aMsg.getValueString("324"));
        this.setSubscriptionRequestType(aMsg.getValueString("324"));
        this.setTradingSessionID(aMsg.getValueString("336"));
        this.setTradingSessionSubID(aMsg.getValueString("625"));
        this.setInstrument(new Instrument(aMsg.getValueString("55")));
        return this.isValid();
    }

    @Override
    public String getRequestID() {
        return this.getSecurityStatusReqID();
    }

    public String getSecurityStatusReqID() {
        return this.mSecurityStatusReqID;
    }

    public void setSecurityStatusReqID(String aSecurityStatusReqID) {
        this.mSecurityStatusReqID = aSecurityStatusReqID;
    }

    public ISubscriptionRequestType getSubscriptionRequestType() {
        return this.mSubscriptionRequestType;
    }

    @Override
    public ICode getType() {
        return OBJ_TYPE;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void reset() {
        super.reset();
        this.setInstrument(null);
        this.setSecurityStatusReqID(null);
        this.setTradingSessionID("FXCM");
        this.setTradingSessionID("");
        this.setSubscriptionRequestType(SubscriptionRequestTypeFactory.SNAPSHOT);
    }

    public void setSubscriptionRequestType(String aSubscriptionRequestType) {
        this.setSubscriptionRequestType(SubscriptionRequestTypeFactory.toCode(aSubscriptionRequestType));
    }

    public void setSubscriptionRequestType(ISubscriptionRequestType aSubscriptionRequestType) {
        this.mSubscriptionRequestType = aSubscriptionRequestType == null ? SubscriptionRequestTypeFactory.SNAPSHOT : aSubscriptionRequestType;
    }

    @Override
    public IMessage toMessage(String aSID, String aTradingSessionID, String aTradingSessionSubID, String aRequestID, int aOptions, IMessageFactory aFactory) {
        IMessage ret = super.toMessage(aSID, aTradingSessionID, aTradingSessionSubID, aRequestID, aOptions, aFactory);
        String req = aRequestID;
        if (req == null) {
            req = this.getRequestID();
        }
        ret.setValue("324", req);
        if (this.getSubscriptionRequestType() != null) {
            ret.setValue("263", this.getSubscriptionRequestType().getCode());
        }
        try {
            ret.setValue("55", this.getInstrument().getSymbol());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("SecurityStatusRequest");
        sb.append(" --- begin superclass toString ");
        sb.append(super.toString());
        sb.append(" --- end superclass toString ");
        sb.append("{mSecurityStatusReqID='").append(this.mSecurityStatusReqID).append('\'');
        sb.append(", mSubscriptionRequestType=").append(this.mSubscriptionRequestType);
        sb.append('}');
        return sb.toString();
    }

    private static class SecurityStatusRequestType
    extends ACode {
        SecurityStatusRequestType() {
            super("e", "SecurityStatusRequest", "");
        }
    }
}

