/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix.pretrade;

import com.fxcm.entity.ACode;
import com.fxcm.entity.ICode;
import com.fxcm.fix.IFixDefs;
import com.fxcm.fix.TradingSecurity;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.IMessageFactory;
import com.fxcm.messaging.ITransportable;

public class SecurityStatus
implements ITransportable,
IFixDefs {
    public static final ICode OBJ_TYPE = new SecurityStatusType();
    private TradingSecurity mSecurity;
    private String mSecurityStatusReqID;
    private String mTradingSessionID;
    private String mTradingSessionSubID;
    private long mMakingTime = System.currentTimeMillis();

    public SecurityStatus() {
        this.reset();
    }

    public SecurityStatus(TradingSecurity aSecurity) {
        this.reset();
        this.mSecurity = aSecurity;
    }

    @Override
    public boolean fill(IMessage aMsg) {
        this.reset();
        if (aMsg.getValueString("55") != null) {
            this.mSecurity = new TradingSecurity(aMsg.getValueString("55"), aMsg.getValueInt("9000"), aMsg.getValueInt("9001"), aMsg.getValueDouble("9002"), aMsg.getValueInt("9005"), aMsg.getValueString("15"), aMsg.getValueDouble("561"));
            this.mSecurity.setFXCMSymInterestBuy(aMsg.getValueDouble("9003"));
            this.mSecurity.setFXCMSymInterestSell(aMsg.getValueDouble("9004"));
            this.mSecurity.setFXCMSubscriptionStatus(aMsg.getValueString("9076"));
            int product = aMsg.getValueInt("460");
            if (product >= 1 && product <= 13) {
                this.mSecurity.setProduct(product);
            }
            this.mSecurity.setContractMultiplier(aMsg.getValueDouble("231"));
            this.mSecurity.setFactor(aMsg.getValueInt("228"));
            this.mSecurity.setCFICode(aMsg.getValueString("461"));
            this.mSecurity.setSecurityType(aMsg.getValueString("167"));
            this.mSecurity.setFXCMProductID(aMsg.getValueInt("9080"));
            this.mSecurity.setFXCMCondDistStop(aMsg.getValueDouble("9090"));
            this.mSecurity.setFXCMCondDistLimit(aMsg.getValueDouble("9091"));
            this.mSecurity.setFXCMCondDistEntryStop(aMsg.getValueDouble("9092"));
            this.mSecurity.setFXCMCondDistEntryLimit(aMsg.getValueDouble("9093"));
            this.mSecurity.setFXCMMaxQuantity(aMsg.getValueDouble("9094"));
            this.mSecurity.setFXCMMinQuantity(aMsg.getValueDouble("9095"));
            this.mSecurity.setFXCMTradingStatus(aMsg.getValueString("9096"));
        }
        this.setTradingSessionID(aMsg.getValueString("336"));
        this.setTradingSessionSubID(aMsg.getValueString("625"));
        this.setSecurityStatusReqID(aMsg.getValueString("324"));
        return this.isValid();
    }

    @Override
    public String getRequestID() {
        return this.getSecurityStatusReqID();
    }

    public String getSecurityStatusReqID() {
        return this.mSecurityStatusReqID;
    }

    public void setSecurityStatusReqID(String aSecurityStatusReqID) {
        this.mSecurityStatusReqID = aSecurityStatusReqID;
    }

    public TradingSecurity getTradingSecurity() {
        return this.mSecurity;
    }

    @Override
    public String getTradingSessionID() {
        return this.mTradingSessionID;
    }

    @Override
    public String getTradingSessionSubID() {
        return this.mTradingSessionSubID;
    }

    @Override
    public ICode getType() {
        return OBJ_TYPE;
    }

    @Override
    public boolean isValid() {
        return this.mSecurity != null;
    }

    private void reset() {
        this.setTradingSecurity(null);
        this.setSecurityStatusReqID(null);
        this.setTradingSessionID("FXCM");
        this.setTradingSessionID("");
    }

    public void setTradingSecurity(TradingSecurity aSecurity) {
        this.mSecurity = aSecurity;
    }

    public void setTradingSessionID(String aTradingSessionID) {
        this.mTradingSessionID = aTradingSessionID != null ? aTradingSessionID : "FXCM";
    }

    public void setTradingSessionSubID(String aTradingSessionSubID) {
        this.mTradingSessionSubID = aTradingSessionSubID != null ? aTradingSessionSubID : "";
    }

    @Override
    public IMessage toMessage(String aSID, IMessageFactory aFactory) {
        return this.toMessage(aSID, null, null, null, 0, aFactory);
    }

    @Override
    public IMessage toMessage(String aSID, String aTradingSessionID, String aTradingSessionSubID, String aRequestID, int aOptions, IMessageFactory aFactory) {
        String tssubid;
        String tsid;
        String req = aRequestID;
        if (req == null) {
            req = this.getSecurityStatusReqID();
        }
        if ((tsid = aTradingSessionID) == null) {
            tsid = this.getTradingSessionID();
        }
        if ((tssubid = aTradingSessionSubID) == null) {
            tssubid = this.getTradingSessionSubID();
        }
        IMessage ret = aFactory.createMessage(aSID, "f");
        if (this.getTradingSecurity() != null) {
            try {
                int product;
                try {
                    ret.setValue("55", this.getTradingSecurity().getSymbol());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.getTradingSecurity().getFXCMSymID() != 0) {
                    ret.setValue("9000", this.getTradingSecurity().getFXCMSymID());
                }
                if (this.getTradingSecurity().getFXCMSymPrecision() != 0) {
                    ret.setValue("9001", this.getTradingSecurity().getFXCMSymPrecision());
                }
                if (this.getTradingSecurity().getFXCMSymPointSize() != 0.0) {
                    ret.setValue("9002", this.getTradingSecurity().getFXCMSymPointSize());
                }
                if (this.getTradingSecurity().getFXCMSymSortOrder() != 0) {
                    ret.setValue("9005", this.getTradingSecurity().getFXCMSymSortOrder());
                }
                if (this.getTradingSecurity().getCurrency() != null) {
                    ret.setValue("15", this.getTradingSecurity().getCurrency());
                }
                if (this.getTradingSecurity().getRoundLot() != 0.0) {
                    ret.setValue("561", this.getTradingSecurity().getRoundLot());
                }
                if (this.getTradingSecurity().getFXCMSymInterestBuy() != 0.0) {
                    ret.setValue("9003", this.getTradingSecurity().getFXCMSymInterestBuy());
                }
                if (this.getTradingSecurity().getFXCMSymInterestSell() != 0.0) {
                    ret.setValue("9004", this.getTradingSecurity().getFXCMSymInterestSell());
                }
                if (this.getTradingSecurity().getFXCMSubscriptionStatus() != null) {
                    ret.setValue("9076", this.getTradingSecurity().getFXCMSubscriptionStatus());
                }
                if ((product = this.getTradingSecurity().getProduct()) >= 1 && product <= 13) {
                    ret.setValue("460", product);
                }
                if (this.getTradingSecurity().getContractMultiplier() != 0.0) {
                    ret.setValue("231", this.getTradingSecurity().getContractMultiplier());
                }
                if (this.getTradingSecurity().getFactor() != 0) {
                    ret.setValue("228", this.getTradingSecurity().getFactor());
                }
                if (this.getTradingSecurity().getCFICode() != null) {
                    ret.setValue("461", this.getTradingSecurity().getCFICode());
                }
                if (this.getTradingSecurity().getSecurityType() != null) {
                    ret.setValue("167", this.getTradingSecurity().getSecurityType());
                }
                if (this.getTradingSecurity().getFXCMProductID() != 0) {
                    ret.setValue("9080", this.getTradingSecurity().getFXCMProductID());
                }
                if (this.getTradingSecurity().getFXCMCondDistStop() != 0.0) {
                    ret.setValue("9090", this.getTradingSecurity().getFXCMCondDistStop());
                }
                if (this.getTradingSecurity().getFXCMCondDistLimit() != 0.0) {
                    ret.setValue("9091", this.getTradingSecurity().getFXCMCondDistLimit());
                }
                if (this.getTradingSecurity().getFXCMCondDistEntryStop() != 0.0) {
                    ret.setValue("9092", this.getTradingSecurity().getFXCMCondDistEntryStop());
                }
                if (this.getTradingSecurity().getFXCMCondDistEntryLimit() != 0.0) {
                    ret.setValue("9093", this.getTradingSecurity().getFXCMCondDistEntryLimit());
                }
                if (this.getTradingSecurity().getFXCMMaxQuantity() != 0.0) {
                    ret.setValue("9094", this.getTradingSecurity().getFXCMMaxQuantity());
                }
                if (this.getTradingSecurity().getFXCMMinQuantity() != 0.0) {
                    ret.setValue("9095", this.getTradingSecurity().getFXCMMinQuantity());
                }
                if (this.getTradingSecurity().getFXCMTradingStatus() != null) {
                    ret.setValue("9096", this.getTradingSecurity().getFXCMTradingStatus());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ret.setValue("325", "Y");
        ret.setValue("336", tsid);
        ret.setValue("625", tssubid);
        ret.setValue("324", req);
        return ret;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("SecurityStatus");
        sb.append("{mSecurity=").append(this.mSecurity);
        sb.append(", mSecurityStatusReqID='").append(this.mSecurityStatusReqID).append('\'');
        sb.append(", mTradingSessionID='").append(this.mTradingSessionID).append('\'');
        sb.append(", mTradingSessionSubID='").append(this.mTradingSessionSubID).append('\'');
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean update(IMessage aMsg) {
        return this.fill(aMsg);
    }

    @Override
    public long getMakingTime() {
        return this.mMakingTime;
    }

    private static class SecurityStatusType
    extends ACode {
        SecurityStatusType() {
            super("f", "SecurityStatusType", "");
        }
    }
}

