/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix.pretrade;

import com.fxcm.entity.ACode;
import com.fxcm.entity.ICode;
import com.fxcm.fix.IFixDefs;
import com.fxcm.fix.Instrument;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.IMessageFactory;
import com.fxcm.messaging.ITransportable;

public class SecurityListRequest
implements ITransportable,
IFixDefs {
    public static final int SECURITYLISTREQUESTTYPE_SYMBOL = 0;
    public static final int SECURITYLISTREQUESTTYPE_ALL = 4;
    public static final ICode OBJ_TYPE = new SecurityListRequestType();
    private Instrument mInstrument;
    private int mSecurityListRequestType;
    private String mSecurityReqID;
    private String mTradingSessionID;
    private String mTradingSessionSubID;
    private long mMakingTime = System.currentTimeMillis();

    public SecurityListRequest() {
        this.reset();
    }

    public SecurityListRequest(int aSecurityListRequestType) {
        this.mSecurityListRequestType = aSecurityListRequestType;
    }

    public SecurityListRequest(Instrument aInstrument, int aSecurityListRequestType) {
        this.reset();
        this.mInstrument = aInstrument;
        this.mSecurityListRequestType = aSecurityListRequestType;
    }

    @Override
    public boolean fill(IMessage aMsg) {
        this.reset();
        if (aMsg.getValueString("55") != null) {
            this.setInstrument(new Instrument(aMsg.getValueString("55")));
        }
        this.setSecurityListRequestType(aMsg.getValueInt("559"));
        this.setSecurityReqID(aMsg.getValueString("320"));
        this.setTradingSessionID(aMsg.getValueString("336"));
        this.setTradingSessionSubID(aMsg.getValueString("625"));
        return this.isValid();
    }

    public Instrument getInstrument() {
        return this.mInstrument;
    }

    public void setInstrument(Instrument aInstrument) {
        this.mInstrument = aInstrument;
    }

    @Override
    public String getRequestID() {
        return this.getSecurityReqID();
    }

    public int getSecurityListRequestType() {
        return this.mSecurityListRequestType;
    }

    public void setSecurityListRequestType(int aSecurityListRequestType) {
        this.mSecurityListRequestType = aSecurityListRequestType;
    }

    public String getSecurityReqID() {
        return this.mSecurityReqID;
    }

    public void setSecurityReqID(String aSecurityReqID) {
        this.mSecurityReqID = aSecurityReqID;
    }

    @Override
    public String getTradingSessionID() {
        return this.mTradingSessionID;
    }

    public void setTradingSessionID(String aTradingSessionID) {
        this.mTradingSessionID = aTradingSessionID;
    }

    @Override
    public String getTradingSessionSubID() {
        return this.mTradingSessionSubID;
    }

    public void setTradingSessionSubID(String aTradingSessionSubID) {
        this.mTradingSessionSubID = aTradingSessionSubID;
    }

    @Override
    public ICode getType() {
        return OBJ_TYPE;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    private void reset() {
        this.setInstrument(null);
        this.setSecurityListRequestType(-1);
        this.setSecurityReqID(null);
        this.setTradingSessionID("FXCM");
        this.setTradingSessionID("");
    }

    @Override
    public IMessage toMessage(String aSID, IMessageFactory aFactory) {
        return this.toMessage(aSID, null, null, null, 0, aFactory);
    }

    @Override
    public IMessage toMessage(String aSID, String aTradingSessionID, String aTradingSessionSubID, String aRequestID, int aOptions, IMessageFactory aFactory) {
        String tssubid;
        String tsid;
        String req = aRequestID;
        if (req == null) {
            req = this.getSecurityReqID();
        }
        if ((tsid = aTradingSessionID) == null) {
            tsid = this.getTradingSessionID();
        }
        if ((tssubid = aTradingSessionSubID) == null) {
            tssubid = this.getTradingSessionSubID();
        }
        IMessage ret = aFactory.createMessage(aSID, "x");
        if (this.mInstrument != null) {
            try {
                ret.setValue("55", this.getInstrument().getSymbol());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ret.setValue("559", this.getSecurityListRequestType());
        ret.setValue("320", req);
        ret.setValue("336", tsid);
        ret.setValue("625", tssubid);
        return ret;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("SecurityListRequest");
        sb.append("{mInstrument=").append(this.mInstrument);
        sb.append(", mSecurityListRequestType=").append(this.mSecurityListRequestType);
        sb.append(", mSecurityReqID='").append(this.mSecurityReqID).append('\'');
        sb.append(", mTradingSessionID='").append(this.mTradingSessionID).append('\'');
        sb.append(", mTradingSessionSubID='").append(this.mTradingSessionSubID).append('\'');
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean update(IMessage aMsg) {
        return this.fill(aMsg);
    }

    @Override
    public long getMakingTime() {
        return this.mMakingTime;
    }

    private static class SecurityListRequestType
    extends ACode {
        SecurityListRequestType() {
            super("x", "SecurityListRequest", "");
        }
    }
}

