/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix.pretrade;

import com.fxcm.entity.ACode;
import com.fxcm.entity.ICode;
import com.fxcm.fix.IFixDefs;
import com.fxcm.fix.NotDefinedException;
import com.fxcm.fix.TradingSecurity;
import com.fxcm.messaging.IFieldGroup;
import com.fxcm.messaging.IFieldGroupList;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.IMessageFactory;
import com.fxcm.messaging.ITransportable;
import java.util.ArrayList;
import java.util.List;

public class SecurityList
implements ITransportable,
IFixDefs {
    public static final ICode OBJ_TYPE = new SecurityListType();
    public static final int SECURITY_REQUEST_RESULT_VALID = 0;
    public static final int SECURITY_REQUEST_RESULT_INVALID = 1;
    public static final int SECURITY_REQUEST_RESULT_NO_INSTRUMENTS_MATCH = 2;
    public static final int SECURITY_REQUEST_RESULT_UNAUTHORIZED = 3;
    public static final int SECURITY_REQUEST_RESULT_TEMP_UNAVAILABLE = 4;
    public static final int SECURITY_REQUEST_RESULT_UNSUPPORTED = 5;
    private List mSecurities = new ArrayList();
    private String mSecurityReqID;
    private int mSecurityRequestResult;
    private String mSecurityResponseID;
    private String mTradingSessionID;
    private String mTradingSessionSubID;
    private long mMakingTime = System.currentTimeMillis();

    public SecurityList() {
        this.reset();
    }

    @Override
    public boolean fill(IMessage aMsg) {
        this.reset();
        this.setSecurityReqID(aMsg.getValueString("320"));
        this.setSecurityRequestResult(aMsg.getValueInt("560"));
        this.setSecurityResponseID(aMsg.getValueString("322"));
        this.setTradingSessionID(aMsg.getValueString("336"));
        this.setTradingSessionSubID(aMsg.getValueString("625"));
        IFieldGroupList grl = aMsg.getValueList("146");
        if (grl != null) {
            for (IFieldGroup gr : grl.values()) {
                TradingSecurity ts = new TradingSecurity();
                ts.setSymbol(gr.getValueString("55"));
                ts.setFXCMSymID(gr.getValueInt("9000"));
                ts.setFXCMSymPrecision(gr.getValueInt("9001"));
                ts.setFXCMSymPointSize(gr.getValueDouble("9002"));
                ts.setFXCMSymSortOrder(gr.getValueInt("9005"));
                ts.setCurrency(gr.getValueString("15"));
                ts.setRoundLot(gr.getValueDouble("561"));
                ts.setFXCMSymInterestBuy(gr.getValueDouble("9003"));
                ts.setFXCMSymInterestSell(gr.getValueDouble("9004"));
                int product = gr.getValueInt("460");
                if (product >= 1 && product <= 13) {
                    ts.setProduct(product);
                }
                ts.setContractMultiplier(gr.getValueDouble("231"));
                ts.setFactor(gr.getValueInt("228"));
                ts.setCFICode(gr.getValueString("461"));
                ts.setSecurityType(gr.getValueString("167"));
                ts.setFXCMProductID(gr.getValueInt("9080"));
                ts.setFXCMCondDistStop(gr.getValueDouble("9090"));
                ts.setFXCMCondDistLimit(gr.getValueDouble("9091"));
                ts.setFXCMCondDistEntryStop(gr.getValueDouble("9092"));
                ts.setFXCMCondDistEntryLimit(gr.getValueDouble("9093"));
                ts.setFXCMMaxQuantity(gr.getValueDouble("9094"));
                ts.setFXCMMinQuantity(gr.getValueDouble("9095"));
                ts.setFXCMTradingStatus(gr.getValueString("9096"));
                this.mSecurities.add(ts);
            }
        }
        return this.isValid();
    }

    public int getNoRelatedSym() {
        return this.mSecurities.size();
    }

    @Override
    public String getRequestID() {
        return this.getSecurityResponseID();
    }

    public List getSecurities() {
        return this.mSecurities;
    }

    public void setSecurities(List aSecurities) {
        this.mSecurities = aSecurities;
    }

    public String getSecurityReqID() {
        return this.mSecurityReqID;
    }

    public void setSecurityReqID(String aSecurityReqID) {
        this.mSecurityReqID = aSecurityReqID;
    }

    public int getSecurityRequestResult() {
        return this.mSecurityRequestResult;
    }

    public void setSecurityRequestResult(int aSecurityRequestResult) {
        this.mSecurityRequestResult = aSecurityRequestResult;
    }

    public String getSecurityResponseID() {
        return this.mSecurityResponseID;
    }

    public void setSecurityResponseID(String aSecurityResponseID) {
        this.mSecurityResponseID = aSecurityResponseID;
    }

    @Override
    public String getTradingSessionID() {
        return this.mTradingSessionID;
    }

    public void setTradingSessionID(String aTradingSessionID) {
        this.mTradingSessionID = aTradingSessionID;
    }

    @Override
    public String getTradingSessionSubID() {
        return this.mTradingSessionSubID;
    }

    public void setTradingSessionSubID(String aTradingSessionSubID) {
        this.mTradingSessionSubID = aTradingSessionSubID;
    }

    @Override
    public ICode getType() {
        return OBJ_TYPE;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    private void reset() {
        this.setSecurityReqID(null);
        this.setSecurityRequestResult(0);
        this.setSecurityResponseID(null);
        this.getSecurities().clear();
        this.setTradingSessionID("FXCM");
        this.setTradingSessionID("");
    }

    public void setSecurity(TradingSecurity aSecurity) {
        this.mSecurities.add(aSecurity);
    }

    @Override
    public IMessage toMessage(String aSID, IMessageFactory aFactory) {
        return this.toMessage(aSID, null, null, null, 0, aFactory);
    }

    @Override
    public IMessage toMessage(String aSID, String aTradingSessionID, String aTradingSessionSubID, String aRequestID, int aOptions, IMessageFactory aFactory) {
        String tssubid;
        String tsid;
        String req = aRequestID;
        if (req == null) {
            req = this.getSecurityReqID();
        }
        if ((tsid = aTradingSessionID) == null) {
            tsid = this.getTradingSessionID();
        }
        if ((tssubid = aTradingSessionSubID) == null) {
            tssubid = this.getTradingSessionSubID();
        }
        IMessage ret = aFactory.createMessage(aSID, "y");
        ret.setValue("320", req);
        ret.setValue("560", this.getSecurityRequestResult());
        ret.setValue("322", this.getSecurityResponseID());
        ret.setValue("336", tsid);
        ret.setValue("625", tssubid);
        IFieldGroupList grl = aFactory.createFieldGroupList();
        for (int i = 0; i < this.mSecurities.size(); ++i) {
            try {
                TradingSecurity ts = (TradingSecurity)this.mSecurities.get(i);
                IFieldGroup gr = aFactory.createFieldGroup();
                gr.setValue("55", ts.getSymbol());
                gr.setValue("9000", ts.getFXCMSymID());
                gr.setValue("9001", ts.getFXCMSymPrecision());
                gr.setValue("9002", ts.getFXCMSymPointSize());
                gr.setValue("9005", ts.getFXCMSymSortOrder());
                gr.setValue("15", ts.getCurrency());
                gr.setValue("561", ts.getRoundLot());
                gr.setValue("9003", ts.getFXCMSymInterestBuy());
                gr.setValue("9004", ts.getFXCMSymInterestSell());
                int product = ts.getProduct();
                if (product >= 1 && product <= 13) {
                    gr.setValue("460", product);
                }
                gr.setValue("231", ts.getContractMultiplier());
                gr.setValue("228", ts.getFactor());
                gr.setValue("461", ts.getCFICode());
                gr.setValue("167", ts.getSecurityType());
                gr.setValue("9080", ts.getFXCMProductID());
                gr.setValue("9090", ts.getFXCMCondDistStop());
                gr.setValue("9091", ts.getFXCMCondDistLimit());
                gr.setValue("9092", ts.getFXCMCondDistEntryStop());
                gr.setValue("9093", ts.getFXCMCondDistEntryLimit());
                gr.setValue("9094", ts.getFXCMMaxQuantity());
                gr.setValue("9095", ts.getFXCMMinQuantity());
                gr.setValue("9096", ts.getFXCMTradingStatus());
                grl.put(gr);
                continue;
            }
            catch (NotDefinedException notDefinedException) {
                // empty catch block
            }
        }
        ret.setValue("146", grl);
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SecurityList");
        sb.append("{mSecurities=").append(this.mSecurities);
        sb.append(", mSecurityReqID='").append(this.mSecurityReqID).append('\'');
        sb.append(", mSecurityRequestResult=").append(this.mSecurityRequestResult);
        sb.append(", mSecurityResponseID='").append(this.mSecurityResponseID).append('\'');
        sb.append(", mTradingSessionID='").append(this.mTradingSessionID).append('\'');
        sb.append(", mTradingSessionSubID='").append(this.mTradingSessionSubID).append('\'');
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean update(IMessage aMsg) {
        return this.fill(aMsg);
    }

    @Override
    public long getMakingTime() {
        return this.mMakingTime;
    }

    private static class SecurityListType
    extends ACode {
        private static final long serialVersionUID = 3493870687263127973L;

        SecurityListType() {
            super("y", "SecurityListType", "");
        }
    }
}

