/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix.pretrade;

import com.fxcm.entity.ACode;
import com.fxcm.entity.ICode;
import com.fxcm.fix.IFixDefs;
import com.fxcm.fix.IQuoteRespType;
import com.fxcm.fix.ISide;
import com.fxcm.fix.Instrument;
import com.fxcm.fix.Parties;
import com.fxcm.fix.QuoteRespTypeFactory;
import com.fxcm.fix.SideFactory;
import com.fxcm.fix.UTCTimestamp;
import com.fxcm.messaging.IFieldGroupList;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.IMessageFactory;
import com.fxcm.messaging.ITransportable;

public class QuoteResponse
implements ITransportable,
IFixDefs {
    public static final ICode OBJ_TYPE = new QuoteResponseType();
    protected String mAccount;
    protected String mClOrdID;
    protected String mSecondaryClOrdID;
    protected Instrument mInstrument;
    protected Parties mParties;
    protected String mTradingSessionID;
    protected String mTradingSessionSubID;
    protected UTCTimestamp mTransactTime;
    private double mBidPx;
    private double mOfferPx;
    private String mQuoteID;
    private String mQuoteRespID;
    private IQuoteRespType mQuoteRespType;
    protected ISide mSide;
    protected double mOrderQty;
    protected String mCurrency;
    private long mMakingTime = System.currentTimeMillis();

    public String getAccount() {
        return this.mAccount;
    }

    public void setAccount(String account) {
        this.mAccount = account;
    }

    public String getClOrdID() {
        return this.mClOrdID;
    }

    public void setClOrdID(String clOrdID) {
        this.mClOrdID = clOrdID;
    }

    public Instrument getInstrument() {
        return this.mInstrument;
    }

    public void setInstrument(Instrument aInstrument) {
        this.mInstrument = aInstrument;
    }

    public Parties getParties() {
        return this.mParties;
    }

    public void setParties(Parties aParties) {
        this.mParties = aParties;
        if (this.mParties == null) {
            this.mParties = new Parties();
        }
    }

    public String getSecondaryClOrdID() {
        return this.mSecondaryClOrdID;
    }

    public void setSecondaryClOrdID(String mSecondaryClOrdID) {
        this.mSecondaryClOrdID = mSecondaryClOrdID;
    }

    public void setTradingSessionID(String aTradingSessionID) {
        this.mTradingSessionID = aTradingSessionID != null ? aTradingSessionID : "FXCM";
    }

    public void setTradingSessionSubID(String aTradingSessionSubID) {
        this.mTradingSessionSubID = aTradingSessionSubID != null ? aTradingSessionSubID : "";
    }

    @Override
    public String getTradingSessionID() {
        return this.mTradingSessionID;
    }

    @Override
    public String getTradingSessionSubID() {
        return this.mTradingSessionSubID;
    }

    public UTCTimestamp getTransactTime() {
        return this.mTransactTime;
    }

    public void setTransactTime(UTCTimestamp aTransactTime) {
        this.mTransactTime = aTransactTime != null ? aTransactTime : new UTCTimestamp();
    }

    @Override
    public boolean fill(IMessage aMsg) {
        this.reset();
        if (aMsg.getValueString("55") != null) {
            this.setInstrument(new Instrument(aMsg.getValueString("55"), aMsg.getValueInt("9000"), 0));
        }
        if (aMsg.getValueString("60") != null) {
            this.setTransactTime(new UTCTimestamp(aMsg.getValueString("60")));
        }
        this.setTradingSessionID(aMsg.getValueString("336"));
        this.setTradingSessionSubID(aMsg.getValueString("625"));
        this.setClOrdID(aMsg.getValueString("11"));
        this.setSecondaryClOrdID(aMsg.getValueString("526"));
        this.setAccount(aMsg.getValueString("1"));
        this.mParties.fill(aMsg.getValueList("453"));
        this.setBidPx(aMsg.getValueDouble("132"));
        this.setOfferPx(aMsg.getValueDouble("133"));
        this.setQuoteID(aMsg.getValueString("117"));
        this.setQuoteRespID(aMsg.getValueString("693"));
        this.setQuoteRespType(QuoteRespTypeFactory.toCode(aMsg.getValueInt("694")));
        this.setSide(SideFactory.toCode(aMsg.getValueString("54")));
        this.setOrderQty(aMsg.getValueDouble("38"));
        this.setCurrency(aMsg.getValueString("15"));
        return this.isValid();
    }

    public String getCurrency() {
        return this.mCurrency;
    }

    public void setCurrency(String aCurrency) {
        this.mCurrency = aCurrency;
    }

    public double getOrderQty() {
        return this.mOrderQty;
    }

    public void setOrderQty(double aOrderQty) {
        this.mOrderQty = aOrderQty;
    }

    public double getBidPx() {
        return this.mBidPx;
    }

    public void setBidPx(double aBidPx) {
        this.mBidPx = aBidPx;
    }

    public ISide getSide() {
        return this.mSide;
    }

    public void setSide(ISide aSide) {
        this.mSide = aSide;
    }

    public double getOfferPx() {
        return this.mOfferPx;
    }

    public void setOfferPx(double aOfferPx) {
        this.mOfferPx = aOfferPx;
    }

    public String getQuoteID() {
        return this.mQuoteID;
    }

    public void setQuoteID(String aQuoteID) {
        this.mQuoteID = aQuoteID;
    }

    public String getQuoteRespID() {
        return this.mQuoteRespID;
    }

    public void setQuoteRespID(String aQuoteRespID) {
        this.mQuoteRespID = aQuoteRespID;
    }

    public IQuoteRespType getQuoteRespType() {
        return this.mQuoteRespType;
    }

    public void setQuoteRespType(IQuoteRespType aQuoteRespType) {
        this.mQuoteRespType = aQuoteRespType;
    }

    @Override
    public String getRequestID() {
        return this.getQuoteRespID();
    }

    @Override
    public ICode getType() {
        return OBJ_TYPE;
    }

    @Override
    public boolean isValid() {
        return this.mQuoteRespID != null && this.mInstrument != null;
    }

    protected void reset() {
        this.mAccount = null;
        this.mClOrdID = null;
        this.mSecondaryClOrdID = null;
        this.mInstrument = null;
        this.mParties = new Parties();
        this.mTradingSessionID = "FXCM";
        this.mTradingSessionSubID = "";
        if (this.mTransactTime == null) {
            this.mTransactTime = new UTCTimestamp();
        } else {
            this.mTransactTime.setDate(null);
        }
        this.mBidPx = 0.0;
        this.mOfferPx = 0.0;
        this.mQuoteID = null;
        this.mQuoteRespID = null;
        this.mQuoteRespType = QuoteRespTypeFactory.PASS;
        this.mSide = null;
        this.mOrderQty = 0.0;
        this.mCurrency = null;
    }

    @Override
    public IMessage toMessage(String aSID, IMessageFactory aFactory) {
        return this.toMessage(aSID, null, null, null, 0, aFactory);
    }

    @Override
    public IMessage toMessage(String aSID, String aTradingSessionID, String aTradingSessionSubID, String aRequestID, int aOptions, IMessageFactory aFactory) {
        String tssubid;
        String tsid = aTradingSessionID;
        if (tsid == null) {
            tsid = this.getTradingSessionID();
        }
        if ((tssubid = aTradingSessionSubID) == null) {
            tssubid = this.getTradingSessionSubID();
        }
        IMessage ret = aFactory.createMessage(aSID, this.getType().getCode());
        try {
            IFieldGroupList list;
            if (this.getAccount() != null) {
                ret.setValue("1", this.getAccount());
            }
            if (this.getClOrdID() != null) {
                ret.setValue("11", this.getClOrdID());
            }
            if (this.getSecondaryClOrdID() != null) {
                ret.setValue("526", this.getSecondaryClOrdID());
            }
            if (this.getInstrument() != null) {
                try {
                    ret.setValue("55", this.getInstrument().getSymbol());
                    ret.setValue("9000", this.getInstrument().getFXCMSymID());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.mParties != null && (list = this.mParties.toList(aFactory)) != null) {
                ret.setValue("453", list);
            }
            if (tsid != null) {
                ret.setValue("336", tsid);
                ret.setValue("625", tssubid);
            }
            if (this.mTransactTime != null) {
                ret.setValue("60", this.getTransactTime().toString());
            }
            if (this.mInstrument != null) {
                if (this.getBidPx() != 0.0) {
                    ret.setValue("133", this.mInstrument.priceToString(this.getBidPx()));
                }
                if (this.getOfferPx() != 0.0) {
                    ret.setValue("132", this.mInstrument.priceToString(this.getOfferPx()));
                }
            }
            ret.setValue("117", this.getQuoteID());
            if (this.getQuoteRespID() != null) {
                ret.setValue("693", this.getQuoteRespID());
            }
            if (this.getQuoteRespType() != null) {
                ret.setValue("694", this.getQuoteRespType().getCode());
            }
            if (this.getSide() != null) {
                ret.setValue("54", this.getSide().getCode());
            }
            if (this.getOrderQty() != 0.0) {
                ret.setValue("38", this.getOrderQty());
            }
            if (this.getCurrency() != null) {
                ret.setValue("15", this.getCurrency());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("QuoteResponse");
        buf.append(" mAccount=").append(this.mAccount);
        buf.append(",mClOrdID=").append(this.mClOrdID);
        buf.append(",mSecondaryClOrdID=").append(this.mSecondaryClOrdID);
        buf.append(",mInstrument=").append(this.mInstrument);
        buf.append(",mParties=").append(this.mParties);
        buf.append(",mTradingSessionID=").append(this.mTradingSessionID);
        buf.append(",mTradingSessionSubID=").append(this.mTradingSessionSubID);
        buf.append(",mTransactTime=").append(this.mTransactTime);
        buf.append(",mBidPx=").append(this.mBidPx);
        buf.append(",mOfferPx=").append(this.mOfferPx);
        buf.append(",mQuoteID=").append(this.mQuoteID);
        buf.append(",mQuoteRespID=").append(this.mQuoteRespID);
        buf.append(",mQuoteRespType=").append(this.mQuoteRespType);
        buf.append(",mSide=").append(this.mSide);
        buf.append(",mOrderQty=").append(this.mOrderQty);
        buf.append(",mCurrency=").append(this.mCurrency);
        return buf.toString();
    }

    @Override
    public boolean update(IMessage aMsg) {
        return this.fill(aMsg);
    }

    @Override
    public long getMakingTime() {
        return this.mMakingTime;
    }

    private static class QuoteResponseType
    extends ACode {
        private static final long serialVersionUID = -2968628173235373091L;

        QuoteResponseType() {
            super("AJ", "QuoteResponseType", "");
        }
    }
}

