/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix.pretrade;

import com.fxcm.entity.ACode;
import com.fxcm.entity.ICode;
import com.fxcm.fix.IFixDefs;
import com.fxcm.fix.Instrument;
import com.fxcm.fix.Parties;
import com.fxcm.messaging.IFieldGroup;
import com.fxcm.messaging.IFieldGroupList;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.IMessageFactory;
import com.fxcm.messaging.ITransportable;
import java.util.List;

public class QuoteRequestReject
implements ITransportable,
IFixDefs {
    public static final ICode OBJ_TYPE = new QuoteRequestRejectType();
    protected String mAccount;
    protected String mFXCMErrorDetails;
    protected int mFXCMRequestRejectReason;
    protected Instrument mInstrument;
    protected Parties mParties;
    protected String mQuoteReqID;
    protected int mQuoteRequestRejectReason;
    protected String mText;
    protected String mTradingSessionID;
    protected String mTradingSessionSubID;
    private long mMakingTime = System.currentTimeMillis();

    public QuoteRequestReject() {
        this.reset();
    }

    @Override
    public boolean fill(IMessage aMsg) {
        List<IFieldGroup> fields;
        this.setQuoteReqID(aMsg.getValueString("131"));
        this.setQuoteRequestRejectReason(aMsg.getValueInt("658"));
        IFieldGroupList grl = aMsg.getValueList("146");
        if (grl != null && (fields = grl.getFields()) != null && grl.size() != 0) {
            IFieldGroup group = fields.get(0);
            String symbol = group.getValueString(aMsg.getValueString("55"));
            int fxcmSymID = group.getValueInt("9000");
            this.setInstrument(new Instrument(symbol, fxcmSymID, 0));
            this.setTradingSessionID(group.getValueString("336"));
            this.setTradingSessionSubID(group.getValueString("625"));
            this.setAccount(group.getValueString("1"));
        }
        this.mParties.fill(aMsg.getValueList("453"));
        this.setText(aMsg.getValueString("58"));
        this.setFXCMErrorDetails(aMsg.getValueString("9029"));
        this.setFXCMRequestRejectReason(aMsg.getValueInt("9025"));
        return this.isValid();
    }

    public String getAccount() {
        return this.mAccount;
    }

    public void setAccount(String aAccount) {
        this.mAccount = aAccount;
    }

    public String getFXCMErrorDetails() {
        return this.mFXCMErrorDetails;
    }

    public void setFXCMErrorDetails(String aFXCMErrorDetails) {
        this.mFXCMErrorDetails = aFXCMErrorDetails;
    }

    public int getFXCMRequestRejectReason() {
        return this.mFXCMRequestRejectReason;
    }

    public void setFXCMRequestRejectReason(int aFXCMRequestRejectReason) {
        this.mFXCMRequestRejectReason = aFXCMRequestRejectReason;
    }

    public Instrument getInstrument() {
        return this.mInstrument;
    }

    public void setInstrument(Instrument aInstrument) {
        this.mInstrument = aInstrument;
    }

    public Parties getParties() {
        return this.mParties;
    }

    public void setParties(Parties aParties) {
        this.mParties = aParties;
        if (this.mParties == null) {
            this.mParties = new Parties();
        }
    }

    public String getQuoteReqID() {
        return this.mQuoteReqID;
    }

    public void setQuoteReqID(String aQuoteReqID) {
        this.mQuoteReqID = aQuoteReqID;
    }

    public int getQuoteRequestRejectReason() {
        return this.mQuoteRequestRejectReason;
    }

    public void setQuoteRequestRejectReason(int aQuoteRequestRejectReason) {
        this.mQuoteRequestRejectReason = aQuoteRequestRejectReason;
    }

    @Override
    public String getRequestID() {
        return null;
    }

    public String getText() {
        return this.mText;
    }

    public void setText(String aText) {
        this.mText = aText;
    }

    @Override
    public String getTradingSessionID() {
        return this.mTradingSessionID;
    }

    @Override
    public String getTradingSessionSubID() {
        return this.mTradingSessionSubID;
    }

    @Override
    public ICode getType() {
        return OBJ_TYPE;
    }

    @Override
    public boolean isValid() {
        return this.mQuoteReqID != null && this.mQuoteRequestRejectReason != 0 && this.mInstrument != null;
    }

    private void reset() {
        this.mQuoteReqID = null;
        this.mQuoteRequestRejectReason = 0;
        this.mInstrument = null;
        this.mTradingSessionID = null;
        this.mTradingSessionSubID = null;
        this.mAccount = null;
        this.mParties = new Parties();
        this.mText = null;
        this.mFXCMErrorDetails = null;
        this.mFXCMRequestRejectReason = -1;
    }

    public void setTradingSessionID(String aTradingSessionID) {
        this.mTradingSessionID = aTradingSessionID;
    }

    public void setTradingSessionSubID(String aTradingSessionSubID) {
        this.mTradingSessionSubID = aTradingSessionSubID;
    }

    @Override
    public IMessage toMessage(String aSID, IMessageFactory aFactory) {
        return this.toMessage(aSID, null, null, null, 0, aFactory);
    }

    @Override
    public IMessage toMessage(String aSID, String aTradingSessionID, String aTradingSessionSubID, String aRequestID, int aOptions, IMessageFactory aFactory) {
        IFieldGroupList list;
        String tssubid;
        String tsid;
        String req = aRequestID;
        if (req == null) {
            req = this.getQuoteReqID();
        }
        if ((tsid = aTradingSessionID) == null) {
            tsid = this.getTradingSessionID();
        }
        if ((tssubid = aTradingSessionSubID) == null) {
            tssubid = this.getTradingSessionSubID();
        }
        IMessage ret = aFactory.createMessage(aSID, "AG");
        ret.setValue("131", req);
        ret.setValue("658", this.getQuoteRequestRejectReason());
        IFieldGroupList grl = aFactory.createFieldGroupList();
        IFieldGroup gr = aFactory.createFieldGroup();
        try {
            gr.setValue("55", this.getInstrument().getSymbol());
            gr.setValue("9000", this.getInstrument().getFXCMSymID());
        }
        catch (Exception exception) {
            // empty catch block
        }
        gr.setValue("336", tsid);
        gr.setValue("625", tssubid);
        gr.setValue("1", this.getAccount());
        grl.put(gr);
        ret.setValue("146", grl);
        if (this.mParties != null && (list = this.mParties.toList(aFactory)) != null) {
            ret.setValue("453", list);
        }
        ret.setValue("58", this.getText());
        if (this.getFXCMRequestRejectReason() >= 0) {
            ret.setValue("9025", this.getFXCMRequestRejectReason());
        }
        if (this.getFXCMErrorDetails() != null) {
            ret.setValue("9029", this.getFXCMErrorDetails());
        }
        return ret;
    }

    @Override
    public boolean update(IMessage aMsg) {
        return this.fill(aMsg);
    }

    @Override
    public long getMakingTime() {
        return this.mMakingTime;
    }

    private static class QuoteRequestRejectType
    extends ACode {
        private static final long serialVersionUID = 5550474829293286908L;

        QuoteRequestRejectType() {
            super("AG", "QuoteRequestRejectType", "");
        }
    }
}

