/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix.pretrade;

import com.fxcm.entity.ACode;
import com.fxcm.entity.ICode;
import com.fxcm.fix.IFixDefs;
import com.fxcm.fix.Instrument;
import com.fxcm.fix.Parties;
import com.fxcm.messaging.IFieldGroup;
import com.fxcm.messaging.IFieldGroupList;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.IMessageFactory;
import com.fxcm.messaging.ITransportable;
import java.util.List;

public class QuoteRequest
implements ITransportable,
IFixDefs {
    public static final ICode OBJ_TYPE = new QuoteRequestType();
    private String mAccount;
    private Instrument mInstrument;
    private double mOrderQty2;
    private Parties mParties;
    private String mQuoteReqID;
    private String mTradingSessionID;
    private String mTradingSessionSubID;
    private String mClOrdID;
    private long mMakingTime = System.currentTimeMillis();

    public String getClOrdID() {
        return this.mClOrdID;
    }

    public void setClOrdID(String aClOrdID) {
        this.mClOrdID = aClOrdID;
    }

    public QuoteRequest() {
        this.reset();
    }

    @Override
    public boolean fill(IMessage aMsg) {
        List<IFieldGroup> fields;
        this.reset();
        this.setQuoteReqID(aMsg.getValueString("131"));
        this.setClOrdID(aMsg.getValueString("11"));
        IFieldGroupList grl = aMsg.getValueList("146");
        if (grl != null && (fields = grl.getFields()) != null && grl.size() != 0) {
            IFieldGroup group = fields.get(0);
            String symbol = group.getValueString(aMsg.getValueString("55"));
            int fxcmSymID = group.getValueInt("9000");
            this.setInstrument(new Instrument(symbol, fxcmSymID, 0));
            this.setAccount(group.getValueString("1"));
            this.setTradingSessionID(group.getValueString("336"));
            this.setTradingSessionSubID(group.getValueString("625"));
            this.setOrderQty2(group.getValueDouble("192"));
        }
        this.mParties.fill(aMsg.getValueList("453"));
        return this.isValid();
    }

    public String getAccount() {
        return this.mAccount;
    }

    public void setAccount(String aAccount) {
        this.mAccount = aAccount;
    }

    public Instrument getInstrument() {
        return this.mInstrument;
    }

    public void setInstrument(Instrument aInstrument) {
        this.mInstrument = aInstrument;
    }

    public double getOrderQty2() {
        return this.mOrderQty2;
    }

    public void setOrderQty2(double aOrderQty2) {
        this.mOrderQty2 = aOrderQty2;
    }

    public Parties getParties() {
        return this.mParties;
    }

    public String getQuoteReqID() {
        return this.mQuoteReqID;
    }

    public void setQuoteReqID(String aQuoteReqID) {
        this.mQuoteReqID = aQuoteReqID;
    }

    @Override
    public String getRequestID() {
        return this.getClOrdID();
    }

    @Override
    public String getTradingSessionID() {
        return this.mTradingSessionID;
    }

    public void setTradingSessionID(String aTradingSessionID) {
        this.mTradingSessionID = aTradingSessionID;
    }

    @Override
    public String getTradingSessionSubID() {
        return this.mTradingSessionSubID;
    }

    public void setTradingSessionSubID(String aTradingSessionSubID) {
        this.mTradingSessionSubID = aTradingSessionSubID;
    }

    @Override
    public ICode getType() {
        return OBJ_TYPE;
    }

    @Override
    public boolean isValid() {
        return this.mQuoteReqID != null && this.mInstrument != null;
    }

    private void reset() {
        this.mClOrdID = null;
        this.mQuoteReqID = null;
        this.mInstrument = null;
        this.mAccount = null;
        this.mParties = new Parties();
    }

    public void setParties(Parties aParties) {
        this.mParties = aParties;
        if (this.mParties == null) {
            this.mParties = new Parties();
        }
    }

    @Override
    public IMessage toMessage(String aSID, IMessageFactory aFactory) {
        return this.toMessage(aSID, null, null, null, 0, aFactory);
    }

    @Override
    public IMessage toMessage(String aSID, String aTradingSessionID, String aTradingSessionSubID, String aRequestID, int aOptions, IMessageFactory aFactory) {
        IFieldGroupList list;
        String tssubid;
        String tsid;
        String req = aRequestID;
        if (req == null) {
            req = this.getQuoteReqID();
        }
        if ((tsid = aTradingSessionID) == null) {
            tsid = this.getTradingSessionID();
        }
        if ((tssubid = aTradingSessionSubID) == null) {
            tssubid = this.getTradingSessionSubID();
        }
        IMessage ret = aFactory.createMessage(aSID, "R");
        ret.setValue("131", req);
        ret.setValue("11", this.getClOrdID());
        IFieldGroupList grl = aFactory.createFieldGroupList();
        IFieldGroup gr = aFactory.createFieldGroup();
        gr.setValue("1", this.getAccount());
        try {
            gr.setValue("55", this.getInstrument().getSymbol());
            gr.setValue("9000", this.getInstrument().getFXCMSymID());
        }
        catch (Exception exception) {
            // empty catch block
        }
        gr.setValue("336", tsid);
        gr.setValue("625", tssubid);
        gr.setValue("192", this.getOrderQty2());
        grl.put(gr);
        ret.setValue("146", grl);
        if (this.mParties != null && (list = this.mParties.toList(aFactory)) != null) {
            ret.setValue("453", list);
        }
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("QuoteRequest");
        sb.append("{mAccount='").append(this.mAccount).append('\'');
        sb.append(", mInstrument=").append(this.mInstrument);
        sb.append(", mOrderQty2=").append(this.mOrderQty2);
        sb.append(", mParties=").append(this.mParties);
        sb.append(", mQuoteReqID='").append(this.mQuoteReqID).append('\'');
        sb.append(", mTradingSessionID='").append(this.mTradingSessionID).append('\'');
        sb.append(", mTradingSessionSubID='").append(this.mTradingSessionSubID).append('\'');
        sb.append(", mClOrdID='").append(this.mClOrdID).append('\'');
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean update(IMessage aMsg) {
        return this.fill(aMsg);
    }

    @Override
    public long getMakingTime() {
        return this.mMakingTime;
    }

    private static class QuoteRequestType
    extends ACode {
        private static final long serialVersionUID = -5022549520866594381L;

        QuoteRequestType() {
            super("R", "QuoteRequestType", "");
        }
    }
}

