/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix.pretrade;

import com.fxcm.entity.ACode;
import com.fxcm.entity.ICode;
import com.fxcm.fix.IFixDefs;
import com.fxcm.fix.Instrument;
import com.fxcm.fix.NotDefinedException;
import com.fxcm.fix.Parties;
import com.fxcm.messaging.IFieldGroupList;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.IMessageFactory;
import com.fxcm.messaging.ITransportable;
import java.io.PrintStream;

public class QuoteCancel
implements ITransportable,
IFixDefs {
    public static final String CANCEL_ALL_QUOTES_TYPE = "4";
    public static final String CANCEL_SYMBOL_TYPE = "1";
    private String mQuoteCancelType;
    private String mQuoteID;
    private Instrument mInstrument;
    public static final ICode OBJ_TYPE = new QuoteCancelType();
    private Parties mParties;
    protected String mTradingSessionID;
    protected String mTradingSessionSubID = "";
    private long mMakingTime = System.currentTimeMillis();

    public QuoteCancel() {
        this.reset();
    }

    @Override
    public ICode getType() {
        return OBJ_TYPE;
    }

    public void setQuoteCancelType(String aQuoteCancelType) {
        this.mQuoteCancelType = aQuoteCancelType;
    }

    public void setQuoteID(String aQuoteID) {
        this.mQuoteID = aQuoteID;
    }

    public String getQuoteID() {
        return this.mQuoteID;
    }

    public void setTradingSessionID(String aTradingSessionID) {
        this.mTradingSessionID = aTradingSessionID != null ? aTradingSessionID : "FXCM";
    }

    public void setTradingSessionSubID(String aTradingSessionSubID) {
        this.mTradingSessionSubID = aTradingSessionSubID != null ? aTradingSessionSubID : "";
    }

    public void setInstrument(Instrument aInstrument) {
        this.mInstrument = aInstrument;
    }

    public String getQuoteCancelType() {
        return this.mQuoteCancelType;
    }

    @Override
    public String getTradingSessionID() {
        return this.mTradingSessionID;
    }

    @Override
    public String getTradingSessionSubID() {
        return this.mTradingSessionSubID;
    }

    public Instrument getInstrument() {
        return this.mInstrument;
    }

    public void setParties(Parties aParties) {
        this.mParties = aParties;
        if (this.mParties == null) {
            this.mParties = new Parties();
        }
    }

    public Parties getParties() {
        return this.mParties;
    }

    @Override
    public IMessage toMessage(String aSID, IMessageFactory aFactory) {
        return this.toMessage(aSID, null, null, null, 0, aFactory);
    }

    @Override
    public IMessage toMessage(String aSID, String aTradingSessionID, String aTradingSessionSubID, String aRequestID, int aOptions, IMessageFactory aFactory) {
        String tssubid;
        String tsid = aTradingSessionID;
        if (tsid == null) {
            tsid = this.getTradingSessionID();
        }
        if ((tssubid = aTradingSessionSubID) == null) {
            tssubid = this.getTradingSessionSubID();
        }
        IMessage ret = null;
        try {
            IFieldGroupList list;
            ret = aFactory.createMessage(aSID, "Z");
            try {
                if (this.mQuoteCancelType.equals(CANCEL_SYMBOL_TYPE)) {
                    ret.setValue("55", this.mInstrument.getSymbol());
                    ret.setValue("9000", this.mInstrument.getFXCMSymID());
                }
            }
            catch (NotDefinedException notDefinedException) {
                // empty catch block
            }
            ret.setValue("298", this.mQuoteCancelType);
            ret.setValue("117", this.mQuoteID);
            if (this.mParties != null && (list = this.mParties.toList(aFactory)) != null) {
                ret.setValue("453", list);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public void reset() {
        this.mInstrument = null;
        this.mParties = new Parties();
        this.mQuoteID = null;
        this.mQuoteCancelType = CANCEL_ALL_QUOTES_TYPE;
        this.mTradingSessionID = "FXCM";
        this.mTradingSessionSubID = "";
    }

    @Override
    public boolean fill(IMessage aMsg) {
        this.reset();
        this.setQuoteCancelType(aMsg.getValueString("298"));
        this.setQuoteID(aMsg.getValueString("117"));
        this.setInstrument(new Instrument(aMsg.getValueString("55"), aMsg.getValueInt("9000"), 0));
        this.mParties.fill(aMsg.getValueList("453"));
        boolean ret = this.isValid();
        return ret;
    }

    @Override
    public boolean update(IMessage aMsg) {
        return this.fill(aMsg);
    }

    @Override
    public boolean isValid() {
        boolean ret = false;
        if (this.mQuoteCancelType != null && this.mQuoteID != null) {
            ret = this.mQuoteCancelType.equals(CANCEL_ALL_QUOTES_TYPE) || this.mQuoteCancelType.equals(CANCEL_SYMBOL_TYPE) && this.mInstrument != null;
        }
        return ret;
    }

    public void printState(PrintStream aOut) {
        if (aOut != null) {
            aOut.println(this.toString());
        } else {
            System.out.println(this.toString());
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("QuoteCancel");
        buf.append("{mInstrument=").append(this.mInstrument);
        buf.append(",mQuoteCancelType=").append(this.mQuoteCancelType);
        buf.append(",mQuoteID=").append(this.mQuoteID);
        buf.append(",mParties=").append(this.mParties);
        buf.append(",mTradingSessionID=").append(this.mTradingSessionID);
        buf.append(",mTradingSessionSubID=").append(this.mTradingSessionSubID);
        buf.append('}');
        return buf.toString();
    }

    @Override
    public String getRequestID() {
        return null;
    }

    @Override
    public long getMakingTime() {
        return this.mMakingTime;
    }

    private static class QuoteCancelType
    extends ACode {
        QuoteCancelType() {
            super("Z", "QuoteCancelType", "");
        }
    }
}

