/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix.pretrade;

import com.fxcm.entity.ACode;
import com.fxcm.entity.ICode;
import com.fxcm.fix.IFixDefs;
import com.fxcm.fix.IQuoteType;
import com.fxcm.fix.ISide;
import com.fxcm.fix.Instrument;
import com.fxcm.fix.Parties;
import com.fxcm.fix.QuoteTypeFactory;
import com.fxcm.fix.SideFactory;
import com.fxcm.fix.UTCTimestamp;
import com.fxcm.messaging.IFieldGroupList;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.IMessageFactory;
import com.fxcm.messaging.ITransportable;

public class Quote
implements ITransportable,
IFixDefs {
    public static final ICode OBJ_TYPE = new QuoteType();
    protected String mAccount;
    protected double mBidPx;
    protected String mCurrency;
    protected Instrument mInstrument;
    protected double mOfferPx;
    protected double mOrderQty;
    protected Parties mParties;
    protected String mQuoteID;
    protected String mQuoteReqID;
    protected String mQuoteRespID;
    protected IQuoteType mQuoteType;
    protected ISide mSide;
    protected String mTradingSessionID;
    protected String mTradingSessionSubID;
    protected UTCTimestamp mTransactTime;
    protected UTCTimestamp mValidUntilTime;
    private long mMakingTime = System.currentTimeMillis();

    public Quote() {
        this.reset();
    }

    @Override
    public boolean fill(IMessage aMsg) {
        this.reset();
        if (aMsg.getValueString("55") != null) {
            this.setInstrument(new Instrument(aMsg.getValueString("55"), aMsg.getValueInt("9000"), aMsg.getValueInt("9001")));
            this.getInstrument().setFXCMSymPointSize(aMsg.getValueDouble("9002"));
            this.getInstrument().setFXCMSymSortOrder(aMsg.getValueInt("9005"));
            int product = aMsg.getValueInt("460");
            if (product >= 1 && product <= 13) {
                this.getInstrument().setProduct(product);
            }
            this.getInstrument().setContractMultiplier(aMsg.getValueDouble("231"));
            this.getInstrument().setFactor(aMsg.getValueInt("228"));
            this.getInstrument().setCFICode(aMsg.getValueString("461"));
            this.getInstrument().setSecurityType(aMsg.getValueString("167"));
            this.getInstrument().setFXCMProductID(aMsg.getValueInt("9080"));
            this.getInstrument().setFXCMCondDistStop(aMsg.getValueDouble("9090"));
            this.getInstrument().setFXCMCondDistLimit(aMsg.getValueDouble("9091"));
            this.getInstrument().setFXCMCondDistEntryStop(aMsg.getValueDouble("9092"));
            this.getInstrument().setFXCMCondDistEntryLimit(aMsg.getValueDouble("9093"));
            this.getInstrument().setFXCMMaxQuantity(aMsg.getValueDouble("9094"));
            this.getInstrument().setFXCMMinQuantity(aMsg.getValueDouble("9095"));
            this.getInstrument().setFXCMTradingStatus(aMsg.getValueString("9096"));
        }
        if (aMsg.getValueString("60") != null) {
            this.setTransactTime(new UTCTimestamp(aMsg.getValueString("60")));
        }
        this.setQuoteRespID(aMsg.getValueString("693"));
        this.setTradingSessionID(aMsg.getValueString("336"));
        this.setTradingSessionSubID(aMsg.getValueString("625"));
        this.setAccount(aMsg.getValueString("1"));
        this.mParties.fill(aMsg.getValueList("453"));
        this.setBidPx(aMsg.getValueDouble("132"));
        this.setOfferPx(aMsg.getValueDouble("133"));
        this.setQuoteID(aMsg.getValueString("117"));
        this.setQuoteReqID(aMsg.getValueString("131"));
        this.setQuoteType(QuoteTypeFactory.toCode(aMsg.getValueInt("537")));
        this.setSide(SideFactory.toCode(aMsg.getValueString("54")));
        this.setOrderQty(aMsg.getValueDouble("38"));
        this.setValidUntilTime(new UTCTimestamp(aMsg.getValueString("62")));
        this.setCurrency(aMsg.getValueString("15"));
        return this.isValid();
    }

    public String getAccount() {
        return this.mAccount;
    }

    public void setAccount(String account) {
        this.mAccount = account;
    }

    public double getBidPx() {
        return this.mBidPx;
    }

    public void setBidPx(double aBidPx) {
        this.mBidPx = aBidPx;
    }

    public String getCurrency() {
        return this.mCurrency;
    }

    public void setCurrency(String aCurrency) {
        this.mCurrency = aCurrency;
    }

    public Instrument getInstrument() {
        return this.mInstrument;
    }

    public void setInstrument(Instrument aInstrument) {
        this.mInstrument = aInstrument;
    }

    public double getOfferPx() {
        return this.mOfferPx;
    }

    public void setOfferPx(double aOfferPx) {
        this.mOfferPx = aOfferPx;
    }

    public double getOrderQty() {
        return this.mOrderQty;
    }

    public void setOrderQty(double aOrderQty) {
        this.mOrderQty = aOrderQty;
    }

    public Parties getParties() {
        return this.mParties;
    }

    public String getQuoteID() {
        return this.mQuoteID;
    }

    public void setQuoteID(String aQuoteID) {
        this.mQuoteID = aQuoteID;
    }

    public String getQuoteReqID() {
        return this.mQuoteReqID;
    }

    public void setQuoteReqID(String aQuoteReqID) {
        this.mQuoteReqID = aQuoteReqID;
    }

    public String getQuoteRespID() {
        return this.mQuoteRespID;
    }

    public void setQuoteRespID(String aQuoteRespID) {
        this.mQuoteRespID = aQuoteRespID;
    }

    public IQuoteType getQuoteType() {
        return this.mQuoteType;
    }

    public void setQuoteType(IQuoteType aQuoteType) {
        this.mQuoteType = aQuoteType;
    }

    @Override
    public String getRequestID() {
        return this.getQuoteReqID();
    }

    public ISide getSide() {
        return this.mSide;
    }

    public void setSide(ISide aSide) {
        this.mSide = aSide;
    }

    @Override
    public String getTradingSessionID() {
        return this.mTradingSessionID;
    }

    @Override
    public String getTradingSessionSubID() {
        return this.mTradingSessionSubID;
    }

    public UTCTimestamp getTransactTime() {
        return this.mTransactTime;
    }

    @Override
    public ICode getType() {
        return OBJ_TYPE;
    }

    public UTCTimestamp getValidUntilTime() {
        return this.mValidUntilTime;
    }

    public void setValidUntilTime(UTCTimestamp aValidUntilTime) {
        this.mValidUntilTime = aValidUntilTime;
    }

    @Override
    public boolean isValid() {
        boolean ret = false;
        if (this.mInstrument != null && this.mTransactTime != null) {
            ret = this.mOfferPx != 0.0 && this.mBidPx != 0.0;
        }
        return ret;
    }

    protected void reset() {
        this.mAccount = null;
        this.mInstrument = null;
        this.mParties = new Parties();
        this.mTradingSessionID = "FXCM";
        this.mTradingSessionSubID = "";
        if (this.mTransactTime == null) {
            this.mTransactTime = new UTCTimestamp();
        } else {
            this.mTransactTime.setDate(null);
        }
        this.mBidPx = 0.0;
        this.mOfferPx = 0.0;
        this.mQuoteID = null;
        this.mQuoteReqID = null;
        this.mQuoteType = QuoteTypeFactory.TRADEABLE;
        this.mSide = null;
        this.mQuoteRespID = null;
        this.mQuoteReqID = null;
        this.mOrderQty = 0.0;
        this.mValidUntilTime = null;
        this.mCurrency = null;
    }

    public void setParties(Parties aParties) {
        this.mParties = aParties;
        if (this.mParties == null) {
            this.mParties = new Parties();
        }
    }

    public void setTradingSessionID(String aTradingSessionID) {
        this.mTradingSessionID = aTradingSessionID != null ? aTradingSessionID : "FXCM";
    }

    public void setTradingSessionSubID(String aTradingSessionSubID) {
        this.mTradingSessionSubID = aTradingSessionSubID != null ? aTradingSessionSubID : "";
    }

    public void setTransactTime(UTCTimestamp aTransactTime) {
        this.mTransactTime = aTransactTime != null ? aTransactTime : new UTCTimestamp();
    }

    @Override
    public IMessage toMessage(String aSID, IMessageFactory aFactory) {
        return this.toMessage(aSID, null, null, null, 0, aFactory);
    }

    @Override
    public IMessage toMessage(String aSID, String aTradingSessionID, String aTradingSessionSubID, String aRequestID, int aOptions, IMessageFactory aFactory) {
        String tssubid;
        String tsid;
        String req = aRequestID;
        if (req == null) {
            req = this.getQuoteReqID();
        }
        if ((tsid = aTradingSessionID) == null) {
            tsid = this.getTradingSessionID();
        }
        if ((tssubid = aTradingSessionSubID) == null) {
            tssubid = this.getTradingSessionSubID();
        }
        IMessage ret = aFactory.createMessage(aSID, this.getType().getCode());
        try {
            IFieldGroupList list;
            if (this.getAccount() != null) {
                ret.setValue("1", this.getAccount());
            }
            if (this.getInstrument() != null) {
                ret.setValue("55", this.getInstrument().getSymbol());
                if (this.getInstrument().getFXCMSymID() != 0) {
                    ret.setValue("9000", this.getInstrument().getFXCMSymID());
                }
                ret.setValue("9001", this.getInstrument().getFXCMSymPrecision());
                ret.setValue("9002", this.getInstrument().getFXCMSymPointSize());
                ret.setValue("9005", this.getInstrument().getFXCMSymSortOrder());
                int product = this.getInstrument().getProduct();
                if (product >= 1 && product <= 13) {
                    ret.setValue("460", product);
                }
                ret.setValue("231", this.getInstrument().getContractMultiplier());
                ret.setValue("228", this.getInstrument().getFactor());
                ret.setValue("461", this.getInstrument().getCFICode());
                ret.setValue("167", this.getInstrument().getSecurityType());
                ret.setValue("9080", this.getInstrument().getFXCMProductID());
                ret.setValue("9090", this.getInstrument().getFXCMCondDistStop());
                ret.setValue("9091", this.getInstrument().getFXCMCondDistLimit());
                ret.setValue("9092", this.getInstrument().getFXCMCondDistEntryStop());
                ret.setValue("9093", this.getInstrument().getFXCMCondDistEntryLimit());
                ret.setValue("9094", this.getInstrument().getFXCMMaxQuantity());
                ret.setValue("9095", this.getInstrument().getFXCMMinQuantity());
                ret.setValue("9096", this.getInstrument().getFXCMTradingStatus());
            }
            if (this.mParties != null && (list = this.mParties.toList(aFactory)) != null) {
                ret.setValue("453", list);
            }
            if (tsid != null) {
                ret.setValue("336", tsid);
                ret.setValue("625", tssubid);
            }
            if (this.mTransactTime != null) {
                ret.setValue("60", this.getTransactTime().toString());
            }
            if (this.mInstrument != null) {
                if (this.getBidPx() != 0.0) {
                    ret.setValue("133", this.mInstrument.priceToString(this.getBidPx()));
                }
                if (this.getOfferPx() != 0.0) {
                    ret.setValue("132", this.mInstrument.priceToString(this.getOfferPx()));
                }
            }
            if (this.getQuoteID() != null) {
                ret.setValue("117", this.getQuoteID());
            }
            if (this.getQuoteRespID() != null) {
                ret.setValue("693", this.getQuoteRespID());
            }
            if (req != null) {
                ret.setValue("131", req);
            }
            if (this.getQuoteType() != null) {
                ret.setValue("537", this.getQuoteType().getCode());
            }
            if (this.getSide() != null) {
                ret.setValue("54", this.getSide().getCode());
            }
            if (this.getOrderQty() != 0.0) {
                ret.setValue("38", this.getOrderQty());
            }
            if (this.getValidUntilTime() != null) {
                ret.setValue("62", this.getValidUntilTime().toString());
            }
            if (this.getCurrency() != null) {
                ret.setValue("15", this.getCurrency());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Quote");
        sb.append("{mAccount='").append(this.mAccount).append('\'');
        sb.append(", mBidPx=").append(this.mBidPx);
        sb.append(", mCurrency='").append(this.mCurrency).append('\'');
        sb.append(", mInstrument=").append(this.mInstrument);
        sb.append(", mOfferPx=").append(this.mOfferPx);
        sb.append(", mOrderQty=").append(this.mOrderQty);
        sb.append(", mParties=").append(this.mParties);
        sb.append(", mQuoteID='").append(this.mQuoteID).append('\'');
        sb.append(", mQuoteReqID='").append(this.mQuoteReqID).append('\'');
        sb.append(", mQuoteRespID='").append(this.mQuoteRespID).append('\'');
        sb.append(", mQuoteType=").append(this.mQuoteType);
        sb.append(", mSide=").append(this.mSide);
        sb.append(", mTradingSessionID='").append(this.mTradingSessionID).append('\'');
        sb.append(", mTradingSessionSubID='").append(this.mTradingSessionSubID).append('\'');
        sb.append(", mTransactTime=").append(this.mTransactTime);
        sb.append(", mValidUntilTime=").append(this.mValidUntilTime);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean update(IMessage aMsg) {
        return this.fill(aMsg);
    }

    @Override
    public long getMakingTime() {
        return this.mMakingTime;
    }

    private static class QuoteType
    extends ACode {
        private static final long serialVersionUID = 6476730401399206363L;

        QuoteType() {
            super("S", "QuoteType", "");
        }
    }
}

