/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix.pretrade;

import com.fxcm.entity.ACode;
import com.fxcm.entity.ICode;
import com.fxcm.fix.IFixDefs;
import com.fxcm.fix.UTCTimestamp;
import com.fxcm.messaging.IFieldGroup;
import com.fxcm.messaging.IFieldGroupList;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.IMessageFactory;
import com.fxcm.messaging.ITransportable;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class News
implements ITransportable,
IFixDefs {
    public static final ICode OBJ_TYPE = new NewsType();
    private String msTestReqID;
    private String msTradingSessionID;
    private String msTradingSessionSubID;
    private String msPageID;
    private int miPageviewID;
    private UTCTimestamp mdtTransactTime;
    private int miContinuousFlag;
    private int miUpdateAction;
    private UTCTimestamp mdtOrigTime;
    private int miUrgency;
    private String msHeadline;
    private Vector mTextLines;
    private long mMakingTime = System.currentTimeMillis();

    public News() {
        this.mTextLines = new Vector();
        this.reset();
    }

    public String getTestReqID() {
        return this.msTestReqID;
    }

    @Override
    public String getTradingSessionID() {
        return this.msTradingSessionID;
    }

    @Override
    public String getTradingSessionSubID() {
        return this.msTradingSessionSubID;
    }

    public String getPageID() {
        return this.msPageID;
    }

    public int getPageviewID() {
        return this.miPageviewID;
    }

    public UTCTimestamp getTransactTime() {
        return this.mdtTransactTime;
    }

    public int getContinuousFlag() {
        return this.miContinuousFlag;
    }

    public int getUpdateAction() {
        return this.miUpdateAction;
    }

    public UTCTimestamp getOrigTime() {
        return this.mdtOrigTime;
    }

    public int getUrgency() {
        return this.miUrgency;
    }

    public String getHeadline() {
        return this.msHeadline;
    }

    public Enumeration getTextLines() {
        return this.mTextLines.elements();
    }

    public void setTestReqID(String asTestReqID) {
        this.msTestReqID = asTestReqID;
    }

    public void setTradingSessionID(String asTradingSessionID) {
        this.msTradingSessionID = asTradingSessionID;
    }

    public void setTradingSessionSubID(String asTradingSessionSubID) {
        this.msTradingSessionSubID = asTradingSessionSubID;
    }

    public void setPageID(String asPageID) {
        this.msPageID = asPageID;
    }

    public void setPageviewID(int aiPageviewID) {
        this.miPageviewID = aiPageviewID;
    }

    public void setTransactTime(UTCTimestamp adtTransactTime) {
        this.mdtTransactTime = adtTransactTime;
    }

    public void setContinuousFlag(int aiContinuousFlag) {
        this.miContinuousFlag = aiContinuousFlag;
    }

    public void setUpdateAction(int aiUpdateAction) {
        this.miUpdateAction = aiUpdateAction;
    }

    public void setOrigTime(UTCTimestamp adtOrigTime) {
        this.mdtOrigTime = adtOrigTime;
    }

    public void setUrgency(int aiUrgency) {
        this.miUrgency = aiUrgency;
    }

    public void setHeadline(String asHeadline) {
        this.msHeadline = asHeadline;
    }

    public void addTextLine(String asLineOfText) {
        this.mTextLines.add(asLineOfText);
    }

    public void reset() {
        this.msTestReqID = null;
        this.msTradingSessionID = "FXCM";
        this.msTradingSessionSubID = "NewsServer";
        this.msPageID = null;
        this.miPageviewID = 0;
        this.mdtTransactTime = null;
        this.miContinuousFlag = 0;
        this.miUpdateAction = 0;
        this.mdtOrigTime = null;
        this.miUrgency = 0;
        this.msHeadline = null;
        this.mTextLines.clear();
    }

    @Override
    public IMessage toMessage(String aSID, IMessageFactory aFactory) {
        return this.toMessage(aSID, null, null, null, 0, aFactory);
    }

    @Override
    public IMessage toMessage(String aSID, String aTradingSessionID, String aTradingSessionSubID, String aRequestID, int aOptions, IMessageFactory aFactory) {
        String tssubid;
        String tsid;
        String req = aRequestID;
        if (req == null) {
            req = this.getTestReqID();
        }
        if ((tsid = aTradingSessionID) == null) {
            tsid = this.getTradingSessionID();
        }
        if ((tssubid = aTradingSessionSubID) == null) {
            tssubid = this.getTradingSessionSubID();
        }
        IMessage msg = aFactory.createMessage(aSID, "B");
        if (req != null) {
            msg.setValue("112", req);
        }
        if (tsid != null) {
            msg.setValue("336", tsid);
        }
        if (tssubid != null) {
            msg.setValue("625", tssubid);
        }
        msg.setValue("9022", this.msPageID);
        msg.setValue("9023", this.miPageviewID);
        msg.setValue("148", this.msHeadline != null ? this.msHeadline : "");
        if (this.mdtTransactTime != null) {
            msg.setValue("60", this.mdtTransactTime.toString());
        }
        if (this.mdtOrigTime != null) {
            msg.setValue("42", this.mdtOrigTime.toString());
        }
        msg.setValue("9020", this.miContinuousFlag);
        msg.setValue("279", this.miUpdateAction);
        msg.setValue("61", this.miUrgency);
        IFieldGroupList grl = aFactory.createFieldGroupList();
        for (int i = 0; i < this.mTextLines.size(); ++i) {
            String sText = (String)this.mTextLines.get(i);
            IFieldGroup gr = aFactory.createFieldGroup();
            gr.setValue("58", sText);
            grl.put(gr);
        }
        msg.setValue("215", grl);
        return msg;
    }

    @Override
    public boolean fill(IMessage aMsg) {
        IFieldGroupList grl;
        String sOrigTime;
        if (aMsg == null) {
            return false;
        }
        this.reset();
        this.setTradingSessionID(aMsg.getValueString("336"));
        this.setTradingSessionSubID(aMsg.getValueString("625"));
        this.setTestReqID(aMsg.getValueString("112"));
        this.setPageID(aMsg.getValueString("9022"));
        this.setPageviewID(aMsg.getValueInt("9023"));
        this.setContinuousFlag(aMsg.getValueInt("9020"));
        this.setUpdateAction(aMsg.getValueInt("279"));
        this.setUrgency(aMsg.getValueInt("61"));
        this.setHeadline(aMsg.getValueString("148"));
        String sTransactTime = aMsg.getValueString("60");
        if (sTransactTime != null) {
            try {
                this.setTransactTime(new UTCTimestamp(sTransactTime));
            }
            catch (Exception e) {
                this.reset();
                return false;
            }
        }
        if ((sOrigTime = aMsg.getValueString("42")) != null) {
            try {
                this.setOrigTime(new UTCTimestamp(sOrigTime));
            }
            catch (Exception e) {
                this.reset();
                return false;
            }
        }
        if ((grl = aMsg.getValueList("33")) == null) {
            grl = aMsg.getValueList("215");
        }
        if (grl == null) {
            this.reset();
            return false;
        }
        Iterator<IFieldGroup> iterator = grl.values().iterator();
        while (iterator.hasNext()) {
            IFieldGroup field;
            IFieldGroup gr = field = iterator.next();
            String sText = gr.getValueString("58");
            this.addTextLine(sText);
        }
        return true;
    }

    @Override
    public boolean update(IMessage aMsg) {
        return this.fill(aMsg);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public ICode getType() {
        return OBJ_TYPE;
    }

    public String toString() {
        UTCTimestamp dt = this.getTransactTime();
        Object ret = "=News Dump Begin===================================\n";
        ret = (String)ret + "PageviewID = " + this.getPageviewID() + "\n";
        ret = (String)ret + "TransactTime (GMT) = " + dt + "\n";
        ret = (String)ret + "ContinuousFlag = " + this.getContinuousFlag() + "\n";
        ret = (String)ret + "=end===============================================\n";
        return ret;
    }

    @Override
    public String getRequestID() {
        return this.getTestReqID();
    }

    @Override
    public long getMakingTime() {
        return this.mMakingTime;
    }

    private static class NewsType
    extends ACode {
        NewsType() {
            super("B", "News", "");
        }
    }
}

