/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix.pretrade;

import com.fxcm.entity.ACode;
import com.fxcm.entity.ICode;
import com.fxcm.fix.FXCMTimingIntervalFactory;
import com.fxcm.fix.IFXCMTimingInterval;
import com.fxcm.fix.Instrument;
import com.fxcm.fix.NotDefinedException;
import com.fxcm.fix.UTCDate;
import com.fxcm.fix.UTCTimeOnly;
import com.fxcm.fix.UTCTimestamp;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.IMessageFactory;
import com.fxcm.messaging.ITransportable;
import java.text.ParseException;

public abstract class MarketDataSnapshot
implements ITransportable {
    public static final ICode OBJ_TYPE = new MarketDataSnapshotType();
    private String mQuoteID;
    private Instrument mInstrument;
    private UTCTimeOnly mTickTime;
    protected UTCTimestamp mTimestamp;
    private UTCTimestamp mDateTime;
    private IFXCMTimingInterval mInterval;
    private boolean mComplete = true;
    private String mMDReqID;
    private String mTradingSessionID;
    private String mTradingSessionSubID = "";
    private String mOriginator;
    private boolean mIsTradeable;
    private int mContinuousFlag;
    private Long mFXCMMsgID;
    private String mPriceStream;
    private long mMakingTime = System.currentTimeMillis();

    protected MarketDataSnapshot() {
        this.reset();
    }

    protected MarketDataSnapshot(MarketDataSnapshot aMarketDataSnapshot) {
        this();
        this.copy(aMarketDataSnapshot);
    }

    protected void copy(MarketDataSnapshot aMarketDataSnapshot) {
        this.setQuoteID(aMarketDataSnapshot.getQuoteID());
        this.setInstrument(aMarketDataSnapshot.getInstrument());
        this.setTimestamp(aMarketDataSnapshot.getTimestamp());
        this.setFXCMTimingInterval(aMarketDataSnapshot.getFXCMTimingInterval());
        this.setComplete(aMarketDataSnapshot.isComplete());
        this.setMDReqID(aMarketDataSnapshot.getMDReqID());
        this.setTradingSessionID(aMarketDataSnapshot.getTradingSessionID());
        this.setTradingSessionSubID(aMarketDataSnapshot.getTradingSessionSubID());
        this.setFXCMContinuousFlag(aMarketDataSnapshot.getFXCMContinuousFlag());
        this.setOriginator(aMarketDataSnapshot.getOriginator());
        this.setTradeable(aMarketDataSnapshot.isTradeable());
        this.setPriceStream(aMarketDataSnapshot.getPriceStream());
        this.setFXCMMsgID(null);
        this.setAskLow(aMarketDataSnapshot._getAskLow());
        this.setAskHigh(aMarketDataSnapshot._getAskHigh());
        this.setAskOpen(aMarketDataSnapshot._getAskOpen());
        this.setAskClose(aMarketDataSnapshot._getAskClose());
        this.setLow(aMarketDataSnapshot._getLow());
        this.setHigh(aMarketDataSnapshot._getHigh());
        this.setBidLow(aMarketDataSnapshot._getBidLow());
        this.setBidHigh(aMarketDataSnapshot._getBidHigh());
        this.setBidOpen(aMarketDataSnapshot._getBidOpen());
        this.setBidClose(aMarketDataSnapshot._getBidClose());
        this.setTickVolume(aMarketDataSnapshot._getTickVolume());
        this.setBidId(aMarketDataSnapshot.getBidId());
        this.setBidQuoteCondition(aMarketDataSnapshot.getBidQuoteCondition());
        this.setBidQuoteType(aMarketDataSnapshot.getBidQuoteType());
        this.setBidExpireTimestamp(aMarketDataSnapshot.getBidExpireTimestamp());
        this.setBidOriginator(aMarketDataSnapshot.getBidOriginator());
        this.setBidCurrency(aMarketDataSnapshot.getBidCurrency());
        this.setBidEntrySize(aMarketDataSnapshot.getBidEntrySize());
        this.setAskId(aMarketDataSnapshot.getAskId());
        this.setAskQuoteCondition(aMarketDataSnapshot.getAskQuoteCondition());
        this.setAskQuoteType(aMarketDataSnapshot.getAskQuoteType());
        this.setAskExpireTimestamp(aMarketDataSnapshot.getAskExpireTimestamp());
        this.setAskOriginator(aMarketDataSnapshot.getAskOriginator());
        this.setAskCurrency(aMarketDataSnapshot.getAskCurrency());
        this.setAskEntrySize(aMarketDataSnapshot.getAskEntrySize());
    }

    public void setPriceStream(String aPriceStream) {
        this.mPriceStream = aPriceStream;
    }

    public String getPriceStream() {
        return this.mPriceStream;
    }

    public boolean isTradeable() {
        return this.mIsTradeable;
    }

    public void setTradeable(boolean aIsTradeable) {
        this.mIsTradeable = aIsTradeable;
    }

    public String getQuoteID() {
        return this.mQuoteID;
    }

    public void setQuoteID(String aQuoteID) {
        this.mQuoteID = aQuoteID;
    }

    public String getOriginator() {
        return this.mOriginator;
    }

    public void setOriginator(String aOriginator) {
        this.mOriginator = aOriginator;
    }

    @Override
    public ICode getType() {
        return OBJ_TYPE;
    }

    public String getName() {
        String ret = null;
        try {
            ret = this.mTradingSessionID + this.mInstrument.getSymbol() + this.mInterval.getCode();
            if (!this.mInterval.equals(FXCMTimingIntervalFactory.TICK) && this.mTimestamp != null) {
                ret = ret + this.mTimestamp.toString();
            }
        }
        catch (NotDefinedException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public void setMDReqID(String aMDReqID) {
        this.mMDReqID = aMDReqID;
    }

    public void setTradingSessionID(String aTradingSessionID) {
        this.mTradingSessionID = aTradingSessionID != null ? aTradingSessionID : "FXCM";
    }

    public void setTradingSessionSubID(String aTradingSessionSubID) {
        this.mTradingSessionSubID = aTradingSessionSubID != null ? aTradingSessionSubID : "";
    }

    public void setInstrument(Instrument aInstrument) {
        this.mInstrument = aInstrument;
    }

    public void setTime(String aTime, boolean aTick) {
        this.setTime(aTime);
        this.mTimestamp.setTick(aTick);
    }

    public void setTime(String aTime) {
        if (this.mTimestamp == null) {
            this.mTimestamp = new UTCTimestamp();
        }
        if (aTime == null) {
            this.mTimestamp.setTimeOnly(0L);
        } else {
            try {
                this.mTimestamp.setTimeOnly(aTime);
            }
            catch (ParseException ignored) {
                this.mTimestamp.setTimeOnly(0L);
            }
        }
        this.mDateTime = null;
    }

    public void setTime(UTCTimeOnly aTime) {
        if (this.mTimestamp == null) {
            this.mTimestamp = new UTCTimestamp();
        }
        if (aTime == null) {
            this.mTimestamp.setTimeOnly(0L);
        } else {
            this.mTimestamp.setTimeOnly(aTime);
        }
        this.mDateTime = null;
    }

    public void setDate(String aDate) {
        if (this.mTimestamp == null) {
            this.mTimestamp = new UTCTimestamp();
        }
        if (aDate == null) {
            this.mTimestamp.setDateOnly(System.currentTimeMillis());
        } else {
            try {
                this.mTimestamp.setDateOnly(aDate);
            }
            catch (ParseException ignored) {
                this.mTimestamp.setDateOnly(System.currentTimeMillis());
            }
        }
        this.mDateTime = null;
    }

    public void setDate(UTCDate aDate) {
        if (this.mTimestamp == null) {
            this.mTimestamp = new UTCTimestamp();
        }
        if (aDate == null) {
            this.mTimestamp.setDateOnly(System.currentTimeMillis());
        } else {
            this.mTimestamp.setDateOnly(aDate);
        }
        this.mDateTime = null;
    }

    public abstract void setAskLow(double var1);

    public abstract void setAskHigh(double var1);

    public abstract void setAskOpen(double var1);

    public abstract void setAskClose(double var1);

    public abstract void setLow(double var1);

    public abstract void setHigh(double var1);

    public abstract void setBidLow(double var1);

    public abstract void setBidHigh(double var1);

    public abstract void setBidOpen(double var1);

    public abstract void setBidClose(double var1);

    public abstract void setTickVolume(int var1);

    public void setFXCMTimingInterval(IFXCMTimingInterval aInterval) {
        if (aInterval != null) {
            this.mInterval = aInterval;
            if (this.getOpenTimestampRef() != null) {
                this.setOpenTimestamp(this.getOpenTimestampRef());
            }
        } else {
            this.mInterval = FXCMTimingIntervalFactory.TICK;
        }
        this.mDateTime = null;
    }

    public void setComplete(boolean aComplete) {
        this.mComplete = aComplete;
    }

    public String getMDReqID() {
        return this.mMDReqID;
    }

    @Override
    public String getTradingSessionID() {
        return this.mTradingSessionID;
    }

    @Override
    public String getTradingSessionSubID() {
        return this.mTradingSessionSubID;
    }

    public Instrument getInstrument() {
        return this.mInstrument;
    }

    public UTCTimeOnly getTime() {
        if (this.mTimestamp == null) {
            return null;
        }
        return new UTCTimeOnly(this.mTimestamp);
    }

    public UTCTimeOnly getTickTime() {
        if (this.mTickTime == null && this.mTimestamp != null) {
            this.mTickTime = new UTCTimeOnly(this.mTimestamp, true);
        }
        return this.mTickTime;
    }

    public UTCDate getDate() {
        if (this.mTimestamp == null) {
            return null;
        }
        return new UTCDate(this.mTimestamp);
    }

    public UTCTimestamp getTimestamp() {
        return this.mTimestamp;
    }

    public void setTimestamp(UTCTimestamp aTimestamp) {
        if (aTimestamp == null) {
            if (this.mTimestamp == null) {
                this.mTimestamp = new UTCTimestamp();
            }
            this.mTimestamp.setTimeOnly(0L);
            this.mTimestamp.setDateOnly(System.currentTimeMillis());
        } else {
            this.mTimestamp = aTimestamp;
        }
        this.mDateTime = null;
    }

    public UTCTimestamp getOpenTimestamp() {
        UTCTimestamp ret = null;
        if (this.mTimestamp != null) {
            ret = new UTCTimestamp(this.mTimestamp.getTime());
        }
        return ret;
    }

    public UTCTimestamp getOpenTimestampRef() {
        if (this.mDateTime == null) {
            this.mDateTime = this.getOpenTimestamp();
        }
        return this.mDateTime;
    }

    public void setOpenTimestamp(UTCTimestamp aTime) {
        if (aTime == null) {
            this.setTimestamp(null);
        } else {
            UTCTimestamp ts = aTime;
            if (this.getFXCMTimingInterval() != null) {
                ts = this.getFXCMTimingInterval().truncate(aTime);
            }
            this.setTimestamp(ts);
        }
    }

    public UTCTimestamp getCloseTimestamp() {
        UTCTimestamp ret = this.getOpenTimestamp();
        if (ret != null && this.getFXCMTimingInterval() != null) {
            ret.addDuration(this.getFXCMTimingInterval().getDuration(ret));
        }
        return ret;
    }

    public double getAskLow() {
        return this._getAskLow() != 0.0 ? this._getAskLow() : this.getAskClose();
    }

    public double getAskHigh() {
        return this._getAskHigh() != 0.0 ? this._getAskHigh() : this.getAskClose();
    }

    public double getAskOpen() {
        return this._getAskOpen() != 0.0 ? this._getAskOpen() : this.getAskClose();
    }

    public double getAskClose() {
        return this._getAskClose() != 0.0 ? this._getAskClose() : this._getBidClose();
    }

    public double getLow() {
        return this._getLow() != 0.0 ? this._getLow() : this.getBidLow();
    }

    public double getHigh() {
        return this._getHigh() != 0.0 ? this._getHigh() : this.getBidHigh();
    }

    public double getBidLow() {
        return this._getBidLow() != 0.0 ? this._getBidLow() : this.getBidClose();
    }

    public double getBidHigh() {
        return this._getBidHigh() != 0.0 ? this._getBidHigh() : this.getBidClose();
    }

    public double getBidOpen() {
        return this._getBidOpen() != 0.0 ? this._getBidOpen() : this.getBidClose();
    }

    public double getBidClose() {
        return this._getBidClose() != 0.0 ? this._getBidClose() : this._getAskClose();
    }

    public int getTickVolume() {
        return this._getTickVolume();
    }

    public IFXCMTimingInterval getFXCMTimingInterval() {
        return this.mInterval;
    }

    public boolean isComplete() {
        return this.mComplete;
    }

    public int getFXCMContinuousFlag() {
        return this.mContinuousFlag;
    }

    public void setFXCMContinuousFlag(int aValue) {
        this.mContinuousFlag = aValue;
    }

    public void setFXCMMsgID(Long aValue) {
        this.mFXCMMsgID = aValue;
    }

    public Long getFXCMMsgID() {
        return this.mFXCMMsgID;
    }

    @Override
    public IMessage toMessage(String aSID, IMessageFactory aFactory) {
        return this.toMessage(aSID, null, null, null, 7, aFactory);
    }

    @Override
    public abstract IMessage toMessage(String var1, String var2, String var3, String var4, int var5, IMessageFactory var6);

    public void reset() {
        this.setInstrument(null);
        this.setTimestamp(null);
        this.setFXCMContinuousFlag(0);
        this.setFXCMTimingInterval(FXCMTimingIntervalFactory.TICK);
        this.setComplete(true);
        this.setMDReqID(null);
        this.setTradingSessionID("FXCM");
        this.setTradingSessionSubID("");
        this.setTradeable(false);
        this.setFXCMMsgID(null);
        this.setPriceStream(null);
    }

    @Override
    public abstract boolean fill(IMessage var1);

    @Override
    public boolean update(IMessage aMsg) {
        return this.fill(aMsg);
    }

    @Override
    public boolean isValid() {
        boolean ret = false;
        if (this.mInstrument != null && this.mTimestamp != null && this.mInterval != null) {
            ret = this.mInterval.equals(FXCMTimingIntervalFactory.TICK) ? this._getAskOpen() != 0.0 || this._getBidOpen() != 0.0 || this._getAskClose() != 0.0 || this._getBidClose() != 0.0 : this._getAskOpen() != 0.0 && this._getAskClose() != 0.0 && this._getAskLow() != 0.0 && this._getAskHigh() != 0.0 || this._getBidOpen() != 0.0 && this._getBidClose() != 0.0 && this._getBidLow() != 0.0 && this._getBidHigh() != 0.0;
        }
        return ret;
    }

    public abstract String getBidId();

    public abstract void setBidId(String var1);

    public abstract String getAskId();

    public abstract void setAskId(String var1);

    public abstract String getBidQuoteCondition();

    public abstract void setBidQuoteCondition(String var1);

    public abstract int getBidQuoteType();

    public abstract void setBidQuoteType(int var1);

    public abstract UTCDate getBidExpireDate();

    public abstract void setBidExpireDate(UTCDate var1);

    public abstract void setBidExpireDate(String var1);

    public abstract UTCTimeOnly getBidExpireTime();

    public abstract void setBidExpireTime(UTCTimeOnly var1);

    public abstract void setBidExpireTime(String var1);

    public abstract void setBidExpireTimestamp(UTCTimestamp var1);

    public abstract UTCTimestamp getBidExpireTimestamp();

    public abstract String getBidOriginator();

    public abstract void setBidOriginator(String var1);

    public abstract String getBidCurrency();

    public abstract void setBidCurrency(String var1);

    public abstract double getBidEntrySize();

    public abstract void setBidEntrySize(double var1);

    public abstract String getAskQuoteCondition();

    public abstract void setAskQuoteCondition(String var1);

    public abstract int getAskQuoteType();

    public abstract void setAskQuoteType(int var1);

    public abstract UTCDate getAskExpireDate();

    public abstract void setAskExpireDate(UTCDate var1);

    public abstract void setAskExpireDate(String var1);

    public abstract UTCTimeOnly getAskExpireTime();

    public abstract void setAskExpireTime(UTCTimeOnly var1);

    public abstract void setAskExpireTime(String var1);

    public abstract UTCTimestamp getAskExpireTimestamp();

    public abstract void setAskExpireTimestamp(UTCTimestamp var1);

    public abstract String getAskOriginator();

    public abstract void setAskOriginator(String var1);

    public abstract String getAskCurrency();

    public abstract void setAskCurrency(String var1);

    public abstract double getAskEntrySize();

    public abstract void setAskEntrySize(double var1);

    @Override
    public String getRequestID() {
        return this.getMDReqID();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarketDataSnapshot mds = (MarketDataSnapshot)o;
        if (Double.compare(mds._getAskClose(), this._getAskClose()) != 0) {
            return false;
        }
        if (Double.compare(mds.getAskEntrySize(), this.getAskEntrySize()) != 0) {
            return false;
        }
        if (Double.compare(mds._getAskHigh(), this._getAskHigh()) != 0) {
            return false;
        }
        if (Double.compare(mds._getAskLow(), this._getAskLow()) != 0) {
            return false;
        }
        if (Double.compare(mds._getAskOpen(), this._getAskOpen()) != 0) {
            return false;
        }
        if (this.getAskQuoteType() != mds.getAskQuoteType()) {
            return false;
        }
        if (Double.compare(mds._getBidClose(), this._getBidClose()) != 0) {
            return false;
        }
        if (Double.compare(mds.getBidEntrySize(), this.getBidEntrySize()) != 0) {
            return false;
        }
        if (Double.compare(mds._getBidHigh(), this._getBidHigh()) != 0) {
            return false;
        }
        if (Double.compare(mds._getBidLow(), this._getBidLow()) != 0) {
            return false;
        }
        if (Double.compare(mds._getBidOpen(), this._getBidOpen()) != 0) {
            return false;
        }
        if (this.getBidQuoteType() != mds.getBidQuoteType()) {
            return false;
        }
        if (this.isComplete() != mds.isComplete()) {
            return false;
        }
        if (this.getFXCMContinuousFlag() != mds.getFXCMContinuousFlag()) {
            return false;
        }
        if (Double.compare(mds._getHigh(), this._getHigh()) != 0) {
            return false;
        }
        if (this.isTradeable() != mds.isTradeable()) {
            return false;
        }
        if (Double.compare(mds._getLow(), this._getLow()) != 0) {
            return false;
        }
        if (this.getAskCurrency() != null ? !this.getAskCurrency().equals(mds.getAskCurrency()) : mds.getAskCurrency() != null) {
            return false;
        }
        if (this.getAskId() != null ? !this.getAskId().equals(mds.getAskId()) : mds.getAskId() != null) {
            return false;
        }
        if (this.getAskOriginator() != null ? !this.getAskOriginator().equals(mds.getAskOriginator()) : mds.getAskOriginator() != null) {
            return false;
        }
        if (this.getAskQuoteCondition() != null ? !this.getAskQuoteCondition().equals(mds.getAskQuoteCondition()) : mds.getAskQuoteCondition() != null) {
            return false;
        }
        if (this.getBidCurrency() != null ? !this.getBidCurrency().equals(mds.getBidCurrency()) : mds.getBidCurrency() != null) {
            return false;
        }
        if (this.getBidId() != null ? !this.getBidId().equals(mds.getBidId()) : mds.getBidId() != null) {
            return false;
        }
        if (this.getBidOriginator() != null ? !this.getBidOriginator().equals(mds.getBidOriginator()) : mds.getBidOriginator() != null) {
            return false;
        }
        if (this.getBidQuoteCondition() != null ? !this.getBidQuoteCondition().equals(mds.getBidQuoteCondition()) : mds.getBidQuoteCondition() != null) {
            return false;
        }
        if (this.getOpenTimestampRef() != null ? !this.getOpenTimestampRef().equals(mds.getOpenTimestampRef()) : mds.getOpenTimestampRef() != null) {
            return false;
        }
        if (this.getInstrument() != null ? !this.getInstrument().equals(mds.getInstrument()) : mds.getInstrument() != null) {
            return false;
        }
        if (this.getFXCMTimingInterval() != null ? !this.getFXCMTimingInterval().equals(mds.getFXCMTimingInterval()) : mds.getFXCMTimingInterval() != null) {
            return false;
        }
        if (this.getTradingSessionID() != null ? !this.getTradingSessionID().equals(mds.getTradingSessionID()) : mds.getTradingSessionID() != null) {
            return false;
        }
        return !(this.getTradingSessionSubID() != null ? !this.getTradingSessionSubID().equals(mds.getTradingSessionSubID()) : mds.getTradingSessionSubID() != null);
    }

    public int hashCode() {
        int result = this.getQuoteID() != null ? this.getQuoteID().hashCode() : 0;
        result = 29 * result + (this.getInstrument() != null ? this.getInstrument().hashCode() : 0);
        result = 29 * result + (this.getOpenTimestampRef() != null ? this.getOpenTimestampRef().hashCode() : 0);
        result = 29 * result + (this.getFXCMTimingInterval() != null ? this.getFXCMTimingInterval().hashCode() : 0);
        result = 29 * result + (this.getTradingSessionID() != null ? this.getTradingSessionID().hashCode() : 0);
        result = 29 * result + (this.getTradingSessionSubID() != null ? this.getTradingSessionSubID().hashCode() : 0);
        result = 29 * result + (this.getOriginator() != null ? this.getOriginator().hashCode() : 0);
        return result;
    }

    protected abstract double _getLow();

    protected abstract double _getHigh();

    protected abstract double _getAskLow();

    protected abstract double _getAskHigh();

    protected abstract double _getAskOpen();

    protected abstract double _getAskClose();

    protected abstract double _getBidLow();

    protected abstract double _getBidHigh();

    protected abstract double _getBidOpen();

    protected abstract double _getBidClose();

    protected abstract int _getTickVolume();

    @Override
    public long getMakingTime() {
        return this.mMakingTime;
    }

    private static class MarketDataSnapshotType
    extends ACode {
        private static final long serialVersionUID = 1426653084792258472L;

        MarketDataSnapshotType() {
            super("W", "MarketDataSnapshotType", "");
        }
    }
}

