/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix.pretrade;

import com.fxcm.entity.ACode;
import com.fxcm.entity.ICode;
import com.fxcm.fix.FXCMTimingIntervalFactory;
import com.fxcm.fix.IFXCMTimingInterval;
import com.fxcm.fix.IFixDefs;
import com.fxcm.fix.IMDReqRejReason;
import com.fxcm.fix.Instrument;
import com.fxcm.fix.MDReqRejReasonFactory;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.IMessageFactory;
import com.fxcm.messaging.ITransportable;

public class MarketDataRequestReject
implements ITransportable,
IFixDefs {
    public static final ICode OBJ_TYPE = new MarketDataRequestRejectType();
    protected String mMDReqID;
    protected IMDReqRejReason mMDReqRejReason;
    protected String mText;
    protected Instrument mInstrument;
    protected IFXCMTimingInterval mFXCMTimingInterval;
    private String mTradingSessionID;
    private String mTradingSessionSubID;
    private long mMakingTime = System.currentTimeMillis();

    private void log(String s) {
        System.out.println(s);
    }

    public MarketDataRequestReject() {
        this.reset();
    }

    public MarketDataRequestReject(String aMDReqID, IMDReqRejReason aMDReqRejReason, String aText) {
        this.setMDReqID(aMDReqID);
        this.setMDReqRejReason(aMDReqRejReason);
        this.setText(aText);
    }

    @Override
    public ICode getType() {
        return OBJ_TYPE;
    }

    public void setMDReqID(String aMDReqID) {
        this.mMDReqID = aMDReqID;
    }

    public void setMDReqRejReason(String aMDReqRejReason) {
        this.mMDReqRejReason = MDReqRejReasonFactory.toCode(aMDReqRejReason);
    }

    public void setMDReqRejReason(IMDReqRejReason aMDReqRejReason) {
        this.mMDReqRejReason = aMDReqRejReason;
    }

    public void setText(String aText) {
        this.mText = aText;
    }

    public String getMDReqID() {
        return this.mMDReqID;
    }

    public IMDReqRejReason getMDReqRejReason() {
        return this.mMDReqRejReason;
    }

    public String getText() {
        return this.mText;
    }

    @Override
    public IMessage toMessage(String aSID, IMessageFactory aFactory) {
        return this.toMessage(aSID, null, null, null, 0, aFactory);
    }

    @Override
    public IMessage toMessage(String aSID, String aTradingSessionID, String aTradingSessionSubID, String aRequestID, int aOptions, IMessageFactory aFactory) {
        String tssubid;
        String tsid;
        String req = aRequestID;
        if (req == null) {
            req = this.getMDReqID();
        }
        if ((tsid = aTradingSessionID) == null) {
            tsid = this.getTradingSessionID();
        }
        if ((tssubid = aTradingSessionSubID) == null) {
            tssubid = this.getTradingSessionSubID();
        }
        IMessage ret = aFactory.createMessage(aSID, "Y");
        ret.setValue("262", req);
        ret.setValue("281", this.getMDReqRejReason().getCode());
        ret.setValue("58", this.getText());
        if (this.mInstrument != null) {
            try {
                ret.setValue("55", this.mInstrument.getSymbol());
                ret.setValue("9000", this.getInstrument().getFXCMSymID());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.getFXCMTimingInterval() != null) {
            String[] messageCodes = FXCMTimingIntervalFactory.storageToMessageIntervalCodes(this.getFXCMTimingInterval().getCode());
            ret.setValue("9011", messageCodes[0]);
            ret.setValue("9075", messageCodes[1]);
        }
        if (this.getTradingSessionID() != null) {
            ret.setValue("336", tsid);
            ret.setValue("625", tssubid);
        }
        return ret;
    }

    public void reset() {
        this.setMDReqID(null);
        this.setMDReqRejReason(MDReqRejReasonFactory.UNKNOWNSYMBOL);
        this.setText(null);
        this.setTradingSessionID(null);
        this.setTradingSessionSubID(null);
        this.setInstrument(null);
        this.setFXCMTimingInterval(FXCMTimingIntervalFactory.TICK);
    }

    @Override
    public boolean fill(IMessage aMsg) {
        this.reset();
        if (aMsg != null) {
            this.setMDReqID(aMsg.getValueString("262"));
            this.setMDReqRejReason(aMsg.getValueString("281"));
            this.setText(aMsg.getValueString("58"));
            int mainTICode = aMsg.getValueInt("9011");
            String auxTICode = aMsg.getValueString("9075");
            if (auxTICode == null) {
                auxTICode = "";
            }
            int interval = FXCMTimingIntervalFactory.messageToStorageIntervalCode(mainTICode, auxTICode);
            this.setFXCMTimingInterval(FXCMTimingIntervalFactory.toCode(interval));
            this.setTradingSessionID(aMsg.getValueString("336"));
            this.setTradingSessionSubID(aMsg.getValueString("625"));
            this.setInstrument(new Instrument(aMsg.getValueString("55"), aMsg.getValueInt("9000"), 0));
        }
        return this.isValid();
    }

    @Override
    public boolean update(IMessage aMsg) {
        return this.fill(aMsg);
    }

    @Override
    public boolean isValid() {
        return this.mMDReqID != null && this.mMDReqRejReason != null;
    }

    @Override
    public String getRequestID() {
        return this.getMDReqID();
    }

    @Override
    public String getTradingSessionID() {
        return this.mTradingSessionID;
    }

    @Override
    public String getTradingSessionSubID() {
        return this.mTradingSessionSubID;
    }

    public void setTradingSessionID(String aTradingSessionID) {
        this.mTradingSessionID = aTradingSessionID;
    }

    public void setTradingSessionSubID(String aTradingSessionSubID) {
        this.mTradingSessionSubID = aTradingSessionSubID;
    }

    public Instrument getInstrument() {
        return this.mInstrument;
    }

    public void setInstrument(Instrument aInstrument) {
        this.mInstrument = aInstrument;
    }

    public IFXCMTimingInterval getFXCMTimingInterval() {
        return this.mFXCMTimingInterval;
    }

    public void setFXCMTimingInterval(IFXCMTimingInterval aInterval) {
        this.mFXCMTimingInterval = aInterval;
    }

    @Override
    public long getMakingTime() {
        return this.mMakingTime;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("MarketDataRequestReject");
        sb.append("{mMDReqID='").append(this.mMDReqID).append('\'');
        sb.append(", mMDReqRejReason=").append(this.mMDReqRejReason);
        sb.append(", mText='").append(this.mText).append('\'');
        sb.append(", mInstrument=").append(this.mInstrument);
        sb.append(", mFXCMTimingInterval=").append(this.mFXCMTimingInterval);
        sb.append(", mTradingSessionID='").append(this.mTradingSessionID).append('\'');
        sb.append(", mTradingSessionSubID='").append(this.mTradingSessionSubID).append('\'');
        sb.append(", mMakingTime=").append(this.mMakingTime);
        sb.append('}');
        return sb.toString();
    }

    private static class MarketDataRequestRejectType
    extends ACode {
        MarketDataRequestRejectType() {
            super("Y", "MarketDataRequestRejectType", "");
        }
    }
}

