/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix.pretrade;

import com.fxcm.entity.ACode;
import com.fxcm.entity.ICode;
import com.fxcm.fix.FXCMTimingIntervalFactory;
import com.fxcm.fix.IFXCMTimingInterval;
import com.fxcm.fix.IFixDefs;
import com.fxcm.fix.ISubscriptionRequestType;
import com.fxcm.fix.Instrument;
import com.fxcm.fix.NotDefinedException;
import com.fxcm.fix.SubscriptionRequestTypeFactory;
import com.fxcm.fix.UTCDate;
import com.fxcm.fix.UTCTimeOnly;
import com.fxcm.fix.UTCTimestamp;
import com.fxcm.messaging.IFieldGroup;
import com.fxcm.messaging.IFieldGroupList;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.IMessageFactory;
import com.fxcm.messaging.ITransportable;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class MarketDataRequest
implements ITransportable,
IFixDefs {
    public static final ICode OBJ_TYPE = new MarketDataRequestType();
    public static final int MDENTRYTYPESET_UNKNOWN = 0;
    public static final int MDENTRYTYPESET_BID = 1;
    public static final int MDENTRYTYPESET_ASK = 2;
    public static final int MDENTRYTYPESET_HLO = 4;
    public static final int MDENTRYTYPESET_EXTRA = 8;
    public static final int MDENTRYTYPESET_TICKVOLUME = 16;
    public static final int MDENTRYTYPESET_BIDASK = 3;
    public static final int MDENTRYTYPESET_ALL = 7;
    public static final int MDENTRYTYPESET_TICKRATIO = 7;
    public static final int MDENTRYTYPESET_BIDEXTRA = 9;
    public static final int MDENTRYTYPESET_ASKEXTRA = 10;
    public static final int MDENTRYTYPESET_TICKEXTRA = 11;
    public static final int MDENTRYTYPESET_TICKALL = 15;
    protected String mMDReqID;
    protected ISubscriptionRequestType mSubscriptionRequestType;
    protected int mMDEntryTypeSet;
    protected Vector mNoRelatedSym;
    protected String mTradingSessionID;
    protected String mTradingSessionSubID = "";
    protected IFXCMTimingInterval mFXCMTimingInterval;
    protected UTCTimestamp mFXCMStartTimestamp;
    protected UTCTimestamp mFXCMEndTimestamp;
    protected int mFXCMNoSnapshot;
    protected int mMDUpdateType;
    protected String mResponseFormat;
    private long mMakingTime = System.currentTimeMillis();
    private String mPriceStream;
    private boolean mIncludeWeekends;
    private int mCandleType;

    public MarketDataRequest() {
        this.mNoRelatedSym = new Vector();
        this.reset();
    }

    @Override
    public ICode getType() {
        return OBJ_TYPE;
    }

    public void setMDReqID(String aMDReqID) {
        this.mMDReqID = aMDReqID;
    }

    public void setTradingSessionID(String aTradingSessionID) {
        this.mTradingSessionID = aTradingSessionID;
    }

    public void setTradingSessionSubID(String aTradingSessionSubID) {
        this.mTradingSessionSubID = aTradingSessionSubID;
    }

    public void setSubscriptionRequestType(String aSubscriptionRequestType) {
        this.mSubscriptionRequestType = SubscriptionRequestTypeFactory.toCode(aSubscriptionRequestType);
    }

    public void setSubscriptionRequestType(ISubscriptionRequestType aSubscriptionRequestType) {
        this.mSubscriptionRequestType = aSubscriptionRequestType;
    }

    public void setMDEntryTypeSet(int aMDEntryTypeSet) {
        this.mMDEntryTypeSet = aMDEntryTypeSet;
    }

    public void setFXCMNoSnapshot(int aFXCMNoSnapshot) {
        this.mFXCMNoSnapshot = aFXCMNoSnapshot > 0 ? aFXCMNoSnapshot : 0;
    }

    public void addRelatedSymbol(Instrument aSymbol) {
        this.mNoRelatedSym.add(aSymbol);
    }

    public void setFXCMTimingInterval(IFXCMTimingInterval aFXCMTimingInterval) {
        this.mFXCMTimingInterval = aFXCMTimingInterval;
    }

    public void setFXCMStartDate(UTCDate aFXCMStartDate) {
        if (aFXCMStartDate == null) {
            this.mFXCMStartTimestamp = null;
            return;
        }
        if (this.mFXCMStartTimestamp == null) {
            this.mFXCMStartTimestamp = new UTCTimestamp();
        }
        this.mFXCMStartTimestamp.setDateOnly(aFXCMStartDate);
    }

    public void setFXCMStartDate(String aFXCMStartDate) {
        if (aFXCMStartDate == null) {
            this.mFXCMStartTimestamp = null;
            return;
        }
        if (this.mFXCMStartTimestamp == null) {
            this.mFXCMStartTimestamp = new UTCTimestamp();
        }
        try {
            this.mFXCMStartTimestamp.setDateOnly(aFXCMStartDate);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void setFXCMStartTime(UTCTimeOnly aFXCMStartTime) {
        if (aFXCMStartTime == null) {
            this.mFXCMStartTimestamp = null;
            return;
        }
        if (this.mFXCMStartTimestamp == null) {
            this.mFXCMStartTimestamp = new UTCTimestamp();
        }
        this.mFXCMStartTimestamp.setTimeOnly(aFXCMStartTime);
    }

    public void setFXCMStartTime(String aFXCMStartTime) {
        if (aFXCMStartTime == null) {
            this.mFXCMStartTimestamp = null;
            return;
        }
        if (this.mFXCMStartTimestamp == null) {
            this.mFXCMStartTimestamp = new UTCTimestamp();
        }
        try {
            this.mFXCMStartTimestamp.setTimeOnly(aFXCMStartTime);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void setFXCMEndDate(String aFXCMEndDate) {
        if (aFXCMEndDate == null) {
            this.mFXCMEndTimestamp = null;
            return;
        }
        if (this.mFXCMEndTimestamp == null) {
            this.mFXCMEndTimestamp = new UTCTimestamp();
        }
        try {
            this.mFXCMEndTimestamp.setDateOnly(aFXCMEndDate);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void setFXCMEndDate(UTCDate aFXCMEndDate) {
        if (aFXCMEndDate == null) {
            this.mFXCMEndTimestamp = null;
            return;
        }
        if (this.mFXCMEndTimestamp == null) {
            this.mFXCMEndTimestamp = new UTCTimestamp();
        }
        this.mFXCMEndTimestamp.setDateOnly(aFXCMEndDate);
    }

    public void setFXCMEndTime(UTCTimeOnly aFXCMEndTime) {
        if (aFXCMEndTime == null) {
            this.mFXCMEndTimestamp = null;
            return;
        }
        if (this.mFXCMEndTimestamp == null) {
            this.mFXCMEndTimestamp = new UTCTimestamp();
        }
        this.mFXCMEndTimestamp.setTimeOnly(aFXCMEndTime);
    }

    public void setFXCMEndTime(String aFXCMEndTime) {
        if (aFXCMEndTime == null) {
            this.mFXCMEndTimestamp = null;
            return;
        }
        if (this.mFXCMEndTimestamp == null) {
            this.mFXCMEndTimestamp = new UTCTimestamp();
        }
        try {
            this.mFXCMEndTimestamp.setTimeOnly(aFXCMEndTime);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public int getMDEntryTypeSet() {
        return this.mMDEntryTypeSet;
    }

    public int getFXCMNoSnapshot() {
        return this.mFXCMNoSnapshot;
    }

    public Enumeration getRelatedSymbols() {
        return this.mNoRelatedSym.elements();
    }

    public int getMDUpdateType() {
        return this.mMDUpdateType;
    }

    public void setMDUpdateType(int aMDUpdateType) {
        this.mMDUpdateType = aMDUpdateType;
    }

    public String getMDReqID() {
        return this.mMDReqID;
    }

    @Override
    public String getTradingSessionID() {
        return this.mTradingSessionID;
    }

    @Override
    public String getTradingSessionSubID() {
        return this.mTradingSessionSubID;
    }

    public ISubscriptionRequestType getSubscriptionRequestType() {
        return this.mSubscriptionRequestType;
    }

    public IFXCMTimingInterval getFXCMTimingInterval() {
        return this.mFXCMTimingInterval;
    }

    public UTCDate getFXCMStartDate() {
        if (this.mFXCMStartTimestamp == null) {
            return null;
        }
        return new UTCDate(this.mFXCMStartTimestamp);
    }

    public UTCTimeOnly getFXCMStartTime() {
        if (this.mFXCMStartTimestamp == null) {
            return null;
        }
        return new UTCTimeOnly(this.mFXCMStartTimestamp);
    }

    public UTCDate getFXCMEndDate() {
        if (this.mFXCMEndTimestamp == null) {
            return null;
        }
        return new UTCDate(this.mFXCMEndTimestamp);
    }

    public UTCTimeOnly getFXCMEndTime() {
        if (this.mFXCMEndTimestamp == null) {
            return null;
        }
        return new UTCTimeOnly(this.mFXCMEndTimestamp);
    }

    public UTCTimestamp getFXCMEndTimestamp() {
        return this.mFXCMEndTimestamp;
    }

    public void setFXCMEndTimestamp(UTCTimestamp aFXCMEndTimestamp) {
        this.mFXCMEndTimestamp = aFXCMEndTimestamp;
    }

    public UTCTimestamp getFXCMStartTimestamp() {
        return this.mFXCMStartTimestamp;
    }

    public void setFXCMStartTimestamp(UTCTimestamp aFXCMStartTimestamp) {
        this.mFXCMStartTimestamp = aFXCMStartTimestamp;
    }

    public String getPriceStream() {
        return this.mPriceStream;
    }

    public void setPriceStream(String mPriceStream) {
        this.mPriceStream = mPriceStream;
    }

    public boolean isIncludeWeekends() {
        return this.mIncludeWeekends;
    }

    public void setIncludeWeekends(boolean aIncludeWeekends) {
        this.mIncludeWeekends = aIncludeWeekends;
    }

    public int getCandleType() {
        return this.mCandleType;
    }

    public void setCandleType(int aCandleType) {
        this.mCandleType = aCandleType;
    }

    @Override
    public IMessage toMessage(String aSID, IMessageFactory aFactory) {
        return this.toMessage(aSID, null, null, null, 0, aFactory);
    }

    @Override
    public IMessage toMessage(String aSID, String aTradingSessionID, String aTradingSessionSubID, String aRequestID, int aOptions, IMessageFactory aFactory) {
        IFieldGroup gr;
        String tssubid;
        String tsid;
        String req = aRequestID;
        if (req == null) {
            req = this.getMDReqID();
        }
        if ((tsid = aTradingSessionID) == null) {
            tsid = this.getTradingSessionID();
        }
        if ((tssubid = aTradingSessionSubID) == null) {
            tssubid = this.getTradingSessionSubID();
        }
        IMessage ret = aFactory.createMessage(aSID, "V");
        ret.setValue("262", req);
        ret.setValue("263", this.getSubscriptionRequestType().getCode());
        ret.setValue("264", 1);
        ret.setValue("265", this.getMDUpdateType());
        IFXCMTimingInterval interval = this.getFXCMTimingInterval();
        if (interval == null) {
            interval = FXCMTimingIntervalFactory.TICK;
        }
        IFieldGroupList grl = aFactory.createFieldGroupList();
        if ((this.mMDEntryTypeSet & 1) != 0) {
            if (interval.equals(FXCMTimingIntervalFactory.TICK)) {
                gr = aFactory.createFieldGroup();
                gr.setValue("269", "0");
                grl.put(gr);
            } else {
                gr = aFactory.createFieldGroup();
                gr.setValue("269", "4");
                grl.put(gr);
                gr = aFactory.createFieldGroup();
                gr.setValue("269", "5");
                grl.put(gr);
                gr = aFactory.createFieldGroup();
                gr.setValue("269", "D");
                grl.put(gr);
                gr = aFactory.createFieldGroup();
                gr.setValue("269", "E");
                grl.put(gr);
            }
        }
        if ((this.mMDEntryTypeSet & 2) != 0) {
            if (interval.equals(FXCMTimingIntervalFactory.TICK)) {
                gr = aFactory.createFieldGroup();
                gr.setValue("269", "1");
                grl.put(gr);
            } else {
                gr = aFactory.createFieldGroup();
                gr.setValue("269", "B");
                grl.put(gr);
                gr = aFactory.createFieldGroup();
                gr.setValue("269", "C");
                grl.put(gr);
                gr = aFactory.createFieldGroup();
                gr.setValue("269", "F");
                grl.put(gr);
                gr = aFactory.createFieldGroup();
                gr.setValue("269", "G");
                grl.put(gr);
            }
        }
        if ((this.mMDEntryTypeSet & 4) != 0 && interval.equals(FXCMTimingIntervalFactory.TICK) && (this.mMDEntryTypeSet & 1) != 0 && (this.mMDEntryTypeSet & 2) != 0) {
            gr = aFactory.createFieldGroup();
            gr.setValue("269", "7");
            grl.put(gr);
            gr = aFactory.createFieldGroup();
            gr.setValue("269", "8");
            grl.put(gr);
            if ((this.mMDEntryTypeSet & 8) == 0) {
                gr = aFactory.createFieldGroup();
                gr.setValue("269", "4");
                grl.put(gr);
            }
        }
        if ((this.mMDEntryTypeSet & 8) != 0 && interval.equals(FXCMTimingIntervalFactory.TICK)) {
            if ((this.mMDEntryTypeSet & 1) != 0) {
                gr = aFactory.createFieldGroup();
                gr.setValue("269", "4");
                grl.put(gr);
                gr = aFactory.createFieldGroup();
                gr.setValue("269", "D");
                grl.put(gr);
                gr = aFactory.createFieldGroup();
                gr.setValue("269", "E");
                grl.put(gr);
            }
            if ((this.mMDEntryTypeSet & 2) != 0) {
                gr = aFactory.createFieldGroup();
                gr.setValue("269", "B");
                grl.put(gr);
                gr = aFactory.createFieldGroup();
                gr.setValue("269", "F");
                grl.put(gr);
                gr = aFactory.createFieldGroup();
                gr.setValue("269", "G");
                grl.put(gr);
            }
        }
        if ((this.mMDEntryTypeSet & 0x10) != 0 && !interval.equals(FXCMTimingIntervalFactory.TICK)) {
            gr = aFactory.createFieldGroup();
            gr.setValue("269", "H");
            grl.put(gr);
        }
        ret.setValue("267", grl);
        Enumeration enumeration = this.getRelatedSymbols();
        grl = aFactory.createFieldGroupList();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Instrument instr = (Instrument)enumeration.nextElement();
                gr = aFactory.createFieldGroup();
                try {
                    gr.setValue("55", instr.getSymbol());
                    gr.setValue("9000", instr.getFXCMSymID());
                    gr.setValue("9001", instr.getFXCMSymPrecision());
                }
                catch (NotDefinedException notDefinedException) {
                    // empty catch block
                }
                if (gr.getValueString("55") == null) continue;
                grl.put(gr);
            }
        }
        ret.setValue("146", grl);
        grl = aFactory.createFieldGroupList();
        gr = aFactory.createFieldGroup();
        gr.setValue("336", tsid);
        gr.setValue("625", tssubid);
        grl.put(gr);
        ret.setValue("386", grl);
        String[] messageCodes = FXCMTimingIntervalFactory.storageToMessageIntervalCodes(interval.getCode());
        ret.setValue("9011", messageCodes[0]);
        ret.setValue("9075", messageCodes[1]);
        if (this.getFXCMStartTimestamp() != null) {
            ret.setValue("9012", this.getFXCMStartTimestamp().toStringDateOnly());
            ret.setValue("9013", this.getFXCMStartTimestamp().toStringTimeOnly());
        }
        if (this.getFXCMEndTimestamp() != null) {
            ret.setValue("9014", this.getFXCMEndTimestamp().toStringDateOnly());
            ret.setValue("9015", this.getFXCMEndTimestamp().toStringTimeOnly());
        }
        if (this.getFXCMNoSnapshot() > 0) {
            ret.setValue("9021", this.getFXCMNoSnapshot());
        }
        if (this.mResponseFormat != null && this.mResponseFormat.length() > 0) {
            ret.setValue("9074", this.mResponseFormat);
        }
        if (this.getPriceStream() != null && this.getPriceStream().length() > 0) {
            ret.setValue("9072", this.getPriceStream());
        }
        ret.setValue("9100", Boolean.toString(this.isIncludeWeekends()));
        return ret;
    }

    public void reset() {
        this.setMDEntryTypeSet(0);
        this.mNoRelatedSym.clear();
        this.setTradingSessionID("FXCM");
        this.setTradingSessionSubID("");
        this.setSubscriptionRequestType(SubscriptionRequestTypeFactory.SUBSCRIBE);
        this.setMDReqID(null);
        this.setFXCMTimingInterval(FXCMTimingIntervalFactory.TICK);
        this.setFXCMStartTimestamp(null);
        this.setFXCMEndTimestamp(null);
        this.setFXCMNoSnapshot(0);
        this.setMDUpdateType(0);
        this.setIncludeWeekends(true);
        this.setCandleType(0);
    }

    @Override
    public boolean isValid() {
        boolean ret = false;
        switch (this.getMDEntryTypeSet()) {
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                if (this.mNoRelatedSym.isEmpty()) break;
                ret = true;
            }
        }
        return ret;
    }

    private void collectMDEntryTypeSet(String aEntryType) {
        if (this.getFXCMTimingInterval().equals(FXCMTimingIntervalFactory.TICK)) {
            if (aEntryType.equals("0")) {
                this.mMDEntryTypeSet |= 1;
            } else if (aEntryType.equals("1")) {
                this.mMDEntryTypeSet |= 2;
            } else if (aEntryType.equals("7") || aEntryType.equals("8")) {
                this.mMDEntryTypeSet |= 4;
            } else if (aEntryType.equals("E") || aEntryType.equals("D") || aEntryType.equals("B") || aEntryType.equals("G") || aEntryType.equals("F")) {
                this.mMDEntryTypeSet |= 8;
            } else if (!aEntryType.equals("4")) {
                this.setMDEntryTypeSet(0);
            }
        } else if (aEntryType.equals("4") || aEntryType.equals("5") || aEntryType.equals("D") || aEntryType.equals("E")) {
            this.mMDEntryTypeSet |= 1;
        } else if (aEntryType.equals("B") || aEntryType.equals("C") || aEntryType.equals("B") || aEntryType.equals("F") || aEntryType.equals("G")) {
            this.mMDEntryTypeSet |= 2;
        } else if (aEntryType.equals("H")) {
            this.mMDEntryTypeSet |= 0x10;
        } else {
            this.setMDEntryTypeSet(0);
        }
    }

    @Override
    public boolean fill(IMessage aMsg) {
        this.reset();
        boolean ret = false;
        if (aMsg != null) {
            IFieldGroup gr;
            this.setMDReqID(aMsg.getValueString("262"));
            this.setSubscriptionRequestType(aMsg.getValueString("263"));
            this.setMDUpdateType(aMsg.getValueInt("265"));
            int mainTICode = aMsg.getValueInt("9011");
            String auxTICode = aMsg.getValueString("9075");
            if (auxTICode == null) {
                auxTICode = "";
            }
            int interval = FXCMTimingIntervalFactory.messageToStorageIntervalCode(mainTICode, auxTICode);
            this.setFXCMTimingInterval(FXCMTimingIntervalFactory.toCode(interval));
            String s = aMsg.getValueString("9012");
            if (s != null) {
                this.setFXCMStartDate(s);
            }
            if ((s = aMsg.getValueString("9013")) != null) {
                this.setFXCMStartTime(s);
            }
            if ((s = aMsg.getValueString("9014")) != null) {
                this.setFXCMEndDate(s);
            }
            if ((s = aMsg.getValueString("9015")) != null) {
                this.setFXCMEndTime(s);
            }
            this.setResponseFormat(aMsg.getValueString("9074"));
            this.setFXCMNoSnapshot(aMsg.getValueInt("9021"));
            this.setPriceStream(aMsg.getValueString("9072"));
            IFieldGroupList grl = aMsg.getValueList("146");
            if (grl != null) {
                for (IFieldGroup field : grl.values()) {
                    gr = field;
                    s = gr.getValueString("55");
                    if (s == null) continue;
                    Instrument instr = new Instrument(s);
                    instr.setFXCMSymID(gr.getValueInt("9000"));
                    instr.setFXCMSymPrecision(gr.getValueInt("9001"));
                    this.addRelatedSymbol(instr);
                }
                grl = aMsg.getValueList("267");
                if (grl != null) {
                    Iterator<IFieldGroup> iterator = grl.values().iterator();
                    while (iterator.hasNext()) {
                        IFieldGroup field;
                        gr = field = iterator.next();
                        s = gr.getValueString("269");
                        this.collectMDEntryTypeSet(s);
                    }
                }
            }
            if ((grl = aMsg.getValueList("386")) != null && grl.size() != 0 && (gr = grl.getFields().get(0)) != null) {
                this.setTradingSessionID(gr.getValueString("336"));
                this.setTradingSessionSubID(gr.getValueString("625"));
                ret = this.isValid();
            }
            if ((s = aMsg.getValueString("9100")) != null) {
                this.setIncludeWeekends("true".equals(s));
            }
        }
        this.setCandleType(aMsg.getValueInt("9101"));
        return ret;
    }

    @Override
    public boolean update(IMessage aMsg) {
        return this.fill(aMsg);
    }

    @Override
    public String getRequestID() {
        return this.getMDReqID();
    }

    public String getResponseFormat() {
        return this.mResponseFormat;
    }

    public void setResponseFormat(String aResponseFormat) {
        this.mResponseFormat = aResponseFormat;
    }

    @Override
    public long getMakingTime() {
        return this.mMakingTime;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MarketDataRequest");
        sb.append("{mMDReqID='").append(this.mMDReqID).append('\'');
        sb.append(", mSubscriptionRequestType=").append(this.mSubscriptionRequestType);
        sb.append(", mMDEntryTypeSet=").append(this.mMDEntryTypeSet);
        sb.append(", mNoRelatedSym=").append(this.mNoRelatedSym);
        sb.append(", mTradingSessionID='").append(this.mTradingSessionID).append('\'');
        sb.append(", mTradingSessionSubID='").append(this.mTradingSessionSubID).append('\'');
        sb.append(", mFXCMTimingInterval=").append(this.mFXCMTimingInterval);
        sb.append(", mFXCMStartTimestamp").append(this.mFXCMStartTimestamp);
        sb.append(", mFXCMEndTimestamp").append(this.mFXCMEndTimestamp);
        sb.append(", mFXCMNoSnapshot=").append(this.mFXCMNoSnapshot);
        sb.append(", mResponseFormat='").append(this.mResponseFormat).append('\'');
        sb.append(", mMakingTime=").append(this.mMakingTime);
        sb.append(", mPriceStream=").append(this.mPriceStream);
        sb.append('}');
        return sb.toString();
    }

    private static class MarketDataRequestType
    extends ACode {
        private static final long serialVersionUID = 2966491357150731980L;

        MarketDataRequestType() {
            super("V", "MarketDataRequestType", "");
        }
    }
}

