/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix.pretrade;

import com.fxcm.entity.ACode;
import com.fxcm.entity.ICode;
import com.fxcm.fix.pretrade.inner.MarketDataEntryIncremental;
import com.fxcm.messaging.IFieldGroup;
import com.fxcm.messaging.IFieldGroupList;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.IMessageFactory;
import com.fxcm.messaging.ITransportable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MarketDataIncremental
implements ITransportable {
    public static final ICode OBJ_TYPE = new MarketDataIncrementalType();
    private long mMakingTime = System.currentTimeMillis();
    private List mMDEntries;
    private String mMDReqID;

    public MarketDataIncremental() {
        this.reset();
    }

    public void addMDEntry(MarketDataEntryIncremental aMarketDataEntryIncremental) {
        this.mMDEntries.add(aMarketDataEntryIncremental);
    }

    @Override
    public boolean fill(IMessage aMsg) {
        this.reset();
        this.setMDReqID(aMsg.getValueString("262"));
        IFieldGroupList grl = aMsg.getValueList("268");
        if (grl != null) {
            Iterator<IFieldGroup> iterator = grl.values().iterator();
            while (iterator.hasNext()) {
                MarketDataEntryIncremental mde = new MarketDataEntryIncremental();
                IFieldGroup gr = iterator.next();
                if (!mde.fill(gr)) continue;
                this.mMDEntries.add(mde);
            }
        }
        return true;
    }

    @Override
    public long getMakingTime() {
        return this.mMakingTime;
    }

    public MarketDataEntryIncremental[] getMDEntries() {
        return this.mMDEntries.toArray(new MarketDataEntryIncremental[this.mMDEntries.size()]);
    }

    public String getMDReqID() {
        return this.mMDReqID;
    }

    public void setMDReqID(String aMDReqID) {
        this.mMDReqID = aMDReqID;
    }

    @Override
    public String getRequestID() {
        return this.getMDReqID();
    }

    @Override
    public String getTradingSessionID() {
        return null;
    }

    @Override
    public String getTradingSessionSubID() {
        return null;
    }

    @Override
    public ICode getType() {
        return OBJ_TYPE;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public void removeMDEntry(MarketDataEntryIncremental aMarketDataEntryIncremental) {
        this.mMDEntries.remove(aMarketDataEntryIncremental);
    }

    private void reset() {
        this.mMDReqID = null;
        this.mMDEntries = new ArrayList();
    }

    @Override
    public IMessage toMessage(String aSID, IMessageFactory aFactory) {
        return this.toMessage(aSID, null, null, null, 0, aFactory);
    }

    @Override
    public IMessage toMessage(String aSID, String aTradingSessionID, String aTradingSessionSubID, String aRequestID, int aOptions, IMessageFactory aFactory) {
        String mdreqid = aRequestID;
        if (mdreqid == null) {
            mdreqid = this.getMDReqID();
        }
        IMessage ret = null;
        try {
            ret = aFactory.createMessage(aSID, "X");
            ret.setValue("262", mdreqid);
            IFieldGroupList grl = aFactory.createFieldGroupList();
            for (int i = 0; i < this.mMDEntries.size(); ++i) {
                MarketDataEntryIncremental mde = (MarketDataEntryIncremental)this.mMDEntries.get(i);
                grl.put(mde.toGroup(aFactory));
            }
            ret.setValue("268", grl);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    @Override
    public boolean update(IMessage aMsg) {
        return this.fill(aMsg);
    }

    private static class MarketDataIncrementalType
    extends ACode {
        MarketDataIncrementalType() {
            super("X", "MarketDataIncrementalType", "");
        }
    }
}

