/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix.pretrade;

import com.fxcm.entity.ACode;
import com.fxcm.entity.ICode;
import com.fxcm.fix.IFixDefs;
import com.fxcm.fix.UTCTimestamp;
import com.fxcm.messaging.IFieldGroup;
import com.fxcm.messaging.IFieldGroupList;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.IMessageFactory;
import com.fxcm.messaging.ITransportable;

public class EMail
implements ITransportable,
IFixDefs {
    public static final ICode OBJ_TYPE = new EMailType();
    private String mEmailThreadID;
    private String mFrom;
    private UTCTimestamp mOrigTime;
    private String mSubject;
    private String mText;
    private String mTradingSessionID;
    private String mTradingSessionSubID;
    private long mMakingTime = System.currentTimeMillis();

    public EMail() {
        this.reset();
    }

    @Override
    public boolean fill(IMessage aMsg) {
        IFieldGroupList list;
        this.setTradingSessionID(aMsg.getValueString("336"));
        this.setTradingSessionSubID(aMsg.getValueString("625"));
        this.setEmailThreadID(aMsg.getValueString("164"));
        this.setSubject(aMsg.getValueString("147"));
        if (aMsg.getValueString("42") != null) {
            this.setOrigTime(new UTCTimestamp(aMsg.getValueString("42")));
        }
        if ((list = aMsg.getValueList("33")) != null) {
            this.setFrom(this.getTextAtIndex(list, 0));
            this.setText(this.getTextAtIndex(list, 1));
        }
        return this.isValid();
    }

    private String getTextAtIndex(IFieldGroupList aFieldGroupList, int aIndex) {
        IFieldGroup next;
        String text = "";
        if (aFieldGroupList.size() > aIndex && (next = aFieldGroupList.getFields().get(aIndex)) != null) {
            text = next.getValueString("58");
        }
        return text;
    }

    public String getEmailThreadID() {
        return this.mEmailThreadID;
    }

    public void setEmailThreadID(String aThreadID) {
        this.mEmailThreadID = aThreadID;
    }

    public String getFrom() {
        return this.mFrom;
    }

    public void setFrom(String aFrom) {
        this.mFrom = aFrom;
    }

    public UTCTimestamp getOrigTime() {
        return this.mOrigTime;
    }

    public void setOrigTime(UTCTimestamp aOrigTime) {
        this.mOrigTime = aOrigTime;
    }

    @Override
    public String getRequestID() {
        return null;
    }

    public String getSubject() {
        return this.mSubject;
    }

    public void setSubject(String aSubject) {
        this.mSubject = aSubject;
    }

    public String getText() {
        return this.mText;
    }

    public void setText(String aText) {
        this.mText = aText;
    }

    @Override
    public String getTradingSessionID() {
        return this.mTradingSessionID;
    }

    public void setTradingSessionID(String aTradingSessionID) {
        this.mTradingSessionID = aTradingSessionID;
    }

    @Override
    public String getTradingSessionSubID() {
        return this.mTradingSessionSubID;
    }

    public void setTradingSessionSubID(String aTradingSessionSubID) {
        this.mTradingSessionSubID = aTradingSessionSubID;
    }

    @Override
    public ICode getType() {
        return OBJ_TYPE;
    }

    @Override
    public boolean isValid() {
        return this.mEmailThreadID != null && this.mSubject != null && this.mText != null;
    }

    public void reset() {
        this.mFrom = null;
        this.mEmailThreadID = null;
        this.mOrigTime = null;
        this.mSubject = "[N/A]";
        this.mText = null;
        this.mTradingSessionID = null;
        this.mTradingSessionSubID = null;
    }

    @Override
    public IMessage toMessage(String aSID, IMessageFactory aFactory) {
        return this.toMessage(aSID, null, null, null, 0, aFactory);
    }

    @Override
    public IMessage toMessage(String aSID, String aTradingSessionID, String aTradingSessionSubID, String aRequestID, int aOptions, IMessageFactory aFactory) {
        String tssubid;
        String tsid = aTradingSessionID;
        if (tsid == null) {
            tsid = this.getTradingSessionID();
        }
        if ((tssubid = aTradingSessionSubID) == null) {
            tssubid = this.getTradingSessionSubID();
        }
        IMessage ret = aFactory.createMessage(aSID, "C");
        if (tsid != null) {
            ret.setValue("336", tsid);
            ret.setValue("625", tssubid);
        }
        ret.setValue("164", this.mEmailThreadID);
        ret.setValue("94", "0");
        ret.setValue("147", this.mSubject == null || "".equals(this.mSubject.trim()) ? "[N/A]" : this.mSubject);
        if (this.mOrigTime != null) {
            ret.setValue("42", this.mOrigTime.toString());
        }
        IFieldGroupList list = aFactory.createFieldGroupList();
        IFieldGroup group1 = aFactory.createFieldGroup();
        group1.setValue("58", this.getFrom());
        list.put(group1);
        IFieldGroup group2 = aFactory.createFieldGroup();
        group2.setValue("58", this.getText());
        list.put(group2);
        ret.setValue("33", list);
        return ret;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("EMail");
        sb.append("{mEmailThreadID='").append(this.mEmailThreadID).append('\'');
        sb.append(", mFrom='").append(this.mFrom).append('\'');
        sb.append(", mOrigTime=").append(this.mOrigTime);
        sb.append(", mSubject='").append(this.mSubject).append('\'');
        sb.append(", mText='").append(this.mText).append('\'');
        sb.append(", mTradingSessionID='").append(this.mTradingSessionID).append('\'');
        sb.append(", mTradingSessionSubID='").append(this.mTradingSessionSubID).append('\'');
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean update(IMessage aMsg) {
        return this.fill(aMsg);
    }

    @Override
    public long getMakingTime() {
        return this.mMakingTime;
    }

    private static class EMailType
    extends ACode {
        EMailType() {
            super("C", "EMailType", "");
        }
    }
}

