/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix.posttrade;

import com.fxcm.entity.ACode;
import com.fxcm.entity.ICode;
import com.fxcm.fix.IFixDefs;
import com.fxcm.fix.IPosReqResult;
import com.fxcm.fix.IPosReqStatus;
import com.fxcm.fix.Parties;
import com.fxcm.fix.PosReqResultFactory;
import com.fxcm.fix.PosReqStatusFactory;
import com.fxcm.messaging.IFieldGroupList;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.IMessageFactory;
import com.fxcm.messaging.ITransportable;

public class RequestForPositionsAck
implements ITransportable,
IFixDefs {
    public static final ICode OBJ_TYPE = new RequestForPositionsAckType();
    private String mAccount;
    private String mFXCMErrorDetails;
    private int mFXCMRequestRejectReason;
    private Parties mParties;
    private String mPosReqID;
    private IPosReqResult mPosReqResult;
    private IPosReqStatus mPosReqStatus;
    private String mText;
    private int mTotalNumPosReports;
    private String mTradingSessionID;
    private String mTradingSessionSubID;
    private String mPosMaintRptID;
    private long mMakingTime = System.currentTimeMillis();

    public RequestForPositionsAck() {
        this.reset();
    }

    @Override
    public boolean fill(IMessage aMsg) {
        this.reset();
        this.setPosMaintRptID(aMsg.getValueString("721"));
        this.setAccount(aMsg.getValueString("1"));
        this.mParties.fill(aMsg.getValueList("453"));
        this.setPosReqID(aMsg.getValueString("710"));
        this.setPosReqResult(PosReqResultFactory.toCode(aMsg.getValueInt("728")));
        this.setPosReqStatus(PosReqStatusFactory.toCode(aMsg.getValueInt("729")));
        this.setTradingSessionID(aMsg.getValueString("336"));
        this.setTradingSessionSubID(aMsg.getValueString("625"));
        if (PosReqResultFactory.VALID_REQUEST == this.getPosReqResult()) {
            this.setTotalNumPosReports(aMsg.getValueInt("727"));
        } else {
            this.setText(aMsg.getValueString("58"));
            this.setFXCMErrorDetails(aMsg.getValueString("9029"));
            this.setFXCMRequestRejectReason(aMsg.getValueInt("9025"));
        }
        return this.isValid();
    }

    public String getPosMaintRptID() {
        return this.mPosMaintRptID;
    }

    public void setPosMaintRptID(String aPosMaintRptID) {
        this.mPosMaintRptID = aPosMaintRptID;
    }

    public String getAccount() {
        return this.mAccount;
    }

    public void setAccount(String aAccount) {
        this.mAccount = aAccount;
    }

    public String getFXCMErrorDetails() {
        return this.mFXCMErrorDetails;
    }

    public void setFXCMErrorDetails(String aFXCMErrorDetails) {
        this.mFXCMErrorDetails = aFXCMErrorDetails;
    }

    public int getFXCMRequestRejectReason() {
        return this.mFXCMRequestRejectReason;
    }

    public void setFXCMRequestRejectReason(int aFXCMRequestRejectReason) {
        this.mFXCMRequestRejectReason = aFXCMRequestRejectReason;
    }

    public Parties getParties() {
        return this.mParties;
    }

    public String getPosReqID() {
        return this.mPosReqID;
    }

    public void setPosReqID(String aPosReqID) {
        this.mPosReqID = aPosReqID;
    }

    public IPosReqResult getPosReqResult() {
        return this.mPosReqResult;
    }

    public void setPosReqResult(IPosReqResult aPosReqResult) {
        this.mPosReqResult = aPosReqResult;
    }

    public IPosReqStatus getPosReqStatus() {
        return this.mPosReqStatus;
    }

    public void setPosReqStatus(IPosReqStatus aPosReqStatus) {
        this.mPosReqStatus = aPosReqStatus;
    }

    @Override
    public String getRequestID() {
        return this.getPosReqID();
    }

    public String getText() {
        return this.mText;
    }

    public void setText(String aText) {
        this.mText = aText;
    }

    public int getTotalNumPosReports() {
        return this.mTotalNumPosReports;
    }

    public void setTotalNumPosReports(int aTotalNumPosReports) {
        this.mTotalNumPosReports = aTotalNumPosReports;
    }

    @Override
    public String getTradingSessionID() {
        return this.mTradingSessionID;
    }

    public void setTradingSessionID(String aTradingSessionID) {
        this.mTradingSessionID = aTradingSessionID;
    }

    @Override
    public String getTradingSessionSubID() {
        return this.mTradingSessionSubID;
    }

    public void setTradingSessionSubID(String aTradingSessionSubID) {
        this.mTradingSessionSubID = aTradingSessionSubID;
    }

    @Override
    public ICode getType() {
        return OBJ_TYPE;
    }

    @Override
    public boolean isValid() {
        return this.mAccount != null && this.mPosReqResult != null && this.mPosReqStatus != null;
    }

    private void reset() {
        this.mAccount = "all";
        this.mFXCMErrorDetails = null;
        this.mFXCMRequestRejectReason = -1;
        this.mParties = new Parties();
        this.mPosReqResult = null;
        this.mPosReqStatus = null;
        this.mText = null;
        this.mTotalNumPosReports = 0;
        this.mTradingSessionID = null;
        this.mTradingSessionID = null;
        this.mPosMaintRptID = null;
    }

    public void setParties(Parties aParties) {
        this.mParties = aParties;
        if (this.mParties == null) {
            this.mParties = new Parties();
        }
    }

    @Override
    public IMessage toMessage(String aSID, IMessageFactory aFactory) {
        return this.toMessage(aSID, null, null, null, 0, aFactory);
    }

    @Override
    public IMessage toMessage(String aSID, String aTradingSessionID, String aTradingSessionSubID, String aRequestID, int aOptions, IMessageFactory aFactory) {
        IFieldGroupList list;
        String tssubid;
        String tsid;
        String req = aRequestID;
        if (req == null) {
            req = this.getPosReqID();
        }
        if ((tsid = aTradingSessionID) == null) {
            tsid = this.getTradingSessionID();
        }
        if ((tssubid = aTradingSessionSubID) == null) {
            tssubid = this.getTradingSessionSubID();
        }
        IMessage ret = aFactory.createMessage(aSID, "AO");
        ret.setValue("1", this.getAccount());
        ret.setValue("581", 6);
        if (this.mParties != null && (list = this.mParties.toList(aFactory)) != null) {
            ret.setValue("453", list);
        }
        ret.setValue("710", req);
        if (this.getPosReqResult() != null) {
            ret.setValue("728", this.getPosReqResult().getCode());
        }
        if (this.getPosReqStatus() != null) {
            ret.setValue("729", this.getPosReqStatus().getCode());
        }
        if (tsid != null) {
            ret.setValue("336", tsid);
        }
        if (tssubid != null) {
            ret.setValue("625", tssubid);
        }
        if (PosReqResultFactory.VALID_REQUEST == this.getPosReqResult()) {
            ret.setValue("721", this.getPosMaintRptID());
            ret.setValue("727", this.getTotalNumPosReports());
        } else {
            ret.setValue("721", 0);
            ret.setValue("727", 0);
            ret.setValue("58", this.getText());
            if (this.getFXCMRequestRejectReason() >= 0) {
                ret.setValue("9025", this.getFXCMRequestRejectReason());
            }
            if (this.getFXCMErrorDetails() != null) {
                ret.setValue("9029", this.getFXCMErrorDetails());
            }
        }
        return ret;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("RequestForPositionsAck");
        sb.append("{mAccount='").append(this.mAccount).append('\'');
        sb.append(", mFXCMErrorDetails='").append(this.mFXCMErrorDetails).append('\'');
        sb.append(", mFXCMRequestRejectReason=").append(this.mFXCMRequestRejectReason);
        sb.append(", mParties=").append(this.mParties);
        sb.append(", mPosReqID='").append(this.mPosReqID).append('\'');
        sb.append(", mPosReqResult=").append(this.mPosReqResult);
        sb.append(", mPosReqStatus=").append(this.mPosReqStatus);
        sb.append(", mText='").append(this.mText).append('\'');
        sb.append(", mTotalNumPosReports=").append(this.mTotalNumPosReports);
        sb.append(", mTradingSessionID='").append(this.mTradingSessionID).append('\'');
        sb.append(", mTradingSessionSubID='").append(this.mTradingSessionSubID).append('\'');
        sb.append(", mPosMaintRptID='").append(this.mPosMaintRptID).append('\'');
        sb.append(", mMakingTime=").append(this.mMakingTime);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean update(IMessage aMsg) {
        return this.fill(aMsg);
    }

    @Override
    public long getMakingTime() {
        return this.mMakingTime;
    }

    private static class RequestForPositionsAckType
    extends ACode {
        RequestForPositionsAckType() {
            super("AO", "RequestForPositionsAckType", "");
        }
    }
}

