/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix.posttrade;

import com.fxcm.entity.ACode;
import com.fxcm.entity.ICode;
import com.fxcm.fix.IFixDefs;
import com.fxcm.fix.IPosReqType;
import com.fxcm.fix.ISubscriptionRequestType;
import com.fxcm.fix.Parties;
import com.fxcm.fix.PosReqTypeFactory;
import com.fxcm.fix.SubscriptionRequestTypeFactory;
import com.fxcm.fix.UTCDate;
import com.fxcm.fix.UTCTimeOnly;
import com.fxcm.fix.UTCTimestamp;
import com.fxcm.messaging.IFieldGroup;
import com.fxcm.messaging.IFieldGroupList;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.IMessageFactory;
import com.fxcm.messaging.ITransportable;

public class RequestForPositions
implements ITransportable,
IFixDefs {
    public static final ICode OBJ_TYPE = new RequestForPositionsType();
    private String mAccount;
    private Parties mParties;
    private String mPosReqID;
    private IPosReqType mPosReqType;
    private String mTradingSessionID;
    private String mTradingSessionSubID;
    private UTCTimestamp mTransactTime;
    private String mFXCMPosID;
    private String mOrderID;
    private String mClOrdID;
    private String mSecondaryClOrdID;
    private UTCDate mFXCMEndDate;
    private UTCTimeOnly mFXCMEndTime;
    private UTCDate mFXCMStartDate;
    private UTCTimeOnly mFXCMStartTime;
    private int mFXCMMaxNoResults;
    private ISubscriptionRequestType mSubscriptionRequestType;
    private long mMakingTime = System.currentTimeMillis();

    public RequestForPositions() {
        this.reset();
    }

    @Override
    public boolean fill(IMessage aMsg) {
        IFieldGroup tsGroup;
        this.setAccount(aMsg.getValueString("1"));
        String code = aMsg.getValueString("263");
        this.setSubscriptionRequestType(SubscriptionRequestTypeFactory.toCode(code));
        this.mParties.fill(aMsg.getValueList("453"));
        this.setPosReqID(aMsg.getValueString("710"));
        this.setPosReqType(PosReqTypeFactory.toCode(aMsg.getValueInt("724")));
        IFieldGroupList tsList = aMsg.getValueList("386");
        if (tsList != null && tsList.size() != 0 && (tsGroup = tsList.getFields().get(0)) != null) {
            this.setTradingSessionID(tsGroup.getValueString("336"));
            this.setTradingSessionSubID(tsGroup.getValueString("625"));
        }
        this.setTransactTime(new UTCTimestamp(aMsg.getValueString("60")));
        this.setFXCMPosID(aMsg.getValueString("9041"));
        this.setOrderID(aMsg.getValueString("37"));
        this.setClOrdID(aMsg.getValueString("11"));
        this.setSecondaryClOrdID(aMsg.getValueString("526"));
        this.setFXCMMaxNoResults(aMsg.getValueInt("9060"));
        String startDt = aMsg.getValueString("9012");
        String startTime = aMsg.getValueString("9013");
        String endDt = aMsg.getValueString("9014");
        String endTime = aMsg.getValueString("9015");
        if (startDt != null) {
            if (startTime == null) {
                this.setFXCMStartDate(new UTCDate(startDt));
            } else {
                this.setFXCMStartDate(new UTCDate(new UTCTimestamp(startDt + "-" + startTime)));
            }
        }
        if (startTime != null) {
            this.setFXCMStartTime(new UTCTimeOnly(startTime));
        }
        if (endDt == null) {
            this.setFXCMEndDate(new UTCDate(new UTCTimestamp()));
        } else if (endTime == null) {
            this.setFXCMEndDate(new UTCDate(endDt));
        } else {
            this.setFXCMEndDate(new UTCDate(new UTCTimestamp(endDt + "-" + endTime)));
        }
        if (endTime != null) {
            this.setFXCMEndTime(new UTCTimeOnly(endTime));
        }
        return this.isValid();
    }

    public void setFXCMPosID(String aFxcmPosID) {
        this.mFXCMPosID = aFxcmPosID;
    }

    public String getFXCMPosID() {
        return this.mFXCMPosID;
    }

    public void setOrderID(String aOrderID) {
        this.mOrderID = aOrderID;
    }

    public String getOrderID() {
        return this.mOrderID;
    }

    public String getClOrdID() {
        return this.mClOrdID;
    }

    public void setClOrdID(String aClOrdID) {
        this.mClOrdID = aClOrdID;
    }

    public String getSecondaryClOrdID() {
        return this.mSecondaryClOrdID;
    }

    public void setSecondaryClOrdID(String aSecondaryClOrdID) {
        this.mSecondaryClOrdID = aSecondaryClOrdID;
    }

    public String getAccount() {
        return this.mAccount;
    }

    public Parties getParties() {
        return this.mParties;
    }

    public String getPosReqID() {
        return this.mPosReqID;
    }

    public IPosReqType getPosReqType() {
        return this.mPosReqType;
    }

    @Override
    public String getRequestID() {
        return this.getPosReqID();
    }

    @Override
    public String getTradingSessionID() {
        return this.mTradingSessionID;
    }

    @Override
    public String getTradingSessionSubID() {
        return this.mTradingSessionSubID;
    }

    public UTCTimestamp getTransactTime() {
        return this.mTransactTime;
    }

    @Override
    public ICode getType() {
        return OBJ_TYPE;
    }

    @Override
    public boolean isValid() {
        return this.mPosReqID != null && this.mAccount != null && this.mTransactTime != null;
    }

    private void reset() {
        this.mAccount = "all";
        this.mParties = new Parties();
        this.mPosReqID = null;
        this.mPosReqType = null;
        this.mTradingSessionID = "FXCM";
        this.mTradingSessionSubID = "";
        if (this.mTransactTime == null) {
            this.mTransactTime = new UTCTimestamp();
        } else {
            this.mTransactTime.setDate(null);
        }
        this.mFXCMPosID = null;
        this.mOrderID = null;
        this.mClOrdID = null;
        this.mSecondaryClOrdID = null;
        this.mFXCMStartDate = null;
        this.mFXCMEndDate = null;
        this.mFXCMStartTime = null;
        this.mFXCMEndTime = null;
        this.mFXCMMaxNoResults = 300;
        this.mSubscriptionRequestType = SubscriptionRequestTypeFactory.SUBSCRIBE;
    }

    public void setAccount(String aAccount) {
        this.mAccount = aAccount;
    }

    public void setParties(Parties aParties) {
        this.mParties = aParties;
        if (this.mParties == null) {
            this.mParties = new Parties();
        }
    }

    public void setPosReqID(String aPosReqID) {
        this.mPosReqID = aPosReqID;
    }

    public void setPosReqType(IPosReqType aPosReqType) {
        this.mPosReqType = aPosReqType;
    }

    public void setTradingSessionID(String aTradingSessionID) {
        this.mTradingSessionID = aTradingSessionID;
    }

    public void setTradingSessionSubID(String aTradingSessionSubID) {
        this.mTradingSessionSubID = aTradingSessionSubID;
    }

    public void setTransactTime(UTCTimestamp aTransactTime) {
        this.mTransactTime = aTransactTime;
    }

    public UTCDate getFXCMEndDate() {
        return this.mFXCMEndDate;
    }

    public ISubscriptionRequestType getSubscriptionRequestType() {
        return this.mSubscriptionRequestType;
    }

    public void setSubscriptionRequestType(ISubscriptionRequestType aSubscriptionRequestType) {
        this.mSubscriptionRequestType = aSubscriptionRequestType == null ? SubscriptionRequestTypeFactory.SUBSCRIBE : aSubscriptionRequestType;
    }

    public void setFXCMEndDate(UTCDate aFXCMEndDate) {
        this.mFXCMEndDate = aFXCMEndDate;
    }

    public UTCTimeOnly getFXCMEndTime() {
        return this.mFXCMEndTime;
    }

    public void setFXCMEndTime(UTCTimeOnly aFXCMEndTime) {
        this.mFXCMEndTime = aFXCMEndTime;
    }

    public UTCDate getFXCMStartDate() {
        return this.mFXCMStartDate;
    }

    public void setFXCMStartDate(UTCDate aFXCMStartDate) {
        this.mFXCMStartDate = aFXCMStartDate;
    }

    public UTCTimeOnly getFXCMStartTime() {
        return this.mFXCMStartTime;
    }

    public void setFXCMStartTime(UTCTimeOnly aFXCMStartTime) {
        this.mFXCMStartTime = aFXCMStartTime;
    }

    public int getFXCMMaxNoResults() {
        return this.mFXCMMaxNoResults;
    }

    public void setFXCMMaxNoResults(int aFXCMMaxNoResults) {
        this.mFXCMMaxNoResults = aFXCMMaxNoResults;
    }

    @Override
    public IMessage toMessage(String aSID, IMessageFactory aFactory) {
        return this.toMessage(aSID, null, null, null, 0, aFactory);
    }

    @Override
    public IMessage toMessage(String aSID, String aTradingSessionID, String aTradingSessionSubID, String aRequestID, int aOptions, IMessageFactory aFactory) {
        IFieldGroupList list;
        String tssubid;
        String tsid;
        String req = aRequestID;
        if (req == null) {
            req = this.getPosReqID();
        }
        if ((tsid = aTradingSessionID) == null) {
            tsid = this.getTradingSessionID();
        }
        if ((tssubid = aTradingSessionSubID) == null) {
            tssubid = this.getTradingSessionSubID();
        }
        IMessage ret = aFactory.createMessage(aSID, "AN");
        ret.setValue("263", this.getSubscriptionRequestType().getCode());
        ret.setValue("1", this.getAccount());
        ret.setValue("581", 6);
        UTCDate today = new UTCDate();
        ret.setValue("715", today.toString());
        if (this.mParties != null && (list = this.mParties.toList(aFactory)) != null) {
            ret.setValue("453", list);
        }
        ret.setValue("710", req);
        if (this.getPosReqType() != null) {
            ret.setValue("724", this.getPosReqType().getCode());
        }
        IFieldGroupList tsList = aFactory.createFieldGroupList();
        IFieldGroup tsGroup = aFactory.createFieldGroup();
        tsGroup.setValue("336", tsid);
        tsGroup.setValue("625", tssubid);
        tsList.put(tsGroup);
        ret.setValue("386", tsList);
        if (this.getTransactTime() != null) {
            ret.setValue("60", this.getTransactTime().toString());
        }
        if (this.getFXCMPosID() != null) {
            ret.setValue("9041", this.getFXCMPosID());
        }
        if (this.getOrderID() != null) {
            ret.setValue("37", this.getOrderID());
        }
        if (this.getClOrdID() != null) {
            ret.setValue("11", this.getClOrdID());
        }
        if (this.getSecondaryClOrdID() != null) {
            ret.setValue("526", this.getSecondaryClOrdID());
        }
        if (this.getFXCMStartDate() != null) {
            ret.setValue("9012", this.getFXCMStartDate().toString());
        }
        if (this.getFXCMStartTime() != null) {
            ret.setValue("9013", this.getFXCMStartTime().toString());
        }
        if (this.getFXCMEndDate() != null) {
            ret.setValue("9014", this.getFXCMEndDate().toString());
        }
        if (this.getFXCMEndTime() != null) {
            ret.setValue("9015", this.getFXCMEndTime().toString());
        }
        ret.setValue("9060", this.getFXCMMaxNoResults());
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RequestForPositions");
        sb.append("{mAccount='").append(this.mAccount).append('\'');
        sb.append(", mParties=").append(this.mParties);
        sb.append(", mPosReqID='").append(this.mPosReqID).append('\'');
        sb.append(", mPosReqType=").append(this.mPosReqType);
        sb.append(", mTradingSessionID='").append(this.mTradingSessionID).append('\'');
        sb.append(", mTradingSessionSubID='").append(this.mTradingSessionSubID).append('\'');
        sb.append(", mTransactTime=").append(this.mTransactTime);
        sb.append(", mFXCMPosID='").append(this.mFXCMPosID).append('\'');
        sb.append(", mOrderID='").append(this.mOrderID).append('\'');
        sb.append(", mClOrdID='").append(this.mClOrdID).append('\'');
        sb.append(", mSecondaryClOrdID='").append(this.mSecondaryClOrdID).append('\'');
        sb.append(", mFXCMEndDate=").append(this.mFXCMEndDate);
        sb.append(", mFXCMEndTime=").append(this.mFXCMEndTime);
        sb.append(", mFXCMStartDate=").append(this.mFXCMStartDate);
        sb.append(", mFXCMStartTime=").append(this.mFXCMStartTime);
        sb.append(", mFXCMMaxNoResults=").append(this.mFXCMMaxNoResults);
        sb.append(", mSubscriptionRequestType=").append(this.mSubscriptionRequestType);
        sb.append(", mMakingTime=").append(this.mMakingTime);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean update(IMessage aMsg) {
        return this.fill(aMsg);
    }

    @Override
    public long getMakingTime() {
        return this.mMakingTime;
    }

    private static class RequestForPositionsType
    extends ACode {
        private static final long serialVersionUID = -5388780967782738518L;

        RequestForPositionsType() {
            super("AN", "RequestForPositionsType", "");
        }
    }
}

