/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix.posttrade;

import com.fxcm.entity.ACode;
import com.fxcm.entity.ICode;
import com.fxcm.fix.ATradeTransportable;
import com.fxcm.fix.IPosReqType;
import com.fxcm.fix.PosReqTypeFactory;
import com.fxcm.fix.PositionQty;
import com.fxcm.fix.UTCDate;
import com.fxcm.fix.UTCTimestamp;
import com.fxcm.messaging.IFieldGroup;
import com.fxcm.messaging.IFieldGroupList;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.IMessageFactory;

public class PositionReport
extends ATradeTransportable {
    public static final ICode OBJ_TYPE = new PositionReportType();
    protected String mCurrency;
    protected double mFXCMPosCommission;
    protected String mFXCMPosID;
    protected double mFXCMPosInterest;
    protected UTCTimestamp mFXCMPosOpenTime;
    protected double mFXCMUsedMargin;
    protected boolean mLastRptRequested;
    protected String mListID;
    protected PositionQty mPositionQty;
    protected String mPosMaintRptID;
    protected String mPosReqID;
    protected String mFXCMPosIDRef;
    protected double mSettlPrice;
    protected int mTotalNumPosReports;
    protected boolean mUnsolicitedIndicator;
    protected IPosReqType mPosReqType;
    protected String mText;

    @Override
    public boolean fill(IMessage aMsg) {
        IFieldGroup grp;
        super.fill(aMsg);
        this.setListID(aMsg.getValueString("66"));
        this.setFXCMPosCommission(aMsg.getValueDouble("9053"));
        this.setFXCMPosID(aMsg.getValueString("9041"));
        this.setFXCMPosInterest(aMsg.getValueDouble("9040"));
        this.setFXCMPosOpenTime(new UTCTimestamp(aMsg.getValueString("9042")));
        this.setFXCMUsedMargin(aMsg.getValueDouble("9038"));
        this.setLastRptRequested("Y".equals(aMsg.getValueString("912")));
        this.setPosMaintRptID(aMsg.getValueString("721"));
        IFieldGroupList lst = aMsg.getValueList("702");
        if (lst != null && lst.size() != 0 && (grp = lst.getFields().get(0)) != null) {
            double d = grp.getValueDouble("704");
            if (d != 0.0) {
                this.mPositionQty.setLongQty(d);
            }
            if ((d = grp.getValueDouble("705")) != 0.0) {
                this.mPositionQty.setShortQty(d);
            }
        }
        this.setPosReqID(aMsg.getValueString("710"));
        this.setSettlPrice(aMsg.getValueDouble("730"));
        this.setTotalNumPosReports(aMsg.getValueInt("727"));
        this.setUnsolicitedIndicator("Y".equals(aMsg.getValueString("325")));
        this.setCurrency(aMsg.getValueString("15"));
        this.setFXCMPosIDRef(aMsg.getValueString("9078"));
        this.setText(aMsg.getValueString("58"));
        this.setPosReqType(PosReqTypeFactory.toCode(aMsg.getValueInt("724")));
        return this.isValid();
    }

    public String getCurrency() {
        return this.mCurrency;
    }

    public void setCurrency(String aCurrency) {
        this.mCurrency = aCurrency;
    }

    public double getFXCMPosCommission() {
        return this.mFXCMPosCommission;
    }

    public void setFXCMPosCommission(double aFXCMPosCommission) {
        this.mFXCMPosCommission = aFXCMPosCommission;
    }

    public String getFXCMPosID() {
        return this.mFXCMPosID;
    }

    public void setFXCMPosID(String aFxcmPosID) {
        this.mFXCMPosID = aFxcmPosID;
    }

    public double getFXCMPosInterest() {
        return this.mFXCMPosInterest;
    }

    public void setFXCMPosInterest(double aFxcmPosInterest) {
        this.mFXCMPosInterest = aFxcmPosInterest;
    }

    public UTCTimestamp getFXCMPosOpenTime() {
        return this.mFXCMPosOpenTime;
    }

    public void setFXCMPosOpenTime(UTCTimestamp aFxcmPosTime) {
        this.mFXCMPosOpenTime = aFxcmPosTime;
    }

    public double getFXCMUsedMargin() {
        return this.mFXCMUsedMargin;
    }

    public void setFXCMUsedMargin(double aFxcmUsedMargin) {
        this.mFXCMUsedMargin = aFxcmUsedMargin;
    }

    public String getListID() {
        return this.mListID;
    }

    public void setListID(String aListID) {
        this.mListID = aListID;
    }

    public PositionQty getPositionQty() {
        return this.mPositionQty;
    }

    public String getPosMaintRptID() {
        return this.mPosMaintRptID;
    }

    public void setPosMaintRptID(String aPosMaintRptID) {
        this.mPosMaintRptID = aPosMaintRptID;
    }

    public String getPosReqID() {
        return this.mPosReqID;
    }

    public void setPosReqID(String aPosReqID) {
        this.mPosReqID = aPosReqID;
    }

    public IPosReqType getPosReqType() {
        return this.mPosReqType;
    }

    public void setPosReqType(IPosReqType aPosReqType) {
        this.mPosReqType = aPosReqType;
    }

    public String getFXCMPosIDRef() {
        return this.mFXCMPosIDRef;
    }

    public void setFXCMPosIDRef(String aFXCMPosIDRef) {
        this.mFXCMPosIDRef = aFXCMPosIDRef;
    }

    @Override
    public String getRequestID() {
        if (this.getPosReqID() != null) {
            return this.getPosReqID();
        }
        return this.getClOrdID();
    }

    public double getSettlPrice() {
        return this.mSettlPrice;
    }

    public void setSettlPrice(double aSettlPrice) {
        this.mSettlPrice = aSettlPrice;
    }

    public String getText() {
        return this.mText;
    }

    public void setText(String aText) {
        this.mText = aText;
    }

    public int getTotalNumPosReports() {
        return this.mTotalNumPosReports;
    }

    public void setTotalNumPosReports(int aTotalNumPosReports) {
        this.mTotalNumPosReports = aTotalNumPosReports;
    }

    @Override
    public ICode getType() {
        return OBJ_TYPE;
    }

    public boolean isLastRptRequested() {
        return this.mLastRptRequested;
    }

    public void setLastRptRequested(boolean aLastRptRequested) {
        this.mLastRptRequested = aLastRptRequested;
    }

    public boolean isUnsolicitedIndicator() {
        return this.mUnsolicitedIndicator;
    }

    public void setUnsolicitedIndicator(boolean aUnsolicitedIndicator) {
        this.mUnsolicitedIndicator = aUnsolicitedIndicator;
    }

    @Override
    public boolean isValid() {
        boolean ret = false;
        if (this.mInstrument != null && this.mSettlPrice != 0.0 && this.mFXCMPosID != null) {
            ret = true;
        }
        return ret;
    }

    @Override
    protected void reset() {
        super.reset();
        this.mFXCMPosCommission = 0.0;
        this.mFXCMPosID = null;
        this.mFXCMPosInterest = 0.0;
        this.mFXCMPosOpenTime = null;
        this.mFXCMUsedMargin = 0.0;
        this.mLastRptRequested = false;
        this.mPosMaintRptID = null;
        this.mPositionQty = new PositionQty();
        this.mPosReqID = null;
        this.mSettlPrice = 0.0;
        this.mTotalNumPosReports = 0;
        this.mUnsolicitedIndicator = false;
        this.mCurrency = null;
        this.mListID = null;
        this.mFXCMPosIDRef = null;
        this.mPosReqType = null;
        this.mText = null;
    }

    public void setPositionQty(PositionQty aPositionQty) {
        this.mPositionQty = aPositionQty;
        if (this.mPositionQty == null) {
            this.mPositionQty = new PositionQty();
        }
    }

    @Override
    public IMessage toMessage(String aSID, String aTradingSessionID, String aTradingSessionSubID, String aRequestID, int aOptions, IMessageFactory aFactory) {
        IMessage ret = super.toMessage(aSID, aTradingSessionID, aTradingSessionSubID, aRequestID, aOptions, aFactory);
        String req = aRequestID;
        if (req == null) {
            req = this.getPosReqID();
        }
        if (req != null) {
            ret.setValue("710", req);
        }
        ret.setValue("66", this.getListID());
        ret.setValue("715", UTCDate.now().toString());
        ret.setValue("9053", this.getFXCMPosCommission());
        ret.setValue("9041", this.getFXCMPosID());
        ret.setValue("9040", this.getFXCMPosInterest());
        if (this.mFXCMPosOpenTime != null) {
            ret.setValue("9042", this.getFXCMPosOpenTime().toString());
        }
        this.toMessageUsedMargin(ret);
        if (!this.isUnsolicitedIndicator()) {
            ret.setValue("912", this.isLastRptRequested() ? "Y" : "N");
        }
        ret.setValue("721", this.getPosMaintRptID());
        IFieldGroupList lst = aFactory.createFieldGroupList();
        IFieldGroup gr = aFactory.createFieldGroup();
        gr.setValue("703", "TQ");
        if (this.mPositionQty.getLongQty() != 0.0) {
            gr.setValue("704", this.mPositionQty.getLongQty());
        }
        if (this.mPositionQty.getShortQty() != 0.0) {
            gr.setValue("705", this.mPositionQty.getShortQty());
        }
        lst.put(gr);
        ret.setValue("702", lst);
        lst = aFactory.createFieldGroupList();
        gr = aFactory.createFieldGroup();
        gr.setValue("707", "CASH");
        gr.setValue("708", 0);
        lst.put(gr);
        ret.setValue("753", lst);
        ret.setValue("730", this.getSettlPrice());
        ret.setValue("727", this.getTotalNumPosReports());
        ret.setValue("325", this.isUnsolicitedIndicator() ? "Y" : "N");
        ret.setValue("728", 0);
        ret.setValue("581", 6);
        ret.setValue("734", 0);
        ret.setValue("731", 1);
        ret.setValue("9078", this.getFXCMPosIDRef());
        if (this.getCurrency() != null) {
            ret.setValue("15", this.getCurrency());
        }
        if (this.mText != null) {
            ret.setValue("58", this.getText());
        }
        if (this.mPosReqType != null) {
            ret.setValue("724", this.getPosReqType().getCode());
        }
        return ret;
    }

    protected void toMessageUsedMargin(IMessage aMsg) {
        aMsg.setValue("9038", this.getFXCMUsedMargin());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PositionReport");
        sb.append(" --- begin superclass toString ");
        sb.append(super.toString());
        sb.append(" --- end superclass toString ");
        sb.append("{mCurrency='").append(this.mCurrency).append('\'');
        sb.append(", mFXCMPosCommission=").append(this.mFXCMPosCommission);
        sb.append(", mFXCMPosID='").append(this.mFXCMPosID).append('\'');
        sb.append(", mFXCMPosIDRef='").append(this.mFXCMPosIDRef).append('\'');
        sb.append(", mFXCMPosInterest=").append(this.mFXCMPosInterest);
        sb.append(", mFXCMPosOpenTime=").append(this.mFXCMPosOpenTime);
        sb.append(", mFXCMUsedMargin=").append(this.mFXCMUsedMargin);
        sb.append(", mLastRptRequested=").append(this.mLastRptRequested);
        sb.append(", mListID='").append(this.mListID).append('\'');
        sb.append(", mPositionQty=").append(this.mPositionQty);
        sb.append(", mPosMaintRptID='").append(this.mPosMaintRptID).append('\'');
        sb.append(", mPosReqID='").append(this.mPosReqID).append('\'');
        sb.append(", mPosReqType=").append(this.mPosReqType);
        sb.append(", mSettlPrice=").append(this.mSettlPrice);
        sb.append(", mText='").append(this.mText).append('\'');
        sb.append(", mTotalNumPosReports=").append(this.mTotalNumPosReports);
        sb.append(", mUnsolicitedIndicator=").append(this.mUnsolicitedIndicator);
        sb.append('}');
        return sb.toString();
    }

    private static class PositionReportType
    extends ACode {
        private static final long serialVersionUID = 2298853124866269815L;

        PositionReportType() {
            super("AP", "PositionReportType", "");
        }
    }
}

