/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix.posttrade;

import com.fxcm.entity.ACode;
import com.fxcm.entity.ICode;
import com.fxcm.fix.IFixDefs;
import com.fxcm.fix.Parties;
import com.fxcm.messaging.IFieldGroupList;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.IMessageFactory;
import com.fxcm.messaging.ITransportable;
import com.fxcm.messaging.util.ThreadSafeNumberFormat;
import java.text.DecimalFormat;

public class CollateralReport
implements ITransportable,
IFixDefs {
    public static final ICode OBJ_TYPE = new CollateralReportType();
    protected final DecimalFormat NUMBER_FORMATTER = new ThreadSafeNumberFormat().getInstance();
    protected String mAccount;
    protected double mCashOutstanding;
    protected String mCollInquiryID;
    protected String mCollRptID;
    protected double mFXCMCashDaily;
    protected String mFXCMMarginCall;
    protected double mFXCMUsedMargin;
    protected double mFXCMUsedMargin3;
    protected boolean mLastRptRequested;
    protected double mStartCash;
    protected double mEndCash;
    protected int mTotNumReports;
    protected String mTradingSessionID;
    protected String mTradingSessionSubID;
    protected Parties mParties;
    protected double mQuantity;
    protected double mMarginRatio;
    private long mMakingTime = System.currentTimeMillis();

    public CollateralReport() {
        this.reset();
    }

    @Override
    public boolean fill(IMessage aMsg) {
        this.reset();
        this.setCollRptID(aMsg.getValueString("908"));
        this.setCollInquiryID(aMsg.getValueString("909"));
        this.setAccount(aMsg.getValueString("1"));
        this.setTotNumReports(aMsg.getValueInt("911"));
        this.setLastRptRequested("Y".equals(aMsg.getValueString("912")));
        this.setCashOutstanding(aMsg.getValueDouble("901"));
        this.setStartCash(aMsg.getValueDouble("921"));
        this.setFXCMUsedMargin(aMsg.getValueDouble("9038"));
        this.setFXCMMarginCall(aMsg.getValueString("9045"));
        this.setFXCMUsedMargin3(aMsg.getValueDouble("9046"));
        this.setFXCMCashDaily(aMsg.getValueDouble("9047"));
        this.setTradingSessionID(aMsg.getValueString("336"));
        this.setTradingSessionSubID(aMsg.getValueString("625"));
        this.mParties.fill(aMsg.getValueList("453"));
        this.setQuantity(aMsg.getValueDouble("53"));
        this.setMarginRatio(aMsg.getValueDouble("898"));
        this.setEndCash(aMsg.getValueDouble("922"));
        return this.isValid();
    }

    public double getMarginRatio() {
        return this.mMarginRatio;
    }

    public void setMarginRatio(double aMarginRatio) {
        this.mMarginRatio = aMarginRatio;
    }

    public Parties getParties() {
        return this.mParties;
    }

    public void setParties(Parties aParties) {
        this.mParties = aParties;
        if (this.mParties == null) {
            this.mParties = new Parties();
        }
    }

    public String getAccount() {
        return this.mAccount;
    }

    public void setAccount(String aAccount) {
        this.mAccount = aAccount;
    }

    public double getCashOutstanding() {
        return this.mCashOutstanding;
    }

    public void setCashOutstanding(double aCashOutstanding) {
        this.mCashOutstanding = aCashOutstanding;
    }

    public String getCollInquiryID() {
        return this.mCollInquiryID;
    }

    public void setCollInquiryID(String aCollInquiryID) {
        this.mCollInquiryID = aCollInquiryID;
    }

    public String getCollRptID() {
        return this.mCollRptID;
    }

    public void setCollRptID(String aCollRptID) {
        this.mCollRptID = aCollRptID;
    }

    public double getEndCash() {
        return this.mEndCash;
    }

    public void setEndCash(double aEndCash) {
        this.mEndCash = aEndCash;
    }

    public double getFXCMCashDaily() {
        return this.mFXCMCashDaily;
    }

    public String getFXCMMarginCall() {
        return this.mFXCMMarginCall;
    }

    public double getFXCMUsedMargin() {
        return this.mFXCMUsedMargin;
    }

    public double getFXCMUsedMargin3() {
        return this.mFXCMUsedMargin3;
    }

    public boolean isLastRptRequested() {
        return this.mLastRptRequested;
    }

    public void setLastRptRequested(boolean aLastRptRequested) {
        this.mLastRptRequested = aLastRptRequested;
    }

    public double getQuantity() {
        return this.mQuantity;
    }

    public void setQuantity(double aQuantity) {
        this.mQuantity = aQuantity;
    }

    @Override
    public String getRequestID() {
        return this.getCollInquiryID();
    }

    public double getStartCash() {
        return this.mStartCash;
    }

    public void setStartCash(double aStartCash) {
        this.mStartCash = aStartCash;
    }

    public int getTotNumReports() {
        return this.mTotNumReports;
    }

    public void setTotNumReports(int aTotNumReports) {
        this.mTotNumReports = aTotNumReports;
    }

    @Override
    public String getTradingSessionID() {
        return this.mTradingSessionID;
    }

    @Override
    public String getTradingSessionSubID() {
        return this.mTradingSessionSubID;
    }

    @Override
    public ICode getType() {
        return OBJ_TYPE;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public void reset() {
        this.mCollRptID = null;
        this.mCollInquiryID = null;
        this.mAccount = null;
        this.mTotNumReports = 0;
        this.mLastRptRequested = false;
        this.mCashOutstanding = 0.0;
        this.mStartCash = 0.0;
        this.mFXCMMarginCall = "N";
        this.mFXCMUsedMargin3 = 0.0;
        this.mFXCMUsedMargin = 0.0;
        this.mFXCMCashDaily = 0.0;
        this.mTradingSessionID = "FXCM";
        this.mTradingSessionSubID = "";
        this.mParties = new Parties();
        this.mQuantity = 0.0;
        this.mMarginRatio = 0.0;
    }

    public void setFXCMCashDaily(double aFxcmCashDaily) {
        this.mFXCMCashDaily = aFxcmCashDaily;
    }

    public void setFXCMMarginCall(String aFxcmMarginCall) {
        this.mFXCMMarginCall = aFxcmMarginCall;
    }

    public void setFXCMUsedMargin(double aFxcmUsedMargin) {
        this.mFXCMUsedMargin = aFxcmUsedMargin;
    }

    public void setFXCMUsedMargin3(double aFxcmUsedMargin3) {
        this.mFXCMUsedMargin3 = aFxcmUsedMargin3;
    }

    public void setTradingSessionID(String aTradingSessionID) {
        this.mTradingSessionID = aTradingSessionID != null ? aTradingSessionID : "FXCM";
    }

    public void setTradingSessionSubID(String aTradingSessionSubID) {
        this.mTradingSessionSubID = aTradingSessionSubID != null ? aTradingSessionSubID : "";
    }

    @Override
    public IMessage toMessage(String aSID, IMessageFactory aFactory) {
        return this.toMessage(aSID, null, null, null, 0, aFactory);
    }

    @Override
    public IMessage toMessage(String aSID, String aTradingSessionID, String aTradingSessionSubID, String aRequestID, int aOptions, IMessageFactory aFactory) {
        IFieldGroupList list;
        String tssubid;
        String tsid;
        String req = aRequestID;
        if (req == null) {
            req = this.getCollInquiryID();
        }
        if ((tsid = aTradingSessionID) == null) {
            tsid = this.getTradingSessionID();
        }
        if ((tssubid = aTradingSessionSubID) == null) {
            tssubid = this.getTradingSessionSubID();
        }
        IMessage ret = aFactory.createMessage(aSID, "BA");
        ret.setValue("1", this.getAccount());
        ret.setValue("901", this.getCashOutstanding());
        ret.setValue("909", req);
        ret.setValue("908", this.getCollRptID());
        ret.setValue("9047", this.getFXCMCashDaily());
        ret.setValue("9045", this.getFXCMMarginCall());
        ret.setValue("9038", this.getFXCMUsedMargin());
        ret.setValue("9046", this.getFXCMUsedMargin3());
        ret.setValue("912", this.isLastRptRequested() ? "Y" : "N");
        ret.setValue("921", this.getStartCash());
        ret.setValue("911", this.getTotNumReports());
        ret.setValue("336", tsid);
        ret.setValue("625", tssubid);
        if (this.mParties != null && (list = this.mParties.toList(aFactory)) != null) {
            ret.setValue("453", list);
        }
        ret.setValue("910", 0);
        ret.setValue("53", this.getQuantity());
        ret.setValue("898", this.getMarginRatio());
        ret.setValue("922", this.getEndCash());
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CollateralReport");
        sb.append("{mAccount='").append(this.mAccount).append('\'');
        sb.append(", mCashOutstanding=").append(this.NUMBER_FORMATTER.format(this.mCashOutstanding));
        sb.append(", mCollInquiryID='").append(this.mCollInquiryID).append('\'');
        sb.append(", mCollRptID='").append(this.mCollRptID).append('\'');
        sb.append(", mFXCMCashDaily=").append(this.NUMBER_FORMATTER.format(this.mFXCMCashDaily));
        sb.append(", mFXCMMarginCall='").append(this.mFXCMMarginCall).append('\'');
        sb.append(", mFXCMUsedMargin=").append(this.NUMBER_FORMATTER.format(this.mFXCMUsedMargin));
        sb.append(", mFXCMUsedMargin3=").append(this.NUMBER_FORMATTER.format(this.mFXCMUsedMargin3));
        sb.append(", mLastRptRequested=").append(this.mLastRptRequested);
        sb.append(", mStartCash=").append(this.NUMBER_FORMATTER.format(this.mStartCash));
        sb.append(", mTotNumReports=").append(this.mTotNumReports);
        sb.append(", mTradingSessionID='").append(this.mTradingSessionID).append('\'');
        sb.append(", mTradingSessionSubID='").append(this.mTradingSessionSubID).append('\'');
        sb.append(", mParties=").append(this.mParties);
        sb.append(", mMarginRatio=").append(this.NUMBER_FORMATTER.format(this.mMarginRatio));
        sb.append(", mQuantity=").append(this.NUMBER_FORMATTER.format(this.mQuantity));
        sb.append(", mEndCash=").append(this.NUMBER_FORMATTER.format(this.mEndCash));
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean update(IMessage aMsg) {
        return this.fill(aMsg);
    }

    @Override
    public long getMakingTime() {
        return this.mMakingTime;
    }

    private static class CollateralReportType
    extends ACode {
        private static final long serialVersionUID = -2318015412074714801L;

        CollateralReportType() {
            super("BA", "CollateralReportType", "");
        }
    }
}

