/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix.posttrade;

import com.fxcm.entity.ACode;
import com.fxcm.entity.ICode;
import com.fxcm.fix.CollInquiryResultFactory;
import com.fxcm.fix.CollInquiryStatusFactory;
import com.fxcm.fix.ICollInquiryResult;
import com.fxcm.fix.ICollInquiryStatus;
import com.fxcm.fix.IFixDefs;
import com.fxcm.fix.Parties;
import com.fxcm.messaging.IFieldGroupList;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.IMessageFactory;
import com.fxcm.messaging.ITransportable;

public class CollateralInquiryAck
implements ITransportable,
IFixDefs {
    public static final ICode OBJ_TYPE = new CollateralInquiryAckType();
    private String mAccount;
    private String mCollInquiryID;
    private ICollInquiryResult mCollInquiryResult;
    private ICollInquiryStatus mCollInquiryStatus;
    private String mFXCMErrorDetails;
    private int mFXCMRequestRejectReason;
    private Parties mParties;
    private String mText;
    private int mTotNumReports;
    private String mTradingSessionID;
    private String mTradingSessionSubID;
    private long mMakingTime = System.currentTimeMillis();

    public CollateralInquiryAck() {
        this.reset();
    }

    @Override
    public boolean fill(IMessage aMsg) {
        this.reset();
        this.setAccount(aMsg.getValueString("1"));
        this.setCollInquiryID(aMsg.getValueString("909"));
        this.setCollInquiryResult(CollInquiryResultFactory.toCode(aMsg.getValueInt("946")));
        this.setCollInquiryStatus(CollInquiryStatusFactory.toCode(aMsg.getValueInt("945")));
        this.mParties.fill(aMsg.getValueList("453"));
        this.setTradingSessionID(aMsg.getValueString("336"));
        this.setTradingSessionSubID(aMsg.getValueString("625"));
        if (CollInquiryResultFactory.SUCCESSFUL == this.getCollInquiryResult()) {
            this.setTotNumReports(aMsg.getValueInt("911"));
        } else {
            this.setText(aMsg.getValueString("58"));
            this.setFXCMErrorDetails(aMsg.getValueString("9029"));
            this.setFXCMRequestRejectReason(aMsg.getValueInt("9025"));
        }
        return this.isValid();
    }

    public String getAccount() {
        return this.mAccount;
    }

    public void setAccount(String aAccount) {
        this.mAccount = aAccount;
    }

    public String getCollInquiryID() {
        return this.mCollInquiryID;
    }

    public void setCollInquiryID(String aCollInquiryID) {
        this.mCollInquiryID = aCollInquiryID;
    }

    public ICollInquiryResult getCollInquiryResult() {
        return this.mCollInquiryResult;
    }

    public void setCollInquiryResult(ICollInquiryResult aCollInquiryResult) {
        this.mCollInquiryResult = aCollInquiryResult;
    }

    public ICollInquiryStatus getCollInquiryStatus() {
        return this.mCollInquiryStatus;
    }

    public void setCollInquiryStatus(ICollInquiryStatus aCollInquiryStatus) {
        this.mCollInquiryStatus = aCollInquiryStatus;
    }

    public String getFXCMErrorDetails() {
        return this.mFXCMErrorDetails;
    }

    public void setFXCMErrorDetails(String aFXCMErrorDetails) {
        this.mFXCMErrorDetails = aFXCMErrorDetails;
    }

    public int getFXCMRequestRejectReason() {
        return this.mFXCMRequestRejectReason;
    }

    public void setFXCMRequestRejectReason(int aFXCMRequestRejectReason) {
        this.mFXCMRequestRejectReason = aFXCMRequestRejectReason;
    }

    public Parties getParties() {
        return this.mParties;
    }

    @Override
    public String getRequestID() {
        return this.getCollInquiryID();
    }

    public String getText() {
        return this.mText;
    }

    public void setText(String aText) {
        this.mText = aText;
    }

    public int getTotNumReports() {
        return this.mTotNumReports;
    }

    public void setTotNumReports(int aTotNumReports) {
        this.mTotNumReports = aTotNumReports;
    }

    @Override
    public String getTradingSessionID() {
        return this.mTradingSessionID;
    }

    public void setTradingSessionID(String aTradingSessionID) {
        this.mTradingSessionID = aTradingSessionID;
    }

    @Override
    public String getTradingSessionSubID() {
        return this.mTradingSessionSubID;
    }

    public void setTradingSessionSubID(String aTradingSessionSubID) {
        this.mTradingSessionSubID = aTradingSessionSubID;
    }

    @Override
    public ICode getType() {
        return OBJ_TYPE;
    }

    @Override
    public boolean isValid() {
        return this.mCollInquiryID != null;
    }

    protected void reset() {
        this.mAccount = null;
        this.mCollInquiryID = null;
        this.mCollInquiryResult = null;
        this.mCollInquiryStatus = null;
        this.mFXCMErrorDetails = null;
        this.mFXCMRequestRejectReason = -1;
        this.mParties = new Parties();
        this.mText = null;
        this.mTotNumReports = 0;
        this.mTradingSessionID = null;
        this.mTradingSessionSubID = null;
    }

    public void setParties(Parties parties) {
        this.mParties = parties;
        if (this.mParties == null) {
            this.mParties = new Parties();
        }
    }

    @Override
    public IMessage toMessage(String aSID, IMessageFactory aFactory) {
        return this.toMessage(aSID, null, null, null, 0, aFactory);
    }

    @Override
    public IMessage toMessage(String aSID, String aTradingSessionID, String aTradingSessionSubID, String aRequestID, int aOptions, IMessageFactory aFactory) {
        IFieldGroupList list;
        String tssubid;
        String tsid;
        String req = aRequestID;
        if (req == null) {
            req = this.getCollInquiryID();
        }
        if ((tsid = aTradingSessionID) == null) {
            tsid = this.getTradingSessionID();
        }
        if ((tssubid = aTradingSessionSubID) == null) {
            tssubid = this.getTradingSessionSubID();
        }
        IMessage ret = aFactory.createMessage(aSID, "BG");
        ret.setValue("1", this.getAccount());
        ret.setValue("909", req);
        if (this.getCollInquiryResult() != null) {
            ret.setValue("946", this.getCollInquiryResult().getCode());
        }
        if (this.getCollInquiryStatus() != null) {
            ret.setValue("945", this.getCollInquiryStatus().getCode());
        }
        if (this.mParties != null && (list = this.mParties.toList(aFactory)) != null) {
            ret.setValue("453", list);
        }
        ret.setValue("336", tsid);
        ret.setValue("625", tssubid);
        if (CollInquiryResultFactory.SUCCESSFUL == this.getCollInquiryResult()) {
            ret.setValue("911", this.getTotNumReports());
        } else {
            ret.setValue("911", 0);
            ret.setValue("58", this.getText());
            if (this.getFXCMRequestRejectReason() >= 0) {
                ret.setValue("9025", this.getFXCMRequestRejectReason());
            }
            if (this.getFXCMErrorDetails() != null) {
                ret.setValue("9029", this.getFXCMErrorDetails());
            }
        }
        return ret;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("CollateralInquiryAck");
        buf.append(" mAccount=").append(this.mAccount);
        buf.append(",mCollInquiryID=").append(this.mCollInquiryID);
        buf.append(",mCollInquiryResult=").append(this.mCollInquiryResult);
        buf.append(",mCollInquiryStatus=").append(this.mCollInquiryStatus);
        buf.append(",mFXCMErrorDetails=").append(this.mFXCMErrorDetails);
        buf.append(",mFXCMRequestRejectReason=").append(this.mFXCMRequestRejectReason);
        buf.append(",mParties=").append(this.mParties);
        buf.append(",mText=").append(this.mText);
        buf.append(",mTotNumReports=").append(this.mTotNumReports);
        buf.append(",mTradingSessionID=").append(this.mTradingSessionID);
        buf.append(",mTradingSessionSubID=").append(this.mTradingSessionSubID);
        return buf.toString();
    }

    @Override
    public boolean update(IMessage aMsg) {
        return this.fill(aMsg);
    }

    @Override
    public long getMakingTime() {
        return this.mMakingTime;
    }

    private static class CollateralInquiryAckType
    extends ACode {
        CollateralInquiryAckType() {
            super("BG", "CollateralInquiryAckType", "");
        }
    }
}

