/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix.posttrade;

import com.fxcm.entity.ACode;
import com.fxcm.entity.ICode;
import com.fxcm.fix.IFixDefs;
import com.fxcm.fix.ISubscriptionRequestType;
import com.fxcm.fix.Parties;
import com.fxcm.fix.SubscriptionRequestTypeFactory;
import com.fxcm.messaging.IFieldGroupList;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.IMessageFactory;
import com.fxcm.messaging.ITransportable;

public class CollateralInquiry
implements ITransportable,
IFixDefs {
    public static final ICode OBJ_TYPE = new CollateralInquiryType();
    private String mAccount;
    private String mCollInquiryID;
    private String mTradingSessionID;
    private String mTradingSessionSubID;
    private Parties mParties;
    private ISubscriptionRequestType mSubscriptionRequestType;
    private long mMakingTime = System.currentTimeMillis();

    @Override
    public boolean fill(IMessage aMsg) {
        this.reset();
        String code = aMsg.getValueString("263");
        this.setSubscriptionRequestType(SubscriptionRequestTypeFactory.toCode(code));
        this.setAccount(aMsg.getValueString("1"));
        this.setCollInquiryID(aMsg.getValueString("909"));
        this.setTradingSessionID(aMsg.getValueString("336"));
        this.setTradingSessionSubID(aMsg.getValueString("625"));
        this.mParties.fill(aMsg.getValueList("453"));
        return this.isValid();
    }

    public CollateralInquiry() {
        this.reset();
    }

    public Parties getParties() {
        return this.mParties;
    }

    public void setParties(Parties aParties) {
        this.mParties = aParties;
        if (this.mParties == null) {
            this.mParties = new Parties();
        }
    }

    public String getAccount() {
        return this.mAccount;
    }

    public void setAccount(String aAccount) {
        this.mAccount = aAccount;
    }

    public String getCollInquiryID() {
        return this.mCollInquiryID;
    }

    public void setCollInquiryID(String aCollInquiryID) {
        this.mCollInquiryID = aCollInquiryID;
    }

    @Override
    public String getRequestID() {
        return this.getCollInquiryID();
    }

    public ISubscriptionRequestType getSubscriptionRequestType() {
        return this.mSubscriptionRequestType;
    }

    public void setSubscriptionRequestType(ISubscriptionRequestType aSubscriptionRequestType) {
        this.mSubscriptionRequestType = aSubscriptionRequestType == null ? SubscriptionRequestTypeFactory.SUBSCRIBE : aSubscriptionRequestType;
    }

    @Override
    public String getTradingSessionID() {
        return this.mTradingSessionID;
    }

    public void setTradingSessionID(String aTradingSessionID) {
        this.mTradingSessionID = aTradingSessionID;
    }

    @Override
    public String getTradingSessionSubID() {
        return this.mTradingSessionSubID;
    }

    public void setTradingSessionSubID(String aTradingSessionSubID) {
        this.mTradingSessionSubID = aTradingSessionSubID;
    }

    @Override
    public ICode getType() {
        return OBJ_TYPE;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    protected void reset() {
        this.mAccount = "all";
        this.mCollInquiryID = null;
        this.mTradingSessionID = "FXCM";
        this.mTradingSessionSubID = "";
        this.mSubscriptionRequestType = SubscriptionRequestTypeFactory.SUBSCRIBE;
        this.mParties = new Parties();
    }

    @Override
    public IMessage toMessage(String aSID, IMessageFactory aFactory) {
        return this.toMessage(aSID, null, null, null, 0, aFactory);
    }

    @Override
    public IMessage toMessage(String aSID, String aTradingSessionID, String aTradingSessionSubID, String aRequestID, int aOptions, IMessageFactory aFactory) {
        IFieldGroupList list;
        String tssubid;
        String tsid;
        String req = aRequestID;
        if (req == null) {
            req = this.getCollInquiryID();
        }
        if ((tsid = aTradingSessionID) == null) {
            tsid = this.getTradingSessionID();
        }
        if ((tssubid = aTradingSessionSubID) == null) {
            tssubid = this.getTradingSessionSubID();
        }
        IMessage ret = aFactory.createMessage(aSID, "BB");
        ret.setValue("263", this.getSubscriptionRequestType().getCode());
        if (this.getAccount() != null) {
            ret.setValue("1", this.getAccount());
        }
        ret.setValue("909", req);
        if (tsid != null) {
            ret.setValue("336", tsid);
            ret.setValue("625", tssubid);
        }
        if (this.mParties != null && (list = this.mParties.toList(aFactory)) != null) {
            ret.setValue("453", list);
        }
        return ret;
    }

    @Override
    public boolean update(IMessage aMsg) {
        return this.fill(aMsg);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("CollateralInquiry ");
        buf.append("mAccount=").append(this.mAccount);
        buf.append(",mCollInquiryID=").append(this.mCollInquiryID);
        buf.append(",mTradingSessionID=").append(this.mTradingSessionID);
        buf.append(",mTradingSessionSubID=").append(this.mTradingSessionSubID);
        buf.append(",mParties=").append(this.mParties);
        return buf.toString();
    }

    @Override
    public long getMakingTime() {
        return this.mMakingTime;
    }

    private static class CollateralInquiryType
    extends ACode {
        CollateralInquiryType() {
            super("BB", "CollateralInquiryType", "");
        }
    }
}

