/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix.posttrade;

import com.fxcm.fix.UTCTimestamp;
import com.fxcm.fix.posttrade.PositionReport;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.IMessageFactory;

public class ClosedPositionReport
extends PositionReport {
    protected String mFXCMCloseClOrdID;
    protected String mFXCMCloseOrderID;
    protected String mFXCMCloseSecondaryClOrdID;
    protected double mFXCMCloseSettlPrice;
    protected double mFXCMPosClosePNL;
    protected UTCTimestamp mFXCMPosCloseTime;

    @Override
    public boolean fill(IMessage aMsg) {
        super.fill(aMsg);
        this.setFXCMUsedMargin(0.0);
        this.setFXCMCloseSecondaryClOrdID(aMsg.getValueString("9049"));
        this.setFXCMCloseOrderID(aMsg.getValueString("9054"));
        this.setFXCMCloseClOrdID(aMsg.getValueString("9048"));
        this.setFXCMCloseSettlPrice(aMsg.getValueDouble("9043"));
        this.setFXCMPosCloseTime(new UTCTimestamp(aMsg.getValueString("9044")));
        this.setFXCMPosClosePNL(aMsg.getValueDouble("9052"));
        return this.isValid();
    }

    public String getFXCMCloseClOrdID() {
        return this.mFXCMCloseClOrdID;
    }

    public String getFXCMCloseOrderID() {
        return this.mFXCMCloseOrderID;
    }

    public String getFXCMCloseSecondaryClOrdID() {
        return this.mFXCMCloseSecondaryClOrdID;
    }

    public double getFXCMCloseSettlPrice() {
        return this.mFXCMCloseSettlPrice;
    }

    public double getFXCMPosClosePNL() {
        return this.mFXCMPosClosePNL;
    }

    public UTCTimestamp getFXCMPosCloseTime() {
        return this.mFXCMPosCloseTime;
    }

    @Override
    public boolean isValid() {
        boolean ret = super.isValid();
        return ret && this.mFXCMCloseSettlPrice != 0.0;
    }

    @Override
    public void reset() {
        super.reset();
        this.mFXCMCloseClOrdID = null;
        this.mFXCMCloseOrderID = null;
        this.mFXCMCloseSecondaryClOrdID = null;
        this.mFXCMCloseSettlPrice = 0.0;
        this.mFXCMPosClosePNL = 0.0;
        this.mFXCMPosCloseTime = null;
    }

    public void setFXCMCloseClOrdID(String aFxcmCloseClOrdID) {
        this.mFXCMCloseClOrdID = aFxcmCloseClOrdID;
    }

    public void setFXCMCloseOrderID(String aFxcmCloseOrderID) {
        this.mFXCMCloseOrderID = aFxcmCloseOrderID;
    }

    public void setFXCMCloseSecondaryClOrdID(String aFxcmCloseSecondaryClOrdID) {
        this.mFXCMCloseSecondaryClOrdID = aFxcmCloseSecondaryClOrdID;
    }

    public void setFXCMCloseSettlPrice(double aFxcmCloseSettlPrice) {
        this.mFXCMCloseSettlPrice = aFxcmCloseSettlPrice;
    }

    public void setFXCMPosClosePNL(double aFxcmPosClosePNL) {
        this.mFXCMPosClosePNL = aFxcmPosClosePNL;
    }

    public void setFXCMPosCloseTime(UTCTimestamp aFxcmPosCloseTime) {
        this.mFXCMPosCloseTime = aFxcmPosCloseTime;
    }

    @Override
    protected void toMessageUsedMargin(IMessage aMsg) {
    }

    @Override
    public IMessage toMessage(String aSID, String aTradingSessionID, String aTradingSessionSubID, String aRequestID, int aOptions, IMessageFactory aFactory) {
        IMessage ret = super.toMessage(aSID, aTradingSessionID, aTradingSessionSubID, aRequestID, aOptions, aFactory);
        if (ret != null) {
            ret.setValue("9049", this.getFXCMCloseSecondaryClOrdID());
            ret.setValue("9054", this.getFXCMCloseOrderID());
            ret.setValue("9048", this.getFXCMCloseClOrdID());
            ret.setValue("9043", this.getFXCMCloseSettlPrice());
            ret.setValue("9044", this.getFXCMPosCloseTime().toString());
            ret.setValue("9052", this.getFXCMPosClosePNL());
        }
        return ret;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ClosedPositionReport");
        sb.append(" --- begin superclass toString ");
        sb.append(super.toString());
        sb.append(" --- end superclass toString ");
        sb.append("{mFXCMCloseClOrdID='").append(this.mFXCMCloseClOrdID).append('\'');
        sb.append(", mFXCMCloseOrderID='").append(this.mFXCMCloseOrderID).append('\'');
        sb.append(", mFXCMCloseSecondaryClOrdID='").append(this.mFXCMCloseSecondaryClOrdID).append('\'');
        sb.append(", mFXCMCloseSettlPrice=").append(this.mFXCMCloseSettlPrice);
        sb.append(", mFXCMPosClosePNL=").append(this.format(this.mFXCMPosClosePNL));
        sb.append(", mFXCMPosCloseTime=").append(this.mFXCMPosCloseTime);
        sb.append('}');
        return sb.toString();
    }
}

