/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix.other;

import com.fxcm.entity.ACode;
import com.fxcm.entity.ICode;
import com.fxcm.fix.IFixDefs;
import com.fxcm.fix.other.UserRequest;
import com.fxcm.messaging.IFieldGroup;
import com.fxcm.messaging.IFieldGroupList;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.IMessageFactory;
import com.fxcm.messaging.ITransportable;
import com.fxcm.messaging.TradingSessionDesc;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class UserResponse
implements ITransportable,
IFixDefs {
    public static final ICode OBJ_TYPE = new UserResponseType();
    protected String mUserRequestID;
    protected int mUserStatus;
    protected String mUsername;
    protected String mUserStatusText;
    protected int mUserRequestType;
    protected Map<String, String> mParams;
    protected TradingSessionDesc[] mTradingSessionDescs;
    protected String mFXCMErrorDetails;
    protected int mFXCMRequestRejectReason;
    private long mMakingTime = System.currentTimeMillis();

    public UserResponse() {
        this.reset();
    }

    public UserResponse(UserRequest aRequest) {
        this.fill(aRequest);
    }

    public void fill(UserRequest aRequest) {
        this.reset();
        this.mUserRequestID = aRequest.getUserRequestID();
        this.mUserRequestType = aRequest.getUserRequestType();
        this.mUsername = aRequest.getUsername();
        this.mParams = new HashMap<String, String>(aRequest.getParamMap());
        this.setTradingSession(aRequest.getTradingSessionID(), aRequest.getTradingSessionSubID());
    }

    public void setTradingSession(String aTradingSessionID, String aTradingSessionSubID) {
        if (aTradingSessionID != null && aTradingSessionSubID != null) {
            if (this.mTradingSessionDescs == null) {
                this.mTradingSessionDescs = new TradingSessionDesc[1];
            }
            this.mTradingSessionDescs[0] = new TradingSessionDesc(aTradingSessionSubID, aTradingSessionID);
        }
    }

    public int getUserRequestType() {
        return this.mUserRequestType;
    }

    public void setUserRequestType(int aUserRequestType) {
        this.mUserRequestType = aUserRequestType;
    }

    @Override
    public ICode getType() {
        return OBJ_TYPE;
    }

    public String getFXCMErrorDetails() {
        return this.mFXCMErrorDetails;
    }

    public void setFXCMErrorDetails(String aFXCMErrorDetails) {
        this.mFXCMErrorDetails = aFXCMErrorDetails;
    }

    public int getFXCMRequestRejectReason() {
        return this.mFXCMRequestRejectReason;
    }

    public void setFXCMRequestRejectReason(int aFXCMRequestRejectReason) {
        this.mFXCMRequestRejectReason = aFXCMRequestRejectReason;
    }

    public void setUserRequestID(String aUserRequestID) {
        this.mUserRequestID = aUserRequestID;
    }

    public String getUserRequestID() {
        return this.mUserRequestID;
    }

    public void setUserStatus(int aUserStatus) {
        this.mUserStatus = aUserStatus;
    }

    public int getUserStatus() {
        return this.mUserStatus;
    }

    public void setUsername(String aUsername) {
        this.mUsername = aUsername;
    }

    public String getUsername() {
        return this.mUsername;
    }

    public void setUserStatusText(String aUserStatusText) {
        this.mUserStatusText = aUserStatusText;
        if (this.getUserStatus() == 1 && this.getUserRequestType() == 5) {
            this.mTradingSessionDescs = null;
            this.fillTradingSessions();
        }
    }

    public String getUserStatusText() {
        return this.mUserStatusText;
    }

    public Hashtable getParams() {
        return new Hashtable<String, String>(this.mParams);
    }

    public void setParams(Hashtable aParams) {
        this.mParams = aParams == null ? new HashMap<String, String>() : new HashMap<String, String>(aParams);
    }

    public Map<String, String> getParamMap() {
        if (this.mParams == null) {
            this.mParams = new HashMap<String, String>();
        }
        return this.mParams;
    }

    public void setParam(String aName, String aValue) {
        if (aName != null) {
            if (this.mParams == null) {
                this.mParams = new HashMap<String, String>();
            }
            this.mParams.put(aName, aValue == null ? "" : aValue);
        }
    }

    public String getParam(String aName) {
        String ret = null;
        if (this.mParams != null && aName != null) {
            ret = this.mParams.get(aName);
        }
        return ret;
    }

    @Override
    public IMessage toMessage(String aSID, IMessageFactory aFactory) {
        return this.toMessage(aSID, null, null, null, 0, aFactory);
    }

    @Override
    public IMessage toMessage(String aSID, String aTradingSessionID, String aTradingSessionSubID, String aRequestID, int aOptions, IMessageFactory aFactory) {
        IFieldGroup group;
        IFieldGroupList list;
        String req = aRequestID;
        if (req == null) {
            req = this.getUserRequestID();
        }
        IMessage ret = aFactory.createMessage(aSID, "BF");
        ret.setValue("923", req);
        ret.setValue("926", this.getUserStatus());
        ret.setValue("553", this.getUsername());
        ret.setValue("924", this.getUserRequestType());
        switch (this.getUserStatus()) {
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                String text = this.getUserStatusText();
                if (text == null && this.getFXCMRequestRejectReason() != -1) {
                    text = String.valueOf(this.getFXCMRequestRejectReason());
                }
                if (text != null) {
                    ret.setValue("927", text);
                }
                if (this.getFXCMRequestRejectReason() >= 0) {
                    ret.setValue("9025", this.getFXCMRequestRejectReason());
                }
                if (this.getFXCMErrorDetails() == null) break;
                ret.setValue("9029", this.getFXCMErrorDetails());
                break;
            }
            default: {
                if (this.getUserRequestType() == 5) {
                    if (this.mTradingSessionDescs == null) {
                        this.fillTradingSessions();
                        break;
                    }
                    Object statusText = "0\n";
                    TradingSessionDesc[] tradingSessionDescArray = this.mTradingSessionDescs;
                    int n = tradingSessionDescArray.length;
                    for (int i = 0; i < n; ++i) {
                        TradingSessionDesc tradingSessionDesc = tradingSessionDescArray[i];
                        statusText = (String)statusText + tradingSessionDesc.getSubID() + ";" + tradingSessionDesc.getID() + ";" + tradingSessionDesc.getName() + ";" + tradingSessionDesc.getDesc() + "\n";
                    }
                    ret.setValue("927", (String)statusText);
                    break;
                }
                if (this.getUserStatusText() == null) break;
                ret.setValue("927", this.getUserStatusText());
            }
        }
        if (this.mTradingSessionDescs != null) {
            list = aFactory.createFieldGroupList();
            for (TradingSessionDesc tradingSessionDesc : this.mTradingSessionDescs) {
                group = aFactory.createFieldGroup();
                group.setValue("336", tradingSessionDesc.getID());
                group.setValue("625", tradingSessionDesc.getSubID());
                group.setValue("9018", tradingSessionDesc.getParamLine());
                list.put(group);
            }
            ret.setValue("386", list);
        }
        if (this.mParams != null && !this.mParams.isEmpty()) {
            list = aFactory.createFieldGroupList();
            for (Map.Entry entry : this.mParams.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (value == null) continue;
                group = aFactory.createFieldGroup();
                group.setValue("9017", key);
                group.setValue("9018", value);
                list.put(group);
            }
            ret.setValue("9016", list);
        }
        return ret;
    }

    public void reset() {
        this.setUserRequestID(null);
        this.setUserStatus(0);
        this.setUsername(null);
        this.setUserStatusText(null);
        this.mParams = null;
        this.mTradingSessionDescs = null;
        this.mFXCMErrorDetails = null;
        this.mFXCMRequestRejectReason = -1;
    }

    @Override
    public boolean fill(IMessage aMsg) {
        this.reset();
        if (aMsg != null) {
            this.setUserRequestID(aMsg.getValueString("923"));
            this.setUserStatus(aMsg.getValueInt("926"));
            this.setUsername(aMsg.getValueString("553"));
            this.setUserStatusText(aMsg.getValueString("927"));
            this.setUserRequestType(aMsg.getValueInt("924"));
            switch (this.getUserStatus()) {
                case 2: 
                case 3: 
                case 4: 
                case 6: {
                    this.setFXCMErrorDetails(aMsg.getValueString("9029"));
                    this.setFXCMRequestRejectReason(aMsg.getValueInt("9025"));
                    this.fillTradingSessions(aMsg.getValueList("386"));
                    break;
                }
                default: {
                    if (this.fillTradingSessions(aMsg.getValueList("386")) || this.getUserRequestType() != 5) break;
                    this.fillTradingSessions();
                }
            }
            IFieldGroupList list = aMsg.getValueList("9016");
            if (list != null) {
                for (IFieldGroup group : list.values()) {
                    String key = group.getValueString("9017");
                    String value = group.getValueString("9018");
                    this.setParam(key, value);
                }
            }
            if (aMsg.getSessionID() != null) {
                this.setParam("SID", aMsg.getSessionID());
            }
        }
        return this.isValid();
    }

    @Override
    public boolean update(IMessage aMsg) {
        return this.fill(aMsg);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public boolean equals(Object aObject) {
        if (this == aObject) {
            return true;
        }
        if (aObject == null || this.getClass() != aObject.getClass()) {
            return false;
        }
        UserResponse userResponse = (UserResponse)aObject;
        if (this.mUserStatus != userResponse.mUserStatus) {
            return false;
        }
        if (this.mUserRequestID != null ? !this.mUserRequestID.equals(userResponse.mUserRequestID) : userResponse.mUserRequestID != null) {
            return false;
        }
        if (this.mUserStatusText != null ? !this.mUserStatusText.equals(userResponse.mUserStatusText) : userResponse.mUserStatusText != null) {
            return false;
        }
        return !(this.mUsername != null ? !this.mUsername.equals(userResponse.mUsername) : userResponse.mUsername != null);
    }

    public int hashCode() {
        return 0;
    }

    @Override
    public String getRequestID() {
        return this.getUserRequestID();
    }

    @Override
    public String getTradingSessionID() {
        String ret = null;
        if (this.mTradingSessionDescs != null && this.mTradingSessionDescs.length > 0) {
            ret = this.mTradingSessionDescs[0].getID();
        }
        return ret;
    }

    @Override
    public String getTradingSessionSubID() {
        String ret = null;
        if (this.mTradingSessionDescs != null && this.mTradingSessionDescs.length > 0) {
            ret = this.mTradingSessionDescs[0].getSubID();
        }
        return ret;
    }

    public TradingSessionDesc[] getTradingSessions() {
        if (this.mTradingSessionDescs == null) {
            this.fillTradingSessions();
        }
        return this.mTradingSessionDescs;
    }

    private boolean fillTradingSessions(IFieldGroupList aFieldGroupList) {
        if (this.mTradingSessionDescs == null && aFieldGroupList != null) {
            for (IFieldGroup group : aFieldGroupList.values()) {
                if (this.mTradingSessionDescs == null) {
                    this.mTradingSessionDescs = new TradingSessionDesc[1];
                } else {
                    TradingSessionDesc[] tsds = this.mTradingSessionDescs;
                    this.mTradingSessionDescs = new TradingSessionDesc[tsds.length + 1];
                    System.arraycopy(tsds, 0, this.mTradingSessionDescs, 0, tsds.length);
                }
                String id = group.getValueString("336");
                String subid = group.getValueString("625");
                String params = group.getValueString("9018");
                if (params == null) {
                    params = "";
                }
                this.mTradingSessionDescs[this.mTradingSessionDescs.length - 1] = new TradingSessionDesc(subid + ";" + id + ";" + params);
            }
        }
        return this.mTradingSessionDescs != null;
    }

    private void fillTradingSessions() {
        String userText;
        this.mTradingSessionDescs = null;
        if (this.getUserStatus() == 1 && (userText = this.getUserStatusText()) != null && userText.length() > 2 && userText.startsWith("0\n")) {
            Vector<TradingSessionDesc> v = new Vector<TradingSessionDesc>();
            StringTokenizer st = new StringTokenizer(userText, "\n");
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                if (s.length() <= 1) continue;
                v.add(new TradingSessionDesc(s));
            }
            if (!v.isEmpty()) {
                this.mTradingSessionDescs = new TradingSessionDesc[v.size()];
                for (int i = 0; i < v.size(); ++i) {
                    this.mTradingSessionDescs[i] = (TradingSessionDesc)v.get(i);
                }
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("UserResponse");
        sb.append("{mUserRequestID='").append(this.mUserRequestID).append('\'');
        sb.append(", mUserRequestType=").append(this.mUserRequestType);
        sb.append(", mUserStatus=").append(this.mUserStatus);
        sb.append(", mUsername='").append(this.mUsername).append('\'');
        sb.append(", mUserStatusText='").append(this.mUserStatusText).append('\'');
        sb.append(", mParams=").append(this.mParams);
        sb.append(", mTradingSessionDescs=").append(this.mTradingSessionDescs == null ? "null" : Arrays.asList(this.mTradingSessionDescs).toString());
        sb.append(", mFXCMErrorDetails='").append(this.mFXCMErrorDetails).append('\'');
        sb.append(", mFXCMRequestRejectReason=").append(this.mFXCMRequestRejectReason);
        sb.append('}');
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fill(Throwable aThrowable) {
        this.setUserStatus(2);
        this.setFXCMRequestRejectReason(4);
        if (aThrowable.getMessage() == null) {
            this.setUserStatusText("Null pointer exception");
        } else {
            this.setUserStatusText(aThrowable.getMessage());
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        try {
            sw.getBuffer().setLength(0);
            aThrowable.printStackTrace(pw);
            this.setFXCMErrorDetails(sw.toString());
        }
        finally {
            try {
                pw.close();
            }
            catch (Exception exception) {}
            try {
                sw.close();
            }
            catch (Exception exception) {}
        }
        return true;
    }

    @Override
    public long getMakingTime() {
        return this.mMakingTime;
    }

    private static class UserResponseType
    extends ACode {
        private static final long serialVersionUID = -1053377328498307361L;

        UserResponseType() {
            super("BF", "UserResponseType", "");
        }
    }
}

