/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix.other;

import com.fxcm.entity.ACode;
import com.fxcm.entity.ICode;
import com.fxcm.fix.IFixDefs;
import com.fxcm.messaging.IFieldGroup;
import com.fxcm.messaging.IFieldGroupList;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.IMessageFactory;
import com.fxcm.messaging.ITransportable;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class UserRequest
implements ITransportable,
IFixDefs {
    public static final ICode OBJ_TYPE = new UserRequestType();
    protected String mUserRequestID;
    protected int mUserRequestType;
    protected String mUsername;
    protected String mPassword;
    protected String mOpenToken;
    protected String mNewPassword;
    protected String mEncryptedNewPassword;
    protected Map<String, String> mParams;
    protected String mTradingSessionID;
    protected String mTradingSessionSubID;
    private long mMakingTime = System.currentTimeMillis();

    public UserRequest() {
        this.reset();
    }

    @Override
    public ICode getType() {
        return OBJ_TYPE;
    }

    public void setTradingSessionID(String aTradingSessionID) {
        this.mTradingSessionID = aTradingSessionID;
    }

    @Override
    public String getTradingSessionID() {
        return this.mTradingSessionID;
    }

    public void setTradingSessionSubID(String aTradingSessionSubID) {
        this.mTradingSessionSubID = aTradingSessionSubID;
    }

    @Override
    public String getTradingSessionSubID() {
        return this.mTradingSessionSubID;
    }

    public void setUserRequestID(String aUserRequestID) {
        this.mUserRequestID = aUserRequestID;
    }

    public String getUserRequestID() {
        return this.mUserRequestID;
    }

    public void setUserRequestType(int aUserRequestType) {
        this.mUserRequestType = aUserRequestType;
    }

    public int getUserRequestType() {
        return this.mUserRequestType;
    }

    public void setUsername(String aUsername) {
        this.mUsername = aUsername;
    }

    public String getUsername() {
        return this.mUsername;
    }

    public void setPassword(String aPassword) {
        this.mPassword = aPassword;
    }

    public String getPassword() {
        return this.mPassword;
    }

    public void setOpenToken(String aOpenToken) {
        this.mOpenToken = aOpenToken;
    }

    public String getOpenToken() {
        return this.mOpenToken;
    }

    public void setNewPassword(String aNewPassword) {
        this.mNewPassword = aNewPassword;
    }

    public String getNewPassword() {
        return this.mNewPassword;
    }

    public void setEncryptedNewPassword(String aEncryptedNewPassword) {
        this.mEncryptedNewPassword = aEncryptedNewPassword;
    }

    public String getEncryptedNewPassword() {
        return this.mEncryptedNewPassword;
    }

    public Hashtable getParams() {
        return new Hashtable<String, String>(this.mParams);
    }

    public Map<String, String> getParamMap() {
        if (this.mParams == null) {
            this.mParams = new HashMap<String, String>();
        }
        return this.mParams;
    }

    public void setParams(Hashtable aParams) {
        this.mParams = aParams == null ? new HashMap<String, String>() : new HashMap<String, String>(aParams);
    }

    public void setParam(String aName, String aValue) {
        if (aName != null) {
            if (this.mParams == null) {
                this.mParams = new HashMap<String, String>();
            }
            this.mParams.put(aName, aValue == null ? "" : aValue);
        }
    }

    public String getParam(String aName) {
        String ret = null;
        if (this.mParams != null && aName != null) {
            ret = this.mParams.get(aName);
        }
        return ret;
    }

    @Override
    public IMessage toMessage(String aSID, IMessageFactory aFactory) {
        return this.toMessage(aSID, null, null, null, 0, aFactory);
    }

    @Override
    public IMessage toMessage(String aSID, String aTradingSessionID, String aTradingSessionSubID, String aRequestID, int aOptions, IMessageFactory aFactory) {
        String tssubid;
        String tsid;
        String req = aRequestID;
        if (req == null) {
            req = this.getUserRequestID();
        }
        if ((tsid = aTradingSessionID) == null) {
            tsid = this.getTradingSessionID();
        }
        if ((tssubid = aTradingSessionSubID) == null) {
            tssubid = this.getTradingSessionSubID();
        }
        IMessage ret = aFactory.createMessage(aSID, "BE");
        ret.setValue("336", tsid);
        ret.setValue("625", tssubid);
        ret.setValue("923", req);
        ret.setValue("924", this.getUserRequestType());
        ret.setValue("553", this.getUsername());
        ret.setValue("554", this.getPassword());
        if (this.getNewPassword() != null) {
            ret.setValue("925", this.getNewPassword());
        }
        if (this.getEncryptedNewPassword() != null) {
            ret.setValue("1404", this.getEncryptedNewPassword());
        }
        if (this.getOpenToken() != null) {
            ret.setValue("556", this.getOpenToken());
        }
        if (this.mParams != null && this.mParams.size() > 0) {
            String key = null;
            String value = null;
            IFieldGroupList list = aFactory.createFieldGroupList();
            for (Map.Entry<String, String> en : this.mParams.entrySet()) {
                key = en.getKey();
                value = en.getValue();
                if (value == null) continue;
                IFieldGroup group = aFactory.createFieldGroup();
                group.setValue("9017", key);
                group.setValue("9018", value);
                list.put(group);
            }
            ret.setValue("9016", list);
        }
        return ret;
    }

    public void reset() {
        this.setTradingSessionID(null);
        this.setTradingSessionSubID(null);
        this.setUserRequestID(null);
        this.setUserRequestType(0);
        this.setUsername(null);
        this.setPassword(null);
        this.setNewPassword(null);
        this.setEncryptedNewPassword(null);
        this.setOpenToken(null);
        this.mParams = null;
    }

    @Override
    public boolean fill(IMessage aMsg) {
        this.reset();
        if (aMsg != null) {
            this.setTradingSessionID(aMsg.getValueString("336"));
            this.setTradingSessionSubID(aMsg.getValueString("625"));
            this.setUserRequestID(aMsg.getValueString("923"));
            this.setUserRequestType(aMsg.getValueInt("924"));
            this.setUsername(aMsg.getValueString("553"));
            this.setPassword(aMsg.getValueString("554"));
            this.setNewPassword(aMsg.getValueString("925"));
            this.setEncryptedNewPassword(aMsg.getValueString("1404"));
            this.setOpenToken(aMsg.getValueString("556"));
            IFieldGroupList list = aMsg.getValueList("9016");
            if (list != null) {
                for (IFieldGroup group : list.values()) {
                    String key = group.getValueString("9017");
                    String value = group.getValueString("9018");
                    this.setParam(key, value);
                }
            }
            if (aMsg.getSessionID() != null && this.getUserRequestType() != 1) {
                this.setParam("SID", aMsg.getSessionID());
            }
        }
        return this.isValid();
    }

    @Override
    public boolean update(IMessage aMsg) {
        return this.fill(aMsg);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public String getRequestID() {
        return this.getUserRequestID();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("UserRequest");
        buf.append("{mNewPassword=").append("*******");
        buf.append(",mEncryptedNewPassword=").append("*******");
        buf.append(",mUserRequestID=").append(this.mUserRequestID);
        buf.append(",mUserRequestType=").append(this.mUserRequestType);
        buf.append(",mUsername=").append(this.mUsername);
        buf.append(",mPassword=").append("*******");
        buf.append(",mOpenToken=").append(this.mOpenToken != null ? this.mOpenToken : "null");
        buf.append(",mParams=").append(this.mParams);
        buf.append(",mTradingSessionID=").append(this.mTradingSessionID);
        buf.append(",mTradingSessionSubID=").append(this.mTradingSessionSubID);
        buf.append('}');
        return buf.toString();
    }

    @Override
    public long getMakingTime() {
        return this.mMakingTime;
    }

    private static class UserRequestType
    extends ACode {
        private static final long serialVersionUID = 2846939840617202543L;

        UserRequestType() {
            super("BE", "UserRequestType", "");
        }
    }
}

