/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix.other;

import com.fxcm.entity.ACode;
import com.fxcm.entity.ICode;
import com.fxcm.fix.BusinessRejectReasonFactory;
import com.fxcm.fix.IBusinessRejectReason;
import com.fxcm.fix.IFixDefs;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.IMessageFactory;
import com.fxcm.messaging.ITransportable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public class BusinessMessageReject
implements ITransportable,
IFixDefs {
    public static final ICode OBJ_TYPE = new BusinessMessageRejectType();
    private String mFXCMErrorDetails;
    private int mFXCMRequestRejectReason;
    private IBusinessRejectReason mBusinessRejectReason;
    private String mBusinessRejectRefID;
    private String mRefMsgType;
    private String mText;
    private String mTradingSessionID;
    private String mTradingSessionSubID;
    private long mMakingTime = System.currentTimeMillis();

    public BusinessMessageReject() {
        this.reset();
    }

    @Override
    public boolean fill(IMessage aMsg) {
        this.reset();
        this.setRefMsgType(aMsg.getValueString("372"));
        this.setBusinessRejectRefID(aMsg.getValueString("379"));
        this.setBusinessRejectReason(BusinessRejectReasonFactory.toCode(aMsg.getValueInt("380")));
        this.setText(aMsg.getValueString("58"));
        this.setFXCMErrorDetails(aMsg.getValueString("9029"));
        this.setFXCMRequestRejectReason(aMsg.getValueInt("9025"));
        this.setTradingSessionID(aMsg.getValueString("336"));
        this.setTradingSessionSubID(aMsg.getValueString("625"));
        return this.isValid();
    }

    public IBusinessRejectReason getBusinessRejectReason() {
        return this.mBusinessRejectReason;
    }

    public String getBusinessRejectRefID() {
        return this.mBusinessRejectRefID;
    }

    public String getFXCMErrorDetails() {
        return this.mFXCMErrorDetails;
    }

    public int getFXCMRequestRejectReason() {
        return this.mFXCMRequestRejectReason;
    }

    public String getRefMsgType() {
        return this.mRefMsgType;
    }

    @Override
    public String getRequestID() {
        return this.getBusinessRejectRefID();
    }

    public String getText() {
        return this.mText;
    }

    @Override
    public String getTradingSessionID() {
        return this.mTradingSessionID;
    }

    @Override
    public String getTradingSessionSubID() {
        return this.mTradingSessionSubID;
    }

    public void setTradingSessionID(String aTradingSessionID) {
        this.mTradingSessionID = aTradingSessionID;
    }

    public void setTradingSessionSubID(String aTradingSessionSubID) {
        this.mTradingSessionSubID = aTradingSessionSubID;
    }

    @Override
    public ICode getType() {
        return OBJ_TYPE;
    }

    @Override
    public boolean isValid() {
        return this.mRefMsgType != null && this.mBusinessRejectReason != null;
    }

    private void reset() {
        this.setBusinessRejectRefID(null);
        this.setBusinessRejectReason(null);
        this.setText(null);
        this.setFXCMRequestRejectReason(-1);
        this.setFXCMErrorDetails(null);
        this.mTradingSessionID = null;
        this.mTradingSessionSubID = null;
    }

    public void setBusinessRejectReason(IBusinessRejectReason aBusinessRejectReason) {
        this.mBusinessRejectReason = aBusinessRejectReason;
    }

    public void setBusinessRejectRefID(String aBusinessRejectRefID) {
        this.mBusinessRejectRefID = aBusinessRejectRefID;
    }

    public void setFXCMErrorDetails(String aFXCMErrorDetails) {
        this.mFXCMErrorDetails = aFXCMErrorDetails;
    }

    public void setFXCMRequestRejectReason(int aFXCMRequestRejectReason) {
        this.mFXCMRequestRejectReason = aFXCMRequestRejectReason;
    }

    public void setRefMsgType(String aRefMsgType) {
        this.mRefMsgType = aRefMsgType;
    }

    public void setText(String aText) {
        this.mText = aText;
    }

    @Override
    public IMessage toMessage(String aSID, IMessageFactory aFactory) {
        return this.toMessage(aSID, null, null, null, 0, aFactory);
    }

    @Override
    public IMessage toMessage(String aSID, String aTradingSessionID, String aTradingSessionSubID, String aRequestID, int aOptions, IMessageFactory aFactory) {
        String tssubid;
        String tsid;
        String req = aRequestID;
        if (req == null) {
            req = this.getBusinessRejectRefID();
        }
        if ((tsid = aTradingSessionID) == null) {
            tsid = this.getTradingSessionID();
        }
        if ((tssubid = aTradingSessionSubID) == null) {
            tssubid = this.getTradingSessionSubID();
        }
        IMessage ret = aFactory.createMessage(aSID, "j");
        if (this.getBusinessRejectReason() != null) {
            ret.setValue("380", this.getBusinessRejectReason().getCode());
        }
        ret.setValue("372", this.getRefMsgType());
        ret.setValue("379", req);
        ret.setValue("58", this.getText());
        if (this.getFXCMRequestRejectReason() >= 0) {
            ret.setValue("9025", this.getFXCMRequestRejectReason());
        }
        if (this.getFXCMErrorDetails() != null) {
            ret.setValue("9029", this.getFXCMErrorDetails());
        }
        if (tsid != null) {
            ret.setValue("336", tsid);
            ret.setValue("625", tssubid);
        }
        return ret;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("BusinessMessageReject");
        buf.append("{mBusinessRejectReason=").append(this.mBusinessRejectReason);
        buf.append(",mFXCMErrorDetails=").append(this.mFXCMErrorDetails);
        buf.append(",mFXCMRequestRejectReason=").append(this.mFXCMRequestRejectReason);
        buf.append(",mBusinessRejectRefID=").append(this.mBusinessRejectRefID);
        buf.append(",mRefMsgType=").append(this.mRefMsgType);
        buf.append(",mText=").append(this.mText);
        buf.append(",mTradingSessionID=").append(this.mTradingSessionID);
        buf.append(",mTradingSessionSubID=").append(this.mTradingSessionSubID);
        buf.append('}');
        return buf.toString();
    }

    @Override
    public boolean update(IMessage aMsg) {
        return this.fill(aMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fill(Throwable aThrowable) {
        this.setBusinessRejectReason(BusinessRejectReasonFactory.OTHER);
        if (aThrowable.getMessage() == null) {
            this.setText("Null pointer exception");
        } else {
            this.setText(aThrowable.getMessage());
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        try {
            sw.getBuffer().setLength(0);
            aThrowable.printStackTrace(pw);
            this.setFXCMErrorDetails(sw.toString());
        }
        finally {
            try {
                pw.close();
                sw.close();
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    @Override
    public long getMakingTime() {
        return this.mMakingTime;
    }

    private static class BusinessMessageRejectType
    extends ACode {
        BusinessMessageRejectType() {
            super("j", "BusinessMessageRejectType", "");
        }
    }
}

