/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix.entity;

import com.fxcm.GenericException;
import com.fxcm.entity.GenericPK;
import com.fxcm.entity.IEntity;
import com.fxcm.entity.IPK;
import com.fxcm.entity.IStatus;
import com.fxcm.fix.FXCMTimingIntervalFactory;
import com.fxcm.fix.IFXCMTimingInterval;
import com.fxcm.fix.Instrument;
import com.fxcm.fix.NotDefinedException;
import com.fxcm.fix.TradingSecurity;
import com.fxcm.fix.UTCDate;
import com.fxcm.fix.UTCTimeOnly;
import com.fxcm.fix.UTCTimestamp;
import com.fxcm.fix.pretrade.inner.MarketDataEntry;
import com.fxcm.messaging.IFieldGroup;
import com.fxcm.messaging.IFieldGroupList;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.IMessageFactory;
import java.io.PrintStream;
import java.text.ParseException;
import java.util.Date;

public class MarketDataSnapshot
extends com.fxcm.fix.pretrade.MarketDataSnapshot
implements IEntity {
    private static final long serialVersionUID = 5855439086243789648L;
    private IPK mPK;
    private long mTouchTime;
    private double mAskLow;
    private double mAskHigh;
    private double mAskOpen;
    private double mAskClose;
    private double mLow;
    private double mHigh;
    private double mBidLow;
    private double mBidHigh;
    private double mBidOpen;
    private double mBidClose;
    private String mBidId;
    private String mBidQuoteCondition;
    private int mBidQuoteType;
    private UTCTimestamp mBidExpireTimeStamp;
    private String mBidOriginator;
    private String mBidCurrency;
    private double mBidEntrySize;
    private String mAskId;
    private String mAskQuoteCondition;
    private int mAskQuoteType;
    private UTCTimestamp mAskExpireTimeStamp;
    private String mAskOriginator;
    private String mAskCurrency;
    private double mAskEntrySize;
    private int mTickVolume;

    public MarketDataSnapshot() {
        this.touch();
    }

    public MarketDataSnapshot(com.fxcm.fix.pretrade.MarketDataSnapshot aMarketDataSnapshot) {
        super(aMarketDataSnapshot);
        this.touch();
    }

    @Override
    protected void copy(com.fxcm.fix.pretrade.MarketDataSnapshot aMarketDataSnapshot) {
        super.copy(aMarketDataSnapshot);
        if (aMarketDataSnapshot instanceof MarketDataSnapshot) {
            this.mPK = ((MarketDataSnapshot)aMarketDataSnapshot).mPK;
        }
    }

    @Override
    public long lastTouch() {
        return this.mTouchTime;
    }

    @Override
    public void touch() {
        this.mTouchTime = System.currentTimeMillis();
    }

    @Override
    public void setTradingSessionID(String aTradingSessionID) {
        super.setTradingSessionID(aTradingSessionID);
        this.mPK = null;
    }

    @Override
    public void setTradingSessionSubID(String aTradingSessionSubID) {
        super.setTradingSessionSubID(aTradingSessionSubID);
        this.mPK = null;
    }

    @Override
    public void setInstrument(Instrument aInstrument) {
        super.setInstrument(aInstrument);
        this.mPK = null;
    }

    @Override
    public void setTime(UTCTimeOnly aTime) {
        super.setTime(aTime);
        this.mPK = null;
    }

    @Override
    public void setDate(UTCDate aDate) {
        super.setDate(aDate);
        this.mPK = null;
    }

    @Override
    public void setFXCMTimingInterval(IFXCMTimingInterval aInterval) {
        super.setFXCMTimingInterval(aInterval);
        this.mPK = null;
    }

    @Override
    public void setAskLow(double aAskLow) {
        this.mAskLow = aAskLow;
    }

    @Override
    public void setAskHigh(double aAskHigh) {
        this.mAskHigh = aAskHigh;
    }

    @Override
    public void setAskOpen(double aAskOpen) {
        this.mAskOpen = aAskOpen;
    }

    @Override
    public void setAskClose(double aAskClose) {
        this.mAskClose = aAskClose;
    }

    @Override
    public void setLow(double aLow) {
        this.mLow = aLow;
    }

    @Override
    public void setHigh(double aHigh) {
        this.mHigh = aHigh;
    }

    @Override
    public void setBidLow(double aBidLow) {
        this.mBidLow = aBidLow;
    }

    @Override
    public void setBidHigh(double aBidHigh) {
        this.mBidHigh = aBidHigh;
    }

    @Override
    public void setBidOpen(double aBidOpen) {
        this.mBidOpen = aBidOpen;
    }

    @Override
    public void setBidClose(double aBidClose) {
        this.mBidClose = aBidClose;
    }

    @Override
    protected double _getAskLow() {
        return this.mAskLow;
    }

    @Override
    protected double _getAskHigh() {
        return this.mAskHigh;
    }

    @Override
    protected double _getAskOpen() {
        return this.mAskOpen;
    }

    @Override
    protected double _getAskClose() {
        return this.mAskClose;
    }

    @Override
    protected double _getLow() {
        return this.mLow;
    }

    @Override
    protected double _getHigh() {
        return this.mHigh;
    }

    @Override
    protected double _getBidLow() {
        return this.mBidLow;
    }

    @Override
    protected double _getBidHigh() {
        return this.mBidHigh;
    }

    @Override
    protected double _getBidOpen() {
        return this.mBidOpen;
    }

    @Override
    protected double _getBidClose() {
        return this.mBidClose;
    }

    @Override
    protected int _getTickVolume() {
        return this.mTickVolume;
    }

    protected void fillEntryTime(IFieldGroup aGroup, String aTradingSessionID, String aTradingSessionSubID) {
        if (this.getDate() != null) {
            aGroup.setValue("272", this.getDate().toString());
        }
        if (FXCMTimingIntervalFactory.TICK.equals(this.getFXCMTimingInterval())) {
            if (this.getTickTime() != null) {
                aGroup.setValue("273", this.getTickTime().toString());
            }
        } else if (this.getTime() != null) {
            aGroup.setValue("273", this.getTime().toString());
        }
        if (aTradingSessionID != null && aTradingSessionID.length() > 0) {
            aGroup.setValue("336", aTradingSessionID);
        }
        if (aTradingSessionSubID != null && aTradingSessionSubID.length() > 0) {
            aGroup.setValue("625", aTradingSessionSubID);
        }
        if (this.getQuoteID() != null) {
            aGroup.setValue("299", this.getQuoteID());
        }
        if (this.getFXCMTimingInterval().equals(FXCMTimingIntervalFactory.TICK)) {
            if (this.getOriginator() != null) {
                aGroup.setValue("282", this.getOriginator());
            }
            aGroup.setValue("276", this.isTradeable() ? "A" : "B");
        }
    }

    @Override
    public IMessage toMessage(String aSID, IMessageFactory aFactory) {
        return this.toMessage(aSID, null, null, null, 7, aFactory);
    }

    @Override
    public IMessage toMessage(String aSID, String aTradingSessionID, String aTradingSessionSubID, String aRequestID, int aMDEntryTypeSet, IMessageFactory aFactory) {
        String tssubid;
        String tsid;
        IMessage ret = null;
        String req = aRequestID;
        if (req == null) {
            req = this.getMDReqID();
        }
        if ((tsid = aTradingSessionID) == null) {
            tsid = this.getTradingSessionID();
        }
        if ((tssubid = aTradingSessionSubID) == null) {
            tssubid = this.getTradingSessionSubID();
        }
        try {
            ret = aFactory.createMessage(aSID, "W");
            if (this.getFXCMMsgID() != null) {
                ret.setValue("9039", this.getFXCMMsgID());
            }
            ret.setValue("55", this.getInstrument().getSymbol());
            ret.setValue("9000", this.getInstrument().getFXCMSymID());
            ret.setValue("9001", this.getInstrument().getFXCMSymPrecision());
            ret.setValue("9002", this.getInstrument().getFXCMSymPointSize());
            int product = this.getInstrument().getProduct();
            if (product >= 1 && product <= 13) {
                ret.setValue("460", product);
            }
            ret.setValue("231", this.getInstrument().getContractMultiplier());
            ret.setValue("228", this.getInstrument().getFactor());
            ret.setValue("461", this.getInstrument().getCFICode());
            ret.setValue("167", this.getInstrument().getSecurityType());
            ret.setValue("9005", this.getInstrument().getFXCMSymSortOrder());
            ret.setValue("9080", this.getInstrument().getFXCMProductID());
            ret.setValue("9090", this.getInstrument().getFXCMCondDistStop());
            ret.setValue("9091", this.getInstrument().getFXCMCondDistLimit());
            ret.setValue("9092", this.getInstrument().getFXCMCondDistEntryStop());
            ret.setValue("9093", this.getInstrument().getFXCMCondDistEntryLimit());
            ret.setValue("9094", this.getInstrument().getFXCMMaxQuantity());
            ret.setValue("9095", this.getInstrument().getFXCMMinQuantity());
            ret.setValue("9096", this.getInstrument().getFXCMTradingStatus());
            ret.setValue("262", req);
            ret.setValue("9072", this.getPriceStream());
            IFieldGroupList grl = aFactory.createFieldGroupList();
            if (this.getFXCMTimingInterval().equals(FXCMTimingIntervalFactory.TICK)) {
                TradingSecurity ts;
                boolean set;
                IFieldGroup gr;
                if (this._getBidClose() != 0.0 && (aMDEntryTypeSet & 1) != 0) {
                    gr = aFactory.createFieldGroup();
                    gr.setValue("278", MarketDataEntry.createEntryID(this.getInstrument().getFXCMSymID(), "0", 0.0, this.getBidOriginator()));
                    gr.setValue("269", "0");
                    gr.setValue("270", this.getInstrument().priceToString(this._getBidClose()));
                    this.fillEntryTime(gr, tsid, tssubid);
                    if (this.getBidQuoteCondition() != null) {
                        gr.setValue("276", this.getBidQuoteCondition());
                    }
                    if (this.getBidQuoteType() != -1) {
                        gr.setValue("537", this.getBidQuoteType());
                    }
                    if (this.getBidExpireTimestamp() != null) {
                        gr.setValue("432", this.getBidExpireTimestamp().toStringDateOnly());
                        gr.setValue("126", this.getBidExpireTimestamp().toString());
                    }
                    if (this.getBidOriginator() != null) {
                        gr.setValue("282", this.getBidOriginator());
                    }
                    if (this.getInstrument() != null && this.getInstrument().getSymbol() != null) {
                        set = false;
                        if (this.getInstrument() instanceof TradingSecurity && !(ts = (TradingSecurity)this.getInstrument()).isForex()) {
                            gr.setValue("15", ts.getCurrency());
                            set = true;
                        }
                        if (!set) {
                            gr.setValue("15", this.getInstrument().getSymbol().substring(0, 3));
                        }
                    }
                    if (this.getBidEntrySize() != -1.0) {
                        gr.setValue("271", this.getBidEntrySize());
                    }
                    grl.put(gr);
                }
                if (this._getAskClose() != 0.0 && (aMDEntryTypeSet & 2) != 0) {
                    gr = aFactory.createFieldGroup();
                    gr.setValue("278", MarketDataEntry.createEntryID(this.getInstrument().getFXCMSymID(), "1", 0.0, this.getAskOriginator()));
                    gr.setValue("269", "1");
                    gr.setValue("270", this.getInstrument().priceToString(this._getAskClose()));
                    this.fillEntryTime(gr, tsid, tssubid);
                    if (this.getAskQuoteCondition() != null) {
                        gr.setValue("276", this.getAskQuoteCondition());
                    }
                    if (this.getAskQuoteType() != -1) {
                        gr.setValue("537", this.getAskQuoteType());
                    }
                    if (this.getAskExpireTimestamp() != null) {
                        gr.setValue("432", this.getAskExpireTimestamp().toStringDateOnly());
                        gr.setValue("126", this.getAskExpireTimestamp().toString());
                    }
                    if (this.getAskOriginator() != null) {
                        gr.setValue("282", this.getAskOriginator());
                    }
                    if (this.getInstrument() != null && this.getInstrument().getSymbol() != null) {
                        set = false;
                        if (this.getInstrument() instanceof TradingSecurity && !(ts = (TradingSecurity)this.getInstrument()).isForex()) {
                            gr.setValue("15", ts.getCurrency());
                            set = true;
                        }
                        if (!set) {
                            gr.setValue("15", this.getInstrument().getSymbol().substring(0, 3));
                        }
                    }
                    if (this.getAskEntrySize() != -1.0) {
                        gr.setValue("271", this.getAskEntrySize());
                    }
                    grl.put(gr);
                }
                if ((aMDEntryTypeSet & 1) != 0 && (aMDEntryTypeSet & 2) != 0 && (aMDEntryTypeSet & 4) != 0) {
                    if (this._getLow() != 0.0) {
                        gr = aFactory.createFieldGroup();
                        gr.setValue("278", MarketDataEntry.createEntryID(this.getInstrument().getFXCMSymID(), "8", 0.0, null));
                        gr.setValue("269", "8");
                        gr.setValue("270", this.getInstrument().priceToString(this._getLow()));
                        grl.put(gr);
                    }
                    if (this._getHigh() != 0.0) {
                        gr = aFactory.createFieldGroup();
                        gr.setValue("278", MarketDataEntry.createEntryID(this.getInstrument().getFXCMSymID(), "7", 0.0, null));
                        gr.setValue("269", "7");
                        gr.setValue("270", this.getInstrument().priceToString(this._getHigh()));
                        grl.put(gr);
                    }
                }
                if ((aMDEntryTypeSet & 1) != 0 && (aMDEntryTypeSet & 8) != 0) {
                    if (this._getBidOpen() != 0.0) {
                        gr = aFactory.createFieldGroup();
                        gr.setValue("278", MarketDataEntry.createEntryID(this.getInstrument().getFXCMSymID(), "4", 0.0, null));
                        gr.setValue("269", "4");
                        gr.setValue("270", this.getInstrument().priceToString(this._getBidOpen()));
                        grl.put(gr);
                    }
                    if (this._getBidHigh() != 0.0) {
                        gr = aFactory.createFieldGroup();
                        gr.setValue("278", MarketDataEntry.createEntryID(this.getInstrument().getFXCMSymID(), "D", 0.0, null));
                        gr.setValue("269", "D");
                        gr.setValue("270", this.getInstrument().priceToString(this._getBidHigh()));
                        grl.put(gr);
                    }
                    if (this._getBidLow() != 0.0) {
                        gr = aFactory.createFieldGroup();
                        gr.setValue("278", MarketDataEntry.createEntryID(this.getInstrument().getFXCMSymID(), "E", 0.0, null));
                        gr.setValue("269", "E");
                        gr.setValue("270", this.getInstrument().priceToString(this._getBidLow()));
                        grl.put(gr);
                    }
                }
                if ((aMDEntryTypeSet & 2) != 0 && (aMDEntryTypeSet & 8) != 0) {
                    if (this._getAskOpen() != 0.0) {
                        gr = aFactory.createFieldGroup();
                        gr.setValue("278", MarketDataEntry.createEntryID(this.getInstrument().getFXCMSymID(), "B", 0.0, null));
                        gr.setValue("269", "B");
                        gr.setValue("270", this.getInstrument().priceToString(this._getAskOpen()));
                        grl.put(gr);
                    }
                    if (this._getAskLow() != 0.0) {
                        gr = aFactory.createFieldGroup();
                        gr.setValue("278", MarketDataEntry.createEntryID(this.getInstrument().getFXCMSymID(), "G", 0.0, null));
                        gr.setValue("269", "G");
                        gr.setValue("270", this.getInstrument().priceToString(this._getAskLow()));
                        grl.put(gr);
                    }
                    if (this._getAskHigh() != 0.0) {
                        gr = aFactory.createFieldGroup();
                        gr.setValue("278", MarketDataEntry.createEntryID(this.getInstrument().getFXCMSymID(), "F", 0.0, null));
                        gr.setValue("269", "F");
                        gr.setValue("270", this.getInstrument().priceToString(this._getAskHigh()));
                        grl.put(gr);
                    }
                }
            } else {
                IFieldGroup gr;
                if ((aMDEntryTypeSet & 1) != 0) {
                    if (this._getBidOpen() != 0.0) {
                        gr = aFactory.createFieldGroup();
                        gr.setValue("278", MarketDataEntry.createEntryID(this.getInstrument().getFXCMSymID(), "4", 0.0, null));
                        gr.setValue("269", "4");
                        gr.setValue("270", this.getInstrument().priceToString(this._getBidOpen()));
                        this.fillEntryTime(gr, tsid, tssubid);
                        grl.put(gr);
                    }
                    if (this._getBidClose() != 0.0) {
                        gr = aFactory.createFieldGroup();
                        gr.setValue("278", MarketDataEntry.createEntryID(this.getInstrument().getFXCMSymID(), "5", 0.0, null));
                        gr.setValue("269", "5");
                        gr.setValue("270", this.getInstrument().priceToString(this._getBidClose()));
                        grl.put(gr);
                    }
                    if (this._getBidLow() != 0.0) {
                        gr = aFactory.createFieldGroup();
                        gr.setValue("278", MarketDataEntry.createEntryID(this.getInstrument().getFXCMSymID(), "E", 0.0, null));
                        gr.setValue("269", "E");
                        gr.setValue("270", this.getInstrument().priceToString(this._getBidLow()));
                        grl.put(gr);
                    }
                    if (this._getBidHigh() != 0.0) {
                        gr = aFactory.createFieldGroup();
                        gr.setValue("278", MarketDataEntry.createEntryID(this.getInstrument().getFXCMSymID(), "D", 0.0, null));
                        gr.setValue("269", "D");
                        gr.setValue("270", this.getInstrument().priceToString(this._getBidHigh()));
                        grl.put(gr);
                    }
                }
                if ((aMDEntryTypeSet & 2) != 0) {
                    if (this._getAskOpen() != 0.0) {
                        gr = aFactory.createFieldGroup();
                        gr.setValue("278", MarketDataEntry.createEntryID(this.getInstrument().getFXCMSymID(), "B", 0.0, null));
                        gr.setValue("269", "B");
                        gr.setValue("270", this.getInstrument().priceToString(this._getAskOpen()));
                        this.fillEntryTime(gr, tsid, tssubid);
                        grl.put(gr);
                    }
                    if (this._getAskClose() != 0.0) {
                        gr = aFactory.createFieldGroup();
                        gr.setValue("278", MarketDataEntry.createEntryID(this.getInstrument().getFXCMSymID(), "C", 0.0, null));
                        gr.setValue("269", "C");
                        gr.setValue("270", this.getInstrument().priceToString(this._getAskClose()));
                        grl.put(gr);
                    }
                    if (this._getAskLow() != 0.0) {
                        gr = aFactory.createFieldGroup();
                        gr.setValue("278", MarketDataEntry.createEntryID(this.getInstrument().getFXCMSymID(), "G", 0.0, null));
                        gr.setValue("269", "G");
                        gr.setValue("270", this.getInstrument().priceToString(this._getAskLow()));
                        grl.put(gr);
                    }
                    if (this._getAskHigh() != 0.0) {
                        gr = aFactory.createFieldGroup();
                        gr.setValue("278", MarketDataEntry.createEntryID(this.getInstrument().getFXCMSymID(), "F", 0.0, null));
                        gr.setValue("269", "F");
                        gr.setValue("270", this.getInstrument().priceToString(this._getAskHigh()));
                        grl.put(gr);
                    }
                }
                if ((aMDEntryTypeSet & 0x10) != 0) {
                    gr = aFactory.createFieldGroup();
                    gr.setValue("278", MarketDataEntry.createEntryID(this.getInstrument().getFXCMSymID(), "H", 0.0, null));
                    gr.setValue("269", "H");
                    gr.setValue("270", Integer.toString(this._getTickVolume()));
                    grl.put(gr);
                }
            }
            ret.setValue("268", grl);
            if (this.getFXCMTimingInterval() != null) {
                String[] messageCodes = FXCMTimingIntervalFactory.storageToMessageIntervalCodes(this.getFXCMTimingInterval().getCode());
                ret.setValue("9011", messageCodes[0]);
                ret.setValue("9075", messageCodes[1]);
            }
            ret.setValue("9020", this.getFXCMContinuousFlag());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    @Override
    public void reset() {
        super.reset();
        this.mAskLow = 0.0;
        this.mAskHigh = 0.0;
        this.mAskOpen = 0.0;
        this.mAskClose = 0.0;
        this.mLow = 0.0;
        this.mHigh = 0.0;
        this.mBidLow = 0.0;
        this.mBidHigh = 0.0;
        this.mBidOpen = 0.0;
        this.mBidClose = 0.0;
        this.mBidId = null;
        this.mBidQuoteCondition = null;
        this.mBidQuoteType = 0;
        this.mBidExpireTimeStamp = null;
        this.mBidOriginator = null;
        this.mBidCurrency = null;
        this.mBidEntrySize = 0.0;
        this.mAskId = null;
        this.mAskQuoteCondition = null;
        this.mAskQuoteType = 0;
        this.mAskExpireTimeStamp = null;
        this.mAskOriginator = null;
        this.mAskCurrency = null;
        this.mAskEntrySize = 0.0;
    }

    private boolean updateEntry(String aType, double aPx, String aDate, String aTime, String aQuoteID, String aOriginator, String aCondition) {
        boolean ret = false;
        if (aType != null && aPx != 0.0) {
            if (this.getFXCMTimingInterval().equals(FXCMTimingIntervalFactory.TICK)) {
                if (aType.equals("0")) {
                    this.setBidClose(aPx);
                    ret = true;
                } else if (aType.equals("1")) {
                    this.setAskClose(aPx);
                    ret = true;
                } else if (aType.equals("8")) {
                    this.setLow(aPx);
                    ret = true;
                } else if (aType.equals("7")) {
                    this.setHigh(aPx);
                    ret = true;
                } else if (aType.equals("4")) {
                    this.setBidOpen(aPx);
                    ret = true;
                } else if (aType.equals("B")) {
                    this.setAskOpen(aPx);
                    ret = true;
                } else if (aType.equals("E")) {
                    this.setBidLow(aPx);
                    ret = true;
                } else if (aType.equals("G")) {
                    this.setAskLow(aPx);
                    ret = true;
                } else if (aType.equals("D")) {
                    this.setBidHigh(aPx);
                    ret = true;
                } else if (aType.equals("F")) {
                    this.setAskHigh(aPx);
                    ret = true;
                }
            } else if (aType.equals("4")) {
                this.setBidOpen(aPx);
                ret = true;
            } else if (aType.equals("B")) {
                this.setAskOpen(aPx);
                ret = true;
            } else if (aType.equals("5")) {
                this.setBidClose(aPx);
                ret = true;
            } else if (aType.equals("C")) {
                this.setAskClose(aPx);
                ret = true;
            } else if (aType.equals("E")) {
                this.setBidLow(aPx);
                ret = true;
            } else if (aType.equals("G")) {
                this.setAskLow(aPx);
                ret = true;
            } else if (aType.equals("D")) {
                this.setBidHigh(aPx);
                ret = true;
            } else if (aType.equals("F")) {
                this.setAskHigh(aPx);
                ret = true;
            }
            if (ret) {
                if (aDate != null) {
                    this.setDate(aDate);
                }
                if (aTime != null) {
                    this.setTime(aTime);
                }
                if (aQuoteID != null && aQuoteID.length() > 0) {
                    this.setQuoteID(aQuoteID);
                }
                if (aOriginator != null && aOriginator.length() > 0) {
                    this.setOriginator(aOriginator);
                }
                if (aCondition != null && aCondition.length() > 0) {
                    this.setTradeable(aCondition.contains("A"));
                }
            }
        }
        return ret;
    }

    @Override
    public boolean fill(IMessage aMsg) {
        boolean ret = false;
        this.reset();
        long id = aMsg.getValueLong("9039");
        if (id != 0L) {
            this.setFXCMMsgID(id);
        }
        this.setMDReqID(aMsg.getValueString("262"));
        int mainTICode = aMsg.getValueInt("9011");
        String auxTICode = aMsg.getValueString("9075");
        if (auxTICode == null) {
            auxTICode = "";
        }
        int interval = FXCMTimingIntervalFactory.messageToStorageIntervalCode(mainTICode, auxTICode);
        this.setFXCMTimingInterval(FXCMTimingIntervalFactory.toCode(interval));
        this.setInstrument(new Instrument(aMsg.getValueString("55"), aMsg.getValueInt("9000"), aMsg.getValueInt("9001")));
        this.getInstrument().setFXCMSymPointSize(aMsg.getValueDouble("9002"));
        this.getInstrument().setFXCMSymSortOrder(aMsg.getValueInt("9005"));
        int product = aMsg.getValueInt("460");
        if (product >= 1 && product <= 13) {
            this.getInstrument().setProduct(product);
        }
        this.getInstrument().setContractMultiplier(aMsg.getValueDouble("231"));
        this.getInstrument().setFactor(aMsg.getValueInt("228"));
        this.getInstrument().setCFICode(aMsg.getValueString("461"));
        this.getInstrument().setSecurityType(aMsg.getValueString("167"));
        this.getInstrument().setFXCMProductID(aMsg.getValueInt("9080"));
        this.getInstrument().setFXCMCondDistStop(aMsg.getValueDouble("9090"));
        this.getInstrument().setFXCMCondDistLimit(aMsg.getValueDouble("9091"));
        this.getInstrument().setFXCMCondDistEntryStop(aMsg.getValueDouble("9092"));
        this.getInstrument().setFXCMCondDistEntryLimit(aMsg.getValueDouble("9093"));
        this.getInstrument().setFXCMMaxQuantity(aMsg.getValueDouble("9094"));
        this.getInstrument().setFXCMMinQuantity(aMsg.getValueDouble("9095"));
        this.getInstrument().setFXCMTradingStatus(aMsg.getValueString("9096"));
        this.setFXCMContinuousFlag(aMsg.getValueInt("9020"));
        this.setPriceStream(aMsg.getValueString("9072"));
        IFieldGroupList grl = aMsg.getValueList("268");
        if (grl != null) {
            for (IFieldGroup gr : grl.values()) {
                String sType = gr.getValueString("269");
                double dPx = gr.getValueDouble("270");
                String sDate = gr.getValueString("272");
                String sTime = gr.getValueString("273");
                String sQuoteID = gr.getValueString("299");
                String sOriginator = gr.getValueString("282");
                String sCondition = gr.getValueString("276");
                this.updateEntry(sType, dPx, sDate, sTime, sQuoteID, sOriginator, sCondition);
                if ("0".equals(sType)) {
                    this.setBidId(gr.getValueString("299"));
                    this.setBidQuoteCondition(gr.getValueString("276"));
                    this.setBidQuoteType(gr.getValueString("537") == null ? 0 : gr.getValueInt("537"));
                    this.setBidExpireDate(gr.getValueString("432"));
                    this.setBidExpireTime(gr.getValueString("126"));
                    this.setBidOriginator(gr.getValueString("282"));
                    this.setBidCurrency(gr.getValueString("15"));
                    this.setBidEntrySize(gr.getValueString("271") == null ? -1.0 : gr.getValueDouble("271"));
                } else if ("1".equals(sType)) {
                    this.setAskId(gr.getValueString("299"));
                    this.setAskQuoteCondition(gr.getValueString("276"));
                    this.setAskQuoteType(gr.getValueString("537") == null ? -1 : gr.getValueInt("537"));
                    this.setAskExpireDate(gr.getValueString("432"));
                    this.setAskExpireTime(gr.getValueString("126"));
                    this.setAskOriginator(gr.getValueString("282"));
                    this.setAskCurrency(gr.getValueString("15"));
                    this.setAskEntrySize(gr.getValueString("271") == null ? -1.0 : gr.getValueDouble("271"));
                }
                String s = gr.getValueString("336");
                if (s != null && s.length() > 0) {
                    this.setTradingSessionID(s);
                }
                if ((s = gr.getValueString("625")) == null || s.length() <= 0) continue;
                this.setTradingSessionSubID(s);
            }
            ret = this.isValid();
        }
        return ret;
    }

    @Override
    public Date getCreationTime() {
        Date ret = null;
        UTCTimestamp td = this.getOpenTimestampRef();
        if (td != null) {
            ret = td.toDate();
        }
        return ret;
    }

    @Override
    public String getDesc() {
        return this.getName();
    }

    @Override
    public Date getModificationTime() {
        return this.getCreationTime();
    }

    @Override
    public String getName() {
        String ret = null;
        IPK pk = this.getPK();
        if (pk != null) {
            ret = pk.getStringID();
        }
        return ret;
    }

    @Override
    public IPK getPK() {
        if (this.mPK == null && this.getFXCMTimingInterval() != null && this.getInstrument() != null && this.getTradingSessionID() != null && this.getTradingSessionSubID() != null) {
            try {
                String s = this.getTradingSessionID() + this.getTradingSessionSubID() + this.getInstrument().getSymbol() + this.getFXCMTimingInterval().getCode();
                if (!this.getFXCMTimingInterval().equals(FXCMTimingIntervalFactory.TICK) && this.getTime() != null && this.getDate() != null) {
                    s = s + this.getDate().toString() + this.getTime().toString();
                }
                this.mPK = new GenericPK(s);
            }
            catch (NotDefinedException notDefinedException) {
                // empty catch block
            }
        }
        return this.mPK;
    }

    @Override
    public IStatus getStatus() {
        return null;
    }

    @Override
    public void setCreationTime(Date aTime) {
    }

    @Override
    public void setDesc(String aDesc) {
    }

    @Override
    public void setModificationTime(Date aTime) {
    }

    @Override
    public void setName(String aName) {
    }

    @Override
    public void setPK(IPK aPk) {
    }

    @Override
    public void setStatus(IStatus aStatus) throws GenericException {
    }

    @Override
    public void printState(PrintStream aOut) {
        if (aOut != null) {
            aOut.println(this.toString());
        } else {
            System.out.println(this.toString());
        }
    }

    @Override
    public boolean isNew() {
        return true;
    }

    @Override
    public void setNew() {
    }

    @Override
    public boolean isDeleted() {
        return false;
    }

    @Override
    public void setDeleted() {
    }

    @Override
    public String getBidId() {
        return this.mBidId;
    }

    @Override
    public void setBidId(String aBidId) {
        this.mBidId = aBidId;
    }

    @Override
    public String getAskId() {
        return this.mAskId;
    }

    @Override
    public void setAskId(String aAskId) {
        this.mAskId = aAskId;
    }

    @Override
    public String getBidQuoteCondition() {
        return this.mBidQuoteCondition;
    }

    @Override
    public void setBidQuoteCondition(String aBidQuoteCondition) {
        this.mBidQuoteCondition = aBidQuoteCondition;
    }

    @Override
    public int getBidQuoteType() {
        return this.mBidQuoteType;
    }

    @Override
    public void setBidQuoteType(int aBidQuoteType) {
        this.mBidQuoteType = aBidQuoteType;
    }

    @Override
    public UTCDate getBidExpireDate() {
        if (this.mBidExpireTimeStamp == null) {
            return null;
        }
        return new UTCDate(this.mBidExpireTimeStamp);
    }

    @Override
    public void setBidExpireDate(UTCDate aBidExpireDate) {
        if (aBidExpireDate == null) {
            this.mBidExpireTimeStamp = null;
            return;
        }
        if (this.mBidExpireTimeStamp == null) {
            this.mBidExpireTimeStamp = new UTCTimestamp();
        }
        this.mBidExpireTimeStamp.setDateOnly(aBidExpireDate);
    }

    @Override
    public void setBidExpireDate(String aBidExpireDate) {
        if (aBidExpireDate == null) {
            this.mBidExpireTimeStamp = null;
            return;
        }
        if (this.mBidExpireTimeStamp == null) {
            this.mBidExpireTimeStamp = new UTCTimestamp();
        }
        try {
            this.mBidExpireTimeStamp.setDateOnly(aBidExpireDate);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    @Override
    public UTCTimeOnly getBidExpireTime() {
        if (this.mBidExpireTimeStamp == null) {
            return null;
        }
        return new UTCTimeOnly(this.mBidExpireTimeStamp);
    }

    @Override
    public void setBidExpireTime(UTCTimeOnly aBidExpireTime) {
        if (aBidExpireTime == null) {
            this.mBidExpireTimeStamp = null;
            return;
        }
        if (this.mBidExpireTimeStamp == null) {
            this.mBidExpireTimeStamp = new UTCTimestamp();
        }
        this.mBidExpireTimeStamp.setTimeOnly(aBidExpireTime);
    }

    @Override
    public void setBidExpireTime(String aBidExpireTime) {
        if (aBidExpireTime == null) {
            this.mBidExpireTimeStamp = null;
            return;
        }
        if (this.mBidExpireTimeStamp == null) {
            this.mBidExpireTimeStamp = new UTCTimestamp();
        }
        try {
            this.mBidExpireTimeStamp.setTimeOnly(aBidExpireTime);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    @Override
    public UTCTimestamp getBidExpireTimestamp() {
        return this.mBidExpireTimeStamp;
    }

    @Override
    public void setBidExpireTimestamp(UTCTimestamp aBidExpireTimestamp) {
        this.mBidExpireTimeStamp = aBidExpireTimestamp;
    }

    @Override
    public String getBidOriginator() {
        return this.mBidOriginator;
    }

    @Override
    public void setBidOriginator(String aBidOriginator) {
        this.mBidOriginator = aBidOriginator;
    }

    @Override
    public String getBidCurrency() {
        return this.mBidCurrency;
    }

    @Override
    public void setBidCurrency(String aBidCurrency) {
        this.mBidCurrency = aBidCurrency;
    }

    @Override
    public double getBidEntrySize() {
        return this.mBidEntrySize;
    }

    @Override
    public void setBidEntrySize(double aBidEntrySize) {
        this.mBidEntrySize = aBidEntrySize;
    }

    @Override
    public String getAskQuoteCondition() {
        return this.mAskQuoteCondition;
    }

    @Override
    public void setAskQuoteCondition(String aAskQuoteCondition) {
        this.mAskQuoteCondition = aAskQuoteCondition;
    }

    @Override
    public int getAskQuoteType() {
        return this.mAskQuoteType;
    }

    @Override
    public void setAskQuoteType(int aAskQuoteType) {
        this.mAskQuoteType = aAskQuoteType;
    }

    @Override
    public UTCDate getAskExpireDate() {
        if (this.mAskExpireTimeStamp == null) {
            return null;
        }
        return new UTCDate(this.mAskExpireTimeStamp);
    }

    @Override
    public void setAskExpireDate(UTCDate aAskExpireDate) {
        if (aAskExpireDate == null) {
            this.mAskExpireTimeStamp = null;
            return;
        }
        if (this.mAskExpireTimeStamp == null) {
            this.mAskExpireTimeStamp = new UTCTimestamp();
        }
        this.mAskExpireTimeStamp.setDateOnly(aAskExpireDate);
    }

    @Override
    public void setAskExpireDate(String aAskExpireDate) {
        if (aAskExpireDate == null) {
            this.mAskExpireTimeStamp = null;
            return;
        }
        if (this.mAskExpireTimeStamp == null) {
            this.mAskExpireTimeStamp = new UTCTimestamp();
        }
        try {
            this.mAskExpireTimeStamp.setDateOnly(aAskExpireDate);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    @Override
    public UTCTimeOnly getAskExpireTime() {
        if (this.mAskExpireTimeStamp == null) {
            return null;
        }
        return new UTCTimeOnly(this.mAskExpireTimeStamp);
    }

    @Override
    public void setAskExpireTime(UTCTimeOnly aAskExpireTime) {
        if (aAskExpireTime == null) {
            this.mAskExpireTimeStamp = null;
            return;
        }
        if (this.mAskExpireTimeStamp == null) {
            this.mAskExpireTimeStamp = new UTCTimestamp();
        }
        this.mAskExpireTimeStamp.setTimeOnly(aAskExpireTime);
    }

    @Override
    public void setAskExpireTime(String aAskExpireTime) {
        if (aAskExpireTime == null) {
            this.mAskExpireTimeStamp = null;
            return;
        }
        if (this.mAskExpireTimeStamp == null) {
            this.mAskExpireTimeStamp = new UTCTimestamp();
        }
        try {
            this.mAskExpireTimeStamp.setTimeOnly(aAskExpireTime);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    @Override
    public void setAskExpireTimestamp(UTCTimestamp aAskExpireTimeStamp) {
        this.mAskExpireTimeStamp = aAskExpireTimeStamp;
    }

    @Override
    public UTCTimestamp getAskExpireTimestamp() {
        return this.mAskExpireTimeStamp;
    }

    @Override
    public String getAskOriginator() {
        return this.mAskOriginator;
    }

    @Override
    public void setAskOriginator(String aAskOriginator) {
        this.mAskOriginator = aAskOriginator;
    }

    @Override
    public String getAskCurrency() {
        return this.mAskCurrency;
    }

    @Override
    public void setAskCurrency(String aAskCurrency) {
        this.mAskCurrency = aAskCurrency;
    }

    @Override
    public double getAskEntrySize() {
        return this.mAskEntrySize;
    }

    @Override
    public void setAskEntrySize(double aAskEntrySize) {
        this.mAskEntrySize = aAskEntrySize;
    }

    @Override
    public int getTickVolume() {
        return this.mTickVolume;
    }

    @Override
    public void setTickVolume(int aTickVolume) {
        this.mTickVolume = aTickVolume;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MarketDataSnapshot");
        sb.append("{QuoteID='").append(this.getQuoteID()).append('\'');
        if (this.getInstrument() != null) {
            sb.append(",Instrument={").append(this.getInstrument().getFXCMSymID());
            try {
                sb.append(",").append(this.getInstrument().getSymbol());
            }
            catch (Exception e) {
                sb.append(",null");
            }
            sb.append("}");
        } else {
            sb.append(",Instrument=null");
        }
        sb.append(", Time=").append(this.getTime());
        sb.append(", Date=").append(this.getDate());
        sb.append(", AskLow=").append(this._getAskLow());
        sb.append(", AskHigh=").append(this._getAskHigh());
        sb.append(", AskOpen=").append(this._getAskOpen());
        sb.append(", AskClose=").append(this._getAskClose());
        sb.append(", Low=").append(this._getLow());
        sb.append(", High=").append(this._getHigh());
        sb.append(", BidLow=").append(this._getBidLow());
        sb.append(", BidHigh=").append(this._getBidHigh());
        sb.append(", BidOpen=").append(this._getBidOpen());
        sb.append(", BidClose=").append(this._getBidClose());
        sb.append(", Interval=").append(this.getFXCMTimingInterval());
        sb.append(", Complete=").append(this.isComplete());
        sb.append(", MDReqID='").append(this.getMDReqID()).append('\'');
        sb.append(", TradingSessionID='").append(this.getTradingSessionID()).append('\'');
        sb.append(", TradingSessionSubID='").append(this.getTradingSessionSubID()).append('\'');
        sb.append(", Originator='").append(this.getOriginator()).append('\'');
        sb.append(", IsTradeable=").append(this.isTradeable());
        sb.append(", ContinuousFlag=").append(this.getFXCMContinuousFlag());
        sb.append(", BidId='").append(this.getBidId()).append('\'');
        sb.append(", BidQuoteCondition='").append(this.getBidQuoteCondition()).append('\'');
        sb.append(", BidQuoteType=").append(this.getBidQuoteType());
        sb.append(", BidExpireTimestamp=").append(this.getBidExpireTimestamp());
        sb.append(", BidOriginator='").append(this.getBidOriginator()).append('\'');
        sb.append(", BidCurrency='").append(this.getBidCurrency()).append('\'');
        sb.append(", BidEntrySize=").append(this.getBidEntrySize());
        sb.append(", AskId='").append(this.getAskId()).append('\'');
        sb.append(", AskQuoteCondition='").append(this.getAskQuoteCondition()).append('\'');
        sb.append(", AskQuoteType=").append(this.getAskQuoteType());
        sb.append(", AskExpireTimestamp=").append(this.getAskExpireTimestamp());
        sb.append(", AskOriginator='").append(this.getAskOriginator()).append('\'');
        sb.append(", AskCurrency='").append(this.getAskCurrency()).append('\'');
        sb.append(", AskEntrySize=").append(this.getAskEntrySize());
        sb.append(", TickVolume=").append(this.getTickVolume());
        sb.append('}');
        return sb.toString();
    }
}

