/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix.custom.zdas;

import com.fxcm.fix.custom.zdas.DasMessage;

public class DasMessageAnalyzer {
    public static String getFixMsgType(DasMessage aMsg) {
        String ret = "";
        if (aMsg != null) {
            String msg = aMsg.getMessage();
            ret = DasMessageAnalyzer.getFixMsgType(msg);
        }
        return ret;
    }

    public static String getFixMsgType(String aMsgText) {
        String ret = "";
        if (aMsgText != null) {
            if (aMsgText.startsWith("OFFER")) {
                ret = "W";
            } else if (aMsgText.startsWith("MAIL")) {
                ret = "C";
            } else if (aMsgText.startsWith("ACCT")) {
                ret = "BA";
            } else if (aMsgText.startsWith("ORDER")) {
                ret = "8";
            } else if (aMsgText.startsWith("TRADE") || aMsgText.startsWith("CLSDTRADE")) {
                ret = "AP";
            } else if (aMsgText.startsWith("INSTRMT")) {
                ret = "f";
            } else if (aMsgText.startsWith("PARAM")) {
                ret = "h";
            } else if (aMsgText.startsWith("RFQ")) {
                ret = "R";
            }
        }
        return ret;
    }

    public static String getFixMsgType(int aMsgType) {
        String ret = "";
        switch (aMsgType) {
            case 1: {
                ret = "W";
                break;
            }
            case 2: {
                ret = "C";
                break;
            }
            case 3: {
                ret = "BA";
                break;
            }
            case 4: {
                ret = "8";
                break;
            }
            case 5: {
                ret = "R";
                break;
            }
            case 6: {
                ret = "AP";
                break;
            }
            case 7: {
                break;
            }
            case 9: {
                ret = "h";
                break;
            }
            case 10: {
                ret = "f";
            }
        }
        return ret;
    }

    public static boolean isRFQ(DasMessage aMsg) {
        boolean ret = false;
        if (aMsg != null) {
            String msg = aMsg.getMessage();
            ret = msg.startsWith("RFQ");
        }
        return ret;
    }

    public static boolean isOffer(DasMessage aMsg) {
        boolean ret = false;
        if (aMsg != null) {
            String msg = aMsg.getMessage();
            ret = msg.startsWith("OFFER");
        }
        return ret;
    }

    public static boolean isEmail(DasMessage aMsg) {
        boolean ret = false;
        if (aMsg != null) {
            String msg = aMsg.getMessage();
            ret = msg.startsWith("MAIL");
        }
        return ret;
    }

    public static boolean isNews(DasMessage aMsg) {
        String msg = aMsg.getMessage();
        return msg.startsWith("NEWS");
    }

    public static boolean isExecutionReport(DasMessage aMsg) {
        String msg = aMsg.getMessage();
        return msg.startsWith("ORDER");
    }

    public static boolean isCollateralReport(DasMessage aMsg) {
        boolean ret = false;
        if (aMsg != null) {
            String msg = aMsg.getMessage();
            ret = msg.startsWith("ACCT");
        }
        return ret;
    }

    public static boolean isPositionReport(DasMessage aMsg) {
        boolean ret = false;
        if (aMsg != null) {
            String msg = aMsg.getMessage();
            ret = msg.startsWith("TRADE") || msg.startsWith("CLSDTRADE");
        }
        return ret;
    }

    public static boolean isSecurityStatus(DasMessage aMsg) {
        boolean ret = false;
        if (aMsg != null) {
            String msg = aMsg.getMessage();
            ret = msg.startsWith("INSTRMT");
        }
        return ret;
    }

    public static boolean isTradingSessionStatus(DasMessage aMsg) {
        boolean ret = false;
        if (aMsg != null) {
            String msg = aMsg.getMessage();
            ret = msg.startsWith("PARAM");
        }
        return ret;
    }

    public static boolean isLogon(DasMessage aMsg) {
        boolean ret = false;
        if (aMsg != null) {
            String msg = aMsg.getMessage();
            ret = msg.startsWith("LOGON");
        }
        return ret;
    }

    public static boolean isOffer(String aMsg) {
        boolean ret = false;
        if (aMsg != null) {
            return aMsg.startsWith("OFFER");
        }
        return ret;
    }

    public static boolean isEmail(String aMsg) {
        boolean ret = false;
        if (aMsg != null) {
            return aMsg.startsWith("MAIL");
        }
        return ret;
    }

    public static boolean isNews(String aMsg) {
        boolean ret = false;
        if (aMsg != null) {
            return aMsg.startsWith("NEWS");
        }
        return ret;
    }

    public static boolean isExecutionReport(String aMsg) {
        boolean ret = false;
        if (aMsg != null) {
            return aMsg.startsWith("ORDER");
        }
        return ret;
    }

    public static boolean isCollateralReport(String aMsg) {
        boolean ret = false;
        if (aMsg != null) {
            return aMsg.startsWith("ACCT");
        }
        return ret;
    }

    public static boolean isPositionReport(String aMsg) {
        boolean ret = false;
        if (aMsg != null) {
            return aMsg.startsWith("TRADE") || aMsg.startsWith("CLSDTRADE");
        }
        return ret;
    }

    public static boolean isSecurityStatus(String aMsg) {
        boolean ret = false;
        if (aMsg != null) {
            return aMsg.startsWith("INSTRMT");
        }
        return ret;
    }

    public static boolean isTradingSessionStatus(String aMsg) {
        boolean ret = false;
        if (aMsg != null) {
            return aMsg.startsWith("PARAM");
        }
        return ret;
    }

    public static boolean isLogon(String aMsg) {
        boolean ret = false;
        if (aMsg != null) {
            return aMsg.startsWith("LOGON");
        }
        return ret;
    }
}

