/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix.custom.zdas;

import com.fxcm.entity.ACode;
import com.fxcm.entity.ICode;
import com.fxcm.fix.FixObjectFactory;
import com.fxcm.fix.IFixDefs;
import com.fxcm.fix.custom.zdas.DasMessageAnalyzer;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.IMessageFactory;
import com.fxcm.messaging.ITransportable;
import com.fxcm.util.DateTimeFormatterMs;
import java.util.Date;
import java.util.StringTokenizer;

public class DasMessage
implements ITransportable,
IFixDefs {
    private int miPosition;
    private int miMaxPosition;
    private long mMakingTime = System.currentTimeMillis();
    public static final int KIND_UNKNOWN = 0;
    public static final int KIND_REGULAR = 1;
    public static final int KIND_BROADCAST = 2;
    public static final int KIND_OBJECT = 3;
    public static final int KIND_DEBUG = 4;
    public static final int OBJTYPE_UNKNOWN = 0;
    public static final int OBJTYPE_OFFER = 1;
    public static final int OBJTYPE_MAIL = 2;
    public static final int OBJTYPE_ACCT = 3;
    public static final int OBJTYPE_ORDER = 4;
    public static final int OBJTYPE_RFQ = 5;
    public static final int OBJTYPE_TRADE = 6;
    public static final int OBJTYPE_CLSDTRADE = 7;
    public static final int OBJTYPE_LOGON = 8;
    public static final int OBJTYPE_PARAM = 9;
    public static final int OBJTYPE_INSTRMT = 10;
    public static final int OBJTYPE_OPNOPTIONE = 11;
    public static final int OBJTYPE_CLSDOPTIONE = 12;
    public static final int OBJTYPE_OPNOPTIONV = 13;
    public static final int OBJTYPE_CLSDOPTIONV = 14;
    public static final int OBJTYPE_COMMIT = 15;
    public static final int OBJTYPE_ORDERE = 16;
    public static final int OBJTYPE_SESSN = 17;
    public static final int CODE_UNKNOWN = 0;
    public static final int CODE_OK = 1;
    public static final int CODE_END = 2;
    public static final int CODE_ERROR = 3;
    public static final int CODE_TIMEOUT = 4;
    public static final int ACTION_UNKNOWN = 0;
    public static final int ACTION_UPDATE = 1;
    public static final int ACTION_INSERT = 2;
    public static final int ACTION_DELETE = 3;
    public static final int OPTION_CLIENTEXTRA = 1;
    public static final int OPTION_SERVEREXTRA = 2;
    public static final String SERVICEKIND_SERVICE = "S";
    public static final String SERVICEKIND_TRADING = "T";
    public static final String SERVICEKIND_DUMMY = "D";
    public static final String SERVICEKIND_DELIVERED = "X";
    public static final ICode OBJ_TYPE = new DasMessageType();
    private String msMsg;
    private String mDt;
    private String msSess;
    private String msKind;
    private int miKind;
    private String msCode;
    private int miCode;
    private String msAction;
    private int miAction;
    private String msObjectID;
    private String msObjectType;
    private int miObjectType;
    private String msOfferID;
    private String msAcctID;
    private String mTradingSessionID;
    private String mTradingSessionSubID;
    private String mServiceKind = null;
    private Long mMsgID = null;
    private Long mMsgIDExternal = null;
    private String mLocatorID1 = null;
    private String mLocatorID2 = null;
    private String mPriceStream = null;
    private long mObjectCode = -1L;

    public DasMessage() {
        this.reset();
    }

    public void reset() {
        this.msMsg = null;
        this.mDt = null;
        this.msSess = null;
        this.msKind = null;
        this.msCode = null;
        this.msAction = null;
        this.miKind = 0;
        this.miCode = 0;
        this.miAction = 0;
        this.miObjectType = 0;
        this.msObjectID = null;
        this.msObjectType = null;
        this.msOfferID = null;
        this.msAcctID = null;
        this.miPosition = 0;
        this.miMaxPosition = 0;
        this.mTradingSessionID = null;
        this.mTradingSessionSubID = null;
        this.mServiceKind = null;
        this.mMsgID = null;
        this.mMsgIDExternal = null;
        this.mLocatorID1 = null;
        this.mLocatorID2 = null;
        this.mPriceStream = null;
    }

    public int getKindI() {
        if (this.miKind == 0) {
            if ("Regular".equals(this.msKind)) {
                this.miKind = 1;
            } else if ("Object".equals(this.msKind)) {
                this.miKind = 3;
            } else if ("Broadcast".equals(this.msKind)) {
                this.miKind = 2;
            } else if ("Debug".equals(this.msKind)) {
                this.miKind = 4;
            }
        }
        return this.miKind;
    }

    public int getCodeI() {
        if (this.miCode == 0) {
            if ("OK".equals(this.msCode)) {
                this.miCode = 1;
            } else if ("Error".equals(this.msCode)) {
                this.miCode = 3;
            } else if ("Timeout".equals(this.msCode)) {
                this.miCode = 4;
            } else if ("The End".equals(this.msCode)) {
                this.miCode = 2;
            }
        }
        return this.miCode;
    }

    public String getMessage() {
        return this.msMsg;
    }

    public String getDate() {
        return this.mDt;
    }

    public String getSession() {
        return this.msSess;
    }

    public String getKind() {
        return this.msKind;
    }

    public String getCode() {
        return this.msCode;
    }

    public String getPriceStream() {
        return this.mPriceStream;
    }

    public String toString() {
        Object ret = "==========";
        ret = (String)ret + "\nMsg: " + this.getMessage();
        ret = (String)ret + "\nDt: " + this.getDate();
        ret = (String)ret + "\nSess: " + this.getSession();
        ret = (String)ret + "\nKind: " + this.getKind();
        ret = (String)ret + "\nCode: " + this.getCode();
        ret = (String)ret + "\nTreadingSessionID: " + this.getTradingSessionID();
        ret = (String)ret + "\nTreadingSessionSubID: " + this.getTradingSessionSubID();
        ret = (String)ret + "\nServiceKind: " + this.getServiceKind();
        ret = (String)ret + "\nMsgID: " + this.getMsgID();
        ret = (String)ret + "\nMsgIDExt: " + this.getMsgIDExternal();
        ret = (String)ret + "\nLocatorID1: " + this.getLocatorID1();
        ret = (String)ret + "\nLocatorID2: " + this.getLocatorID2();
        ret = (String)ret + "\nOffer: " + this.getOfferID();
        ret = (String)ret + "\nStream: " + this.getPriceStream();
        ret = (String)ret + "\nObjectType: " + this.getObjectType() + "[" + this.getObjectTypeI() + "]";
        ret = (String)ret + "\n==========\n";
        return ret;
    }

    public String getObjectID() {
        this.prepareFields();
        return this.msObjectID;
    }

    public String getAction() {
        this.prepareFields();
        return this.msAction;
    }

    public int getActionI() {
        this.prepareFields();
        if (this.miAction == 0 && this.msAction != null) {
            this.miAction = "UID".indexOf(this.msAction) + 1;
        }
        return this.miAction;
    }

    public String getObjectType() {
        this.prepareFields();
        return this.msObjectType;
    }

    public int getObjectTypeI() {
        this.prepareFields();
        return this.miObjectType;
    }

    public String getOfferID() {
        this.prepareFields();
        return this.msOfferID;
    }

    public String getAcctID() {
        this.prepareFields();
        return this.msAcctID;
    }

    private String formatDASDate(Date aDt) {
        return DateTimeFormatterMs.formatDASDate(aDt);
    }

    @Override
    public IMessage toMessage(String aSID, IMessageFactory aFactory) {
        return this.toMessage(aSID, null, null, null, 2, aFactory);
    }

    @Override
    public IMessage toMessage(String aSID, String aTradingSessionID, String aTradingSessionSubID, String aRequestID, int aOptions, IMessageFactory aFactory) {
        Object s;
        String tssubid;
        String tsid = aTradingSessionID;
        if (tsid == null) {
            tsid = this.mTradingSessionID;
        }
        if ((tssubid = aTradingSessionSubID) == null) {
            tssubid = this.mTradingSessionSubID;
        }
        IMessage msg = aFactory.createMessage(aSID, OBJ_TYPE.getCode());
        if (tsid != null) {
            msg.setValue("336", tsid);
        }
        if (tssubid != null) {
            msg.setValue("625", tssubid);
        }
        if (this.msMsg != null) {
            s = "0;" + this.getDate() + "\n";
            s = (String)s + this.msMsg;
            msg.setValue("58", (String)s);
        }
        if ((aOptions & 1) > 0) {
            s = "";
            s = this.getSession() == null ? (String)s + " ;" : (String)s + this.getSession() + ";";
            s = this.getKind() == null ? (String)s + " ;" : (String)s + this.getKind() + ";";
            s = this.getCode() == null ? (String)s + " ;" : (String)s + this.getCode() + ";";
            msg.setValue("9027", (String)s);
        }
        if ((aOptions & 2) > 0) {
            if (this.getSession() != null) {
                msg.setValue("9062", this.getSession());
            }
            if (this.getKind() != null) {
                msg.setValue("9063", this.getKind());
            }
            if (this.getCode() != null) {
                msg.setValue("9064", this.getCode());
            }
            if (this.getAction() != null) {
                msg.setValue("9065", this.getAction());
            }
            if (this.getObjectID() != null) {
                msg.setValue("9066", this.getObjectID());
            }
            if (this.getObjectType() != null) {
                msg.setValue("9067", this.getObjectType());
            }
            if (this.getOfferID() != null) {
                msg.setValue("9000", this.getOfferID());
            }
            if (this.getAcctID() != null) {
                msg.setValue("9068", this.getAcctID());
            }
            if (this.getServiceKind() != null) {
                msg.setValue("9069", this.getServiceKind());
            }
            if (this.getMsgID() != null) {
                msg.setValue("9039", this.getMsgID());
            }
            if (this.getLocatorID1() != null) {
                msg.setValue("9070", this.getLocatorID1());
            }
            if (this.getLocatorID2() != null) {
                msg.setValue("9071", this.getLocatorID2());
            }
            if (this.getPriceStream() != null) {
                msg.setValue("9072", this.getPriceStream());
            }
            if (this.getMsgIDExternal() != null) {
                msg.setValue("9097", this.getMsgIDExternal());
            }
        }
        return msg;
    }

    @Override
    public boolean fill(IMessage aMsg) {
        if (aMsg == null) {
            return false;
        }
        this.reset();
        String s = aMsg.getValueString("58");
        int iMsg = s.indexOf(10);
        if (iMsg < 0) {
            this.setMessage(s);
        } else if (iMsg > 2) {
            this.setDate(s.substring(2, iMsg));
            this.setMessage(s.substring(++iMsg));
        } else {
            int endIndex = s.indexOf("\n", 2);
            this.setDate(s.substring(2, endIndex));
            this.setMessage(s.substring(endIndex++));
        }
        s = aMsg.getValueString("9063");
        if (s != null) {
            this.setKind(s);
            this.setSession(aMsg.getValueString("9062"));
            this.setCode(aMsg.getValueString("9064"));
            this.setAction(aMsg.getValueString("9065"));
            this.setObjectID(aMsg.getValueString("9066"));
            this.setObjectType(aMsg.getValueString("9067"));
            this.setOfferID(aMsg.getValueString("9000"));
            this.setAcctID(aMsg.getValueString("9068"));
            this.setServiceKind(aMsg.getValueString("9069"));
            this.setMsgID(aMsg.getValueLong("9039"));
            this.setLocatorID1(aMsg.getValueString("9070"));
            this.setLocatorID2(aMsg.getValueString("9071"));
            this.setPriceStream(aMsg.getValueString("9072"));
            this.setTradingSessionID(aMsg.getValueString("336"));
            this.setTradingSessionSubID(aMsg.getValueString("625"));
            if (aMsg.getValueString("9097") != null) {
                this.setMsgIDExternal(aMsg.getValueLong("9097"));
            }
        } else {
            s = aMsg.getValueString("9027");
            if (s != null) {
                StringTokenizer st = new StringTokenizer(s, ";");
                block5: for (int i = 0; st.hasMoreTokens() && i < 3; ++i) {
                    s = st.nextToken().trim();
                    if (s.length() == 0) {
                        s = null;
                    }
                    switch (i) {
                        case 0: {
                            this.setSession(s);
                            continue block5;
                        }
                        case 1: {
                            this.setKind(s);
                            continue block5;
                        }
                        case 2: {
                            this.setCode(s);
                        }
                    }
                }
            }
        }
        return true;
    }

    public boolean fill(DasMessage aMsg) {
        this.reset();
        this.setDate(aMsg.getDate());
        this.setMessage(aMsg.getMessage());
        this.setKind(aMsg.getKind());
        this.setSession(aMsg.getSession());
        this.setCode(aMsg.getCode());
        this.setAction(aMsg.getAction());
        this.setObjectID(aMsg.getObjectID());
        this.setObjectType(aMsg.getObjectType());
        this.setOfferID(aMsg.getOfferID());
        this.setAcctID(aMsg.getAcctID());
        this.setServiceKind(aMsg.getServiceKind());
        this.setMsgID(aMsg.getMsgID());
        this.setLocatorID1(aMsg.getLocatorID1());
        this.setLocatorID2(aMsg.getLocatorID2());
        this.setPriceStream(aMsg.getPriceStream());
        return true;
    }

    @Override
    public boolean update(IMessage aMsg) {
        return this.fill(aMsg);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public ICode getType() {
        return OBJ_TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareFields() {
        if ((this.msObjectType == null || this.msAction == null) && this.hasMoreTokens()) {
            DasMessage dasMessage = this;
            synchronized (dasMessage) {
                if ((this.msObjectType == null || this.msAction == null) && this.hasMoreTokens()) {
                    this.miPosition = 0;
                    String s = this.nextToken();
                    this.setObjectType(s.trim());
                    if (this.mObjectCode < 0L) {
                        this.mObjectCode = FixObjectFactory.getMessageChannel(DasMessageAnalyzer.getFixMsgType(this.miObjectType));
                    }
                    switch (this.miObjectType) {
                        case 10: {
                            block49: for (int i = 1; i > 0 && this.hasMoreTokens(); ++i) {
                                String var = this.nextToken();
                                switch (i) {
                                    case 1: {
                                        this.msAction = var;
                                        continue block49;
                                    }
                                    case 2: {
                                        this.msObjectID = var;
                                        this.msOfferID = var;
                                        i = -1;
                                    }
                                }
                            }
                            break;
                        }
                        case 1: {
                            block50: for (int i = 1; i > 0 && this.hasMoreTokens(); ++i) {
                                String var = this.nextToken();
                                switch (i) {
                                    case 1: {
                                        this.msAction = var;
                                        continue block50;
                                    }
                                    case 2: {
                                        this.msObjectID = var;
                                        this.msOfferID = var;
                                        i = -1;
                                    }
                                }
                            }
                            break;
                        }
                        case 3: {
                            block51: for (int i = 1; i > 0 && this.hasMoreTokens(); ++i) {
                                String var = this.nextToken();
                                switch (i) {
                                    case 1: {
                                        this.msAction = var;
                                        continue block51;
                                    }
                                    case 2: {
                                        this.msObjectID = var;
                                        this.msAcctID = var;
                                        i = -1;
                                    }
                                }
                            }
                            break;
                        }
                        case 5: 
                        case 6: 
                        case 7: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: {
                            block52: for (int i = 1; i > 0 && this.hasMoreTokens(); ++i) {
                                String var = this.nextToken();
                                switch (i) {
                                    case 1: {
                                        this.msAction = var;
                                        continue block52;
                                    }
                                    case 2: {
                                        this.msObjectID = var;
                                        continue block52;
                                    }
                                    case 6: {
                                        this.msAcctID = var;
                                        continue block52;
                                    }
                                    case 8: {
                                        this.msOfferID = var;
                                        i = -1;
                                    }
                                }
                            }
                            break;
                        }
                        case 4: 
                        case 16: {
                            block53: for (int i = 1; i > 0 && this.hasMoreTokens(); ++i) {
                                String var = this.nextToken();
                                switch (i) {
                                    case 1: {
                                        this.msAction = var;
                                        continue block53;
                                    }
                                    case 2: {
                                        this.msObjectID = var;
                                        continue block53;
                                    }
                                    case 12: {
                                        this.msAcctID = var;
                                        continue block53;
                                    }
                                    case 14: {
                                        this.msOfferID = var;
                                        i = -1;
                                    }
                                }
                            }
                            break;
                        }
                        case 9: {
                            for (int i = 1; i > 0 && this.hasMoreTokens(); ++i) {
                                String var = this.nextToken();
                                switch (i) {
                                    case 1: {
                                        this.msAction = var;
                                        i = -1;
                                    }
                                }
                            }
                            break;
                        }
                        case 15: {
                            block55: for (int i = 1; i > 0 && this.hasMoreTokens(); ++i) {
                                String var = this.nextToken();
                                switch (i) {
                                    case 1: {
                                        this.msAction = var;
                                        continue block55;
                                    }
                                    case 2: {
                                        this.msObjectID = var;
                                        continue block55;
                                    }
                                    case 3: {
                                        this.msAcctID = var;
                                        i = -1;
                                    }
                                }
                            }
                            break;
                        }
                        case 17: {
                            block56: for (int i = 1; i > 0 && this.hasMoreTokens(); ++i) {
                                String var = this.nextToken();
                                switch (i) {
                                    case 1: {
                                        this.msAction = var;
                                        continue block56;
                                    }
                                    case 2: {
                                        this.msObjectID = var;
                                        i = -1;
                                    }
                                }
                            }
                            break;
                        }
                    }
                }
            }
        }
    }

    protected boolean hasMoreTokens() {
        return this.miPosition < this.miMaxPosition;
    }

    protected String nextToken() {
        String ret = "";
        if (this.hasMoreTokens()) {
            int nextPosition = this.msMsg.indexOf(59, this.miPosition);
            if (nextPosition < 0) {
                ret = this.msMsg.substring(this.miPosition);
                this.miPosition = this.miMaxPosition;
            } else {
                ret = this.msMsg.substring(this.miPosition, nextPosition);
                this.miPosition = nextPosition + 1;
            }
        }
        return ret;
    }

    @Override
    public String getRequestID() {
        return null;
    }

    @Override
    public String getTradingSessionID() {
        return this.mTradingSessionID;
    }

    @Override
    public String getTradingSessionSubID() {
        return this.mTradingSessionSubID;
    }

    public String getServiceKind() {
        return this.mServiceKind;
    }

    public boolean isService() {
        return SERVICEKIND_SERVICE.equals(this.getServiceKind());
    }

    public Long getMsgID() {
        return this.mMsgID;
    }

    public String getLocatorID1() {
        return this.mLocatorID1;
    }

    public String getLocatorID2() {
        return this.mLocatorID2;
    }

    public boolean parse(String aRawPalmoDasMsg) {
        String[] parts = aRawPalmoDasMsg.split("\t");
        boolean ret = false;
        if (parts.length >= 2) {
            this.setMessage(parts[1]);
            String[] fields = parts[0].split(";");
            if (fields.length >= 4) {
                this.setKind(fields[0]);
                this.setServiceKind(fields[1]);
                this.setDate(fields[2]);
                try {
                    this.setMsgID(Long.valueOf(fields[3]));
                }
                catch (NumberFormatException ex) {
                    return false;
                }
                if (fields.length > 4 && fields[4].length() > 0) {
                    this.setLocatorID1(fields[4]);
                }
                if (fields.length > 5 && fields[5].length() > 0) {
                    this.setLocatorID2(fields[5]);
                }
                if (fields.length > 6) {
                    this.setSession(fields[6]);
                }
                if (fields.length > 7 && fields[7].length() > 0) {
                    this.setOfferID(fields[7]);
                }
                if (fields.length > 8 && fields[8].length() > 0) {
                    this.setPriceStream(fields[8]);
                }
                if (fields.length > 9 && fields[9].length() > 0) {
                    try {
                        this.setMsgIDExternal(Long.valueOf(fields[9]));
                    }
                    catch (NumberFormatException ex) {
                        return false;
                    }
                }
                if (fields.length > 10 && fields[10].length() > 0) {
                    this.setTradingSessionID("FXCM");
                    this.setTradingSessionSubID(fields[10]);
                }
                ret = true;
            }
        }
        return ret;
    }

    public void setMessage(String asMsg) {
        this.msMsg = asMsg;
        this.msAction = null;
        this.msObjectID = null;
        this.msObjectType = null;
        this.msOfferID = null;
        this.msAcctID = null;
        this.miPosition = 0;
        this.miMaxPosition = 0;
        this.miKind = 0;
        this.miCode = 0;
        this.miAction = 0;
        this.miObjectType = 0;
        if (this.msMsg != null) {
            this.miMaxPosition = this.msMsg.length();
        }
    }

    public void setDate(String aDt) {
        this.mDt = aDt;
    }

    public void setSession(String asSess) {
        this.msSess = asSess;
    }

    public void setKind(String asKind) {
        this.msKind = asKind;
        this.miKind = 0;
    }

    public void setCode(String asCode) {
        this.msCode = asCode;
        this.miCode = 0;
    }

    public void setAction(String aAction) {
        this.msAction = aAction;
        this.miAction = 0;
    }

    public void setObjectID(String aObjectID) {
        this.msObjectID = aObjectID;
    }

    public void setObjectType(String aObjectType) {
        this.msObjectType = aObjectType;
        this.miObjectType = 0;
        if ("OFFER".equals(this.msObjectType)) {
            this.miObjectType = 1;
        } else if ("MAIL".equals(this.msObjectType)) {
            this.miObjectType = 2;
        } else if ("ACCT".equals(this.msObjectType)) {
            this.miObjectType = 3;
        } else if ("ORDER".equals(this.msObjectType)) {
            this.miObjectType = 4;
        } else if ("RFQ".equals(this.msObjectType)) {
            this.miObjectType = 5;
        } else if ("OPTIONV".equals(this.msObjectType)) {
            this.miObjectType = 13;
        } else if ("CLSDOPTIONV".equals(this.msObjectType)) {
            this.miObjectType = 14;
        } else if ("OPTIONE".equals(this.msObjectType)) {
            this.miObjectType = 11;
        } else if ("CLSDOPTIONE".equals(this.msObjectType)) {
            this.miObjectType = 12;
        } else if ("TRADE".equals(this.msObjectType)) {
            this.miObjectType = 6;
        } else if ("CLSDTRADE".equals(this.msObjectType)) {
            this.miObjectType = 7;
        } else if ("LOGON".equals(this.msObjectType)) {
            this.miObjectType = 8;
        } else if ("PARAM".equals(this.msObjectType)) {
            this.miObjectType = 9;
        } else if ("INSTRMT".equals(this.msObjectType)) {
            this.miObjectType = 10;
        } else if ("COMMIT".equals(this.msObjectType)) {
            this.miObjectType = 15;
        } else if ("ARDER".equals(this.msObjectType)) {
            this.miObjectType = 16;
        } else if ("SESSN".equals(this.msObjectType)) {
            this.miObjectType = 17;
        }
    }

    public void setOfferID(String aOfferID) {
        this.msOfferID = aOfferID;
    }

    public void setAcctID(String aAcctID) {
        this.msAcctID = aAcctID;
    }

    public void setTradingSessionID(String aTradingSessionID) {
        this.mTradingSessionID = aTradingSessionID;
    }

    public void setTradingSessionSubID(String aTradingSessionSubID) {
        this.mTradingSessionSubID = aTradingSessionSubID;
    }

    public void setServiceKind(String aServiceKind) {
        this.mServiceKind = aServiceKind;
    }

    public void setMsgID(Long aMsgID) {
        this.mMsgID = aMsgID;
    }

    public void setLocatorID1(String aLocatorID1) {
        this.mLocatorID1 = aLocatorID1;
    }

    public void setLocatorID2(String aLocatorID2) {
        this.mLocatorID2 = aLocatorID2;
    }

    public void setPriceStream(String aStreamName) {
        this.mPriceStream = aStreamName;
        if (this.mPriceStream != null) {
            this.mPriceStream = this.mPriceStream.toLowerCase();
        }
    }

    public long getObjectCode() {
        this.prepareFields();
        if (this.mObjectCode < 0L) {
            this.mObjectCode = FixObjectFactory.getMessageChannel(DasMessageAnalyzer.getFixMsgType(this.miObjectType));
        }
        return this.mObjectCode;
    }

    @Override
    public long getMakingTime() {
        return this.mMakingTime;
    }

    public Long getMsgIDExternal() {
        return this.mMsgIDExternal;
    }

    public void setMsgIDExternal(Long aMsgIDExternal) {
        this.mMsgIDExternal = aMsgIDExternal;
    }

    private static class DasMessageType
    extends ACode {
        DasMessageType() {
            super("U60", "DasMessage", "");
        }
    }
}

