/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix.custom.news;

import com.fxcm.entity.ACode;
import com.fxcm.entity.ICode;
import com.fxcm.fix.IFixDefs;
import com.fxcm.fix.custom.news.FXCMNewsTopicResponsePage;
import com.fxcm.messaging.IFieldGroup;
import com.fxcm.messaging.IFieldGroupList;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.IMessageFactory;
import com.fxcm.messaging.ITransportable;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class FXCMNewsTopicResponse
implements ITransportable,
IFixDefs {
    private long mMakingTime = System.currentTimeMillis();
    public static final ICode OBJ_TYPE = new FXCMNewsTopicResponseType();
    private String msTestReqID;
    private String msTradingSessionID;
    private String msTradingSessionSubID;
    private Vector mPages = new Vector();

    public FXCMNewsTopicResponse() {
        this.reset();
    }

    public String getTestReqID() {
        return this.msTestReqID;
    }

    @Override
    public String getTradingSessionID() {
        return this.msTradingSessionID;
    }

    @Override
    public String getTradingSessionSubID() {
        return this.msTradingSessionSubID;
    }

    public void setTestReqID(String asTestReqID) {
        this.msTestReqID = asTestReqID;
    }

    public void setTradingSessionID(String asTradingSessionID) {
        this.msTradingSessionID = asTradingSessionID;
    }

    public void setTradingSessionSubID(String asTradingSessionSubID) {
        this.msTradingSessionSubID = asTradingSessionSubID;
    }

    public Enumeration getPages() {
        return this.mPages.elements();
    }

    public void addPage(FXCMNewsTopicResponsePage aPage) {
        this.mPages.add(aPage);
    }

    public void reset() {
        this.msTestReqID = null;
        this.msTradingSessionID = "FXCM";
        this.msTradingSessionSubID = "NewsServer";
        this.mPages.clear();
    }

    @Override
    public IMessage toMessage(String aSID, IMessageFactory aFactory) {
        return this.toMessage(aSID, null, null, null, 0, aFactory);
    }

    @Override
    public IMessage toMessage(String aSID, String aTradingSessionID, String aTradingSessionSubID, String aRequestID, int aOptions, IMessageFactory aFactory) {
        String tssubid;
        String tsid;
        String req = aRequestID;
        if (req == null) {
            req = this.msTestReqID;
        }
        if ((tsid = aTradingSessionID) == null) {
            tsid = this.msTradingSessionID;
        }
        if ((tssubid = aTradingSessionSubID) == null) {
            tssubid = this.msTradingSessionSubID;
        }
        IMessage msg = aFactory.createMessage(aSID, OBJ_TYPE.getCode());
        if (req != null) {
            msg.setValue("112", req);
        }
        if (tsid != null) {
            msg.setValue("336", tsid);
        }
        if (tssubid != null) {
            msg.setValue("625", tssubid);
        }
        IFieldGroupList grl = aFactory.createFieldGroupList();
        Enumeration en = this.getPages();
        while (en.hasMoreElements()) {
            FXCMNewsTopicResponsePage page = (FXCMNewsTopicResponsePage)en.nextElement();
            IFieldGroup gr = aFactory.createFieldGroup();
            gr.setValue("9022", page.getPageID());
            String sHeadline = page.getHeadline();
            if (sHeadline != null) {
                gr.setValue("148", sHeadline);
            }
            grl.put(gr);
        }
        msg.setValue("9026", grl);
        return msg;
    }

    @Override
    public boolean fill(IMessage aMsg) {
        if (aMsg == null) {
            return false;
        }
        this.reset();
        this.setTradingSessionID(aMsg.getValueString("336"));
        this.setTradingSessionSubID(aMsg.getValueString("625"));
        this.setTestReqID(aMsg.getValueString("112"));
        IFieldGroupList grl = aMsg.getValueList("9026");
        if (grl == null) {
            this.reset();
            return false;
        }
        Iterator<IFieldGroup> iterator = grl.values().iterator();
        while (iterator.hasNext()) {
            IFieldGroup field;
            IFieldGroup gr = field = iterator.next();
            FXCMNewsTopicResponsePage page = new FXCMNewsTopicResponsePage();
            page.setPageID(gr.getValueString("9022"));
            page.setHeadline(gr.getValueString("148"));
            this.addPage(page);
        }
        return true;
    }

    @Override
    public boolean update(IMessage aMsg) {
        return this.fill(aMsg);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public ICode getType() {
        return OBJ_TYPE;
    }

    @Override
    public String getRequestID() {
        return this.getTestReqID();
    }

    @Override
    public long getMakingTime() {
        return this.mMakingTime;
    }

    private static class FXCMNewsTopicResponseType
    extends ACode {
        FXCMNewsTopicResponseType() {
            super("U53", "FXCMNewsTopicResponse", "");
        }
    }
}

