/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix.custom.news;

import com.fxcm.entity.ACode;
import com.fxcm.entity.ICode;
import com.fxcm.fix.IFixDefs;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.IMessageFactory;
import com.fxcm.messaging.ITransportable;

public class FXCMNewsTopicRequest
implements ITransportable,
IFixDefs {
    private long mMakingTime = System.currentTimeMillis();
    public static final ICode OBJ_TYPE = new FXCMNewsTopicRequestType();
    private String msTestReqID;
    private String msTradingSessionID;
    private String msTradingSessionSubID;

    public FXCMNewsTopicRequest() {
        this.reset();
    }

    public String getTestReqID() {
        return this.msTestReqID;
    }

    @Override
    public String getTradingSessionID() {
        return this.msTradingSessionID;
    }

    @Override
    public String getTradingSessionSubID() {
        return this.msTradingSessionSubID;
    }

    public void setTestReqID(String asTestReqID) {
        this.msTestReqID = asTestReqID;
    }

    public void setTradingSessionID(String asTradingSessionID) {
        this.msTradingSessionID = asTradingSessionID;
    }

    public void setTradingSessionSubID(String asTradingSessionSubID) {
        this.msTradingSessionSubID = asTradingSessionSubID;
    }

    public void reset() {
        this.msTestReqID = null;
        this.msTradingSessionID = "FXCM";
        this.msTradingSessionSubID = "NewsServer";
    }

    @Override
    public IMessage toMessage(String aSID, IMessageFactory aFactory) {
        return this.toMessage(aSID, null, null, null, 0, aFactory);
    }

    @Override
    public IMessage toMessage(String aSID, String aTradingSessionID, String aTradingSessionSubID, String aRequestID, int aOptions, IMessageFactory aFactory) {
        String tssubid;
        String tsid;
        String req = aRequestID;
        if (req == null) {
            req = this.msTestReqID;
        }
        if ((tsid = aTradingSessionID) == null) {
            tsid = this.msTradingSessionID;
        }
        if ((tssubid = aTradingSessionSubID) == null) {
            tssubid = this.msTradingSessionSubID;
        }
        IMessage msg = aFactory.createMessage(aSID, OBJ_TYPE.getCode());
        if (req != null) {
            msg.setValue("112", req);
        }
        if (tsid != null) {
            msg.setValue("336", tsid);
        }
        if (tssubid != null) {
            msg.setValue("625", tssubid);
        }
        return msg;
    }

    @Override
    public boolean update(IMessage aMsg) {
        return this.fill(aMsg);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public ICode getType() {
        return OBJ_TYPE;
    }

    @Override
    public boolean fill(IMessage aMsg) {
        if (aMsg == null) {
            return false;
        }
        this.reset();
        this.setTradingSessionID(aMsg.getValueString("336"));
        this.setTradingSessionSubID(aMsg.getValueString("625"));
        this.setTestReqID(aMsg.getValueString("112"));
        return true;
    }

    @Override
    public String getRequestID() {
        return this.getTestReqID();
    }

    @Override
    public long getMakingTime() {
        return this.mMakingTime;
    }

    private static class FXCMNewsTopicRequestType
    extends ACode {
        FXCMNewsTopicRequestType() {
            super("U51", "FXCMNewsTopicRequest", "");
        }
    }
}

