/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix.custom.news;

import com.fxcm.entity.ACode;
import com.fxcm.entity.ICode;
import com.fxcm.fix.IFixDefs;
import com.fxcm.fix.ISubscriptionRequestType;
import com.fxcm.fix.SubscriptionRequestTypeFactory;
import com.fxcm.fix.UTCTimestamp;
import com.fxcm.fix.custom.news.FXCMNewsRequestPage;
import com.fxcm.messaging.IFieldGroup;
import com.fxcm.messaging.IFieldGroupList;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.IMessageFactory;
import com.fxcm.messaging.ITransportable;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class FXCMNewsRequest
implements ITransportable,
IFixDefs {
    private long mMakingTime = System.currentTimeMillis();
    public static final ICode OBJ_TYPE = new FXCMNewsRequestType();
    private String msTestReqID;
    private String msTradingSessionID;
    private String msTradingSessionSubID;
    private ISubscriptionRequestType mSubscriptionRequestType;
    private Vector mPageIDNo = new Vector();

    public FXCMNewsRequest() {
        this.reset();
    }

    public String getTestReqID() {
        return this.msTestReqID;
    }

    @Override
    public String getTradingSessionID() {
        return this.msTradingSessionID;
    }

    @Override
    public String getTradingSessionSubID() {
        return this.msTradingSessionSubID;
    }

    public void setTestReqID(String asTestReqID) {
        this.msTestReqID = asTestReqID;
    }

    public void setTradingSessionID(String asTradingSessionID) {
        this.msTradingSessionID = asTradingSessionID;
    }

    public void setTradingSessionSubID(String asTradingSessionSubID) {
        this.msTradingSessionSubID = asTradingSessionSubID;
    }

    public ISubscriptionRequestType getSubscriptionRequestType() {
        return this.mSubscriptionRequestType;
    }

    public void setSubscriptionRequestType(ISubscriptionRequestType aType) {
        this.mSubscriptionRequestType = aType;
    }

    public Enumeration getPageIDNo() {
        return this.mPageIDNo.elements();
    }

    public void addPageIDNo(FXCMNewsRequestPage aPage) {
        this.mPageIDNo.add(aPage);
    }

    public void reset() {
        this.msTestReqID = null;
        this.msTradingSessionID = "FXCM";
        this.msTradingSessionSubID = "NewsServer";
        this.mSubscriptionRequestType = null;
        this.mPageIDNo.clear();
    }

    @Override
    public IMessage toMessage(String aSID, IMessageFactory aFactory) {
        return this.toMessage(aSID, null, null, null, 0, aFactory);
    }

    @Override
    public IMessage toMessage(String aSID, String aTradingSessionID, String aTradingSessionSubID, String aRequestID, int aOptions, IMessageFactory aFactory) {
        String tssubid;
        String tsid;
        String req = aRequestID;
        if (req == null) {
            req = this.msTestReqID;
        }
        if ((tsid = aTradingSessionID) == null) {
            tsid = this.msTradingSessionID;
        }
        if ((tssubid = aTradingSessionSubID) == null) {
            tssubid = this.msTradingSessionSubID;
        }
        IMessage msg = aFactory.createMessage(aSID, OBJ_TYPE.getCode());
        if (req != null) {
            msg.setValue("112", req);
        }
        if (tsid != null) {
            msg.setValue("336", tsid);
        }
        if (tssubid != null) {
            msg.setValue("625", tssubid);
        }
        msg.setValue("263", this.getSubscriptionRequestType().getCode());
        IFieldGroupList grl = aFactory.createFieldGroupList();
        Enumeration en = this.getPageIDNo();
        while (en.hasMoreElements()) {
            FXCMNewsRequestPage page = (FXCMNewsRequestPage)en.nextElement();
            IFieldGroup gr = aFactory.createFieldGroup();
            UTCTimestamp t = page.getTransactTime();
            gr.setValue("9022", page.getPageID());
            gr.setValue("9023", page.getPageviewID());
            gr.setValue("9024", page.getPageviewLifetime());
            gr.setValue("9021", page.getNoSnapshot());
            if (t != null) {
                gr.setValue("60", t.toString());
            }
            grl.put(gr);
        }
        msg.setValue("9026", grl);
        return msg;
    }

    @Override
    public boolean update(IMessage aMsg) {
        return this.fill(aMsg);
    }

    @Override
    public boolean isValid() {
        return this.mSubscriptionRequestType != null;
    }

    @Override
    public ICode getType() {
        return OBJ_TYPE;
    }

    @Override
    public boolean fill(IMessage aMsg) {
        if (aMsg == null) {
            return false;
        }
        this.reset();
        this.setTradingSessionID(aMsg.getValueString("336"));
        this.setTradingSessionSubID(aMsg.getValueString("625"));
        this.setTestReqID(aMsg.getValueString("112"));
        ISubscriptionRequestType type = SubscriptionRequestTypeFactory.toCode(aMsg.getValueString("263"));
        this.setSubscriptionRequestType(type);
        IFieldGroupList grl = aMsg.getValueList("9026");
        if (grl == null) {
            this.reset();
            return false;
        }
        Iterator<IFieldGroup> iterator = grl.values().iterator();
        while (iterator.hasNext()) {
            IFieldGroup field;
            IFieldGroup gr = field = iterator.next();
            String sPageID = gr.getValueString("9022");
            int iPageviewID = gr.getValueInt("9023");
            int iPageviewLifetime = gr.getValueInt("9024");
            String sTransactTime = gr.getValueString("60");
            int iFXCMNoSnapshot = gr.getValueInt("9021");
            FXCMNewsRequestPage page = new FXCMNewsRequestPage();
            page.setPageID(sPageID);
            page.setPageviewID(iPageviewID);
            page.setPageviewLifetime(iPageviewLifetime);
            if (sTransactTime != null) {
                page.setTransactTime(new UTCTimestamp(sTransactTime));
            }
            page.setNoSnapshot(iFXCMNoSnapshot);
            this.addPageIDNo(page);
        }
        return true;
    }

    @Override
    public String getRequestID() {
        return this.getTestReqID();
    }

    @Override
    public long getMakingTime() {
        return this.mMakingTime;
    }

    private static class FXCMNewsRequestType
    extends ACode {
        FXCMNewsRequestType() {
            super("U50", "FXCMNewsRequest", "");
        }
    }
}

