/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix.custom;

import com.fxcm.fix.UTCTimestamp;
import com.fxcm.fix.custom.Addon;
import com.fxcm.messaging.IFieldGroup;
import com.fxcm.messaging.IFieldGroupList;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.IMessageFactory;
import com.fxcm.messaging.ITransportable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AFXCMMessage
implements ITransportable {
    public static final String RESPONSEECODING_DAS = "DAS";
    public static final String RESPONSEECODING_RE = "RE";
    public static final String RESPONSEECODING_DS = "DS";
    private String msTestReqID = null;
    private String msTradingSessionID = null;
    private String msTradingSessionSubID = null;
    private String msFXCMCommandID = null;
    private Map<String, String> mParams = null;
    private List<Addon> mAddons = null;
    private String mDBAlias = null;
    private String mEntityCode = null;
    private String mResponseEncoding = null;
    private String mRequestBusID = null;
    private String mMessageBusID = null;
    private String mDatabaseBusID = null;
    private String mCustomBusID = null;
    private String mRequestorID = null;
    private String mSessionID = null;
    protected UTCTimestamp mTransactTime;
    private long mMakingTime = System.currentTimeMillis();

    public AFXCMMessage() {
        this.reset();
    }

    public AFXCMMessage(AFXCMMessage aMessage) {
        this.reset();
        this.copy(aMessage);
    }

    public boolean copy(AFXCMMessage aMessage) {
        this.reset();
        this.msTestReqID = aMessage.msTestReqID;
        this.msTradingSessionID = aMessage.msTradingSessionID;
        this.msTradingSessionSubID = aMessage.msTradingSessionSubID;
        this.msFXCMCommandID = aMessage.msFXCMCommandID;
        this.mParams = aMessage.mParams;
        this.mAddons = aMessage.mAddons;
        this.mDBAlias = aMessage.mDBAlias;
        this.mEntityCode = aMessage.mEntityCode;
        this.mResponseEncoding = aMessage.mResponseEncoding;
        this.mRequestBusID = aMessage.mRequestBusID;
        this.mMessageBusID = aMessage.mMessageBusID;
        this.mDatabaseBusID = aMessage.mDatabaseBusID;
        this.mCustomBusID = aMessage.mCustomBusID;
        this.mRequestorID = aMessage.mRequestorID;
        this.mSessionID = aMessage.mSessionID;
        if (this.getType().equals(aMessage.getType()) && aMessage.mTransactTime != null) {
            this.mTransactTime = new UTCTimestamp(aMessage.mTransactTime);
        }
        return this.isValid();
    }

    public boolean deepCopy(AFXCMMessage aMessage) {
        List<Addon> adds;
        this.reset();
        this.msTestReqID = aMessage.msTestReqID;
        this.msTradingSessionID = aMessage.msTradingSessionID;
        this.msTradingSessionSubID = aMessage.msTradingSessionSubID;
        this.msFXCMCommandID = aMessage.msFXCMCommandID;
        Map<String, String> params = aMessage.mParams;
        if (params != null && params instanceof HashMap) {
            this.mParams = (Map)((HashMap)params).clone();
        }
        if ((adds = aMessage.mAddons) != null) {
            this.mAddons = new ArrayList<Addon>(adds.size());
            for (Addon add : adds) {
                this.mAddons.add((Addon)add.clone());
            }
        }
        this.mDBAlias = aMessage.mDBAlias;
        this.mEntityCode = aMessage.mEntityCode;
        this.mResponseEncoding = aMessage.mResponseEncoding;
        this.mRequestBusID = aMessage.mRequestBusID;
        this.mMessageBusID = aMessage.mMessageBusID;
        this.mDatabaseBusID = aMessage.mDatabaseBusID;
        this.mCustomBusID = aMessage.mCustomBusID;
        this.mRequestorID = aMessage.mRequestorID;
        this.mSessionID = aMessage.mSessionID;
        if (this.getType().equals(aMessage.getType()) && aMessage.mTransactTime != null) {
            this.mTransactTime = new UTCTimestamp(aMessage.mTransactTime);
        }
        return this.isValid();
    }

    public String getFXCMCommandID() {
        return this.msFXCMCommandID;
    }

    public void setFXCMCommandID(String aFXCMCommandID) {
        this.msFXCMCommandID = aFXCMCommandID;
    }

    public String getTestReqID() {
        return this.msTestReqID;
    }

    @Override
    public String getTradingSessionID() {
        return this.msTradingSessionID;
    }

    @Override
    public String getTradingSessionSubID() {
        return this.msTradingSessionSubID;
    }

    public void setTestReqID(String asTestReqID) {
        this.msTestReqID = asTestReqID;
    }

    public void setTradingSessionID(String asTradingSessionID) {
        this.msTradingSessionID = asTradingSessionID;
    }

    public void setTradingSessionSubID(String asTradingSessionSubID) {
        this.msTradingSessionSubID = asTradingSessionSubID;
    }

    public Map getParams() {
        return this.mParams;
    }

    public void setParams(Map aParams) {
        this.mParams = aParams;
    }

    public List getAddons() {
        return this.mAddons;
    }

    public void setDBAlias(String aDBAlias) {
        this.mDBAlias = aDBAlias;
    }

    public String getDBAlias() {
        return this.mDBAlias;
    }

    public void setEntityCode(String aEntityCode) {
        this.mEntityCode = aEntityCode;
    }

    public String getEntityCode() {
        return this.mEntityCode;
    }

    public void setResponseEncoding(String aResponseEncoding) {
        this.mResponseEncoding = aResponseEncoding;
    }

    public String getResponseEncoding() {
        return this.mResponseEncoding;
    }

    public void setRequestBusID(String aRequestBusID) {
        this.mRequestBusID = aRequestBusID;
    }

    public String getRequestBusID() {
        return this.mRequestBusID;
    }

    public void setMessageBusID(String aMessageBusID) {
        this.mMessageBusID = aMessageBusID;
    }

    public String getMessageBusID() {
        return this.mMessageBusID;
    }

    public void setDatabaseBusID(String aDatabaseBusID) {
        this.mDatabaseBusID = aDatabaseBusID;
    }

    public String getDatabaseBusID() {
        return this.mDatabaseBusID;
    }

    public void setCustomBusID(String aCustomBusID) {
        this.mCustomBusID = aCustomBusID;
    }

    public String getCustomBusID() {
        return this.mCustomBusID;
    }

    public void setSessionID(String aSessionID) {
        this.mSessionID = aSessionID;
    }

    public String getSessionID() {
        return this.mSessionID;
    }

    public void setRequestorID(String aRequestorID) {
        this.mRequestorID = aRequestorID;
    }

    public String getRequestorID() {
        return this.mRequestorID;
    }

    public void setAddons(List aAddons) {
        this.mAddons = aAddons;
    }

    public void addAddon(Addon aAddon) {
        if (this.mAddons == null) {
            this.mAddons = new ArrayList<Addon>();
        }
        this.mAddons.add(aAddon);
    }

    public void setParam(String aName, String aValue) {
        if (aName != null) {
            if (this.mParams == null) {
                this.mParams = new HashMap<String, String>();
            }
            this.mParams.put(aName, aValue == null ? "" : aValue);
        }
    }

    public String getParam(String aName) {
        String ret = null;
        if (this.mParams != null && aName != null) {
            ret = this.mParams.get(aName);
        }
        return ret;
    }

    public void reset() {
        this.msTestReqID = null;
        this.msTradingSessionID = "FXCM";
        this.msTradingSessionSubID = "";
        this.mParams = null;
        this.msFXCMCommandID = null;
        this.mAddons = null;
        this.mDBAlias = null;
        this.mEntityCode = null;
        this.mResponseEncoding = null;
        this.mRequestBusID = null;
        this.mMessageBusID = null;
        this.mDatabaseBusID = null;
        this.mCustomBusID = null;
        this.mRequestorID = null;
        this.mSessionID = null;
        this.mTransactTime = null;
    }

    @Override
    public IMessage toMessage(String aSID, IMessageFactory aFactory) {
        return this.toMessage(aSID, null, null, null, 0, aFactory);
    }

    @Override
    public IMessage toMessage(String aSID, String aTradingSessionID, String aTradingSessionSubID, String aRequestID, int aOptions, IMessageFactory aFactory) {
        IFieldGroupList list;
        String sid;
        String tssubid;
        String tsid;
        String req = aRequestID;
        if (req == null) {
            req = this.msTestReqID;
        }
        if ((tsid = aTradingSessionID) == null) {
            tsid = this.msTradingSessionID;
        }
        if ((tssubid = aTradingSessionSubID) == null) {
            tssubid = this.msTradingSessionSubID;
        }
        if ((sid = aSID) == null) {
            sid = this.getSessionID();
        }
        IMessage msg = aFactory.createMessage(sid, this.getType().getCode());
        if (req != null) {
            msg.setValue("112", req);
        }
        if (this.msTradingSessionID != null) {
            msg.setValue("336", tsid);
        }
        if (this.msTradingSessionSubID != null) {
            msg.setValue("625", tssubid);
        }
        if (this.msFXCMCommandID != null) {
            msg.setValue("9028", this.msFXCMCommandID);
        }
        if (this.mParams != null && this.mParams.size() > 0) {
            list = aFactory.createFieldGroupList();
            for (Map.Entry entry : this.mParams.entrySet()) {
                IFieldGroup group = aFactory.createFieldGroup();
                group.setValue("9017", (String)entry.getKey());
                group.setValue("9018", (String)entry.getValue());
                list.put(group);
            }
            msg.setValue("9016", list);
        }
        if (this.mAddons != null && this.mAddons.size() > 0) {
            list = aFactory.createFieldGroupList();
            for (Addon addon : this.mAddons) {
                list.put(addon.toGroup(aFactory));
            }
            msg.setValue("9055", list);
        }
        if (this.mDBAlias != null) {
            msg.setValue("9057", this.mDBAlias);
        }
        if (this.mEntityCode != null) {
            msg.setValue("9058", this.mEntityCode);
        }
        if (this.mResponseEncoding != null) {
            msg.setValue("9059", this.mResponseEncoding);
        }
        if (this.mRequestBusID != null) {
            msg.setValue("9032", this.mRequestBusID);
        }
        if (this.mMessageBusID != null) {
            msg.setValue("9033", this.mMessageBusID);
        }
        if (this.mDatabaseBusID != null) {
            msg.setValue("9034", this.mDatabaseBusID);
        }
        if (this.mCustomBusID != null) {
            msg.setValue("9035", this.mCustomBusID);
        }
        if (this.mRequestorID != null) {
            msg.setValue("9037", this.mRequestorID);
        }
        if (this.mTransactTime != null) {
            if (this.getTransactTime().getTime() != 0L) {
                msg.setValue("60", this.getTransactTime().toStringMs());
            }
        } else {
            msg.setValue("60", UTCTimestamp.now().toStringMs());
        }
        return msg;
    }

    @Override
    public boolean fill(IMessage aMsg) {
        IFieldGroupList list;
        boolean sessionSet = false;
        if (aMsg == null) {
            return false;
        }
        this.reset();
        this.setSessionID(aMsg.getSessionID());
        this.setTradingSessionID(aMsg.getValueString("336"));
        this.setTradingSessionSubID(aMsg.getValueString("625"));
        this.setTestReqID(aMsg.getValueString("112"));
        this.setFXCMCommandID(aMsg.getValueString("9028"));
        String s = aMsg.getValueString("60");
        if (s != null) {
            this.setTransactTime(new UTCTimestamp(s));
        }
        if ((list = aMsg.getValueList("9016")) != null) {
            for (IFieldGroup group : list.values()) {
                String key = group.getValueString("9017");
                String value = group.getValueString("9018");
                if (key.equalsIgnoreCase("SID")) {
                    sessionSet = true;
                    value = this.getSessionID();
                }
                this.setParam(key, value);
            }
        }
        if (!sessionSet) {
            this.setParam("SID", this.getSessionID());
        }
        if ((list = aMsg.getValueList("9055")) != null) {
            this.mAddons = new ArrayList<Addon>(list.size());
            for (IFieldGroup group : list.values()) {
                Addon add = new Addon();
                add.fill(group);
                this.mAddons.add(add);
            }
        }
        this.setDBAlias(aMsg.getValueString("9057"));
        this.setEntityCode(aMsg.getValueString("9058"));
        this.setResponseEncoding(aMsg.getValueString("9059"));
        this.setRequestBusID(aMsg.getValueString("9032"));
        this.setMessageBusID(aMsg.getValueString("9033"));
        this.setDatabaseBusID(aMsg.getValueString("9034"));
        this.setCustomBusID(aMsg.getValueString("9035"));
        this.setRequestorID(aMsg.getValueString("9037"));
        return true;
    }

    @Override
    public boolean update(IMessage aMsg) {
        return this.fill(aMsg);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public String getRequestID() {
        return this.getTestReqID();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getType().getLabel());
        buf.append(" msTestReqID=").append(this.msTestReqID);
        buf.append(",msTradingSessionID=").append(this.msTradingSessionID);
        buf.append(",msTradingSessionSubID=").append(this.msTradingSessionSubID);
        buf.append(",msFXCMCommandID=").append(this.msFXCMCommandID);
        if (this.mParams != null && this.mParams.size() > 0) {
            buf.append(",mParams={");
            int s = 32;
            for (Map.Entry<String, String> entry : this.mParams.entrySet()) {
                buf.append((char)s).append(entry.getKey()).append('=').append(entry.getValue());
                s = 59;
            }
            buf.append("}");
        }
        if (this.mAddons != null && this.mAddons.size() > 0) {
            buf.append(",mAddons={");
            for (Addon add : this.mAddons) {
                buf.append('[').append(add).append(']');
            }
            buf.append("}");
        }
        buf.append(",mDBAlias=").append(this.mDBAlias);
        buf.append(",mEntityCode=").append(this.mEntityCode);
        buf.append(",mResponseEncoding=").append(this.mResponseEncoding);
        buf.append(",mRequestBusID=").append(this.mRequestBusID);
        buf.append(",mMessageBusID=").append(this.mMessageBusID);
        buf.append(",mDatabaseBusID=").append(this.mDatabaseBusID);
        buf.append(",mCustomBusID=").append(this.mCustomBusID);
        buf.append(",mRequestorID=").append(this.mRequestorID);
        buf.append(",mSessionID=").append(this.mSessionID);
        buf.append(",mTransactTime=").append(this.mTransactTime == null ? "null" : this.mTransactTime.toStringMs());
        return buf.toString();
    }

    @Override
    public long getMakingTime() {
        return this.mMakingTime;
    }

    public void setTransactTime(UTCTimestamp aTransactTime) {
        this.mTransactTime = aTransactTime;
    }

    public UTCTimestamp getTransactTime() {
        return this.mTransactTime;
    }
}

