/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix.custom;

import com.fxcm.fix.FixObjectFactory;
import com.fxcm.fix.UTCTimestamp;
import com.fxcm.fix.custom.AFXCMMessage;
import com.fxcm.messaging.IField;
import com.fxcm.messaging.IFieldGroup;
import com.fxcm.messaging.IFieldGroupList;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.IMessageFactory;
import com.fxcm.messaging.ITransportable;
import com.fxcm.messaging.util.UniversalMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ABatchMessage
implements ITransportable {
    protected String mRequestTopicID;
    protected IFieldGroupList mEmbMsgs;
    protected String mRefMsgType;
    protected int mBatchResponseRequired;
    protected boolean mUseSerialization;
    protected String mSessionID;
    protected String msTradingSessionID;
    protected String msTradingSessionSubID;
    protected String mMDReqID;
    protected String msFXCMCommandID;
    protected List mResponses;
    protected int mContingencyType;
    protected UTCTimestamp mTransactTime;
    protected static final Log cLog = LogFactory.getLog(ABatchMessage.class);
    private long mMakingTime = System.currentTimeMillis();

    protected ABatchMessage() {
        this.reset();
    }

    protected ABatchMessage(ABatchMessage aBatchResponse) {
        this.reset();
        this.mRequestTopicID = aBatchResponse.mRequestTopicID;
        this.mRefMsgType = aBatchResponse.mRefMsgType;
        this.mBatchResponseRequired = aBatchResponse.mBatchResponseRequired;
        this.mSessionID = aBatchResponse.mSessionID;
        this.msTradingSessionID = aBatchResponse.msTradingSessionID;
        this.msTradingSessionSubID = aBatchResponse.msTradingSessionSubID;
        this.mMDReqID = aBatchResponse.mMDReqID;
        this.msFXCMCommandID = aBatchResponse.msFXCMCommandID;
        if (this.getType().equals(aBatchResponse.getType()) && aBatchResponse.mTransactTime != null) {
            this.mTransactTime = new UTCTimestamp(aBatchResponse.mTransactTime);
        }
    }

    @Override
    public String getTradingSessionID() {
        return this.msTradingSessionID;
    }

    public void setTradingSessionID(String aTradingSessionID) {
        this.msTradingSessionID = aTradingSessionID;
    }

    @Override
    public String getTradingSessionSubID() {
        return this.msTradingSessionSubID;
    }

    public void setTradingSessionSubID(String aTradingSessionSubID) {
        this.msTradingSessionSubID = aTradingSessionSubID;
    }

    public String getFXCMCommandID() {
        return this.msFXCMCommandID;
    }

    public void setFXCMCommandID(String aFXCMCommandID) {
        this.msFXCMCommandID = aFXCMCommandID;
    }

    public void setMDReqID(String aMDReqID) {
        this.mMDReqID = aMDReqID;
    }

    public String getMDReqID() {
        return this.mMDReqID;
    }

    public Iterator getMessages() {
        return this.responses().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMessage[] getIMessages() {
        ArrayList<UniversalMessage> list = new ArrayList<UniversalMessage>();
        ABatchMessage aBatchMessage = this;
        synchronized (aBatchMessage) {
            if (this.mEmbMsgs != null) {
                for (IFieldGroup fg : this.mEmbMsgs.values()) {
                    list.add(new UniversalMessage(fg));
                }
            }
        }
        return list.toArray(new IMessage[list.size()]);
    }

    public ITransportable[] getITransportables() {
        List responses = this.responses();
        return responses.toArray(new ITransportable[responses.size()]);
    }

    private synchronized List responses() {
        if (this.mResponses == null) {
            this.mResponses = new ArrayList();
            if (this.mEmbMsgs != null) {
                for (IFieldGroup fg : this.mEmbMsgs.values()) {
                    UniversalMessage embMsg = new UniversalMessage(fg);
                    ITransportable fixMsg = FixObjectFactory.toObject(embMsg);
                    this.mResponses.add(fixMsg);
                }
            }
        }
        return this.mResponses;
    }

    public int getMsgCount() {
        if (this.mResponses != null) {
            return this.mResponses.size();
        }
        if (this.mEmbMsgs != null) {
            return this.mEmbMsgs.size();
        }
        return 0;
    }

    public void addMessage(ITransportable aMessage) {
        this.responses().add(aMessage);
        this.mEmbMsgs = null;
    }

    public void reset() {
        this.msTradingSessionID = "FXCM";
        this.msTradingSessionSubID = "";
        this.mResponses = null;
        this.mEmbMsgs = null;
        this.mMDReqID = null;
        this.msFXCMCommandID = null;
        this.mSessionID = null;
        this.mRefMsgType = null;
        this.mBatchResponseRequired = -1;
        this.mContingencyType = 0;
        this.mTransactTime = null;
    }

    @Override
    public IMessage toMessage(String aSID, IMessageFactory aFactory) {
        return this.toMessage(aSID, null, null, null, 0, aFactory);
    }

    @Override
    public IMessage toMessage(String aSID, String aTradingSessionID, String aTradingSessionSubID, String aRequestID, int aOptions, IMessageFactory aFactory) {
        String tssubid;
        String tsid;
        String req;
        String sid = aSID;
        if (sid == null) {
            sid = this.getSessionID();
        }
        if ((req = aRequestID) == null) {
            req = this.getMDReqID();
        }
        if ((tsid = aTradingSessionID) == null) {
            tsid = this.msTradingSessionID;
        }
        if ((tssubid = aTradingSessionSubID) == null) {
            tssubid = this.msTradingSessionSubID;
        }
        IMessage msg = aFactory.createMessage(sid, this.getType().getCode());
        msg.setValue("262", req);
        if (tsid != null) {
            msg.setValue("336", tsid);
        }
        if (tssubid != null) {
            msg.setValue("625", tssubid);
        }
        if (this.msFXCMCommandID != null) {
            msg.setValue("9028", this.msFXCMCommandID);
        }
        if (this.getRefMsgType() != null) {
            msg.setValue("372", this.getRefMsgType());
        }
        if (this.mBatchResponseRequired >= 0) {
            msg.setValue("9073", this.mBatchResponseRequired == 0 ? 0 : 1);
        }
        if (this.mContingencyType > 0) {
            msg.setValue("1385", this.mContingencyType);
        }
        if (this.mTransactTime != null) {
            msg.setValue("60", this.getTransactTime().toStringMs());
        } else {
            msg.setValue("60", UTCTimestamp.now().toStringMs());
        }
        if (this.mEmbMsgs == null) {
            IFieldGroupList grl = aFactory.createFieldGroupList();
            UTCTimestamp dummy = new UTCTimestamp(0L);
            Iterator it = this.responses().iterator();
            while (it.hasNext()) {
                ITransportable tobj = (ITransportable)it.next();
                boolean dummyset = false;
                if (tobj instanceof AFXCMMessage && ((AFXCMMessage)tobj).getTransactTime() == null) {
                    ((AFXCMMessage)tobj).setTransactTime(dummy);
                    dummyset = true;
                }
                IMessage m = tobj.toMessage(aSID, aTradingSessionID, aTradingSessionSubID, aRequestID, aOptions, aFactory);
                if (it.hasNext()) {
                    m.setValue("9020", 1);
                } else {
                    m.setValue("9020", 2);
                }
                grl.put(m);
                if (!dummyset) continue;
                ((AFXCMMessage)tobj).setTransactTime(null);
            }
            this.mEmbMsgs = grl;
        }
        if (this.mUseSerialization) {
            ByteArrayOutputStream bufValue = new ByteArrayOutputStream();
            try {
                ObjectOutputStream os = new ObjectOutputStream(bufValue);
                os.writeObject(this.mEmbMsgs);
                msg.setValue("9036", bufValue.toByteArray());
            }
            catch (IOException e) {
                cLog.error("BatchMessage.toMessage()", e);
            }
        } else {
            msg.setValue("9036", this.mEmbMsgs);
        }
        if (this.mRequestTopicID != null) {
            msg.setValue("9034", this.mRequestTopicID);
        }
        return msg;
    }

    @Override
    public boolean fill(IMessage aMsg) {
        byte[] bytesValue;
        IField value;
        if (aMsg == null) {
            return false;
        }
        this.reset();
        this.setSessionID(aMsg.getSessionID());
        this.setTradingSessionID(aMsg.getValueString("336"));
        this.setTradingSessionSubID(aMsg.getValueString("625"));
        this.setMDReqID(aMsg.getValueString("262"));
        this.mRequestTopicID = aMsg.getValueString("9034");
        this.setFXCMCommandID(aMsg.getValueString("9028"));
        this.setRefMsgType(aMsg.getValueString("372"));
        this.setContingencyType(aMsg.getValueInt("1385"));
        String s = aMsg.getValueString("9073");
        if (s != null && s.length() > 0) {
            this.setBatchResponseRequired("0".equals(s) ? 0 : 1);
        }
        if ((s = aMsg.getValueString("60")) != null) {
            this.setTransactTime(new UTCTimestamp(s));
        }
        if ((value = aMsg.getField("9036")).getDatatype() == IField.DATATYPE_LIST) {
            this.mEmbMsgs = value.getValueList();
        } else if (value.getDatatype().equals(IField.DATATYPE_BYTES) && (bytesValue = aMsg.getValueBytes("9036")) != null) {
            try {
                ObjectInputStream is = new ObjectInputStream(new ByteArrayInputStream(bytesValue));
                this.mEmbMsgs = (IFieldGroupList)is.readObject();
            }
            catch (IOException e) {
                cLog.error("BatchMessage.fill()", e);
            }
            catch (ClassNotFoundException e) {
                cLog.error("BatchMessage.fill()", e);
            }
        }
        return null != this.mEmbMsgs;
    }

    @Override
    public boolean update(IMessage aMsg) {
        return this.fill(aMsg);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public String toString() {
        return "msTradingSessionID='" + this.msTradingSessionID + "', msTradingSessionSubID='" + this.msTradingSessionSubID + "', msFXCMCommandID='" + this.msFXCMCommandID + "', mMDReqID='" + this.mMDReqID + "', mRefMsgType='" + this.mRefMsgType + "', mBatchResponseRequired='" + this.mBatchResponseRequired + "', mContingencyType=" + this.mContingencyType + ", mTransactTime=" + (this.mTransactTime == null ? "null" : this.mTransactTime.toStringMs());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ABatchMessage)) {
            return false;
        }
        ABatchMessage batchResponse = (ABatchMessage)o;
        if (this.responses() != null ? !this.responses().equals(batchResponse.responses()) : batchResponse.responses() != null) {
            return false;
        }
        if (!this.msTradingSessionID.equals(batchResponse.msTradingSessionID)) {
            return false;
        }
        return this.msTradingSessionSubID.equals(batchResponse.msTradingSessionSubID);
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getRequestID() {
        return this.getMDReqID();
    }

    public String getRequestTopicID() {
        return this.mRequestTopicID;
    }

    public void setRequestTopicID(String aRequestTopicID) {
        this.mRequestTopicID = aRequestTopicID;
    }

    public void useSerialization(boolean aUseSerialization) {
        this.mUseSerialization = aUseSerialization;
    }

    public String getSessionID() {
        return this.mSessionID;
    }

    public void setSessionID(String aSessionID) {
        this.mSessionID = aSessionID;
    }

    public String getRefMsgType() {
        return this.mRefMsgType;
    }

    public void setRefMsgType(String aRefMsgType) {
        this.mRefMsgType = aRefMsgType;
    }

    public int getBatchResponseRequired() {
        return this.mBatchResponseRequired;
    }

    public void setBatchResponseRequired(int aBatchResponseRequired) {
        this.mBatchResponseRequired = aBatchResponseRequired;
    }

    @Override
    public long getMakingTime() {
        return this.mMakingTime;
    }

    public int getContingencyType() {
        return this.mContingencyType;
    }

    public void setContingencyType(int aContingencyType) {
        this.mContingencyType = aContingencyType;
    }

    public void setTransactTime(UTCTimestamp aTransactTime) {
        this.mTransactTime = aTransactTime;
    }

    public UTCTimestamp getTransactTime() {
        return this.mTransactTime;
    }
}

