/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix;

import com.fxcm.fix.UTCDate;
import com.fxcm.fix.UTCTimeOnly;
import com.fxcm.util.DateTimeFormatterMs;
import com.fxcm.util.IDateTimeFormatter;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class UTCTimestamp
implements Comparable,
Serializable {
    private static final long serialVersionUID = 3520302584051153632L;
    private static final ThreadLocal<UTCTimestamp> cNow = new ThreadLocal<UTCTimestamp>(){

        @Override
        protected UTCTimestamp initialValue() {
            return new UTCTimestamp();
        }

        @Override
        public UTCTimestamp get() {
            UTCTimestamp now = (UTCTimestamp)super.get();
            now.setTime(0L);
            return now;
        }
    };
    protected long mlTimestamp = 0L;
    protected boolean mIsTick = true;
    protected static IDateTimeFormatter cFormater = null;
    protected static IDateTimeFormatter cFormaterMs = null;
    protected static IDateTimeFormatter cDateFormater = null;
    protected static IDateTimeFormatter cTimeFormatter = null;
    protected static IDateTimeFormatter cTickTimeFormatter = null;

    public static UTCTimestamp now() {
        return cNow.get();
    }

    protected IDateTimeFormatter getFormater() {
        return this.mIsTick ? cFormaterMs : cFormater;
    }

    protected IDateTimeFormatter getTimeOnlyFormater() {
        return this.mIsTick ? cTickTimeFormatter : cTimeFormatter;
    }

    protected IDateTimeFormatter getDateOnlyFormater() {
        return cDateFormater;
    }

    public UTCTimestamp() {
        this.setTime(0L);
    }

    public UTCTimestamp(UTCTimestamp aTimestamp) {
        if (aTimestamp == null) {
            this.setTime(0L);
        } else {
            this.mlTimestamp = aTimestamp.mlTimestamp;
        }
    }

    public UTCTimestamp(long aMlTimestamp) {
        this.mlTimestamp = aMlTimestamp;
    }

    public UTCTimestamp(UTCTimestamp aDate, UTCTimestamp aTime) {
        if (aDate != null) {
            long date = aDate.mlTimestamp;
            long time = aTime == null ? System.currentTimeMillis() : aTime.mlTimestamp;
            this.mlTimestamp = UTCTimestamp.mergeDateTime(date, time);
        } else {
            this.setTime(0L);
        }
    }

    public UTCTimestamp(String aTime) {
        long dt = 0L;
        if (aTime != null) {
            try {
                dt = cFormaterMs.parseUTCInMillis(aTime);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        this.setTime(dt);
    }

    public UTCTimestamp(Date aID) {
        this.setDate(aID);
    }

    public UTCTimestamp(String aTime, boolean aIsTick) {
        this.mIsTick = aIsTick;
        long dt = 0L;
        if (aTime != null) {
            try {
                dt = this.getFormater().parseUTCInMillis(aTime);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        this.setTime(dt);
    }

    public UTCTimestamp(UTCTimestamp aTime, boolean aIsTick) {
        this(aTime);
        this.mIsTick = aIsTick;
    }

    public boolean isTick() {
        return this.mIsTick;
    }

    public void setTick(boolean aTick) {
        this.mIsTick = aTick;
    }

    public String toString() {
        String ret = null;
        try {
            ret = this.getFormater().formatUTCInMillis(this.getTime());
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return ret;
    }

    public String toStringTimeOnly() {
        String ret = null;
        try {
            ret = this.getTimeOnlyFormater().formatUTCInMillis(this.getTime());
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return ret;
    }

    public String toStringDateOnly() {
        String ret = null;
        try {
            ret = this.getDateOnlyFormater().formatUTCInMillis(this.getTime());
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return ret;
    }

    public String toStringMs() {
        String ret = null;
        try {
            ret = cFormaterMs.formatUTCInMillis(this.getTime());
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return ret;
    }

    public Date toDate() {
        return new Date(this.mlTimestamp);
    }

    public long getTime() {
        return this.mlTimestamp;
    }

    public void setTime(long aTime) {
        this.mlTimestamp = aTime == 0L ? System.currentTimeMillis() : aTime;
    }

    public void setTime(String aTime) throws ParseException {
        this.mlTimestamp = aTime == null ? System.currentTimeMillis() : this.getFormater().parseUTCInMillis(aTime);
    }

    public void setTimeOnly(UTCTimeOnly aTimeOnly) {
        if (aTimeOnly != null) {
            this.setTimeOnly(aTimeOnly.getTime());
        }
    }

    public void setTimeOnly(long aTimeOnly) {
        this.mlTimestamp = aTimeOnly == 0L ? UTCTimestamp.mergeDateTime(this.mlTimestamp, System.currentTimeMillis()) : UTCTimestamp.mergeDateTime(this.mlTimestamp, aTimeOnly);
    }

    public void setTimeOnly(String aTimeOnly) throws ParseException {
        if (aTimeOnly != null) {
            this.mlTimestamp = this.getFormater().parseUTCInMillis(this.toStringDateOnly() + "-" + aTimeOnly);
        }
    }

    public void setDateOnly(UTCDate aDateOnly) {
        if (aDateOnly != null) {
            this.setDateOnly(aDateOnly.getTime());
        }
    }

    public void setDateOnly(long aDateOnly) {
        this.mlTimestamp = aDateOnly == 0L ? UTCTimestamp.mergeDateTime(System.currentTimeMillis(), this.mlTimestamp) : UTCTimestamp.mergeDateTime(aDateOnly, this.mlTimestamp);
    }

    public void setDateOnly(String aDateOnly) throws ParseException {
        if (aDateOnly != null) {
            this.mlTimestamp = this.getFormater().parseUTCInMillis(aDateOnly + "-" + this.toStringTimeOnly());
        }
    }

    public UTCTimestamp addDuration(long aMsec) {
        this.mlTimestamp += aMsec;
        return this;
    }

    public boolean equals(Object aObj) {
        boolean ret = false;
        if (aObj != null && aObj instanceof UTCTimestamp) {
            ret = this.getTime() == ((UTCTimestamp)aObj).getTime();
        }
        return ret;
    }

    public int compareTo(Object aObj) {
        int ret = -1;
        if (aObj != null && aObj instanceof UTCTimestamp) {
            if (this.getTime() == ((UTCTimestamp)aObj).getTime()) {
                ret = 0;
            } else if (this.getTime() > ((UTCTimestamp)aObj).getTime()) {
                ret = 1;
            }
        }
        return ret;
    }

    public void setDate(Date aTime) {
        this.mlTimestamp = aTime == null ? System.currentTimeMillis() : aTime.getTime();
    }

    public String toString(int aTimeZone) {
        Object tz = "GMT";
        if (aTimeZone > 0) {
            tz = (String)tz + "+";
        }
        tz = (String)tz + aTimeZone + ":00";
        SimpleDateFormat sdf = new SimpleDateFormat(this.getFormater().getFormatAsString());
        sdf.setTimeZone(TimeZone.getTimeZone((String)tz));
        return sdf.format(this.toDate());
    }

    public Date toDateRef() {
        return this.toDate();
    }

    public Date toDate(int aTimeZone) {
        return this.toDate();
    }

    public static int getLocalTimeZone() {
        Calendar cal = Calendar.getInstance();
        return (cal.get(16) + cal.get(15)) / 3600000;
    }

    public Date getLocalDate() {
        return this.toDate();
    }

    public void setLocalDate(Date aLocalTime) {
        this.setDate(aLocalTime);
    }

    private static long mergeDateTime(long aDate, long aTime) {
        int mask = 86400000;
        long dt = aDate / (long)mask;
        long ti = aTime % (long)mask;
        return (dt *= (long)mask) + ti;
    }

    static {
        try {
            cFormater = new DateTimeFormatterMs(5);
            cFormaterMs = new DateTimeFormatterMs(3);
            cDateFormater = new DateTimeFormatterMs(2);
            cTimeFormatter = new DateTimeFormatterMs(4);
            cTickTimeFormatter = new DateTimeFormatterMs(1);
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
        }
    }
}

