/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix;

import com.fxcm.fix.Instrument;
import com.fxcm.fix.NotDefinedException;

public class TradingSecurity
extends Instrument {
    protected String mCurrency;
    protected double mRoundLot;
    protected double mFXCMSymInterestBuy;
    protected double mFXCMSymInterestSell;
    protected String mFXCMSubscriptionStatus;

    public TradingSecurity() {
    }

    public TradingSecurity(String aSymbol, int aFXCMSymID, int aFXCMSymPrecision, String aCurrency, double aRoundLot) {
        super(aSymbol, aFXCMSymID, aFXCMSymPrecision);
        this.mCurrency = aCurrency;
        this.mRoundLot = aRoundLot;
        this.mFXCMSymInterestBuy = 0.0;
        this.mFXCMSymInterestSell = 0.0;
    }

    public TradingSecurity(String aSymbol, int aFXCMSymID, int aFXCMSymPrecision, double aFXCMSymPointSize, int aFXCMSymSortOrder, String aCurrency, double aRoundLot) {
        super(aSymbol, aFXCMSymID, aFXCMSymPrecision, aFXCMSymPointSize, aFXCMSymSortOrder);
        this.mCurrency = aCurrency;
        this.mRoundLot = aRoundLot;
        this.mFXCMSymInterestBuy = 0.0;
        this.mFXCMSymInterestSell = 0.0;
    }

    public String getFXCMSubscriptionStatus() {
        return this.mFXCMSubscriptionStatus;
    }

    public void setFXCMSubscriptionStatus(String aFXCMSubscriptionStatus) {
        this.mFXCMSubscriptionStatus = aFXCMSubscriptionStatus;
    }

    public String getCurrency() throws NotDefinedException {
        if (this.mCurrency == null) {
            throw new NotDefinedException("Currency not defined");
        }
        return this.mCurrency;
    }

    public double getRoundLot() throws NotDefinedException {
        if (this.mRoundLot == 0.0) {
            throw new NotDefinedException("RoundLot not defined");
        }
        return this.mRoundLot;
    }

    public void setCurrency(String aCurrency) {
        this.mCurrency = aCurrency;
    }

    public void setRoundLot(double aRoundLot) {
        this.mRoundLot = aRoundLot;
    }

    public double getFXCMSymInterestBuy() {
        return this.mFXCMSymInterestBuy;
    }

    public void setFXCMSymInterestBuy(double aFXCMSymInterestBuy) {
        this.mFXCMSymInterestBuy = aFXCMSymInterestBuy;
    }

    public double getFXCMSymInterestSell() {
        return this.mFXCMSymInterestSell;
    }

    public void setFXCMSymInterestSell(double aFXCMSymInterestSell) {
        this.mFXCMSymInterestSell = aFXCMSymInterestSell;
    }

    @Override
    public boolean fill(Instrument aOrig) {
        boolean ret = false;
        try {
            if (aOrig != null && super.fill(aOrig) && aOrig instanceof TradingSecurity) {
                TradingSecurity ts = (TradingSecurity)aOrig;
                this.mFXCMSymInterestBuy = ts.getFXCMSymInterestBuy();
                this.mFXCMSymInterestSell = ts.getFXCMSymInterestSell();
                if (ts.getCurrency() != null) {
                    this.mCurrency = ts.getCurrency();
                }
                if (ts.getRoundLot() != 0.0) {
                    this.mRoundLot = ts.getRoundLot();
                }
                if (ts.getFXCMSubscriptionStatus() != null) {
                    this.mFXCMSubscriptionStatus = ts.getFXCMSubscriptionStatus();
                }
                ret = true;
            }
        }
        catch (NotDefinedException notDefinedException) {
            // empty catch block
        }
        return ret;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("TradingSecurity");
        sb.append(" --- begin superclass toString ");
        sb.append(super.toString());
        sb.append(" --- end superclass toString ");
        sb.append("{mCurrency='").append(this.mCurrency).append('\'');
        sb.append(", mRoundLot=").append(this.mRoundLot);
        sb.append(", mFXCMSymInterestBuy=").append(this.mFXCMSymInterestBuy);
        sb.append(", mFXCMSymInterestSell=").append(this.mFXCMSymInterestSell);
        sb.append(", mFXCMSubscriptionStatus='").append(this.mFXCMSubscriptionStatus).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

