/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix;

import com.fxcm.entity.ACode;
import com.fxcm.fix.ITradSesStatus;
import java.util.HashMap;
import java.util.Map;

public class TradSesStatusFactory {
    private static final Map cStatus = new HashMap();
    public static final ITradSesStatus UNKNOWN = new Adaptor(0, "Unknown", 0);
    public static final ITradSesStatus HALTED = new Adaptor(1, "Halted", 4);
    public static final ITradSesStatus OPEN = new Adaptor(2, "Open", 1);
    public static final ITradSesStatus CLOSED = new Adaptor(3, "Closed", 4);
    public static final ITradSesStatus PREOPEN = new Adaptor(4, "Pre-Open", 12);
    public static final ITradSesStatus PRECLOSE = new Adaptor(5, "Pre-Close", 1);
    public static final ITradSesStatus REQUESTREJECTED = new Adaptor(6, "Request Rejected", 6);

    public static ITradSesStatus toStatus(int aCode) {
        return (ITradSesStatus)cStatus.get(String.valueOf(aCode));
    }

    private static class Adaptor
    extends ACode
    implements ITradSesStatus {
        int mMode = 0;

        protected Adaptor(int aCode, String aLabel, int aMode) {
            super(String.valueOf(aCode), aLabel, aLabel);
            this.mMode = aMode;
            cStatus.put(String.valueOf(aCode), this);
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        @Override
        public String toString() {
            return "TradSesStatus:" + this.getLabel() + " (" + this.getCode() + ")";
        }

        @Override
        public boolean isActive() {
            return (this.mMode & 1) > 0;
        }

        @Override
        public boolean isDeleted() {
            return (this.mMode & 2) > 0;
        }

        @Override
        public boolean isInactive() {
            return (this.mMode & 4) > 0;
        }

        @Override
        public boolean isInitial() {
            return (this.mMode & 8) > 0;
        }
    }
}

