/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix;

import com.fxcm.fix.ISide;
import com.fxcm.fix.SideFactory;

public class PositionQty {
    protected double mLongQty;
    protected double mShortQty;

    public PositionQty() {
    }

    public PositionQty(double aLongQty, double aShortQty) {
        this.setLongQty(aLongQty);
        this.setShortQty(aShortQty);
    }

    public PositionQty(ISide aSide, double aQty) {
        if (aSide == SideFactory.SELL) {
            this.setShortQty(aQty);
        } else if (aSide == SideFactory.BUY) {
            this.setLongQty(aQty);
        }
    }

    public ISide getSide() {
        ISide ret = SideFactory.BUY;
        if (this.getLongQty() == 0.0) {
            ret = SideFactory.SELL;
        }
        return ret;
    }

    public double getShortQty() {
        return this.mShortQty;
    }

    public double getLongQty() {
        return this.mLongQty;
    }

    public double getQty() {
        double ret = this.getLongQty();
        if (this.getLongQty() == 0.0) {
            ret = this.getShortQty();
        }
        return ret;
    }

    public void setSideQty(ISide aSide, double aQty) {
        this.mLongQty = 0.0;
        this.mShortQty = 0.0;
        if (aSide == SideFactory.BUY) {
            this.mLongQty = aQty;
        } else if (aSide == SideFactory.SELL) {
            this.mShortQty = aQty;
        }
    }

    public void setShortQty(double aShortQty) {
        this.mShortQty = aShortQty;
        this.mLongQty = 0.0;
    }

    public void setLongQty(double aLongQty) {
        this.mLongQty = aLongQty;
        this.mShortQty = 0.0;
    }

    public boolean equals(Object aObj) {
        boolean ret = false;
        try {
            if (aObj instanceof PositionQty) {
                PositionQty p = (PositionQty)aObj;
                ret = p.getLongQty() == this.getLongQty() && p.getShortQty() == this.getShortQty();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public boolean fill(PositionQty aOrig) {
        boolean ret = false;
        try {
            if (aOrig != null) {
                this.setLongQty(aOrig.getLongQty());
                this.setShortQty(aOrig.getShortQty());
                ret = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public String toString() {
        return "Position amount (" + this.getSide().getLabel() + ") " + this.getQty();
    }
}

