/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix;

import com.fxcm.fix.NotDefinedException;
import com.fxcm.messaging.IFieldGroup;
import com.fxcm.messaging.IFieldGroupList;
import com.fxcm.messaging.IMessageFactory;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class Party
implements Serializable {
    private static final long serialVersionUID = -5686958232269241601L;
    protected String mPartyId;
    protected String mPartyIdSource;
    protected String mPartyRole;
    protected Map mSubParties = new LinkedHashMap();

    public Party() {
    }

    public Party(String aPartyId, String aPartyIdSource, String aPartyRole) {
        this();
        this.setPartyId(aPartyId);
        this.setPartyIdSource(aPartyIdSource);
        this.setPartyRole(aPartyRole);
    }

    public String getPartyId() throws NotDefinedException {
        if (this.mPartyId == null) {
            throw new NotDefinedException("PartyID not defined");
        }
        return this.mPartyId;
    }

    public String getPartyIdSource() throws NotDefinedException {
        if (this.mPartyIdSource == null) {
            throw new NotDefinedException("PartyIdSource not defined");
        }
        return this.mPartyIdSource;
    }

    public String getPartyRole() throws NotDefinedException {
        if (this.mPartyRole == null) {
            throw new NotDefinedException("PartyRole not defined");
        }
        return this.mPartyRole;
    }

    public void setPartyId(String aPartyId) {
        this.mPartyId = aPartyId;
    }

    public void setPartyIdSource(String aPartyIdSource) {
        this.mPartyIdSource = aPartyIdSource;
    }

    public void setPartyRole(String aPartyRole) {
        this.mPartyRole = aPartyRole;
    }

    public Iterator getSubParties() {
        return this.mSubParties.values().iterator();
    }

    public void setSubParty(String aPartySubIdType, String aPartySubId) {
        if (aPartySubIdType != null) {
            if (aPartySubId == null) {
                this.mSubParties.remove(aPartySubIdType);
            } else {
                this.mSubParties.put(aPartySubIdType, new SubParty(aPartySubIdType, aPartySubId));
            }
        }
    }

    public String getPartySubId(String aPartySubIdType) {
        SubParty sp;
        String ret = null;
        if (aPartySubIdType != null && (sp = (SubParty)this.mSubParties.get(aPartySubIdType)) != null) {
            ret = sp.getPartySubId();
        }
        return ret;
    }

    public boolean fill(Party aOrig) {
        boolean ret = false;
        this.clear();
        try {
            if (aOrig != null) {
                this.setPartyId(aOrig.getPartyId());
                this.setPartyIdSource(aOrig.getPartyIdSource());
                this.setPartyRole(aOrig.getPartyRole());
                Iterator it = aOrig.getSubParties();
                while (it.hasNext()) {
                    SubParty sp = (SubParty)it.next();
                    this.setSubParty(sp.getPartySubIdType(), sp.getPartySubId());
                }
                ret = true;
            }
        }
        catch (NotDefinedException notDefinedException) {
            // empty catch block
        }
        return ret;
    }

    public boolean isValid() {
        return this.mPartyId != null && this.mPartyIdSource != null && this.mPartyRole != null;
    }

    public void clear() {
        this.mSubParties.clear();
        this.setPartyId(null);
        this.setPartyIdSource(null);
        this.setPartyRole(null);
    }

    public boolean fill(IFieldGroup aGroup) {
        this.clear();
        if (aGroup != null) {
            this.setPartyId(aGroup.getValueString("448"));
            this.setPartyIdSource(aGroup.getValueString("447"));
            this.setPartyRole(aGroup.getValueString("452"));
            IFieldGroupList lst = aGroup.getValueList("802");
            if (lst != null) {
                for (IFieldGroup group : lst.values()) {
                    this.setSubParty(group.getValueString("803"), group.getValueString("523"));
                }
            }
        }
        return this.isValid();
    }

    public IFieldGroup toGroup(IMessageFactory aFactory) {
        IFieldGroup ret = null;
        IFieldGroupList lst = null;
        if (this.isValid()) {
            try {
                ret = aFactory.createFieldGroup();
                ret.setValue("448", this.getPartyId());
                ret.setValue("447", this.getPartyIdSource());
                ret.setValue("452", this.getPartyRole());
                Iterator it = this.getSubParties();
                while (it.hasNext()) {
                    SubParty sp = (SubParty)it.next();
                    if (lst == null) {
                        lst = aFactory.createFieldGroupList();
                    }
                    IFieldGroup gr = aFactory.createFieldGroup();
                    gr.setValue("803", sp.getPartySubIdType());
                    gr.setValue("523", sp.getPartySubId());
                    lst.put(gr);
                    ret.setValue("802", lst);
                }
            }
            catch (NotDefinedException notDefinedException) {
                // empty catch block
            }
        }
        return ret;
    }

    public String toString() {
        String ret = "Party:" + this.mPartyRole + ":" + this.mPartyIdSource + ":" + this.mPartyId + "(";
        Iterator it = this.getSubParties();
        while (it.hasNext()) {
            SubParty sp = (SubParty)it.next();
            ret = ret + sp.getPartySubIdType() + ":" + sp.getPartySubId() + ";";
        }
        return ret + ")";
    }

    public static class SubParty
    implements Serializable {
        private static final long serialVersionUID = -6342790907030303315L;
        private String mPartySubID;
        private String mPartySubIDType;

        public SubParty(String aPartySubIDType, String aPartySubID) {
            this.mPartySubIDType = aPartySubIDType;
            this.mPartySubID = aPartySubID;
        }

        public String getPartySubIdType() {
            return this.mPartySubIDType;
        }

        public String getPartySubId() {
            return this.mPartySubID;
        }
    }
}

