/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix;

import com.fxcm.fix.Party;
import com.fxcm.messaging.IFieldGroup;
import com.fxcm.messaging.IFieldGroupList;
import com.fxcm.messaging.IMessageFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Parties
implements Serializable {
    protected static final String PARTY_FXCM_ID = "FXCM ID";
    protected static final String PARTY_ID_SOURCE_CUSTOM = "D";
    protected static final String PARTY_ROLE_CLIENT_ID = "3";
    protected static final String PARTY_SUBID_TYPE_PERSON = "2";
    protected static final String PARTY_SUBID_SECURITY_ACCT_NO = "10";
    protected static final String PARTY_SUBID_SECURITY_ACCT_NAME = "22";
    protected static final String PARTY_SUBID_ACCT_TYPE = "26";
    protected static final String PARTY_SUBID_FXCM_POSITION_MAINTENANCE = "4000";
    private static final long serialVersionUID = 1187236973252665329L;
    protected List mParties = new ArrayList();
    protected Party mFXCMParty;

    public Parties() {
        this.fillFXCMParty();
    }

    public void addParty(Party aParty) {
        if (aParty != null && aParty.isValid()) {
            try {
                this.mParties.add(aParty);
                if (PARTY_FXCM_ID.equals(aParty.getPartyId()) && PARTY_ID_SOURCE_CUSTOM.equals(aParty.getPartyIdSource()) && PARTY_ROLE_CLIENT_ID.equals(aParty.getPartyRole())) {
                    this.mFXCMParty = aParty;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Iterator getParties() {
        return this.mParties.iterator();
    }

    public boolean fill(Parties aOrig) {
        boolean ret = false;
        if (aOrig != null) {
            this.mParties.clear();
            ret = true;
            Iterator it = aOrig.getParties();
            while (it.hasNext()) {
                this.addParty((Party)it.next());
            }
        }
        return ret;
    }

    public boolean isValid() {
        boolean ret = true;
        Iterator it = this.getParties();
        while (ret && it.hasNext()) {
            ret = ((Party)it.next()).isValid();
        }
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Parties [");
        Iterator it = this.getParties();
        while (it.hasNext()) {
            sb.append(it.next()).append(";");
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean fill(IFieldGroupList aList) {
        this.clear();
        boolean ret = false;
        if (aList != null) {
            ret = true;
            Iterator<IFieldGroup> iterator = aList.values().iterator();
            while (iterator.hasNext()) {
                Party p = new Party();
                IFieldGroup group = iterator.next();
                ret = p.fill(group);
                if (!ret) continue;
                this.addParty(p);
            }
        }
        if (!ret) {
            this.clear();
        }
        return ret;
    }

    public IFieldGroupList toList(IMessageFactory aFactory) {
        IFieldGroupList ret = null;
        if (aFactory != null) {
            Iterator it = this.getParties();
            while (it.hasNext()) {
                Party p = (Party)it.next();
                IFieldGroup group = p.toGroup(aFactory);
                if (group == null) continue;
                if (ret == null) {
                    ret = aFactory.createFieldGroupList();
                }
                ret.put(group);
            }
        }
        return ret;
    }

    public void clear() {
        this.mParties.clear();
        this.mFXCMParty = null;
    }

    public String getFXCMTraderLoginId() {
        String ret = null;
        if (this.mFXCMParty != null) {
            ret = this.mFXCMParty.getPartySubId(PARTY_SUBID_TYPE_PERSON);
        }
        return ret;
    }

    public void setFXCMTraderLoginId(String aLoginID) {
        this.mFXCMParty.setSubParty(PARTY_SUBID_TYPE_PERSON, aLoginID);
    }

    public String getFXCMAcctName() {
        String ret = null;
        if (this.mFXCMParty != null) {
            ret = this.mFXCMParty.getPartySubId(PARTY_SUBID_SECURITY_ACCT_NAME);
        }
        return ret;
    }

    public void setFXCMAcctName(String aName) {
        this.mFXCMParty.setSubParty(PARTY_SUBID_SECURITY_ACCT_NAME, aName);
    }

    public long getFXCMAcctID() {
        String s;
        long ret = 0L;
        if (this.mFXCMParty != null && (s = this.mFXCMParty.getPartySubId(PARTY_SUBID_SECURITY_ACCT_NO)) != null) {
            try {
                ret = Long.parseLong(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }

    public void setFXCMAcctID(long aID) {
        this.mFXCMParty.setSubParty(PARTY_SUBID_SECURITY_ACCT_NO, String.valueOf(aID));
    }

    public String getFXCMPositionMaintenance() {
        String ret = null;
        if (this.mFXCMParty != null) {
            ret = this.mFXCMParty.getPartySubId(PARTY_SUBID_FXCM_POSITION_MAINTENANCE);
        }
        return ret;
    }

    public void setFXCMPositionMaintenance(String aValue) {
        this.mFXCMParty.setSubParty(PARTY_SUBID_FXCM_POSITION_MAINTENANCE, aValue);
    }

    public int getFXCMAcctType() {
        String s;
        int ret = 0;
        if (this.mFXCMParty != null && (s = this.mFXCMParty.getPartySubId(PARTY_SUBID_ACCT_TYPE)) != null) {
            try {
                ret = Integer.parseInt(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }

    public void setFXCMAcctType(int aType) {
        this.mFXCMParty.setSubParty(PARTY_SUBID_ACCT_TYPE, String.valueOf(aType));
    }

    protected void fillFXCMParty() {
        if (this.mFXCMParty == null) {
            this.mFXCMParty = new Party(PARTY_FXCM_ID, PARTY_ID_SOURCE_CUSTOM, PARTY_ROLE_CLIENT_ID);
            this.mParties.add(this.mFXCMParty);
        }
    }
}

