/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix;

import com.fxcm.entity.ACode;
import com.fxcm.entity.ICode;
import com.fxcm.fix.NotDefinedException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Hashtable;
import java.util.Locale;

public class Instrument {
    public static final ICode OBJ_TYPE = new InstrumentType();
    private static final Hashtable FORMATTERS = new Hashtable();
    protected String mCFICode;
    protected double mContractMultiplier;
    protected int mFactor;
    protected double mFXCMCondDistEntryLimit;
    protected double mFXCMCondDistEntryStop;
    protected double mFXCMCondDistLimit;
    protected double mFXCMCondDistStop;
    protected double mFXCMMaxQuantity;
    protected double mFXCMMinQuantity;
    protected int mFXCMProductID;
    protected int mFXCMSymID;
    protected double mFXCMSymPointSize;
    protected int mFXCMSymPrecision = -1;
    protected int mFXCMSymSortOrder;
    protected String mFXCMTradingStatus;
    protected int mProduct;
    protected String mSecurityType;
    protected String mSymbol;
    protected long mTouchTime;

    public Instrument() {
    }

    public Instrument(String aSymbol) {
        this.setSymbol(aSymbol);
    }

    public Instrument(String aSymbol, int aFXCMSymID, int aFXCMSymPrecision) {
        this.setSymbol(aSymbol);
        this.setFXCMSymID(aFXCMSymID);
        this.setFXCMSymPrecision(aFXCMSymPrecision);
    }

    public Instrument(String aSymbol, int aFXCMSymID, int aFXCMSymPrecision, double aFXCMSymPointSize, int aFXCMSymSortOrder) {
        this.setSymbol(aSymbol);
        this.setFXCMSymID(aFXCMSymID);
        this.setFXCMSymPrecision(aFXCMSymPrecision);
        this.setFXCMSymPointSize(aFXCMSymPointSize);
        this.setFXCMSymSortOrder(aFXCMSymSortOrder);
    }

    public boolean equals(Object aObj) {
        boolean ret = false;
        try {
            if (aObj instanceof Instrument) {
                Instrument instr = (Instrument)aObj;
                if (instr.getSymbol().equals(this.getSymbol())) {
                    ret = true;
                } else if (instr.getSymbol() != null && this.getSymbol() != null) {
                    ret = instr.getSymbol().equals(this.getSymbol());
                }
            }
        }
        catch (NotDefinedException notDefinedException) {
            // empty catch block
        }
        return ret;
    }

    public boolean fill(Instrument aOrig) {
        boolean ret;
        block21: {
            ret = false;
            try {
                if (aOrig == null) break block21;
                this.setSymbol(aOrig.getSymbol());
                if (aOrig.getFXCMSymID() != 0) {
                    this.setFXCMSymID(aOrig.getFXCMSymID());
                }
                try {
                    if (aOrig.getFXCMSymPrecision() >= 0) {
                        this.setFXCMSymPrecision(aOrig.getFXCMSymPrecision());
                    }
                }
                catch (NotDefinedException notDefinedException) {
                    // empty catch block
                }
                if (aOrig.getFXCMSymPointSize() != 0.0) {
                    this.setFXCMSymPointSize(aOrig.getFXCMSymPointSize());
                }
                if (aOrig.getFXCMSymSortOrder() != 0) {
                    this.setFXCMSymSortOrder(aOrig.getFXCMSymSortOrder());
                }
                if (aOrig.getProduct() != 0) {
                    this.setProduct(aOrig.getProduct());
                }
                if (aOrig.getContractMultiplier() != 0.0) {
                    this.setContractMultiplier(aOrig.getContractMultiplier());
                }
                if (aOrig.getFactor() != 0) {
                    this.setFactor(aOrig.getFactor());
                }
                if (aOrig.getCFICode() != null) {
                    this.setCFICode(aOrig.getCFICode());
                }
                if (aOrig.getFXCMProductID() != 0) {
                    this.setFXCMProductID(aOrig.getFXCMProductID());
                }
                if (aOrig.getSecurityType() != null) {
                    this.setSecurityType(aOrig.getSecurityType());
                }
                if (aOrig.getFXCMCondDistStop() != 0.0) {
                    this.setFXCMCondDistStop(aOrig.getFXCMCondDistStop());
                }
                if (aOrig.getFXCMCondDistLimit() != 0.0) {
                    this.setFXCMCondDistLimit(aOrig.getFXCMCondDistLimit());
                }
                if (aOrig.getFXCMCondDistEntryStop() != 0.0) {
                    this.setFXCMCondDistEntryStop(aOrig.getFXCMCondDistEntryStop());
                }
                if (aOrig.getFXCMCondDistEntryLimit() != 0.0) {
                    this.setFXCMCondDistEntryLimit(aOrig.getFXCMCondDistEntryLimit());
                }
                if (aOrig.getFXCMMaxQuantity() != 0.0) {
                    this.setFXCMMaxQuantity(aOrig.getFXCMMaxQuantity());
                }
                if (aOrig.getFXCMMinQuantity() != 0.0) {
                    this.setFXCMMinQuantity(aOrig.getFXCMMinQuantity());
                }
                if (aOrig.getFXCMTradingStatus() != null) {
                    this.setFXCMTradingStatus(aOrig.getFXCMTradingStatus());
                }
                ret = true;
            }
            catch (NotDefinedException notDefinedException) {
                // empty catch block
            }
        }
        return ret;
    }

    public String getCFICode() {
        return this.mCFICode;
    }

    public void setCFICode(String aCFICode) {
        this.mCFICode = aCFICode;
    }

    public double getContractMultiplier() {
        return this.mContractMultiplier;
    }

    public void setContractMultiplier(double aContractMultiplier) {
        this.mContractMultiplier = aContractMultiplier;
    }

    public int getFactor() {
        return this.mFactor;
    }

    public void setFactor(int aFactor) {
        this.mFactor = aFactor;
    }

    public double getFXCMCondDistEntryLimit() {
        return this.mFXCMCondDistEntryLimit;
    }

    public void setFXCMCondDistEntryLimit(double aFXCMCondDistEntryLimit) {
        this.mFXCMCondDistEntryLimit = aFXCMCondDistEntryLimit;
    }

    public double getFXCMCondDistEntryStop() {
        return this.mFXCMCondDistEntryStop;
    }

    public void setFXCMCondDistEntryStop(double aFXCMCondDistEntryStop) {
        this.mFXCMCondDistEntryStop = aFXCMCondDistEntryStop;
    }

    public double getFXCMCondDistLimit() {
        return this.mFXCMCondDistLimit;
    }

    public void setFXCMCondDistLimit(double aFXCMCondDistLimit) {
        this.mFXCMCondDistLimit = aFXCMCondDistLimit;
    }

    public double getFXCMCondDistStop() {
        return this.mFXCMCondDistStop;
    }

    public void setFXCMCondDistStop(double aFXCMCondDistStop) {
        this.mFXCMCondDistStop = aFXCMCondDistStop;
    }

    public double getFXCMMaxQuantity() {
        return this.mFXCMMaxQuantity;
    }

    public void setFXCMMaxQuantity(double aFXCMMaxQuantity) {
        this.mFXCMMaxQuantity = aFXCMMaxQuantity;
    }

    public double getFXCMMinQuantity() {
        return this.mFXCMMinQuantity;
    }

    public void setFXCMMinQuantity(double aFXCMMinQuantity) {
        this.mFXCMMinQuantity = aFXCMMinQuantity;
    }

    public int getFXCMProductID() {
        return this.mFXCMProductID;
    }

    public void setFXCMProductID(int aFXCMProductID) {
        this.mFXCMProductID = aFXCMProductID;
    }

    public int getFXCMSymID() {
        return this.mFXCMSymID;
    }

    public void setFXCMSymID(int aFXCMSymID) {
        this.mFXCMSymID = aFXCMSymID;
    }

    public double getFXCMSymPointSize() {
        return this.mFXCMSymPointSize;
    }

    public void setFXCMSymPointSize(double aFXCMSymPointSize) {
        this.mFXCMSymPointSize = aFXCMSymPointSize;
    }

    public int getFXCMSymPrecision() throws NotDefinedException {
        if (this.mFXCMSymPrecision == -1) {
            throw new NotDefinedException("FXCMSymPrecision not defined");
        }
        return this.mFXCMSymPrecision;
    }

    public void setFXCMSymPrecision(int aFXCMSymPrecision) {
        this.mFXCMSymPrecision = aFXCMSymPrecision;
    }

    public int getFXCMSymSortOrder() {
        return this.mFXCMSymSortOrder;
    }

    public void setFXCMSymSortOrder(int aFXCMSymSortOrder) {
        this.mFXCMSymSortOrder = aFXCMSymSortOrder;
    }

    public String getFXCMTradingStatus() {
        return this.mFXCMTradingStatus;
    }

    public void setFXCMTradingStatus(String aFXCMTradingStatus) {
        this.mFXCMTradingStatus = aFXCMTradingStatus;
    }

    private static DecimalFormat getPriceFormatter(int aPrecision) {
        String key = String.valueOf(aPrecision);
        DecimalFormat formatter = (DecimalFormat)FORMATTERS.get(key);
        if (formatter == null) {
            StringBuilder fs = new StringBuilder("##0.");
            for (int i = 0; i < aPrecision; ++i) {
                fs.append("0");
            }
            formatter = new DecimalFormat();
            formatter.applyPattern(fs.toString());
            formatter.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
            FORMATTERS.put(key, formatter);
        }
        return formatter;
    }

    public int getProduct() {
        return this.mProduct;
    }

    public void setProduct(int aProduct) {
        this.mProduct = aProduct;
    }

    public String getSecurityType() {
        return this.mSecurityType;
    }

    public void setSecurityType(String aSecurityType) {
        this.mSecurityType = aSecurityType;
    }

    public String getSymbol() throws NotDefinedException {
        if (this.mSymbol == null) {
            throw new NotDefinedException("Symbol not defined");
        }
        return this.mSymbol;
    }

    public void setSymbol(String aSymbol) {
        this.mSymbol = aSymbol;
    }

    public ICode getType() {
        return OBJ_TYPE;
    }

    public boolean isForex() {
        return this.mFXCMProductID == 1;
    }

    public boolean isIndex() {
        return this.mFXCMProductID == 2;
    }

    public boolean isCommodity() {
        return this.mFXCMProductID == 3;
    }

    public boolean isTreasury() {
        return this.mFXCMProductID == 4;
    }

    public boolean isBullion() {
        return this.mFXCMProductID == 5;
    }

    public boolean isValid() {
        return true;
    }

    public String priceToString(double aPx) {
        String ret;
        try {
            ret = Instrument.getPriceFormatter(this.getFXCMSymPrecision()).format(aPx);
        }
        catch (Exception e) {
            ret = Double.toString(aPx);
        }
        return ret;
    }

    public void printState(PrintStream aOut) {
        if (aOut == null) {
            System.out.println(this.toString());
        } else {
            aOut.println(this.toString());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Instrument");
        sb.append("{mCFICode='").append(this.mCFICode).append('\'');
        sb.append(", mContractMultiplier=").append(this.mContractMultiplier);
        sb.append(", mFactor=").append(this.mFactor);
        sb.append(", mFXCMCondDistEntryLimit=").append(this.mFXCMCondDistEntryLimit);
        sb.append(", mFXCMCondDistEntryStop=").append(this.mFXCMCondDistEntryStop);
        sb.append(", mFXCMCondDistLimit=").append(this.mFXCMCondDistLimit);
        sb.append(", mFXCMCondDistStop=").append(this.mFXCMCondDistStop);
        sb.append(", mFXCMMaxQuantity=").append(this.mFXCMMaxQuantity);
        sb.append(", mFXCMMinQuantity=").append(this.mFXCMMinQuantity);
        sb.append(", mFXCMProductID=").append(this.mFXCMProductID);
        sb.append(", mFXCMSymID=").append(this.mFXCMSymID);
        sb.append(", mFXCMSymPointSize=").append(this.mFXCMSymPointSize);
        sb.append(", mFXCMSymPrecision=").append(this.mFXCMSymPrecision);
        sb.append(", mFXCMSymSortOrder=").append(this.mFXCMSymSortOrder);
        sb.append(", mFXCMTradingStatus='").append(this.mFXCMTradingStatus).append('\'');
        sb.append(", mProduct=").append(this.mProduct);
        sb.append(", mSecurityType='").append(this.mSecurityType).append('\'');
        sb.append(", mSymbol='").append(this.mSymbol).append('\'');
        sb.append(", mTouchTime=").append(this.mTouchTime);
        sb.append('}');
        return sb.toString();
    }

    private static class InstrumentType
    extends ACode {
        private static final long serialVersionUID = -1629563334356765696L;

        InstrumentType() {
            super("INSTR", "InstrumentType", "");
        }
    }
}

