/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix;

import com.fxcm.fix.admin.Heartbeat;
import com.fxcm.fix.admin.Logout;
import com.fxcm.fix.admin.TestRequest;
import com.fxcm.fix.custom.BatchRequest;
import com.fxcm.fix.custom.BatchResponse;
import com.fxcm.fix.custom.FXCMRequest;
import com.fxcm.fix.custom.FXCMRequestReject;
import com.fxcm.fix.custom.FXCMResponse;
import com.fxcm.fix.custom.news.FXCMNewsRequest;
import com.fxcm.fix.custom.news.FXCMNewsTopicRequest;
import com.fxcm.fix.custom.news.FXCMNewsTopicResponse;
import com.fxcm.fix.custom.zdas.DasMessage;
import com.fxcm.fix.other.BusinessMessageReject;
import com.fxcm.fix.other.UserRequest;
import com.fxcm.fix.other.UserResponse;
import com.fxcm.fix.posttrade.ClosedPositionReport;
import com.fxcm.fix.posttrade.CollateralInquiry;
import com.fxcm.fix.posttrade.CollateralInquiryAck;
import com.fxcm.fix.posttrade.CollateralReport;
import com.fxcm.fix.posttrade.PositionReport;
import com.fxcm.fix.posttrade.RequestForPositions;
import com.fxcm.fix.posttrade.RequestForPositionsAck;
import com.fxcm.fix.pretrade.EMail;
import com.fxcm.fix.pretrade.MarketDataIncremental;
import com.fxcm.fix.pretrade.MarketDataRequest;
import com.fxcm.fix.pretrade.MarketDataRequestReject;
import com.fxcm.fix.pretrade.News;
import com.fxcm.fix.pretrade.Quote;
import com.fxcm.fix.pretrade.QuoteCancel;
import com.fxcm.fix.pretrade.QuoteRequest;
import com.fxcm.fix.pretrade.QuoteResponse;
import com.fxcm.fix.pretrade.SecurityList;
import com.fxcm.fix.pretrade.SecurityListRequest;
import com.fxcm.fix.pretrade.SecurityStatus;
import com.fxcm.fix.pretrade.SecurityStatusRequest;
import com.fxcm.fix.pretrade.TradingSessionStatusRequest;
import com.fxcm.fix.pretrade.inner.MarketDataSnapshot;
import com.fxcm.fix.pretrade.inner.TradingSessionStatus;
import com.fxcm.fix.trade.ExecutionReport;
import com.fxcm.fix.trade.OrderCancelReject;
import com.fxcm.fix.trade.OrderCancelReplaceRequest;
import com.fxcm.fix.trade.OrderCancelRequest;
import com.fxcm.fix.trade.OrderList;
import com.fxcm.fix.trade.OrderMassStatusRequest;
import com.fxcm.fix.trade.OrderSingle;
import com.fxcm.fix.trade.OrderStatusRequest;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.ITransportable;
import com.fxcm.util.logging.Utils;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;

public class FixObjectFactory {
    private static final Map<String, Long> cChannelSettings = new HashMap<String, Long>(){
        {
            this.put("0", 895L);
            this.put("W", 1L);
            this.put("X", 1L);
            this.put("h", 64L);
            this.put("B", 32L);
            this.put("C", 16L);
            this.put("AP", 4L);
            this.put("BA", 8L);
            this.put("8", 2L);
            this.put("f", 128L);
            this.put("R", 256L);
            this.put("S", 256L);
        }
    };
    private static final Log cLogger = Utils.getLog(FixObjectFactory.class);

    private static ITransportable convert(IMessage aMessage) {
        String msgType = aMessage.getMsgType();
        if ("A".equals(msgType)) {
            return new Logout();
        }
        if ("0".equals(msgType)) {
            return new Heartbeat();
        }
        if ("1".equals(msgType)) {
            return new TestRequest();
        }
        if ("U54.Batch".equals(msgType)) {
            return new BatchResponse();
        }
        if ("U54.Batch.Req".equals(msgType)) {
            return new BatchRequest();
        }
        if ("U54".equals(msgType)) {
            return new FXCMRequest();
        }
        if ("U55".equals(msgType)) {
            return new FXCMResponse();
        }
        if ("U52".equals(msgType)) {
            return new FXCMRequestReject();
        }
        if ("U50".equals(msgType)) {
            return new FXCMNewsRequest();
        }
        if ("U53".equals(msgType)) {
            return new FXCMNewsTopicResponse();
        }
        if ("U51".equals(msgType)) {
            return new FXCMNewsTopicRequest();
        }
        if ("U60".equals(msgType)) {
            return new DasMessage();
        }
        if ("BF".equals(msgType)) {
            return new UserResponse();
        }
        if ("BE".equals(msgType)) {
            return new UserRequest();
        }
        if ("j".equals(msgType)) {
            return new BusinessMessageReject();
        }
        if ("AP".equals(msgType)) {
            if (aMessage.getValueString("9044") != null) {
                return new ClosedPositionReport();
            }
            return new PositionReport();
        }
        if ("BA".equals(msgType)) {
            return new CollateralReport();
        }
        if ("BB".equals(msgType)) {
            return new CollateralInquiry();
        }
        if ("BG".equals(msgType)) {
            return new CollateralInquiryAck();
        }
        if ("AN".equals(msgType)) {
            return new RequestForPositions();
        }
        if ("AO".equals(msgType)) {
            return new RequestForPositionsAck();
        }
        if ("h".equals(msgType)) {
            return new TradingSessionStatus();
        }
        if ("W".equals(msgType)) {
            return new MarketDataSnapshot();
        }
        if ("X".equals(msgType)) {
            return new MarketDataIncremental();
        }
        if ("g".equals(msgType)) {
            return new TradingSessionStatusRequest();
        }
        if ("Y".equals(msgType)) {
            return new MarketDataRequestReject();
        }
        if ("V".equals(msgType)) {
            return new MarketDataRequest();
        }
        if ("S".equals(msgType)) {
            return new Quote();
        }
        if ("Z".equals(msgType)) {
            return new QuoteCancel();
        }
        if ("B".equals(msgType)) {
            return new News();
        }
        if ("R".equals(msgType)) {
            return new QuoteRequest();
        }
        if ("AJ".equals(msgType)) {
            return new QuoteResponse();
        }
        if ("C".equals(msgType)) {
            return new EMail();
        }
        if ("f".equals(msgType)) {
            return new SecurityStatus();
        }
        if ("e".equals(msgType)) {
            return new SecurityStatusRequest();
        }
        if ("x".equals(msgType)) {
            return new SecurityListRequest();
        }
        if ("y".equals(msgType)) {
            return new SecurityList();
        }
        if ("AF".equals(msgType)) {
            return new OrderMassStatusRequest();
        }
        if ("G".equals(msgType)) {
            return new OrderCancelReplaceRequest();
        }
        if ("F".equals(msgType)) {
            return new OrderCancelRequest();
        }
        if ("9".equals(msgType)) {
            return new OrderCancelReject();
        }
        if ("D".equals(msgType)) {
            return new OrderSingle();
        }
        if ("E".equals(msgType)) {
            return new OrderList();
        }
        if ("8".equals(msgType)) {
            return new ExecutionReport();
        }
        if ("H".equals(msgType)) {
            return new OrderStatusRequest();
        }
        return null;
    }

    public static ITransportable toObject(IMessage aMsg) {
        ITransportable ret = FixObjectFactory.convert(aMsg);
        if (ret != null) {
            try {
                ret.fill(aMsg);
            }
            catch (Exception e) {
                cLogger.error(e.getMessage(), e);
            }
        }
        return ret;
    }

    public static boolean isMsgReceiveOn(long aMsgFlags, long aMsgCode) {
        return (aMsgFlags & aMsgCode) != aMsgCode;
    }

    public static long getMessageChannel(String aMessageType) {
        Long channel = cChannelSettings.get(aMessageType);
        if (channel == null) {
            return 512L;
        }
        return channel;
    }
}

