/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix;

import com.fxcm.entity.ACode;
import com.fxcm.fix.IFXCMTimingInterval;
import com.fxcm.fix.UTCTimestamp;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.Vector;

public class FXCMTimingIntervalFactory {
    private static final int TIMING_INTERVAL_TRANS_COEFFIENT = 100;
    public static final String ROLLOVERTIMEZONECODE = "com.fxcm.fix.FXCMTimingIntervalFactory.RolloverTimezoneCode";
    private static String cRolloverTimezoneCode = "FXCM";
    private static Calendar cFXCMCalendar = null;
    private static Calendar cDBFXCalendar = null;
    private static Calendar cJapanCalendar = null;
    public static final IFXCMTimingInterval TICK;
    public static final IFXCMTimingInterval SEC10;
    public static final IFXCMTimingInterval MIN1;
    public static final IFXCMTimingInterval MIN5;
    public static final IFXCMTimingInterval MIN15;
    public static final IFXCMTimingInterval MIN30;
    public static final IFXCMTimingInterval HOUR1;
    public static final IFXCMTimingInterval HOUR2;
    public static final IFXCMTimingInterval HOUR3;
    public static final IFXCMTimingInterval HOUR4;
    public static final IFXCMTimingInterval HOUR6;
    public static final IFXCMTimingInterval HOUR8;
    public static final IFXCMTimingInterval DAY1;
    public static final IFXCMTimingInterval WEEK1;
    public static final IFXCMTimingInterval MONTH1;
    private static final Vector cIntervals;

    public static Vector getIntervals() {
        return cIntervals;
    }

    public static IFXCMTimingInterval toCode(int aNum) {
        IFXCMTimingInterval ret;
        switch (aNum) {
            case 0: {
                ret = TICK;
                break;
            }
            case 9: 
            case 900: {
                ret = SEC10;
                break;
            }
            case 1: 
            case 100: {
                ret = MIN1;
                break;
            }
            case 2: 
            case 200: {
                ret = MIN5;
                break;
            }
            case 3: 
            case 300: {
                ret = MIN15;
                break;
            }
            case 4: 
            case 400: {
                ret = MIN30;
                break;
            }
            case 5: 
            case 500: {
                ret = HOUR1;
                break;
            }
            case 502: {
                ret = HOUR2;
                break;
            }
            case 503: {
                ret = HOUR3;
                break;
            }
            case 504: {
                ret = HOUR4;
                break;
            }
            case 506: {
                ret = HOUR6;
                break;
            }
            case 508: {
                ret = HOUR8;
                break;
            }
            case 6: 
            case 600: {
                ret = DAY1;
                break;
            }
            case 7: 
            case 700: {
                ret = WEEK1;
                break;
            }
            case 8: 
            case 800: {
                ret = MONTH1;
                break;
            }
            default: {
                throw new RuntimeException("invalid interval code: " + aNum);
            }
        }
        return ret;
    }

    public static Calendar getTradingSessionCalendar() {
        Calendar ret = null;
        ret = "dbFX".equals(cRolloverTimezoneCode) ? (Calendar)cDBFXCalendar.clone() : ("Japan".equals(cRolloverTimezoneCode) ? (Calendar)cJapanCalendar.clone() : (Calendar)cFXCMCalendar.clone());
        return ret;
    }

    public static void setRolloverTimezoneCode(String aRolloverTimezoneCode) {
        cRolloverTimezoneCode = "dbFX".equalsIgnoreCase(aRolloverTimezoneCode) ? "dbFX" : ("Japan".equalsIgnoreCase(aRolloverTimezoneCode) ? "Japan" : "FXCM");
    }

    public static String getMappedDbIntervalCode(IFXCMTimingInterval aInterval) {
        return String.valueOf(aInterval.getIntCode() / 100);
    }

    public static int getMappedDbIntervalCodeMultiplier(IFXCMTimingInterval aInterval) {
        return aInterval.getIntCode() % 100;
    }

    public static IFXCMTimingInterval getDBTimingInterval(IFXCMTimingInterval aCurInterval, String aDBTimingIntervalCode) {
        IFXCMTimingInterval dbInterval = null;
        switch (aCurInterval.getIntCode()) {
            case 0: {
                dbInterval = aCurInterval;
                break;
            }
            case 900: {
                dbInterval = new Sec10(aDBTimingIntervalCode);
                break;
            }
            case 100: {
                dbInterval = new Min1(aDBTimingIntervalCode);
                break;
            }
            case 200: {
                dbInterval = new Min5(aDBTimingIntervalCode);
                break;
            }
            case 300: {
                dbInterval = new Min15(aDBTimingIntervalCode);
                break;
            }
            case 400: {
                dbInterval = new Min30(aDBTimingIntervalCode);
                break;
            }
            case 500: 
            case 502: 
            case 503: 
            case 504: 
            case 506: 
            case 508: {
                dbInterval = new Hour1(aDBTimingIntervalCode);
                break;
            }
            case 600: {
                dbInterval = new Day1(aDBTimingIntervalCode);
                break;
            }
            case 700: {
                dbInterval = new Week1(aDBTimingIntervalCode);
                break;
            }
            case 800: {
                dbInterval = new Month1(aDBTimingIntervalCode);
                break;
            }
            default: {
                throw new Error("Unsupported code provided: " + aCurInterval.getCode());
            }
        }
        return dbInterval;
    }

    public static IFXCMTimingInterval getDBInterval(IFXCMTimingInterval aInterval) {
        IFXCMTimingInterval dbInterval = null;
        String code = aInterval.getCode();
        String dbCode = null;
        if (code.length() == String.valueOf(1).length()) {
            dbInterval = aInterval;
        } else {
            dbCode = FXCMTimingIntervalFactory.getMappedDbIntervalCode(aInterval);
            dbInterval = FXCMTimingIntervalFactory.getDBTimingInterval(aInterval, dbCode);
        }
        return dbInterval;
    }

    public static IFXCMTimingInterval getStorageTimingInterval(IFXCMTimingInterval aDBInterval, String aStorageTimingIntervalCode) {
        IFXCMTimingInterval storageInterval = null;
        String dbCode = aDBInterval.getCode();
        if (dbCode.length() == String.valueOf(100).length()) {
            storageInterval = aDBInterval;
            return storageInterval;
        }
        switch (aDBInterval.getIntCode()) {
            case 0: {
                storageInterval = aDBInterval;
                break;
            }
            case 9: {
                storageInterval = new Sec10(aStorageTimingIntervalCode);
                break;
            }
            case 1: {
                storageInterval = new Min1(aStorageTimingIntervalCode);
                break;
            }
            case 2: {
                storageInterval = new Min5(aStorageTimingIntervalCode);
                break;
            }
            case 3: {
                storageInterval = new Min15(aStorageTimingIntervalCode);
                break;
            }
            case 4: {
                storageInterval = new Min30(aStorageTimingIntervalCode);
                break;
            }
            case 5: {
                int multiplier = Integer.parseInt(aStorageTimingIntervalCode) % 500;
                if (multiplier == 2) {
                    storageInterval = new Hour2(aStorageTimingIntervalCode);
                    break;
                }
                if (multiplier == 3) {
                    storageInterval = new Hour3(aStorageTimingIntervalCode);
                    break;
                }
                if (multiplier == 4) {
                    storageInterval = new Hour4(aStorageTimingIntervalCode);
                    break;
                }
                if (multiplier == 6) {
                    storageInterval = new Hour6(aStorageTimingIntervalCode);
                    break;
                }
                if (multiplier == 8) {
                    storageInterval = new Hour8(aStorageTimingIntervalCode);
                    break;
                }
                storageInterval = new Hour1(aStorageTimingIntervalCode);
                break;
            }
            case 6: {
                storageInterval = new Day1(aStorageTimingIntervalCode);
                break;
            }
            case 7: {
                storageInterval = new Week1(aStorageTimingIntervalCode);
                break;
            }
            case 8: {
                storageInterval = new Month1(aStorageTimingIntervalCode);
                break;
            }
            default: {
                throw new Error("Unsupported code provided: " + aDBInterval.getCode());
            }
        }
        return storageInterval;
    }

    public static int messageToStorageIntervalCode(int aMainCode, String aAuxCode) {
        int csIntervalCode = 0;
        switch (aMainCode) {
            case 0: {
                csIntervalCode = aMainCode;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                csIntervalCode = aMainCode * 100;
                break;
            }
            case 5: {
                if (aAuxCode.trim().equalsIgnoreCase("h2")) {
                    csIntervalCode = aMainCode * 100 + 2;
                    break;
                }
                if (aAuxCode.trim().equalsIgnoreCase("h3")) {
                    csIntervalCode = aMainCode * 100 + 3;
                    break;
                }
                if (aAuxCode.trim().equalsIgnoreCase("h4")) {
                    csIntervalCode = aMainCode * 100 + 4;
                    break;
                }
                if (aAuxCode.trim().equalsIgnoreCase("h6")) {
                    csIntervalCode = aMainCode * 100 + 6;
                    break;
                }
                if (aAuxCode.trim().equalsIgnoreCase("h8")) {
                    csIntervalCode = aMainCode * 100 + 8;
                    break;
                }
                csIntervalCode = aMainCode * 100;
                break;
            }
            default: {
                throw new Error("Unsupported codes provided: " + aMainCode + " and " + aAuxCode);
            }
        }
        return csIntervalCode;
    }

    public static String[] storageToMessageIntervalCodes(String aStorageCode) {
        String[] messageCodes = new String[2];
        int storageCodeInt = Integer.parseInt(aStorageCode);
        switch (storageCodeInt) {
            case 0: {
                messageCodes[0] = aStorageCode;
                messageCodes[1] = "";
                break;
            }
            case 100: 
            case 200: 
            case 300: 
            case 400: 
            case 500: 
            case 600: 
            case 700: 
            case 800: 
            case 900: {
                messageCodes[0] = String.valueOf(storageCodeInt / 100);
                messageCodes[1] = "";
                break;
            }
            case 502: {
                messageCodes[0] = String.valueOf(storageCodeInt / 100);
                messageCodes[1] = "h2";
                break;
            }
            case 503: {
                messageCodes[0] = String.valueOf(storageCodeInt / 100);
                messageCodes[1] = "h3";
                break;
            }
            case 504: {
                messageCodes[0] = String.valueOf(storageCodeInt / 100);
                messageCodes[1] = "h4";
                break;
            }
            case 506: {
                messageCodes[0] = String.valueOf(storageCodeInt / 100);
                messageCodes[1] = "h6";
                break;
            }
            case 508: {
                messageCodes[0] = String.valueOf(storageCodeInt / 100);
                messageCodes[1] = "h8";
                break;
            }
            default: {
                throw new Error("Unsupported code provided by CandleStorage: " + aStorageCode);
            }
        }
        return messageCodes;
    }

    static {
        TimeZone tz = (TimeZone)TimeZone.getTimeZone("America/New_York").clone();
        tz.setRawOffset(25200000 + tz.getRawOffset());
        cFXCMCalendar = Calendar.getInstance(tz);
        tz = (TimeZone)TimeZone.getTimeZone("Europe/London").clone();
        tz.setRawOffset(28800000 + tz.getRawOffset());
        cDBFXCalendar = Calendar.getInstance(tz);
        tz = (TimeZone)TimeZone.getTimeZone("Asia/Tokyo").clone();
        tz.setRawOffset(28800000 + tz.getRawOffset());
        cJapanCalendar = Calendar.getInstance(tz);
        FXCMTimingIntervalFactory.setRolloverTimezoneCode(System.getProperty(ROLLOVERTIMEZONECODE));
        TICK = new Tick();
        SEC10 = new Sec10();
        MIN1 = new Min1();
        MIN5 = new Min5();
        MIN15 = new Min15();
        MIN30 = new Min30();
        HOUR1 = new Hour1();
        HOUR2 = new Hour2();
        HOUR3 = new Hour3();
        HOUR4 = new Hour4();
        HOUR6 = new Hour6();
        HOUR8 = new Hour8();
        DAY1 = new Day1();
        WEEK1 = new Week1();
        MONTH1 = new Month1();
        cIntervals = new Vector();
        cIntervals.add(TICK);
        cIntervals.add(SEC10);
        cIntervals.add(MIN1);
        cIntervals.add(MIN5);
        cIntervals.add(MIN15);
        cIntervals.add(MIN30);
        cIntervals.add(HOUR1);
        cIntervals.add(HOUR2);
        cIntervals.add(HOUR3);
        cIntervals.add(HOUR4);
        cIntervals.add(HOUR6);
        cIntervals.add(HOUR8);
        cIntervals.add(DAY1);
        cIntervals.add(WEEK1);
        cIntervals.add(MONTH1);
    }

    private static class Month1
    extends ACode
    implements IFXCMTimingInterval {
        private static final long serialVersionUID = 1L;

        Month1(String code) {
            super(code, "1 Month", "");
        }

        Month1() {
            super(Integer.toString(800), "1 Month", "");
        }

        @Override
        public long getDuration(UTCTimestamp aTime) {
            Calendar calendar = FXCMTimingIntervalFactory.getTradingSessionCalendar();
            calendar.setTime(aTime.toDate());
            calendar.set(14, 0);
            calendar.set(13, 0);
            calendar.set(12, 0);
            calendar.set(11, 0);
            calendar.set(5, 1);
            long first = calendar.getTimeInMillis();
            calendar.add(2, 1);
            return calendar.getTimeInMillis() - first;
        }

        @Override
        public UTCTimestamp truncate(UTCTimestamp aTime) {
            return this.truncate(aTime.getTime());
        }

        @Override
        public UTCTimestamp truncate(long aTime) {
            Calendar calendar = FXCMTimingIntervalFactory.getTradingSessionCalendar();
            calendar.setTimeInMillis(aTime);
            calendar.set(14, 0);
            calendar.set(13, 0);
            calendar.set(12, 0);
            calendar.set(11, 0);
            calendar.set(5, 1);
            return new UTCTimestamp(calendar.getTimeInMillis());
        }

        @Override
        public int getIntCode() {
            if (this.getCode().length() == 1) {
                return 8;
            }
            return 800;
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        @Override
        public String toString() {
            return "FXCMTimingInterval:" + this.getLabel() + " (" + this.getCode() + ")";
        }
    }

    private static class Week1
    extends ACode
    implements IFXCMTimingInterval {
        private static final long serialVersionUID = 1L;

        Week1(String code) {
            super(code, "1 Week", "");
        }

        Week1() {
            super(Integer.toString(700), "1 Week", "");
        }

        @Override
        public long getDuration(UTCTimestamp aTime) {
            return 604800000L;
        }

        @Override
        public UTCTimestamp truncate(UTCTimestamp aTime) {
            return this.truncate(aTime.getTime());
        }

        @Override
        public UTCTimestamp truncate(long aTime) {
            Calendar calendar = FXCMTimingIntervalFactory.getTradingSessionCalendar();
            calendar.setTimeInMillis(aTime);
            calendar.set(14, 0);
            calendar.set(13, 0);
            calendar.set(12, 0);
            calendar.set(11, 0);
            calendar.set(7, 1);
            return new UTCTimestamp(calendar.getTimeInMillis());
        }

        @Override
        public int getIntCode() {
            if (this.getCode().length() == 1) {
                return 7;
            }
            return 700;
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        @Override
        public String toString() {
            return "FXCMTimingInterval:" + this.getLabel() + " (" + this.getCode() + ")";
        }
    }

    private static class Day1
    extends ACode
    implements IFXCMTimingInterval {
        private static final long serialVersionUID = 1L;

        Day1(String code) {
            super(code, "1 Day", "");
        }

        Day1() {
            super(Integer.toString(600), "1 Day", "");
        }

        @Override
        public long getDuration(UTCTimestamp aTime) {
            return 86400000L;
        }

        @Override
        public UTCTimestamp truncate(UTCTimestamp aTime) {
            return this.truncate(aTime.getTime());
        }

        @Override
        public UTCTimestamp truncate(long aTime) {
            Calendar calendar = FXCMTimingIntervalFactory.getTradingSessionCalendar();
            calendar.setTimeInMillis(aTime);
            calendar.set(14, 0);
            calendar.set(13, 0);
            calendar.set(12, 0);
            calendar.set(11, 0);
            return new UTCTimestamp(calendar.getTimeInMillis());
        }

        @Override
        public int getIntCode() {
            if (this.getCode().length() == 1) {
                return 6;
            }
            return 600;
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        @Override
        public String toString() {
            return "FXCMTimingInterval:" + this.getLabel() + " (" + this.getCode() + ")";
        }
    }

    private static class Hour8
    extends ACode
    implements IFXCMTimingInterval {
        private static final long serialVersionUID = 1L;

        Hour8(String code) {
            super(code, "8 Hours", "");
        }

        Hour8() {
            super(Integer.toString(508), "8 Hours", "");
        }

        @Override
        public long getDuration(UTCTimestamp aTime) {
            return 28800000L;
        }

        @Override
        public UTCTimestamp truncate(UTCTimestamp aTime) {
            return this.truncate(aTime.getTime());
        }

        @Override
        public UTCTimestamp truncate(long aTime) {
            Calendar calendar = FXCMTimingIntervalFactory.getTradingSessionCalendar();
            calendar.setTimeInMillis(aTime);
            int hour = calendar.get(11);
            hour = hour / 8 * 8;
            calendar.set(14, 0);
            calendar.set(13, 0);
            calendar.set(12, 0);
            calendar.set(11, hour);
            return new UTCTimestamp(calendar.getTimeInMillis());
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        @Override
        public String toString() {
            return "FXCMTimingInterval:" + this.getLabel() + " (" + this.getCode() + ")";
        }

        @Override
        public int getIntCode() {
            return 508;
        }
    }

    private static class Hour6
    extends ACode
    implements IFXCMTimingInterval {
        private static final long serialVersionUID = 1L;

        Hour6(String code) {
            super(code, "6 Hours", "");
        }

        Hour6() {
            super(Integer.toString(506), "6 Hours", "");
        }

        @Override
        public long getDuration(UTCTimestamp aTime) {
            return 21600000L;
        }

        @Override
        public UTCTimestamp truncate(UTCTimestamp aTime) {
            return this.truncate(aTime.getTime());
        }

        @Override
        public UTCTimestamp truncate(long aTime) {
            Calendar calendar = FXCMTimingIntervalFactory.getTradingSessionCalendar();
            calendar.setTimeInMillis(aTime);
            int hour = calendar.get(11);
            hour = hour / 6 * 6;
            calendar.set(14, 0);
            calendar.set(13, 0);
            calendar.set(12, 0);
            calendar.set(11, hour);
            return new UTCTimestamp(calendar.getTimeInMillis());
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        @Override
        public String toString() {
            return "FXCMTimingInterval:" + this.getLabel() + " (" + this.getCode() + ")";
        }

        @Override
        public int getIntCode() {
            return 506;
        }
    }

    private static class Hour4
    extends ACode
    implements IFXCMTimingInterval {
        private static final long serialVersionUID = 1L;

        Hour4(String code) {
            super(code, "4 Hours", "");
        }

        Hour4() {
            super(Integer.toString(504), "4 Hours", "");
        }

        @Override
        public long getDuration(UTCTimestamp aTime) {
            return 14400000L;
        }

        @Override
        public UTCTimestamp truncate(UTCTimestamp aTime) {
            return this.truncate(aTime.getTime());
        }

        @Override
        public UTCTimestamp truncate(long aTime) {
            Calendar calendar = FXCMTimingIntervalFactory.getTradingSessionCalendar();
            calendar.setTimeInMillis(aTime);
            int hour = calendar.get(11);
            hour = hour / 4 * 4;
            calendar.set(14, 0);
            calendar.set(13, 0);
            calendar.set(12, 0);
            calendar.set(11, hour);
            return new UTCTimestamp(calendar.getTimeInMillis());
        }

        @Override
        public int getIntCode() {
            return 504;
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        @Override
        public String toString() {
            return "FXCMTimingInterval:" + this.getLabel() + " (" + this.getCode() + ")";
        }
    }

    private static class Hour3
    extends ACode
    implements IFXCMTimingInterval {
        private static final long serialVersionUID = 1L;

        Hour3(String code) {
            super(code, "3 Hours", "");
        }

        Hour3() {
            super(Integer.toString(503), "3 Hours", "");
        }

        @Override
        public long getDuration(UTCTimestamp aTime) {
            return 10800000L;
        }

        @Override
        public UTCTimestamp truncate(UTCTimestamp aTime) {
            return this.truncate(aTime.getTime());
        }

        @Override
        public UTCTimestamp truncate(long aTime) {
            Calendar calendar = FXCMTimingIntervalFactory.getTradingSessionCalendar();
            calendar.setTimeInMillis(aTime);
            int hour = calendar.get(11);
            hour = hour / 3 * 3;
            calendar.set(14, 0);
            calendar.set(13, 0);
            calendar.set(12, 0);
            calendar.set(11, hour);
            return new UTCTimestamp(calendar.getTimeInMillis());
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        @Override
        public String toString() {
            return "FXCMTimingInterval:" + this.getLabel() + " (" + this.getCode() + ")";
        }

        @Override
        public int getIntCode() {
            return 503;
        }
    }

    private static class Hour2
    extends ACode
    implements IFXCMTimingInterval {
        private static final long serialVersionUID = 1L;

        Hour2(String code) {
            super(code, "2 Hours", "");
        }

        Hour2() {
            super(Integer.toString(502), "2 Hours", "");
        }

        @Override
        public long getDuration(UTCTimestamp aTime) {
            return 0x6DDD00L;
        }

        @Override
        public UTCTimestamp truncate(UTCTimestamp aTime) {
            return this.truncate(aTime.getTime());
        }

        @Override
        public UTCTimestamp truncate(long aTime) {
            Calendar calendar = FXCMTimingIntervalFactory.getTradingSessionCalendar();
            calendar.setTimeInMillis(aTime);
            int hour = calendar.get(11);
            hour = hour / 2 * 2;
            calendar.set(14, 0);
            calendar.set(13, 0);
            calendar.set(12, 0);
            calendar.set(11, hour);
            return new UTCTimestamp(calendar.getTimeInMillis());
        }

        @Override
        public int getIntCode() {
            return 502;
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        @Override
        public String toString() {
            return "FXCMTimingInterval:" + this.getLabel() + " (" + this.getCode() + ")";
        }
    }

    private static class Hour1
    extends ACode
    implements IFXCMTimingInterval {
        private static final long serialVersionUID = 1L;

        Hour1(String code) {
            super(code, "1 Hour", "");
        }

        Hour1() {
            super(Integer.toString(500), "1 Hour", "");
        }

        @Override
        public long getDuration(UTCTimestamp aTime) {
            return 3600000L;
        }

        @Override
        public UTCTimestamp truncate(UTCTimestamp aTime) {
            return this.truncate(aTime.getTime());
        }

        @Override
        public UTCTimestamp truncate(long aTime) {
            Calendar calendar = FXCMTimingIntervalFactory.getTradingSessionCalendar();
            calendar.setTimeInMillis(aTime);
            calendar.set(14, 0);
            calendar.set(13, 0);
            calendar.set(12, 0);
            return new UTCTimestamp(calendar.getTimeInMillis());
        }

        @Override
        public int getIntCode() {
            if (this.getCode().length() == 1) {
                return 5;
            }
            return 500;
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        @Override
        public String toString() {
            return "FXCMTimingInterval:" + this.getLabel() + " (" + this.getCode() + ")";
        }
    }

    private static class Min30
    extends ACode
    implements IFXCMTimingInterval {
        private static final long serialVersionUID = 1L;

        Min30(String code) {
            super(code, "30 Min", "");
        }

        Min30() {
            super(Integer.toString(400), "30 Min", "");
        }

        @Override
        public long getDuration(UTCTimestamp aTime) {
            return 1800000L;
        }

        @Override
        public UTCTimestamp truncate(UTCTimestamp aTime) {
            return this.truncate(aTime.getTime());
        }

        @Override
        public UTCTimestamp truncate(long aTime) {
            Calendar calendar = FXCMTimingIntervalFactory.getTradingSessionCalendar();
            calendar.setTimeInMillis(aTime);
            int min = calendar.get(12);
            min = min / 30 * 30;
            calendar.set(14, 0);
            calendar.set(13, 0);
            calendar.set(12, min);
            return new UTCTimestamp(calendar.getTimeInMillis());
        }

        @Override
        public int getIntCode() {
            if (this.getCode().length() == 1) {
                return 4;
            }
            return 400;
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        @Override
        public String toString() {
            return "FXCMTimingInterval:" + this.getLabel() + " (" + this.getCode() + ")";
        }
    }

    private static class Min15
    extends ACode
    implements IFXCMTimingInterval {
        private static final long serialVersionUID = 1L;

        Min15(String code) {
            super(code, "15 Min", "");
        }

        Min15() {
            super(Integer.toString(300), "15 Min", "");
        }

        @Override
        public long getDuration(UTCTimestamp aTime) {
            return 900000L;
        }

        @Override
        public UTCTimestamp truncate(UTCTimestamp aTime) {
            return this.truncate(aTime.getTime());
        }

        @Override
        public UTCTimestamp truncate(long aTime) {
            Calendar calendar = FXCMTimingIntervalFactory.getTradingSessionCalendar();
            calendar.setTimeInMillis(aTime);
            int min = calendar.get(12);
            min = min / 15 * 15;
            calendar.set(14, 0);
            calendar.set(13, 0);
            calendar.set(12, min);
            return new UTCTimestamp(calendar.getTimeInMillis());
        }

        @Override
        public int getIntCode() {
            if (this.getCode().length() == 1) {
                return 3;
            }
            return 300;
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        @Override
        public String toString() {
            return "FXCMTimingInterval:" + this.getLabel() + " (" + this.getCode() + ")";
        }
    }

    private static class Min5
    extends ACode
    implements IFXCMTimingInterval {
        private static final long serialVersionUID = 1L;

        Min5(String code) {
            super(code, "5 Min", "");
        }

        Min5() {
            super(Integer.toString(200), "5 Min", "");
        }

        @Override
        public long getDuration(UTCTimestamp aTime) {
            return 300000L;
        }

        @Override
        public UTCTimestamp truncate(UTCTimestamp aTime) {
            return this.truncate(aTime.getTime());
        }

        @Override
        public UTCTimestamp truncate(long aTime) {
            Calendar calendar = FXCMTimingIntervalFactory.getTradingSessionCalendar();
            calendar.setTimeInMillis(aTime);
            int min = calendar.get(12);
            min = min / 5 * 5;
            calendar.set(14, 0);
            calendar.set(13, 0);
            calendar.set(12, min);
            return new UTCTimestamp(calendar.getTimeInMillis());
        }

        @Override
        public int getIntCode() {
            if (this.getCode().length() == 1) {
                return 2;
            }
            return 200;
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        @Override
        public String toString() {
            return "FXCMTimingInterval:" + this.getLabel() + " (" + this.getCode() + ")";
        }
    }

    private static class Min1
    extends ACode
    implements IFXCMTimingInterval {
        private static final long serialVersionUID = 1L;

        Min1(String code) {
            super(code, "1 Min", "");
        }

        Min1() {
            super(Integer.toString(100), "1 Min", "");
        }

        @Override
        public long getDuration(UTCTimestamp aTime) {
            return 60000L;
        }

        @Override
        public UTCTimestamp truncate(UTCTimestamp aTime) {
            return this.truncate(aTime.getTime());
        }

        @Override
        public UTCTimestamp truncate(long aTime) {
            Calendar calendar = FXCMTimingIntervalFactory.getTradingSessionCalendar();
            calendar.setTimeInMillis(aTime);
            calendar.set(14, 0);
            calendar.set(13, 0);
            return new UTCTimestamp(calendar.getTimeInMillis());
        }

        @Override
        public int getIntCode() {
            if (this.getCode().length() == 1) {
                return 1;
            }
            return 100;
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        @Override
        public String toString() {
            return "FXCMTimingInterval:" + this.getLabel() + " (" + this.getCode() + ")";
        }
    }

    private static class Sec10
    extends ACode
    implements IFXCMTimingInterval {
        private static final long serialVersionUID = 1L;

        Sec10(String code) {
            super(code, "10 Sec", "");
        }

        Sec10() {
            super(Integer.toString(900), "10 Sec", "");
        }

        @Override
        public long getDuration(UTCTimestamp aTime) {
            return 10000L;
        }

        @Override
        public UTCTimestamp truncate(UTCTimestamp aTime) {
            return this.truncate(aTime.getTime());
        }

        @Override
        public UTCTimestamp truncate(long aTime) {
            Calendar calendar = FXCMTimingIntervalFactory.getTradingSessionCalendar();
            calendar.setTimeInMillis(aTime);
            int sec = calendar.get(13);
            sec = sec / 10 * 10;
            calendar.set(14, 0);
            calendar.set(13, sec);
            return new UTCTimestamp(calendar.getTimeInMillis());
        }

        @Override
        public int getIntCode() {
            if (this.getCode().length() == 1) {
                return 9;
            }
            return 900;
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        @Override
        public String toString() {
            return "FXCMTimingInterval:" + this.getLabel() + " (" + this.getCode() + ")";
        }
    }

    private static class Tick
    extends ACode
    implements IFXCMTimingInterval {
        private static final long serialVersionUID = 1L;

        Tick(String code) {
            super(code, "Tick", "");
        }

        Tick() {
            super(Integer.toString(0), "Tick", "");
        }

        @Override
        public long getDuration(UTCTimestamp aTime) {
            return 0L;
        }

        @Override
        public UTCTimestamp truncate(UTCTimestamp aTime) {
            return this.truncate(aTime.getTime());
        }

        @Override
        public UTCTimestamp truncate(long aTime) {
            return new UTCTimestamp(aTime);
        }

        @Override
        public int getIntCode() {
            if (this.getCode().length() == 1) {
                return 0;
            }
            return 0;
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        @Override
        public String toString() {
            return "FXCMTimingInterval:" + this.getLabel() + " (" + this.getCode() + ")";
        }
    }
}

