/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix;

import com.fxcm.entity.ACode;
import com.fxcm.fix.IFXCMOrdStatus;
import java.util.HashMap;
import java.util.Map;

public class FXCMOrdStatusFactory {
    private static final Map cStatus = new HashMap();
    public static final IFXCMOrdStatus WAITING = new Adaptor("W", "Waiting", 1);
    public static final IFXCMOrdStatus INPROCESS = new Adaptor("P", "In process", 1);
    public static final IFXCMOrdStatus DEALER_INTERVENTION = new Adaptor("I", "Dealer intervention", 1);
    public static final IFXCMOrdStatus REQUOTED = new Adaptor("Q", "Requoted", 6);
    public static final IFXCMOrdStatus EXECUTING = new Adaptor("E", "Executing", 1);
    public static final IFXCMOrdStatus CANCELLED = new Adaptor("C", "Cancelled", 6);
    public static final IFXCMOrdStatus REJECTED = new Adaptor("R", "Rejected", 6);
    public static final IFXCMOrdStatus EXPIRED = new Adaptor("T", "Expired", 6);
    public static final IFXCMOrdStatus EXECUTED = new Adaptor("F", "Executed", 6);
    public static final IFXCMOrdStatus PEDNING_CALCULATED = new Adaptor("U", "Pending Calculated", 1);
    public static final IFXCMOrdStatus PENDING_CANCEL = new Adaptor("S", "Pending Cancel", 1);
    public static final IFXCMOrdStatus PENDING_CANCEL_CALCULATED = new Adaptor("H", "Pending Cancel Calculated", 1);

    public static IFXCMOrdStatus toCode(String aCode) {
        return (IFXCMOrdStatus)cStatus.get(aCode);
    }

    private static class Adaptor
    extends ACode
    implements IFXCMOrdStatus {
        int mMode = 0;

        protected Adaptor(String aCode, String aLabel, int aMode) {
            super(aCode, aLabel, aLabel);
            this.mMode = aMode;
            cStatus.put(aCode, this);
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        @Override
        public String toString() {
            return "FXCMOrdStatus:" + this.getLabel() + " (" + this.getCode() + ")";
        }

        @Override
        public boolean isActive() {
            return (this.mMode & 1) > 0;
        }

        @Override
        public boolean isDeleted() {
            return (this.mMode & 2) > 0;
        }

        @Override
        public boolean isInactive() {
            return (this.mMode & 4) > 0;
        }

        @Override
        public boolean isInitial() {
            return (this.mMode & 8) > 0;
        }
    }
}

