/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix;

import com.fxcm.entity.ACode;
import com.fxcm.fix.IExecType;
import com.fxcm.fix.OrdStatusFactory;
import java.util.HashMap;
import java.util.Map;

public class ExecTypeFactory {
    private static final Map TYPES = new HashMap();
    public static final IExecType NEW = OrdStatusFactory.NEW;
    public static final IExecType DONE_FOR_DAY = OrdStatusFactory.DONE_FOR_DAY;
    public static final IExecType CANCELLED = OrdStatusFactory.CANCELLED;
    public static final IExecType REPLACED = OrdStatusFactory.REPLACED;
    public static final IExecType PENDING_CANCEL = OrdStatusFactory.PENDING_CANCEL;
    public static final IExecType STOPPED = OrdStatusFactory.STOPPED;
    public static final IExecType REJECTED = OrdStatusFactory.REJECTED;
    public static final IExecType PENDING_NEW = OrdStatusFactory.PENDING_NEW;
    public static final IExecType CALCULATED = OrdStatusFactory.CALCULATED;
    public static final IExecType EXPIRED = OrdStatusFactory.EXPIRED;
    public static final IExecType PENDING_REPLACE = OrdStatusFactory.PENDING_REPLACE;
    public static final IExecType TRADE = new Adaptor("F", "Trade");
    public static final IExecType ORDER_STATUS = new Adaptor("I", "OrderStatus");

    public static IExecType toCode(String aCode) {
        IExecType ret = TYPES.get(aCode) != null ? (IExecType)TYPES.get(aCode) : OrdStatusFactory.toCode(aCode);
        return ret;
    }

    private static class Adaptor
    extends ACode
    implements IExecType {
        protected Adaptor(String aCode, String aLabel) {
            super(aCode, aLabel, aLabel);
            TYPES.put(aCode, this);
        }

        @Override
        public boolean equals(Object aObj) {
            return this == aObj;
        }

        @Override
        public String toString() {
            return "ExecType:" + this.getLabel() + " (" + this.getCode() + ")";
        }
    }
}

