/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.fix;

import com.fxcm.fix.IFixDefs;
import com.fxcm.fix.Instrument;
import com.fxcm.fix.Parties;
import com.fxcm.fix.UTCTimestamp;
import com.fxcm.messaging.IFieldGroup;
import com.fxcm.messaging.IFieldGroupList;
import com.fxcm.messaging.IMessage;
import com.fxcm.messaging.IMessageFactory;
import com.fxcm.messaging.ITransportable;
import com.fxcm.messaging.util.ThreadSafeNumberFormat;
import java.text.DecimalFormat;

public abstract class ATradeTransportable
implements ITransportable,
IFixDefs {
    protected String mAccount;
    protected String mOrderID;
    protected String mClOrdID;
    protected String mSecondaryClOrdID;
    protected Instrument mInstrument;
    protected Parties mParties;
    protected String mTradingSessionID;
    protected String mTradingSessionSubID;
    protected UTCTimestamp mTransactTime;
    private long mMakingTime = System.currentTimeMillis();
    private final DecimalFormat NUMBER_FORMATTER = new ThreadSafeNumberFormat().getInstance();

    protected ATradeTransportable() {
        this.reset();
    }

    protected void fillTradingSessionIDs(IFieldGroup aGroup) {
        this.setTradingSessionID(aGroup.getValueString("336"));
        this.setTradingSessionSubID(aGroup.getValueString("625"));
    }

    @Override
    public boolean fill(IMessage aMsg) {
        return this.fill((IFieldGroup)aMsg);
    }

    public boolean fill(IFieldGroup aGrp) {
        this.reset();
        if (aGrp.getValueString("55") != null) {
            this.setInstrument(new Instrument(aGrp.getValueString("55"), aGrp.getValueInt("9000"), -1));
        }
        if (aGrp.getValueString("60") != null) {
            this.setTransactTime(new UTCTimestamp(aGrp.getValueString("60")));
        }
        this.fillTradingSessionIDs(aGrp);
        this.setOrderID(aGrp.getValueString("37"));
        this.setClOrdID(aGrp.getValueString("11"));
        this.setSecondaryClOrdID(aGrp.getValueString("526"));
        this.setAccount(aGrp.getValueString("1"));
        this.mParties.fill(aGrp.getValueList("453"));
        return this.isValid();
    }

    public String format(double number) {
        try {
            return this.NUMBER_FORMATTER.format(number);
        }
        catch (Exception aE) {
            return String.valueOf(number);
        }
    }

    public String getAccount() {
        return this.mAccount;
    }

    public void setAccount(String account) {
        this.mAccount = account;
    }

    public void setOrderID(String aOrderID) {
        this.mOrderID = aOrderID;
    }

    public String getOrderID() {
        return this.mOrderID;
    }

    public String getClOrdID() {
        return this.mClOrdID;
    }

    public void setClOrdID(String aClOrdID) {
        this.mClOrdID = aClOrdID;
    }

    public Instrument getInstrument() {
        return this.mInstrument;
    }

    public void setInstrument(Instrument aInstrument) {
        this.mInstrument = aInstrument;
    }

    public Parties getParties() {
        return this.mParties;
    }

    public void setParties(Parties aParties) {
        this.mParties = aParties;
        if (this.mParties == null) {
            this.mParties = new Parties();
        }
    }

    public String getSecondaryClOrdID() {
        return this.mSecondaryClOrdID;
    }

    public void setSecondaryClOrdID(String aSecondaryClOrdID) {
        this.mSecondaryClOrdID = aSecondaryClOrdID;
    }

    public void setTradingSessionID(String aTradingSessionID) {
        this.mTradingSessionID = aTradingSessionID != null ? aTradingSessionID : "FXCM";
    }

    public void setTradingSessionSubID(String aTradingSessionSubID) {
        this.mTradingSessionSubID = aTradingSessionSubID != null ? aTradingSessionSubID : "";
    }

    @Override
    public String getTradingSessionID() {
        return this.mTradingSessionID;
    }

    @Override
    public String getTradingSessionSubID() {
        return this.mTradingSessionSubID;
    }

    public UTCTimestamp getTransactTime() {
        return this.mTransactTime;
    }

    protected void reset() {
        this.mAccount = null;
        this.mOrderID = null;
        this.mClOrdID = null;
        this.mSecondaryClOrdID = null;
        this.mInstrument = null;
        this.mParties = new Parties();
        this.mTradingSessionID = "FXCM";
        this.mTradingSessionSubID = "";
        if (this.mTransactTime == null) {
            this.mTransactTime = new UTCTimestamp();
        } else {
            this.mTransactTime.setDate(null);
        }
    }

    public void setTransactTime(UTCTimestamp aTransactTime) {
        if (aTransactTime != null) {
            this.mTransactTime = aTransactTime;
        } else if (this.mTradingSessionID == null) {
            this.mTransactTime = new UTCTimestamp();
        } else {
            this.mTransactTime.setDate(null);
        }
    }

    protected void toMessageTradingSessionIDs(IMessage aMessage, String aTradingSessionID, String aTradingSessionSubID, IMessageFactory aFactory) {
        if (aTradingSessionID != null) {
            aMessage.setValue("336", aTradingSessionID);
            aMessage.setValue("625", aTradingSessionSubID);
        }
    }

    @Override
    public IMessage toMessage(String aSID, IMessageFactory aFactory) {
        return this.toMessage(aSID, null, null, null, 0, aFactory);
    }

    @Override
    public IMessage toMessage(String aSID, String aTradingSessionID, String aTradingSessionSubID, String aRequestID, int aOptions, IMessageFactory aFactory) {
        String tssubid;
        String tsid = aTradingSessionID;
        if (tsid == null) {
            tsid = this.getTradingSessionID();
        }
        if ((tssubid = aTradingSessionSubID) == null) {
            tssubid = this.getTradingSessionSubID();
        }
        IMessage ret = aFactory.createMessage(aSID, this.getType().getCode());
        try {
            IFieldGroupList list;
            if (this.getAccount() != null) {
                ret.setValue("1", this.getAccount());
            }
            if (this.getOrderID() != null) {
                ret.setValue("37", this.getOrderID());
            }
            if (this.getClOrdID() != null) {
                ret.setValue("11", this.getClOrdID());
            }
            if (this.getSecondaryClOrdID() != null) {
                ret.setValue("526", this.getSecondaryClOrdID());
            }
            if (this.getInstrument() != null) {
                ret.setValue("55", this.getInstrument().getSymbol());
                if (this.getInstrument().getFXCMSymID() != 0) {
                    ret.setValue("9000", this.getInstrument().getFXCMSymID());
                }
            }
            if (this.mParties != null && (list = this.mParties.toList(aFactory)) != null) {
                ret.setValue("453", list);
            }
            this.toMessageTradingSessionIDs(ret, tsid, tssubid, aFactory);
            if (this.mTransactTime != null) {
                ret.setValue("60", this.getTransactTime().toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("mAccount=").append(this.mAccount);
        buf.append(",mOrderID=").append(this.mOrderID);
        buf.append(",mClOrdID=").append(this.mClOrdID);
        buf.append(",mSecondaryClOrdID=").append(this.mSecondaryClOrdID);
        buf.append(",mInstrument=").append(this.mInstrument);
        buf.append(",mParties=").append(this.mParties);
        buf.append(",mTradingSessionID=").append(this.mTradingSessionID);
        buf.append(",mTradingSessionSubID=").append(this.mTradingSessionSubID);
        buf.append(",mTransactTime=").append(this.mTransactTime);
        return buf.toString();
    }

    @Override
    public boolean update(IMessage aMsg) {
        return this.fill(aMsg);
    }

    @Override
    public long getMakingTime() {
        return this.mMakingTime;
    }
}

