/*
 * Decompiled with CFR 0.152.
 */
package com.fxcm.entity;

import com.fxcm.GenericException;
import com.fxcm.entity.ICode;
import com.fxcm.entity.IEntity;
import com.fxcm.entity.IPK;
import com.fxcm.entity.IStatus;
import com.fxcm.entity.StateGraph;
import java.io.PrintStream;
import java.util.Date;

public abstract class AEntity
implements IEntity {
    private IPK mPK;
    private String msName;
    private String msDesc;
    private ICode mType;
    private IStatus mStatus;
    private Date mCreationTime;
    private Date mModificationTime;
    private long mTouchTime;
    private static final String LABEL_INVALID = "Invalid";
    private static final String MSG_INVALIDSTATUS = "Invalid state transition. Code : ";

    protected AEntity(ICode aType) {
        this.mType = aType;
    }

    @Override
    public Date getCreationTime() {
        return this.mCreationTime;
    }

    @Override
    public String getDesc() {
        return this.msDesc;
    }

    @Override
    public Date getModificationTime() {
        return this.mModificationTime;
    }

    @Override
    public String getName() {
        return this.msName;
    }

    @Override
    public IPK getPK() {
        return this.mPK;
    }

    protected abstract StateGraph getStateGraph();

    @Override
    public IStatus getStatus() {
        return this.mStatus;
    }

    @Override
    public ICode getType() {
        return this.mType;
    }

    @Override
    public long lastTouch() {
        return this.mTouchTime;
    }

    @Override
    public void touch() {
        this.mTouchTime = System.currentTimeMillis();
    }

    @Override
    public void setCreationTime(Date aTime) {
        this.mCreationTime = aTime;
    }

    @Override
    public void setDesc(String aDesc) {
        this.msDesc = aDesc;
    }

    @Override
    public void setModificationTime(Date aTime) {
        this.mModificationTime = aTime;
    }

    @Override
    public void setName(String aName) {
        this.msName = aName;
    }

    @Override
    public void setPK(IPK aPk) {
        this.mPK = aPk;
    }

    @Override
    public void setStatus(IStatus aStatus) throws GenericException {
        if (this.mStatus != null && aStatus != null && this.getStateGraph() != null && !this.getStateGraph().isPossible(this.getStatus(), aStatus)) {
            throw new GenericException(MSG_INVALIDSTATUS + this.getStatus().getCode() + "->" + aStatus.getCode());
        }
        this.mStatus = aStatus;
    }

    @Override
    public boolean isValid() {
        return this.getPK() != null && this.getStatus() != null && this.getName() != null;
    }

    @Override
    public boolean isNew() {
        return this.getPK() == null;
    }

    @Override
    public void setNew() {
        this.setPK(null);
    }

    @Override
    public boolean isDeleted() {
        boolean ret = false;
        if (this.getStatus() != null) {
            ret = this.getStatus().isDeleted();
        }
        return ret;
    }

    @Override
    public void setDeleted() {
    }

    @Override
    public void printState(PrintStream aOut) {
        Object s = this.getName();
        if (this.getPK() != null) {
            s = (String)s + "; " + this.getPK().toString();
        }
        if (this.getStatus() != null) {
            s = (String)s + "; " + this.getStatus().getLabel();
        }
        s = (String)s + (this.isDeleted() ? "; deleted" : (this.isNew() ? "; new" : "; existing"));
        if (this.getDesc() != null) {
            s = (String)s + "; " + this.getDesc();
        }
        if (aOut == null) {
            System.out.println((String)s);
        } else {
            aOut.println((String)s);
        }
    }

    public String toString() {
        Object s = this.getName();
        if (this.getPK() != null) {
            s = (String)s + "; " + this.getPK().toString();
        }
        if (this.getStatus() != null) {
            s = (String)s + "; " + this.getStatus().getLabel();
        }
        s = (String)s + (this.isDeleted() ? "; deleted" : (this.isNew() ? "; new" : "; existing"));
        if (this.getDesc() != null) {
            s = (String)s + "; " + this.getDesc();
        }
        return s;
    }
}

